using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace FHTE.LTOOLS.GUI
{
	/// <summary>
	/// The PartitionsDialog-class shows a dialog with the partitions on the local or remote machine.
	/// The String is displayed in a "Courier New"-Font that the columns are displayed among one another.
	/// </summary>
	public class PartitionsDialog : System.Windows.Forms.Form
	{
        // ############################################################################################################
        // FIELDS
        // ############################################################################################################
        private System.Windows.Forms.Label labelPartitions;
        private System.Windows.Forms.Button buttonOK;
        private System.Windows.Forms.Panel panelIconLabel;
        private System.Windows.Forms.Panel panelMain;
        private System.Windows.Forms.Panel panelButton;
		private System.Windows.Forms.PictureBox pictureBox;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
        // ############################################################################################################
        // PROPERTIES
        // ############################################################################################################

        // ############################################################################################################
        // CONSTRUCTORS
        // ############################################################################################################
        /// <summary>
        /// The Constructor of the Dialog sets the caption and the size of the Dialog.
        /// </summary>
        /// <param name="partitions">the string to be displayed in the dialog</param>
        /// <param name="caption">the caption of the form</param>
        public PartitionsDialog(string partitions, string caption)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
            StringTokenizer st = new StringTokenizer(partitions, "\r\n") ;
            int lines = 0 ;
            while (st.HasMoreTokens())
            {
                lines++ ;
                st.NextToken() ;
            }

            labelPartitions.Text = partitions ;
            int heightPanelIconLabel = lines * labelPartitions.Font.Height + 50 ; // (int)((1.0) * (float)())
            if (heightPanelIconLabel < 150)
            {
                heightPanelIconLabel = 150 ;
            }
            panelIconLabel.Height = heightPanelIconLabel ;
            labelPartitions.Height = heightPanelIconLabel ;
            this.Height = heightPanelIconLabel + panelButton.Height ;
            this.Text = caption ;
		}

        // ############################################################################################################
        // METHODS
        // ############################################################################################################
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(PartitionsDialog));
			this.labelPartitions = new System.Windows.Forms.Label();
			this.pictureBox = new System.Windows.Forms.PictureBox();
			this.buttonOK = new System.Windows.Forms.Button();
			this.panelIconLabel = new System.Windows.Forms.Panel();
			this.panelMain = new System.Windows.Forms.Panel();
			this.panelButton = new System.Windows.Forms.Panel();
			this.panelIconLabel.SuspendLayout();
			this.panelMain.SuspendLayout();
			this.panelButton.SuspendLayout();
			this.SuspendLayout();
			// 
			// labelPartitions
			// 
			this.labelPartitions.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.labelPartitions.Location = new System.Drawing.Point(64, 8);
			this.labelPartitions.Name = "labelPartitions";
			this.labelPartitions.Size = new System.Drawing.Size(335, 150);
			this.labelPartitions.TabIndex = 0;
			this.labelPartitions.Text = "label";
			// 
			// pictureBox
			// 
			this.pictureBox.Image = ((System.Drawing.Bitmap)(resources.GetObject("pictureBox.Image")));
			this.pictureBox.Location = new System.Drawing.Point(8, 8);
			this.pictureBox.Name = "pictureBox";
			this.pictureBox.Size = new System.Drawing.Size(48, 48);
			this.pictureBox.TabIndex = 1;
			this.pictureBox.TabStop = false;
			// 
			// buttonOK
			// 
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.Location = new System.Drawing.Point(151, 8);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.Size = new System.Drawing.Size(100, 25);
			this.buttonOK.TabIndex = 2;
			this.buttonOK.Text = "OK";
			// 
			// panelIconLabel
			// 
			this.panelIconLabel.Controls.AddRange(new System.Windows.Forms.Control[] {
																						 this.pictureBox,
																						 this.labelPartitions});
			this.panelIconLabel.Dock = System.Windows.Forms.DockStyle.Fill;
			this.panelIconLabel.Name = "panelIconLabel";
			this.panelIconLabel.Size = new System.Drawing.Size(402, 208);
			this.panelIconLabel.TabIndex = 3;
			// 
			// panelMain
			// 
			this.panelMain.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.panelButton,
																					this.panelIconLabel});
			this.panelMain.Dock = System.Windows.Forms.DockStyle.Fill;
			this.panelMain.Name = "panelMain";
			this.panelMain.Size = new System.Drawing.Size(402, 208);
			this.panelMain.TabIndex = 4;
			// 
			// panelButton
			// 
			this.panelButton.BackColor = System.Drawing.SystemColors.Control;
			this.panelButton.Controls.AddRange(new System.Windows.Forms.Control[] {
																					  this.buttonOK});
			this.panelButton.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.panelButton.Location = new System.Drawing.Point(0, 168);
			this.panelButton.Name = "panelButton";
			this.panelButton.Size = new System.Drawing.Size(402, 40);
			this.panelButton.TabIndex = 4;
			// 
			// PartitionsDialog
			// 
			this.AcceptButton = this.buttonOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(402, 208);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.panelMain});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "PartitionsDialog";
			this.ShowInTaskbar = false;
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "PartitionsDialog";
			this.panelIconLabel.ResumeLayout(false);
			this.panelMain.ResumeLayout(false);
			this.panelButton.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

	}
}
