/*
 * AddDriveDialog.java
 */
import java.io.File;
import java.awt.*;
import javax.swing.*;

/** A Dialog to specify a drive and a directory to add in the DirFilePane
 * @author Joerg Holzaepfel
 */
public class AddDriveDialog extends javax.swing.JDialog
{
    static final boolean CANCEL = false ;                       // status of the dialog after clicking the cancel-button
    static final boolean OK = true ;                            // status of the dialog after clicking the ok-button
    private boolean status = CANCEL ;                           // the default-status of the dialog

    /** Creates an instance of an AddDriveDialog
     * @param parent the parent-frame of this dialog
     * @param modal true if the dialog should be shown as a modal dialog
     * @param isLinux true if a linux-drive should be specified
     */    
	public AddDriveDialog(Frame parent, boolean modal, boolean isLinux)
	{
		super(parent, modal);
		
		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.
		//{{INIT_CONTROLS
		setResizable(false);
		getContentPane().setLayout(new BorderLayout(0,0));
		setSize(290,109);
		setVisible(false);
		northJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.NORTH,northJPanel);
		northJPanel.setBounds(0,0,290,10);
		eastJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.EAST,eastJPanel);
		eastJPanel.setBounds(280,10,10,64);
		southJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.SOUTH,southJPanel);
		southJPanel.setBounds(0,74,290,35);
		okJButton.setSelected(true);
		okJButton.setText("OK");
		okJButton.setActionCommand("OK");
		southJPanel.add(okJButton);
		okJButton.setBounds(80,5,51,25);
		cancelJButton.setText("Cancel");
		cancelJButton.setActionCommand("Cancel");
		southJPanel.add(cancelJButton);
		cancelJButton.setBounds(136,5,73,25);
		westJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.WEST,westJPanel);
		westJPanel.setBounds(0,10,10,64);
		centerJPanel.setLayout(new GridLayout(2,2,0,0));
		getContentPane().add(BorderLayout.CENTER,centerJPanel);
		centerJPanel.setBounds(10,10,270,64);
		deviceJLabel.setText("Device:");
		centerJPanel.add(deviceJLabel);
		deviceJLabel.setBounds(0,0,135,32);
		centerJPanel.add(deviceJTextField);
		deviceJTextField.setBounds(135,0,135,32);
		directoryJLabel.setText("Directory:");
		centerJPanel.add(directoryJLabel);
		directoryJLabel.setBounds(0,32,135,32);
		centerJPanel.add(directoryJTextField);
		directoryJTextField.setBounds(135,32,135,32);
		//}}
		
        if (isLinux)
        {
            this.setTitle("LTOOLS - Add Linux-Drive") ;
            deviceJTextField.setText("/dev/fd0") ;
            directoryJTextField.setText("/") ;
        }
        else
        {
            this.setTitle("LTOOLS - Add DOS-Drive") ;
            deviceJTextField.setText("C:") ;
            directoryJTextField.setText(File.separator) ;
        }
        int x = parent.getLocation().x + (parent.getWidth()/2 - this.getWidth()/2) ;
        int y = parent.getLocation().y + (parent.getHeight()/2 - this.getHeight()/2) ;
        this.setLocation(new Point(x, y)) ;
        
        // getRootPane().setDefaultButton(jButtonOK) ;
	
		//{{REGISTER_LISTENERS
		SymAction lSymAction = new SymAction();
		okJButton.addActionListener(lSymAction);
		cancelJButton.addActionListener(lSymAction);
		//}}
	}

    /** sets the dialog visible or not
     * @param b true to set the dialog visible, false to set it not visible
     */    
	public void setVisible(boolean b)
	{
		if (b)
			setLocation(50, 50);
		super.setVisible(b);
	}

    /** calls parents addNotify()-method */    
	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension size = getSize();

		super.addNotify();

		if (frameSizeAdjusted)
			return;
		frameSizeAdjusted = true;

		// Adjust size of frame according to the insets
		Insets insets = getInsets();
		setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
	}

	// Used by addNotify
	boolean frameSizeAdjusted = false;

	//{{DECLARE_CONTROLS
	javax.swing.JPanel northJPanel = new javax.swing.JPanel();
	javax.swing.JPanel eastJPanel = new javax.swing.JPanel();
	javax.swing.JPanel southJPanel = new javax.swing.JPanel();
	javax.swing.JButton okJButton = new javax.swing.JButton();
	javax.swing.JButton cancelJButton = new javax.swing.JButton();
	javax.swing.JPanel westJPanel = new javax.swing.JPanel();
	javax.swing.JPanel centerJPanel = new javax.swing.JPanel();
	javax.swing.JLabel deviceJLabel = new javax.swing.JLabel();
	javax.swing.JTextField deviceJTextField = new javax.swing.JTextField();
	javax.swing.JLabel directoryJLabel = new javax.swing.JLabel();
	javax.swing.JTextField directoryJTextField = new javax.swing.JTextField();
	//}}


    /** ActionListener-class */    
	class SymAction implements java.awt.event.ActionListener
	{
        /** the actionPerformed()-method of the ActionListener-class
         * @param event the event data
         */        
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == okJButton)
				okJButton_actionPerformed(event);
			else if (object == cancelJButton)
				cancelJButton_actionPerformed(event);
		}
	}

    /** Invoked when the ok-button has been clicked.
     * @param event the event data
     */    
	void okJButton_actionPerformed(java.awt.event.ActionEvent event)
	{
        this.status = true ;
        setVisible(false) ;
	}

    /** Invoked when the cancel-button has been clicked.
     * @param event the event data
     */    
	void cancelJButton_actionPerformed(java.awt.event.ActionEvent event)
	{
        this.status = false ;
        setVisible(false) ;
	}
    /** This main-method is just for testing the AddDriveDialog-class
     * @param args the command line arguments
     */
    public static void main(String args[]) 
    {
        JFrame frame = new JFrame() ;
        frame.setSize(300,200) ;
        frame.setVisible(true) ;
        AddDriveDialog dialog = new AddDriveDialog(frame, true, true) ;
        dialog.show() ;
        System.out.println("status   : " + dialog.getStatus()) ;
        System.out.println("device   : " + dialog.getDevice()) ;
        System.out.println("directory: " + dialog.getDirectory()) ;
        System.exit(0) ;
    }
    /** The getDevice()-method returns a String with a device-name specified by the user
     * in the dialog
     * e.g.: "C:" for a DOS device or "/dev/hda2" for a Linux-Device
     * @return String - returns the device
     */
    public String getDevice() 
    {
        return deviceJTextField.getText() ;
    }    
    /** The getDevice()-method returns a String with a directory-name specified by the user
     * in the dialog
     * e.g.: "\temp" for a DOS device or "/home/test" for a Linux-Device
     * @return String - returns the directory
     */
    public String getDirectory() 
    {
        return directoryJTextField.getText() ;
    }
    /** the getStatus()-method returns a boolean value.
     * true if the OK-button was pressed or
     * false if the Cancel-button was pressed
     * @return boolean - the return-status of the dialog
     */
    public boolean getStatus()
    {
        return status ;
    }
}