/*
 * ContexMenuTree.java
 */
//import java.util.*;
//import java.io.*;
//import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//import javax.swing.tree.*;
import javax.swing.border.*;
import javax.swing.event.*;

/** The Class is a popupmenu for the JTree of the DirFilePane-class
 * @author Joerg Holzaepfel
 */
public class ContextMenuTree extends JPopupMenu implements PopupMenuListener, ActionListener
{
    DirFilePane parent ;                                        // The DirFilePane of this contextmenu
    JTree jTree ;                                               // the JTree of this contextmenu
    private String expandNodeLabel    = "Expand Node" ;         // the text of the menuitems in the contextmenu
    private String collapseNodeLabel  = "Collapse Node" ;
    private String collapseAllLabel   = "Collapse All" ;
    private String addDriveLabel      = "Add Drive" ;
    private String removeDriveLabel   = "Remove Drive" ;
    private String refreshNodeLabel   = "Refresh Node" ;
    private String refreshLabel       = "Refresh" ;
    JMenuItem expandNodeItem ;                                  // the menuitems of the contextmenu
    JMenuItem collapseNodeItem ;
    JMenuItem collapseAllItem ;
    JMenuItem addDriveItem ;
    JMenuItem removeDriveItem ;
    JMenuItem refreshNodeItem ;
    JMenuItem refreshItem ;

    /** creates an instance of the ContextMenuTree-class
     * @param parent the DirFilePane of this contextmenu
     */
    public ContextMenuTree(DirFilePane parent) 
    {
        this.parent = parent ;
        this.jTree = parent.getJTree() ;
        expandNodeItem = new JMenuItem(expandNodeLabel) ;
        collapseNodeItem = new JMenuItem(collapseNodeLabel) ;
        collapseAllItem = new JMenuItem(collapseAllLabel) ;
        addDriveItem = new JMenuItem(addDriveLabel) ;
        removeDriveItem = new JMenuItem(removeDriveLabel) ;
        refreshNodeItem = new JMenuItem(refreshNodeLabel) ;
        refreshItem = new JMenuItem(refreshLabel) ;

        this.add(expandNodeItem) ;
        expandNodeItem.addActionListener(this) ;
        
        this.add(collapseNodeItem);
        collapseNodeItem.addActionListener(this) ;

        this.add(collapseAllItem);
        collapseAllItem.addActionListener(this) ;
        
        this.addSeparator();
        
        this.add(addDriveItem);
        addDriveItem.addActionListener(this) ;
        
        this.add(removeDriveItem);
        removeDriveItem.addActionListener(this) ;

        this.addSeparator();
        
        this.add(refreshNodeItem) ;
        refreshNodeItem.addActionListener(this) ;
        
        this.add(refreshItem);
        refreshItem.addActionListener(this) ;

        this.setBorder(new BevelBorder(BevelBorder.RAISED));
        this.addPopupMenuListener(this);
    }
    /** the enableAllMenuItemsForNode()-method enables all items in the contextmenu to
     * work on a node of the tree
     */
    public void enableAllMenuItemsForNode()
    {
        expandNodeItem.setEnabled(true) ;
        collapseNodeItem.setEnabled(true) ;
        collapseAllItem.setEnabled(false) ;
        addDriveItem.setEnabled(false) ;
        removeDriveItem.setEnabled(true) ;
        refreshNodeItem.setEnabled(true) ;
        refreshItem.setEnabled(false) ;
    }
    /** the enableAllMenuItemsForTree()-method enables all items in the contextmenu to
     * work on the tree
     */
    public void enableAllMenuItemsForTree()
    {
        expandNodeItem.setEnabled(false) ;
        collapseNodeItem.setEnabled(false) ;
        collapseAllItem.setEnabled(true) ;
        addDriveItem.setEnabled(true) ;
        removeDriveItem.setEnabled(false) ;
        refreshNodeItem.setEnabled(false) ;
        refreshItem.setEnabled(true) ;
    }
    /** the enableAllMenuItems()-method enables all items in the contextmenu */
    public void enableAllMenuItems()
    {
        expandNodeItem.setEnabled(true) ;
        collapseNodeItem.setEnabled(true) ;
        collapseAllItem.setEnabled(true) ;
        addDriveItem.setEnabled(true) ;
        removeDriveItem.setEnabled(true) ;
        refreshNodeItem.setEnabled(true) ;
        refreshItem.setEnabled(true) ;
    }
    /** the disableAllMenuItems()-method disables all items in the contextmenu */
    public void disableAllMenuItems()
    {
        expandNodeItem.setEnabled(false) ;
        collapseNodeItem.setEnabled(false) ;
        collapseAllItem.setEnabled(false) ;
        addDriveItem.setEnabled(false) ;
        removeDriveItem.setEnabled(false) ;
        refreshNodeItem.setEnabled(false) ;
        refreshItem.setEnabled(false) ;
    }
    // PopupMenuListener ##############################################################################################
    /** the popupMenuWillBecomeVisible()-method is called before the contextmenu becomes
     * visible
     * @param e the event data
     */
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) 
    {
        // System.out.println("Popup menu will be visible!");
    }
    /** the popupMenuWillBecomeInvisible()-method is called before the contextmenu becomes
     * invisible
     * @param e the event data
     */
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) 
    {
        // System.out.println("Popup menu will be invisible!");
    }
    /** the popupMenuCanceled()-method is called when the contextmenu is canceled
     * @param e the event data
     */
    public void popupMenuCanceled(PopupMenuEvent e) 
    {
        // System.out.println("Popup menu is hidden!");
    }
    
    // ActionListener #################################################################################################
    /** the actionPerformed()-method is called if a menuitem was clicked
     * @param event the event data
     */
    public void actionPerformed(ActionEvent event) 
    {
        parent.debugOutput("Popup menu item [" + event.getActionCommand() + "] was pressed.");
        
        // #############################################################################################################
        if (event.getActionCommand().equals(expandNodeLabel))           // expand Node
        {
            if (jTree.getSelectionCount() == 1)
            {
                int row = jTree.getSelectionRows()[0] ;
                if (!jTree.isExpanded(row))
                {
                    jTree.expandRow(row) ;
                }
            }
        }
        // #############################################################################################################
        else if (event.getActionCommand().equals(collapseNodeLabel))    // collapse Node
        {
            if (jTree.getSelectionCount() == 1)
            {
                int row = jTree.getSelectionRows()[0] ;
                if (jTree.isExpanded(row))
                {
                    jTree.collapseRow(row) ;
                }
            }
        }
        // #############################################################################################################
        else if (event.getActionCommand().equals(collapseAllLabel))     // collapse All
        {
            for (int i=jTree.getRowCount(); i > 0; i--)
            {
                if (jTree.isExpanded(i))
                {
                    jTree.collapseRow(i) ;
                }
            }
        }
        // #############################################################################################################
        else if (event.getActionCommand().equals(addDriveLabel))        // add Drive
        {
            parent.addDrive() ;
        }
        // #############################################################################################################
        else if (event.getActionCommand().equals(removeDriveLabel))     // remove Drive
        {
            parent.removeDrive() ;
        }
        // #############################################################################################################
        else if (event.getActionCommand().equals(refreshNodeLabel))     // refresh the Node
        {
            parent.refreshTreeNode() ;
        }
        // #############################################################################################################
        else if (event.getActionCommand().equals(refreshLabel))         // refresh the tree
        {
            // fill the tree again !!!
            if (parent.isLinux())
            {
                parent.fillLinuxDirectoryTree() ;
            }
            else
            {
                parent.fillDosDirectoryTree() ;
            }
        }
    }
}
