import java.io.*;

/**
 *
 */
class DOSFileFilter implements FilenameFilter
{
    String pattern ;
    boolean isDebug = false ; // LTOOLSgui.DEBUG ;

    /**
     *
     */
    public DOSFileFilter(String pattern)
    {
        this.pattern =  pattern ;
        debugOutput("pattern: " + pattern);
    }
    /**
     *
     */
    public boolean accept( File f, String s )
    {
        debugOutput("###################################################################################") ;
        File file = new File(f.toString() + File.separator + s) ;
        debugOutput("new File: " + file.toString()) ;
        if (file.isDirectory())                                    // return true if it's a directory
        {
            debugOutput(f.toString() + " is a directory.") ;
            return true ;
        }
        
        if (pattern.equals("*") || pattern.equals(""))
        {
            debugOutput("show all files") ;
            debugOutput (" " + s + " --- OK") ;
            return true ;
        }
        else if (pattern.startsWith("*"))
        {
            debugOutput("Starts with *");
            if(pattern.endsWith("*"))
            {
                debugOutput(" and ends with *");
                // hier datei finden, die das muster zwischen den Strernen enthlt
                String search = pattern.substring(1, pattern.length() - 1) ;
                debugOutput(" --- search:" + search) ;
                if (s.toLowerCase().indexOf(search.toLowerCase()) > -1)
                {
                    debugOutput (" " + s + " --- OK") ;
                    return true ;
                }
                else
                {
                    debugOutput (" " + s + " --- BAD") ;
                    return false ;
                }
            }
            else
            {
                debugOutput(" and ends NOT with *");
                // hier datei finden, die mit dem pattern endet
                String search = pattern.substring(1) ;
                debugOutput(" --- search:" + search) ;
                if (s.toLowerCase().indexOf(search.toLowerCase()) == s.length() - search.length())
                {
                    debugOutput (" " + s + " --- OK") ;
                    return true ;
                }
                else
                {
                    debugOutput (" " + s + " --- BAD") ;
                    return false ;
                }
            }
        }
        else if (pattern.endsWith("*"))
        {
            debugOutput("Ends with *");
            // hier dateien finden, die mit dem pattern starten
            String search = pattern.substring(0, pattern.length() - 1) ;
            debugOutput(" --- search:" + search) ;
            if (s.toLowerCase().indexOf(search.toLowerCase()) > -1)
            {
                debugOutput (" " + s + " --- OK") ;
                return true ;
            }
            else
            {
                debugOutput (" " + s + " --- BAD") ;
                return false ;
            }
        }
        debugOutput (" " + s + " --- BAD") ;
        return false;
    }

    /**
     *
     */
    public void debugOutput(String str)
    {
        if (isDebug())
        {
            System.out.println(str) ;
        }
    }
    /**
     *
     */
    public boolean isDebug()
    {
        return isDebug ;
    }
    /**
     * for testing
     */
    public static void main( String args[] )
    {
        // File userdir = new File( System.getProperty("user.dir") );
         File userdir = new File("D:\\temp\\");
        
        System.out.println( userdir );
        
        String entries[] = userdir.list( new DOSFileFilter("*.java") );
        
        for ( int i = 0; i < entries.length; i++ )
            System.out.println(i+1 + ": " + entries[i] );
    }
}
