/*
 * DriveType.java
 *
 * Created on 5. Juni 2003, 16:13
 */
import java.util.*;
import java.io.*;

/**
 *
 * @author  joerg
 */
public class DriveType
{
    private String drive;                                       // the dosDrive e.g.: "C:\"
    private int type;                                           // 

    public static int DriveUnknown    = 0 ;
	public static int DriveNoRootdir  = 1 ;
	public static int DriveRemoveable = 2 ;
	public static int DriveFixed      = 3 ;
	public static int DriveRemote     = 4 ;
	public static int DriveCDRom      = 5 ;
	public static int DriveRamdisk    = 6 ;
    
    /**
     * Creates a new instance of DriveType
     */
    public DriveType(String drive, int type)
    {
        this.drive = drive ;
        this.type = type ;
    }
    /**
     *
     */    
    public String getDrive() 
    {
        return drive ;
    }
    /**
     *
     */
    public int getType()
    {
        return type ;
    }
    /**
     *
     */
    public String getTypeString(int type)
    {
        switch(type)
        {
            case 0:
                return "DriveUnknown" ;
            case 1:
                return "DriveNoRootdir" ;
            case 2:
                return "DriveRemoveable" ;
            case 3:
                return "DriveFixed" ;
            case 4:
                return "DriveRemote" ;
            case 5:
                return "DriveCDRom" ;
            case 6:
                return "DriveRamdisk" ;
        }
        return "" ;
    }
    /**
     *
     */
    public String toString()
    {
        return "\"" + getDrive() + "\" - " + getTypeString(getType()) ;
    }
    /**
     *
     */
    public static Vector getDOSDriveTypesOnMachine()
    {
        Vector dosDrives = new Vector() ;
        try
        {
            String getDriveTypeExe = "GetDriveType.exe" ;
            File test = new File(getDriveTypeExe) ;
            // System.out.println(getDriveTypeExe + " exists: " + test.exists()) ;
            
            if (File.separator.equals("\\") == false ||
                !test.exists())
            {
                // LTOOLSgui.beepSound() ;
                // String msg = "Sorry, running LTOOLSgui-application only supported under DOS/Windows." ;
                // JOptionPane.showMessageDialog(LTOOLSgui.myProg, msg, "LTOOLS", JOptionPane.ERROR_MESSAGE);
                // return;
                // dosDrives.removeAllElements() ;
                File[] roots = File.listRoots() ;
                for (int i=0; i < roots.length; i++)
                {
                    dosDrives.add(new DriveType(roots[i].toString(), DriveType.DriveFixed)) ;
                }
            }
            else
            {
                Runtime r = Runtime.getRuntime() ;
                Process myProcess ;
                String command = getDriveTypeExe ;
                myProcess = r.exec(command) ;

                BufferedReader in = new BufferedReader(new InputStreamReader(myProcess.getInputStream())) ;
                String input = "" ;
                String s;
                while ( (s = in.readLine()) != null )
                {
                    input = input + s ;
                    // System.out.println( s );
                }
                StringTokenizer st = new StringTokenizer(input, "\t") ;
                while (st.hasMoreTokens())
                {
                    String drive = st.nextToken() ;
                    String type = st.nextToken() ;
                    DriveType driveType = new DriveType(drive, Integer.parseInt(type)) ;
                    dosDrives.add(driveType) ;
                }
            }
            return dosDrives ;
        }
        catch (Exception e)
        {
            e.printStackTrace() ;
            return dosDrives ;
        }
    }
}
