/*
 * LToolGuiTableCellRenderer.java
 */
import javax.swing.table.*;

/** the LToolGuiTableCellRenderer extends the DefaultTableCellRenderer
 * @author Joerg Holzaepfel
 */
public class LToolGuiTableCellRenderer extends DefaultTableCellRenderer 
{
    /**
     * Creates a new instance of LToolGuiTableCellRenderer 
     */
    public LToolGuiTableCellRenderer() 
    {
    }
    
    /** Sets the <code>String</code> object for the cell being rendered to
     * <code>value</code>.
     * @param value the string value for this cell; if value is
     * 		<code>null</code> it sets the text value to an empty string
     * @see JLabel#setText
     */
    protected void setValue(Object value)
    {
        if (value instanceof LToolGuiTableIconData)
        {
            LToolGuiTableIconData iconData = (LToolGuiTableIconData) value ;
            setIcon(iconData.getIcon()) ; //  ListItemFile.icons[0]) ;
            setText(iconData.toString()) ;
        }
        else
        {
            super.setValue(value) ;
        }
    }
}
