/*
 * LToolGuiTableIconData.java
 */
import javax.swing.*;

/** the LToolGuiTableIconData represents the firs column in the JTable of a
 * DirFilePane
 * @author Joerg Holzaepfel
 */
public class LToolGuiTableIconData 
{
    private ImageIcon icon;                                     // The icon to be show in a row of the JTable
    private Object data;                                        // the filename of the file
    
    /** Creates a new instance of LToolGuiTableIconData
     * @param icon the icon of the filetype
     * @param data the filename of the file
     */
    public LToolGuiTableIconData(ImageIcon icon, Object data) 
    {
        this.icon = icon ;
        this.data = data ;
    }
    
    /** Returns a string representation of the object. In general, the
     * <code>toString</code> method returns a string that
     * "textually represents" this object. The result should
     * be a concise but informative representation that is easy for a
     * person to read.
     * It is recommended that all subclasses override this method.
     * <p>
     * The <code>toString</code> method for class <code>Object</code>
     * returns a string consisting of the name of the class of which the
     * object is an instance, the at-sign character `<code>@</code>', and
     * the unsigned hexadecimal representation of the hash code of the
     * object. In other words, this method returns a string equal to the
     * value of:
     * <blockquote>
     * <pre>
     * getClass().getName() + '@' + Integer.toHexString(hashCode())
     * </pre></blockquote>
     *
     * @return  a string representation of the object.
     *
     */
    public String toString() 
    {
        return data.toString() ;
    }
    /** the getIcon()-method returns the icon of this object
     * @return the icon of this file
     */
    public ImageIcon getIcon()
    {
        return icon ;
    }
}
