/*
 * LToolGuiTableKeyListener.java
 */
import java.util.*;
import java.awt.event.*;
import javax.swing.*;
/** The LToolGuiTableKeyListener-class processes all KeyEvents in the JTable of a
 * DirFilePane.
 * @author Joerg Holzaepfel
 */
public class LToolGuiTableKeyListener implements KeyListener 
{
    DirFilePane parent ;                                        // the DirFilePane to process all KeyEvents
    int row ;                                                   // it's to remember the selected row after pressing
                                                                // <RETURN> to select this row again
    boolean selectRow = false ;                                 // to remember if <RETURN> was pressed. (by pressing 
                                                                // <RETURN> in a JTable the selection normally changes
                                                                // to the next row of the JTable)
    /** Creates a new instance of LToolGuiTableKeyListener
     * @param parent the DirFilePane to process the events
     */
    public LToolGuiTableKeyListener(DirFilePane parent) 
    {
        this.parent = parent ;
        parent.debugOutput("LToolGuiTableKeyListener") ;
    }

    /**
     * Invoked when a key has been pressed.
     * See the class description for {@link KeyEvent} for a definition of
     * a key pressed event.
     * @param e the event data
     */
    public void keyPressed(KeyEvent e) 
    {
        /*
        parent.debugOutput("##################################################################") ;
        parent.debugOutput("keyPressed") ;
        parent.debugOutput("##################################################################") ;
        */
        if (e.getKeyCode() == KeyEvent.VK_ENTER)
        {
            parent.debugOutput("ENTER - Key") ;
            Vector items = parent.getSelectedListItemFile() ;
            if (items.size() > 1)
            {
                JOptionPane.showMessageDialog(LTOOLSgui.myProg, 
                    "Select just one file to start an application, please.",
                    "LTOOLS",
                    JOptionPane.ERROR_MESSAGE) ;
            }
            int rowIndex = parent.getJTable().getSelectedRow() ;

            this.row = rowIndex ;
            this.selectRow = true ;

            ListItemFile item = null ;
            item = (ListItemFile)items.elementAt(0) ;

            /*
            if (item != null)
            {
                item.printItem() ;
            }
            */

            if (parent.isLinux())
            {
                parent.doubleClickLinuxTable() ;
            }
            else
            {
                parent.doubleClickDOSTable() ;
            }
            if (!item.isDirectory())
            {
                parent.getJTable().setRowSelectionInterval(rowIndex, rowIndex) ;
            }
        }
    }

    /** Invoked when a key has been released.
     * See the class description for {@link KeyEvent} for a definition of
     * a key released event.
     * @param e the event data
     */
    public void keyReleased(KeyEvent e) 
    {
        this.selectRow = false ;
        /*
        parent.debugOutput("##################################################################") ;
        parent.debugOutput("keyReleased") ;
        parent.debugOutput("##################################################################") ;
        */
        if (e.getKeyCode() == KeyEvent.VK_DELETE)
        {
            parent.debugOutput("DELETE - Key") ;
            LTOOLSgui.myProg.deleteListItemFiles() ;
        }
        else if (e.getKeyCode() == KeyEvent.VK_F5)
        {
            parent.debugOutput("F5 - Key") ;
            if (parent.isLinux())
            {
                parent.updateLinuxJTable(parent.getTreeNode(parent.getJTree().getSelectionPath())) ;
            }
            else
            {
                parent.updateDOSJTable(parent.getTreeNode(parent.getJTree().getSelectionPath())) ;
            }
        }
    }

    /** Invoked when a key has been typed.
     * See the class description for {@link KeyEvent} for a definition of
     * a key typed event.
     * @param e the event data
     */
    public void keyTyped(KeyEvent e) 
    {
        /*
        parent.debugOutput("##################################################################") ;
        parent.debugOutput("keyTyped") ;
        parent.debugOutput("##################################################################") ;
        */
        if (this.selectRow)
        {
            parent.getJTable().setRowSelectionInterval(this.row, this.row) ;
            this.selectRow = false ;
        }
    }
}
