/*
 * LToolGuiTreeMouseListener.java
 */
//import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;

/** the LToolGuiTreeMouseListener-class is processing the MouseEvents of the JTree n
 * a DirFilePane
 * @author Joerg Holzaepfel
 */
public class LToolGuiTreeMouseListener implements MouseListener 
{
    DirFilePane parent ;                                        // the DirFilePane to process the events
    JTree jTree ;                                               // the jTree-field of the DirFilePane
    DefaultTreeModel treeModel ;                                // the treeModel-field of the DirFilePane
    ContextMenuTree contextMenuTree ;                           // the contextmenu 
    
    /** Creates a new instance of LToolGuiTreeMouseListener
     * @param parent the DirFilePane to process the events of
     */
    public LToolGuiTreeMouseListener(DirFilePane parent) 
    {
        this.parent = parent ;
        this.jTree = parent.getJTree() ;
        this.treeModel = parent.getTreeModel() ;
        this.contextMenuTree = parent.getContextMenuTree() ;
    }
    
    /**
     * Invoked when the mouse button has been clicked (pressed
     * and released) on a component.
     * @param e the event data
     */
    public void mouseClicked(MouseEvent e)
    {
        // System.out.println("mouseClicked - LToolGuiTreeMouseListener()");
        if (e.getClickCount() == 1)
        {
            // getButton and MouseEvent.Button3 since SunJava1.4
            // if (e.getButton() == MouseEvent.BUTTON3)            // right mouse-button
            if (e.getModifiers() == InputEvent.META_MASK)       // right mouse-button
            {
                // Point mousePos = e.getPoint() ;
                if(jTree.getRowForLocation(e.getX(), e.getY()) != -1)
                {
                    jTree.setSelectionRow(jTree.getRowForLocation(e.getX(), e.getY())) ;
                    contextMenuTree.enableAllMenuItemsForNode() ;
                    contextMenuTree.show(parent.getJTree(), e.getX(), e.getY()) ;
                }
                else
                {
                    contextMenuTree.enableAllMenuItemsForTree() ;
                    contextMenuTree.show(parent.getJTree(), e.getX(), e.getY()) ;
                }
            }
        }
    }
    
    /** Invoked when the mouse enters a component.
     * @param e the event data
     */
    public void mouseEntered(MouseEvent e)
    {
    }
    
    /** Invoked when the mouse exits a component.
     * @param e the event data
     */
    public void mouseExited(MouseEvent e) 
    {
    }
    
    /** Invoked when a mouse button has been pressed on a component.
     * @param e the event data
     */
    public void mousePressed(MouseEvent e)
    {
    }
    
    /** Invoked when a mouse button has been released on a component.
     * @param e the event data
     */
    public void mouseReleased(MouseEvent e)
    {
    }
}
