/*
 * LToolGuiTreeSelectionListener.java
 */
//import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;

/** The LToolGuiTreeSelectionListener-class is processing the TreeSelectionEvents of
 * the JTree in a DirFilePane
 */
class LToolGuiTreeSelectionListener implements TreeSelectionListener
{
    DirFilePane parent ;                                        // the DirFilePane of this Listener
    boolean isLinux ;                                           // true if it's a linux-DirFilePane
    
    /** Creates a new instance of LToolGuiTreeSelectionListener
     * @param parent the DirFilePane to process the events
     */
    public LToolGuiTreeSelectionListener(DirFilePane parent) 
    {
        this.parent = parent ;
        isLinux = parent.isLinux() ;
    }
    /** it's called if another node in the JTree was selected
     * @param event the event data
     */
    public void valueChanged(TreeSelectionEvent event)
    {
        try
        {
            parent.debugOutput("TreeSelection-valueChanged: " + event.getPath().toString()) ;
            LTOOLSgui.setActiveDirFilePane((DirFilePane)parent) ;
            if (isLinux)
            {
                parent.setCurrentDirectory(event.getPath()) ;
                DefaultMutableTreeNode node = parent.getTreeNode(event.getPath());
                parent.getJTree().scrollPathToVisible(parent.getJTree().getSelectionPath()) ;
                parent.updateLinuxJTable(node) ;
            }
            else
            {
                parent.setCurrentDirectory(event.getPath()) ;
                DefaultMutableTreeNode node = parent.getTreeNode(event.getPath());
                if (node instanceof DirectoryMutableTreeNode)
                {
                    DirectoryMutableTreeNode dn = (DirectoryMutableTreeNode)node ;
                    if ( dn.isRemovableDrive() )                // add directories to a removable drive
                    {
                        parent.getJTree().collapsePath(event.getPath()) ;
                        dn.removeAllChildren() ;
                        dn.setSubDirectoriesAdded(false) ;
                        parent.addDOSDirectories(dn, parent.getCurrentDirectory()) ;
                        parent.getJTree().expandPath(event.getPath()) ;
                    }
                }
                parent.getJTree().scrollPathToVisible(parent.getJTree().getSelectionPath()) ;
                parent.updateDOSJTable(node) ;
            }
        }
        catch (Exception e)
        {
            parent.debugOutput("LToolGuiTreeSelectionListener.valueChanged():") ;
            e.printStackTrace() ;
        }
    }
}
