/*
 * PartitionsFrame.java
 */
import java.util.*;
import java.awt.*;
//import javax.swing.*;

/** The PartitionsFrame show in a dialog all partitions on the local or remote
 * machine
 * @author Joerg Holzaepfel
 */
public class PartitionsFrame extends javax.swing.JDialog
{
    /** Creates a new Instance of the PartitionsFrame-class
     * @param parent the parent frame
     * @param modal true if the dialog should be modal
     * @param partitions the partitions on the local or remote machine
     * @param caption the caption of the dialog
     */    
	public PartitionsFrame(Frame parent, boolean modal, String partitions, String caption)
	{
		super(parent, modal);
		
		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.
		//{{INIT_CONTROLS
		setResizable(false);
		getContentPane().setLayout(new BorderLayout(0,0));
		setSize(405,305);
		setVisible(false);
		northJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.NORTH,northJPanel);
		northJPanel.setBounds(0,0,405,10);
		eastJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.EAST,eastJPanel);
		eastJPanel.setBounds(395,10,10,260);
		southJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.SOUTH,southJPanel);
		southJPanel.setBounds(0,270,405,35);
		okJButton.setSelected(true);
		okJButton.setText("OK");
		southJPanel.add(okJButton);
		okJButton.setBounds(177,5,51,25);
		westJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.WEST,westJPanel);
		westJPanel.setBounds(0,10,10,260);
		centerJPanel.setLayout(new GridLayout(1,1,0,0));
		getContentPane().add(BorderLayout.CENTER,centerJPanel);
		centerJPanel.setBounds(10,10,385,260);
		partitionsJTextArea.setEditable(false);
		centerJPanel.add(partitionsJTextArea);
		partitionsJTextArea.setBounds(0,0,385,260);
		//}}
        
        setTitle(caption) ;
        Color color = (java.awt.Color) javax.swing.UIManager.getDefaults().get("TextField.inactiveBackground") ;
        partitionsJTextArea.setBackground(color);
        
        StringTokenizer st = new StringTokenizer(partitions, "\r\n") ;
        int lines = 0 ;
        while (st.hasMoreTokens())
        {
            lines++ ;
            st.nextToken() ;
        }
        FontMetrics fm = partitionsJTextArea.getFontMetrics(partitionsJTextArea.getFont()) ;
        int fontHeight = fm.getHeight() ;

        int width = 375 ;
        int height = lines * fontHeight + 90 ;
        if (height < 200)                                       // minimum height 200
        {
            height = 200 ;
        }
        this.setSize(width, height) ;
        
        int x = parent.getLocation().x + (parent.getWidth()/2 - this.getWidth()/2) ;
        int y = parent.getLocation().y + (parent.getHeight()/2 - this.getHeight()/2) ;
        this.setLocation(new Point(x, y)) ;
        
        partitionsJTextArea.setText(partitions) ;                        // + "\nfontheight: " + fontHeight
        // this.getRootPane().setDefaultButton(okJButton) ;
	
		//{{REGISTER_LISTENERS
		SymAction lSymAction = new SymAction();
		okJButton.addActionListener(lSymAction);
		//}}
	}

    /** sets the frame visible or invisible
     * @param b true if the frame should be visible
     */    
	public void setVisible(boolean b)
	{
		if (b)
			setLocation(50, 50);
		super.setVisible(b);
	}

    /** calls the super.addNotify()-method */    
	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension size = getSize();

		super.addNotify();

		if (frameSizeAdjusted)
			return;
		frameSizeAdjusted = true;

		// Adjust size of frame according to the insets
		Insets insets = getInsets();
		setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
	}

	// Used by addNotify
	boolean frameSizeAdjusted = false;

	//{{DECLARE_CONTROLS
	javax.swing.JPanel northJPanel = new javax.swing.JPanel();
	javax.swing.JPanel eastJPanel = new javax.swing.JPanel();
	javax.swing.JPanel southJPanel = new javax.swing.JPanel();
	javax.swing.JButton okJButton = new javax.swing.JButton();
	javax.swing.JPanel westJPanel = new javax.swing.JPanel();
	javax.swing.JPanel centerJPanel = new javax.swing.JPanel();
	javax.swing.JTextArea partitionsJTextArea = new javax.swing.JTextArea();
	//}}

    /** ActionListener-class */    
	class SymAction implements java.awt.event.ActionListener
	{
        /** the actionPerformed()-method of the ActionListener-class
         * @param event the event data
         */        
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == okJButton)
				okJButton_actionPerformed(event);
		}
	}

    /** it's called after clicking the ok-button
     * @param event the event data
     */    
	void okJButton_actionPerformed(java.awt.event.ActionEvent event)
	{
        setVisible(false);
        dispose();
	}
}