/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version
 *  2 of the License, or (at your option) any later version.
 *
 *  Copyright 2004 Spiro Trikaliotis
 *
 */

/*! ************************************************************** 
** \file sys/libcommon/debug.c \n
** \author Spiro Trikaliotis \n
** \version $Id: debug.c,v 1.16 2006/03/09 17:31:35 strik Exp $ \n
** \n
** \brief Debug helper functions for kernel-mode drivers
**
****************************************************************/

/*! Mark: This file is DEBUG.C, thus, some variables and functions
 * should not be defined as "extern"  */
// #define DBG_IS_DEBUG_C

#include <wdm.h>
// #include <ntddk.h>
#include "cbm_driver.h"

#include "../../arch/windows/debug.c"

/*! find the minimum of both parameters */
#ifndef min
# define min(_x, _y) ( ((_x) < (_y)) ? (_x) : (_y) )
#endif

#if 0
    #define REPORT_BUG(_no, _a, _b, _c, _d, _str) KeBugCheckEx(_no, _a, _b, _c, _d)
#else
    #define REPORT_BUG(_no, _a, _b, _c, _d, _str) \
        DbgPrint("--- REPORT_BUG: %04x (%08x, %08x, %08x, %08x). '%s' " \
        "in %s, %s(), line %u\n", \
        _no, _a, _b, _c, _d, _str, \
        __FILE__, __FUNCTION__, __LINE__);
#endif



/*! one descriptional entry for the NTSTATUS codes */
typedef
struct NTSTATUS_DEBUGCODE
{
   /*! String containing the name of the NTSTATUS code */
   const UCHAR *Name;
   
   /*! The value of the NTSTATUS code */
   NTSTATUS Value;
   
} NTSTATUS_DEBUGCODE;

/*! Define one NTSTATUS entry */
#define DEFINE_STATUSCODE(_x) { #_x, _x }

/*! This mark is used as value for the last entry of the array */
#define _MARKLASTENTRY ((NTSTATUS) -1)

/*! this marks the last entry of the array */
#define _LASTENTRY { "", _MARKLASTENTRY }

/*! The array of NTSTATUS codes */
const
NTSTATUS_DEBUGCODE text[] =
{
    DEFINE_STATUSCODE(STATUS_SUCCESS),
    DEFINE_STATUSCODE(STATUS_SUCCESS),
    DEFINE_STATUSCODE(STATUS_WAIT_0),
    DEFINE_STATUSCODE(STATUS_WAIT_1),
    DEFINE_STATUSCODE(STATUS_WAIT_2),
    DEFINE_STATUSCODE(STATUS_WAIT_3),
    DEFINE_STATUSCODE(STATUS_WAIT_63),
    DEFINE_STATUSCODE(STATUS_ABANDONED),
    DEFINE_STATUSCODE(STATUS_ABANDONED_WAIT_0),
    DEFINE_STATUSCODE(STATUS_ABANDONED_WAIT_63),
    DEFINE_STATUSCODE(STATUS_USER_APC),
    DEFINE_STATUSCODE(STATUS_KERNEL_APC),
    DEFINE_STATUSCODE(STATUS_ALERTED),
    DEFINE_STATUSCODE(STATUS_TIMEOUT),
    DEFINE_STATUSCODE(STATUS_PENDING),
    DEFINE_STATUSCODE(STATUS_REPARSE),
    DEFINE_STATUSCODE(STATUS_MORE_ENTRIES),
    DEFINE_STATUSCODE(STATUS_NOT_ALL_ASSIGNED),
    DEFINE_STATUSCODE(STATUS_SOME_NOT_MAPPED),
    DEFINE_STATUSCODE(STATUS_OPLOCK_BREAK_IN_PROGRESS),
    DEFINE_STATUSCODE(STATUS_VOLUME_MOUNTED),
    DEFINE_STATUSCODE(STATUS_RXACT_COMMITTED),
    DEFINE_STATUSCODE(STATUS_NOTIFY_CLEANUP),
    DEFINE_STATUSCODE(STATUS_NOTIFY_ENUM_DIR),
    DEFINE_STATUSCODE(STATUS_NO_QUOTAS_FOR_ACCOUNT),
    DEFINE_STATUSCODE(STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED),
    DEFINE_STATUSCODE(STATUS_PAGE_FAULT_TRANSITION),
    DEFINE_STATUSCODE(STATUS_PAGE_FAULT_DEMAND_ZERO),
    DEFINE_STATUSCODE(STATUS_PAGE_FAULT_COPY_ON_WRITE),
    DEFINE_STATUSCODE(STATUS_PAGE_FAULT_GUARD_PAGE),
    DEFINE_STATUSCODE(STATUS_PAGE_FAULT_PAGING_FILE),
    DEFINE_STATUSCODE(STATUS_CACHE_PAGE_LOCKED),
    DEFINE_STATUSCODE(STATUS_CRASH_DUMP),
    DEFINE_STATUSCODE(STATUS_BUFFER_ALL_ZEROS),
    DEFINE_STATUSCODE(STATUS_REPARSE_OBJECT),
    DEFINE_STATUSCODE(STATUS_RESOURCE_REQUIREMENTS_CHANGED),
    DEFINE_STATUSCODE(STATUS_TRANSLATION_COMPLETE),
    DEFINE_STATUSCODE(STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY),
    DEFINE_STATUSCODE(DBG_EXCEPTION_HANDLED),
    DEFINE_STATUSCODE(DBG_CONTINUE),
    DEFINE_STATUSCODE(STATUS_OBJECT_NAME_EXISTS),
    DEFINE_STATUSCODE(STATUS_THREAD_WAS_SUSPENDED),
    DEFINE_STATUSCODE(STATUS_WORKING_SET_LIMIT_RANGE),
    DEFINE_STATUSCODE(STATUS_IMAGE_NOT_AT_BASE),
    DEFINE_STATUSCODE(STATUS_RXACT_STATE_CREATED),
    DEFINE_STATUSCODE(STATUS_SEGMENT_NOTIFICATION),
    DEFINE_STATUSCODE(STATUS_LOCAL_USER_SESSION_KEY),
    DEFINE_STATUSCODE(STATUS_BAD_CURRENT_DIRECTORY),
    DEFINE_STATUSCODE(STATUS_SERIAL_MORE_WRITES),
    DEFINE_STATUSCODE(STATUS_REGISTRY_RECOVERED),
    DEFINE_STATUSCODE(STATUS_FT_READ_RECOVERY_FROM_BACKUP),
    DEFINE_STATUSCODE(STATUS_FT_WRITE_RECOVERY),
    DEFINE_STATUSCODE(STATUS_SERIAL_COUNTER_TIMEOUT),
    DEFINE_STATUSCODE(STATUS_NULL_LM_PASSWORD),
    DEFINE_STATUSCODE(STATUS_IMAGE_MACHINE_TYPE_MISMATCH),
    DEFINE_STATUSCODE(STATUS_RECEIVE_PARTIAL),
    DEFINE_STATUSCODE(STATUS_RECEIVE_EXPEDITED),
    DEFINE_STATUSCODE(STATUS_RECEIVE_PARTIAL_EXPEDITED),
    DEFINE_STATUSCODE(STATUS_EVENT_DONE),
    DEFINE_STATUSCODE(STATUS_EVENT_PENDING),
    DEFINE_STATUSCODE(STATUS_CHECKING_FILE_SYSTEM),
    DEFINE_STATUSCODE(STATUS_FATAL_APP_EXIT),
    DEFINE_STATUSCODE(STATUS_PREDEFINED_HANDLE),
    DEFINE_STATUSCODE(STATUS_WAS_UNLOCKED),
    DEFINE_STATUSCODE(STATUS_SERVICE_NOTIFICATION),
    DEFINE_STATUSCODE(STATUS_WAS_LOCKED),
    DEFINE_STATUSCODE(STATUS_LOG_HARD_ERROR),
    DEFINE_STATUSCODE(STATUS_ALREADY_WIN32),
    DEFINE_STATUSCODE(STATUS_WX86_UNSIMULATE),
    DEFINE_STATUSCODE(STATUS_WX86_CONTINUE),
    DEFINE_STATUSCODE(STATUS_WX86_SINGLE_STEP),
    DEFINE_STATUSCODE(STATUS_WX86_BREAKPOINT),
    DEFINE_STATUSCODE(STATUS_WX86_EXCEPTION_CONTINUE),
    DEFINE_STATUSCODE(STATUS_WX86_EXCEPTION_LASTCHANCE),
    DEFINE_STATUSCODE(STATUS_WX86_EXCEPTION_CHAIN),
    DEFINE_STATUSCODE(STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE),
    DEFINE_STATUSCODE(STATUS_NO_YIELD_PERFORMED),
    DEFINE_STATUSCODE(STATUS_TIMER_RESUME_IGNORED),
    DEFINE_STATUSCODE(STATUS_ARBITRATION_UNHANDLED),
    DEFINE_STATUSCODE(STATUS_CARDBUS_NOT_SUPPORTED),
    DEFINE_STATUSCODE(STATUS_WX86_CREATEWX86TIB),
    DEFINE_STATUSCODE(STATUS_MP_PROCESSOR_MISMATCH),
    DEFINE_STATUSCODE(DBG_REPLY_LATER),
    DEFINE_STATUSCODE(DBG_UNABLE_TO_PROVIDE_HANDLE),
    DEFINE_STATUSCODE(DBG_TERMINATE_THREAD),
    DEFINE_STATUSCODE(DBG_TERMINATE_PROCESS),
    DEFINE_STATUSCODE(DBG_CONTROL_C),
    DEFINE_STATUSCODE(DBG_PRINTEXCEPTION_C),
    DEFINE_STATUSCODE(DBG_RIPEXCEPTION),
    DEFINE_STATUSCODE(DBG_CONTROL_BREAK),
    DEFINE_STATUSCODE(STATUS_GUARD_PAGE_VIOLATION),
    DEFINE_STATUSCODE(STATUS_DATATYPE_MISALIGNMENT),
    DEFINE_STATUSCODE(STATUS_BREAKPOINT),
    DEFINE_STATUSCODE(STATUS_SINGLE_STEP),
    DEFINE_STATUSCODE(STATUS_BUFFER_OVERFLOW),
    DEFINE_STATUSCODE(STATUS_NO_MORE_FILES),
    DEFINE_STATUSCODE(STATUS_WAKE_SYSTEM_DEBUGGER),
    DEFINE_STATUSCODE(STATUS_HANDLES_CLOSED),
    DEFINE_STATUSCODE(STATUS_NO_INHERITANCE),
    DEFINE_STATUSCODE(STATUS_GUID_SUBSTITUTION_MADE),
    DEFINE_STATUSCODE(STATUS_PARTIAL_COPY),
    DEFINE_STATUSCODE(STATUS_DEVICE_PAPER_EMPTY),
    DEFINE_STATUSCODE(STATUS_DEVICE_POWERED_OFF),
    DEFINE_STATUSCODE(STATUS_DEVICE_OFF_LINE),
    DEFINE_STATUSCODE(STATUS_DEVICE_BUSY),
    DEFINE_STATUSCODE(STATUS_NO_MORE_EAS),
    DEFINE_STATUSCODE(STATUS_INVALID_EA_NAME),
    DEFINE_STATUSCODE(STATUS_EA_LIST_INCONSISTENT),
    DEFINE_STATUSCODE(STATUS_INVALID_EA_FLAG),
    DEFINE_STATUSCODE(STATUS_VERIFY_REQUIRED),
    DEFINE_STATUSCODE(STATUS_EXTRANEOUS_INFORMATION),
    DEFINE_STATUSCODE(STATUS_RXACT_COMMIT_NECESSARY),
    DEFINE_STATUSCODE(STATUS_NO_MORE_ENTRIES),
    DEFINE_STATUSCODE(STATUS_FILEMARK_DETECTED),
    DEFINE_STATUSCODE(STATUS_MEDIA_CHANGED),
    DEFINE_STATUSCODE(STATUS_BUS_RESET),
    DEFINE_STATUSCODE(STATUS_END_OF_MEDIA),
    DEFINE_STATUSCODE(STATUS_BEGINNING_OF_MEDIA),
    DEFINE_STATUSCODE(STATUS_MEDIA_CHECK),
    DEFINE_STATUSCODE(STATUS_SETMARK_DETECTED),
    DEFINE_STATUSCODE(STATUS_NO_DATA_DETECTED),
    DEFINE_STATUSCODE(STATUS_REDIRECTOR_HAS_OPEN_HANDLES),
    DEFINE_STATUSCODE(STATUS_SERVER_HAS_OPEN_HANDLES),
    DEFINE_STATUSCODE(STATUS_ALREADY_DISCONNECTED),
    DEFINE_STATUSCODE(STATUS_LONGJUMP),
    DEFINE_STATUSCODE(DBG_EXCEPTION_NOT_HANDLED),
    DEFINE_STATUSCODE(STATUS_UNSUCCESSFUL),
    DEFINE_STATUSCODE(STATUS_NOT_IMPLEMENTED),
    DEFINE_STATUSCODE(STATUS_INVALID_INFO_CLASS),
    DEFINE_STATUSCODE(STATUS_INFO_LENGTH_MISMATCH),
    DEFINE_STATUSCODE(STATUS_ACCESS_VIOLATION),
    DEFINE_STATUSCODE(STATUS_IN_PAGE_ERROR),
    DEFINE_STATUSCODE(STATUS_PAGEFILE_QUOTA),
    DEFINE_STATUSCODE(STATUS_INVALID_HANDLE),
    DEFINE_STATUSCODE(STATUS_BAD_INITIAL_STACK),
    DEFINE_STATUSCODE(STATUS_BAD_INITIAL_PC),
    DEFINE_STATUSCODE(STATUS_INVALID_CID),
    DEFINE_STATUSCODE(STATUS_TIMER_NOT_CANCELED),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER),
    DEFINE_STATUSCODE(STATUS_NO_SUCH_DEVICE),
    DEFINE_STATUSCODE(STATUS_NO_SUCH_FILE),
    DEFINE_STATUSCODE(STATUS_INVALID_DEVICE_REQUEST),
    DEFINE_STATUSCODE(STATUS_END_OF_FILE),
    DEFINE_STATUSCODE(STATUS_WRONG_VOLUME),
    DEFINE_STATUSCODE(STATUS_NO_MEDIA_IN_DEVICE),
    DEFINE_STATUSCODE(STATUS_UNRECOGNIZED_MEDIA),
    DEFINE_STATUSCODE(STATUS_NONEXISTENT_SECTOR),
    DEFINE_STATUSCODE(STATUS_MORE_PROCESSING_REQUIRED),
    DEFINE_STATUSCODE(STATUS_NO_MEMORY),
    DEFINE_STATUSCODE(STATUS_CONFLICTING_ADDRESSES),
    DEFINE_STATUSCODE(STATUS_NOT_MAPPED_VIEW),
    DEFINE_STATUSCODE(STATUS_UNABLE_TO_FREE_VM),
    DEFINE_STATUSCODE(STATUS_UNABLE_TO_DELETE_SECTION),
    DEFINE_STATUSCODE(STATUS_INVALID_SYSTEM_SERVICE),
    DEFINE_STATUSCODE(STATUS_ILLEGAL_INSTRUCTION),
    DEFINE_STATUSCODE(STATUS_INVALID_LOCK_SEQUENCE),
    DEFINE_STATUSCODE(STATUS_INVALID_VIEW_SIZE),
    DEFINE_STATUSCODE(STATUS_INVALID_FILE_FOR_SECTION),
    DEFINE_STATUSCODE(STATUS_ALREADY_COMMITTED),
    DEFINE_STATUSCODE(STATUS_ACCESS_DENIED),
    DEFINE_STATUSCODE(STATUS_BUFFER_TOO_SMALL),
    DEFINE_STATUSCODE(STATUS_OBJECT_TYPE_MISMATCH),
    DEFINE_STATUSCODE(STATUS_NONCONTINUABLE_EXCEPTION),
    DEFINE_STATUSCODE(STATUS_INVALID_DISPOSITION),
    DEFINE_STATUSCODE(STATUS_UNWIND),
    DEFINE_STATUSCODE(STATUS_BAD_STACK),
    DEFINE_STATUSCODE(STATUS_INVALID_UNWIND_TARGET),
    DEFINE_STATUSCODE(STATUS_NOT_LOCKED),
    DEFINE_STATUSCODE(STATUS_PARITY_ERROR),
    DEFINE_STATUSCODE(STATUS_UNABLE_TO_DECOMMIT_VM),
    DEFINE_STATUSCODE(STATUS_NOT_COMMITTED),
    DEFINE_STATUSCODE(STATUS_INVALID_PORT_ATTRIBUTES),
    DEFINE_STATUSCODE(STATUS_PORT_MESSAGE_TOO_LONG),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_MIX),
    DEFINE_STATUSCODE(STATUS_INVALID_QUOTA_LOWER),
    DEFINE_STATUSCODE(STATUS_DISK_CORRUPT_ERROR),
    DEFINE_STATUSCODE(STATUS_OBJECT_NAME_INVALID),
    DEFINE_STATUSCODE(STATUS_OBJECT_NAME_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_OBJECT_NAME_COLLISION),
    DEFINE_STATUSCODE(STATUS_PORT_DISCONNECTED),
    DEFINE_STATUSCODE(STATUS_DEVICE_ALREADY_ATTACHED),
    DEFINE_STATUSCODE(STATUS_OBJECT_PATH_INVALID),
    DEFINE_STATUSCODE(STATUS_OBJECT_PATH_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_OBJECT_PATH_SYNTAX_BAD),
    DEFINE_STATUSCODE(STATUS_DATA_OVERRUN),
    DEFINE_STATUSCODE(STATUS_DATA_LATE_ERROR),
    DEFINE_STATUSCODE(STATUS_DATA_ERROR),
    DEFINE_STATUSCODE(STATUS_CRC_ERROR),
    DEFINE_STATUSCODE(STATUS_SECTION_TOO_BIG),
    DEFINE_STATUSCODE(STATUS_PORT_CONNECTION_REFUSED),
    DEFINE_STATUSCODE(STATUS_INVALID_PORT_HANDLE),
    DEFINE_STATUSCODE(STATUS_SHARING_VIOLATION),
    DEFINE_STATUSCODE(STATUS_QUOTA_EXCEEDED),
    DEFINE_STATUSCODE(STATUS_INVALID_PAGE_PROTECTION),
    DEFINE_STATUSCODE(STATUS_MUTANT_NOT_OWNED),
    DEFINE_STATUSCODE(STATUS_SEMAPHORE_LIMIT_EXCEEDED),
    DEFINE_STATUSCODE(STATUS_PORT_ALREADY_SET),
    DEFINE_STATUSCODE(STATUS_SECTION_NOT_IMAGE),
    DEFINE_STATUSCODE(STATUS_SUSPEND_COUNT_EXCEEDED),
    DEFINE_STATUSCODE(STATUS_THREAD_IS_TERMINATING),
    DEFINE_STATUSCODE(STATUS_BAD_WORKING_SET_LIMIT),
    DEFINE_STATUSCODE(STATUS_INCOMPATIBLE_FILE_MAP),
    DEFINE_STATUSCODE(STATUS_SECTION_PROTECTION),
    DEFINE_STATUSCODE(STATUS_EAS_NOT_SUPPORTED),
    DEFINE_STATUSCODE(STATUS_EA_TOO_LARGE),
    DEFINE_STATUSCODE(STATUS_NONEXISTENT_EA_ENTRY),
    DEFINE_STATUSCODE(STATUS_NO_EAS_ON_FILE),
    DEFINE_STATUSCODE(STATUS_EA_CORRUPT_ERROR),
    DEFINE_STATUSCODE(STATUS_FILE_LOCK_CONFLICT),
    DEFINE_STATUSCODE(STATUS_LOCK_NOT_GRANTED),
    DEFINE_STATUSCODE(STATUS_DELETE_PENDING),
    DEFINE_STATUSCODE(STATUS_CTL_FILE_NOT_SUPPORTED),
    DEFINE_STATUSCODE(STATUS_UNKNOWN_REVISION),
    DEFINE_STATUSCODE(STATUS_REVISION_MISMATCH),
    DEFINE_STATUSCODE(STATUS_INVALID_OWNER),
    DEFINE_STATUSCODE(STATUS_INVALID_PRIMARY_GROUP),
    DEFINE_STATUSCODE(STATUS_NO_IMPERSONATION_TOKEN),
    DEFINE_STATUSCODE(STATUS_CANT_DISABLE_MANDATORY),
    DEFINE_STATUSCODE(STATUS_NO_LOGON_SERVERS),
    DEFINE_STATUSCODE(STATUS_NO_SUCH_LOGON_SESSION),
    DEFINE_STATUSCODE(STATUS_NO_SUCH_PRIVILEGE),
    DEFINE_STATUSCODE(STATUS_PRIVILEGE_NOT_HELD),
    DEFINE_STATUSCODE(STATUS_INVALID_ACCOUNT_NAME),
    DEFINE_STATUSCODE(STATUS_USER_EXISTS),
    DEFINE_STATUSCODE(STATUS_NO_SUCH_USER),
    DEFINE_STATUSCODE(STATUS_GROUP_EXISTS),
    DEFINE_STATUSCODE(STATUS_NO_SUCH_GROUP),
    DEFINE_STATUSCODE(STATUS_MEMBER_IN_GROUP),
    DEFINE_STATUSCODE(STATUS_MEMBER_NOT_IN_GROUP),
    DEFINE_STATUSCODE(STATUS_LAST_ADMIN),
    DEFINE_STATUSCODE(STATUS_WRONG_PASSWORD),
    DEFINE_STATUSCODE(STATUS_ILL_FORMED_PASSWORD),
    DEFINE_STATUSCODE(STATUS_PASSWORD_RESTRICTION),
    DEFINE_STATUSCODE(STATUS_LOGON_FAILURE),
    DEFINE_STATUSCODE(STATUS_ACCOUNT_RESTRICTION),
    DEFINE_STATUSCODE(STATUS_INVALID_LOGON_HOURS),
    DEFINE_STATUSCODE(STATUS_INVALID_WORKSTATION),
    DEFINE_STATUSCODE(STATUS_PASSWORD_EXPIRED),
    DEFINE_STATUSCODE(STATUS_ACCOUNT_DISABLED),
    DEFINE_STATUSCODE(STATUS_NONE_MAPPED),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_LUIDS_REQUESTED),
    DEFINE_STATUSCODE(STATUS_LUIDS_EXHAUSTED),
    DEFINE_STATUSCODE(STATUS_INVALID_SUB_AUTHORITY),
    DEFINE_STATUSCODE(STATUS_INVALID_ACL),
    DEFINE_STATUSCODE(STATUS_INVALID_SID),
    DEFINE_STATUSCODE(STATUS_INVALID_SECURITY_DESCR),
    DEFINE_STATUSCODE(STATUS_PROCEDURE_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_INVALID_IMAGE_FORMAT),
    DEFINE_STATUSCODE(STATUS_NO_TOKEN),
    DEFINE_STATUSCODE(STATUS_BAD_INHERITANCE_ACL),
    DEFINE_STATUSCODE(STATUS_RANGE_NOT_LOCKED),
    DEFINE_STATUSCODE(STATUS_DISK_FULL),
    DEFINE_STATUSCODE(STATUS_SERVER_DISABLED),
    DEFINE_STATUSCODE(STATUS_SERVER_NOT_DISABLED),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_GUIDS_REQUESTED),
    DEFINE_STATUSCODE(STATUS_GUIDS_EXHAUSTED),
    DEFINE_STATUSCODE(STATUS_INVALID_ID_AUTHORITY),
    DEFINE_STATUSCODE(STATUS_AGENTS_EXHAUSTED),
    DEFINE_STATUSCODE(STATUS_INVALID_VOLUME_LABEL),
    DEFINE_STATUSCODE(STATUS_SECTION_NOT_EXTENDED),
    DEFINE_STATUSCODE(STATUS_NOT_MAPPED_DATA),
    DEFINE_STATUSCODE(STATUS_RESOURCE_DATA_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_RESOURCE_TYPE_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_RESOURCE_NAME_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_ARRAY_BOUNDS_EXCEEDED),
    DEFINE_STATUSCODE(STATUS_FLOAT_DENORMAL_OPERAND),
    DEFINE_STATUSCODE(STATUS_FLOAT_DIVIDE_BY_ZERO),
    DEFINE_STATUSCODE(STATUS_FLOAT_INEXACT_RESULT),
    DEFINE_STATUSCODE(STATUS_FLOAT_INVALID_OPERATION),
    DEFINE_STATUSCODE(STATUS_FLOAT_OVERFLOW),
    DEFINE_STATUSCODE(STATUS_FLOAT_STACK_CHECK),
    DEFINE_STATUSCODE(STATUS_FLOAT_UNDERFLOW),
    DEFINE_STATUSCODE(STATUS_INTEGER_DIVIDE_BY_ZERO),
    DEFINE_STATUSCODE(STATUS_INTEGER_OVERFLOW),
    DEFINE_STATUSCODE(STATUS_PRIVILEGED_INSTRUCTION),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_PAGING_FILES),
    DEFINE_STATUSCODE(STATUS_FILE_INVALID),
    DEFINE_STATUSCODE(STATUS_ALLOTTED_SPACE_EXCEEDED),
    DEFINE_STATUSCODE(STATUS_INSUFFICIENT_RESOURCES),
    DEFINE_STATUSCODE(STATUS_DFS_EXIT_PATH_FOUND),
    DEFINE_STATUSCODE(STATUS_DEVICE_DATA_ERROR),
    DEFINE_STATUSCODE(STATUS_DEVICE_NOT_CONNECTED),
    DEFINE_STATUSCODE(STATUS_DEVICE_POWER_FAILURE),
    DEFINE_STATUSCODE(STATUS_FREE_VM_NOT_AT_BASE),
    DEFINE_STATUSCODE(STATUS_MEMORY_NOT_ALLOCATED),
    DEFINE_STATUSCODE(STATUS_WORKING_SET_QUOTA),
    DEFINE_STATUSCODE(STATUS_MEDIA_WRITE_PROTECTED),
    DEFINE_STATUSCODE(STATUS_DEVICE_NOT_READY),
    DEFINE_STATUSCODE(STATUS_INVALID_GROUP_ATTRIBUTES),
    DEFINE_STATUSCODE(STATUS_BAD_IMPERSONATION_LEVEL),
    DEFINE_STATUSCODE(STATUS_CANT_OPEN_ANONYMOUS),
    DEFINE_STATUSCODE(STATUS_BAD_VALIDATION_CLASS),
    DEFINE_STATUSCODE(STATUS_BAD_TOKEN_TYPE),
    DEFINE_STATUSCODE(STATUS_BAD_MASTER_BOOT_RECORD),
    DEFINE_STATUSCODE(STATUS_INSTRUCTION_MISALIGNMENT),
    DEFINE_STATUSCODE(STATUS_INSTANCE_NOT_AVAILABLE),
    DEFINE_STATUSCODE(STATUS_PIPE_NOT_AVAILABLE),
    DEFINE_STATUSCODE(STATUS_INVALID_PIPE_STATE),
    DEFINE_STATUSCODE(STATUS_PIPE_BUSY),
    DEFINE_STATUSCODE(STATUS_ILLEGAL_FUNCTION),
    DEFINE_STATUSCODE(STATUS_PIPE_DISCONNECTED),
    DEFINE_STATUSCODE(STATUS_PIPE_CLOSING),
    DEFINE_STATUSCODE(STATUS_PIPE_CONNECTED),
    DEFINE_STATUSCODE(STATUS_PIPE_LISTENING),
    DEFINE_STATUSCODE(STATUS_INVALID_READ_MODE),
    DEFINE_STATUSCODE(STATUS_IO_TIMEOUT),
    DEFINE_STATUSCODE(STATUS_FILE_FORCED_CLOSED),
    DEFINE_STATUSCODE(STATUS_PROFILING_NOT_STARTED),
    DEFINE_STATUSCODE(STATUS_PROFILING_NOT_STOPPED),
    DEFINE_STATUSCODE(STATUS_COULD_NOT_INTERPRET),
    DEFINE_STATUSCODE(STATUS_FILE_IS_A_DIRECTORY),
    DEFINE_STATUSCODE(STATUS_NOT_SUPPORTED),
    DEFINE_STATUSCODE(STATUS_REMOTE_NOT_LISTENING),
    DEFINE_STATUSCODE(STATUS_DUPLICATE_NAME),
    DEFINE_STATUSCODE(STATUS_BAD_NETWORK_PATH),
    DEFINE_STATUSCODE(STATUS_NETWORK_BUSY),
    DEFINE_STATUSCODE(STATUS_DEVICE_DOES_NOT_EXIST),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_COMMANDS),
    DEFINE_STATUSCODE(STATUS_ADAPTER_HARDWARE_ERROR),
    DEFINE_STATUSCODE(STATUS_INVALID_NETWORK_RESPONSE),
    DEFINE_STATUSCODE(STATUS_UNEXPECTED_NETWORK_ERROR),
    DEFINE_STATUSCODE(STATUS_BAD_REMOTE_ADAPTER),
    DEFINE_STATUSCODE(STATUS_PRINT_QUEUE_FULL),
    DEFINE_STATUSCODE(STATUS_NO_SPOOL_SPACE),
    DEFINE_STATUSCODE(STATUS_PRINT_CANCELLED),
    DEFINE_STATUSCODE(STATUS_NETWORK_NAME_DELETED),
    DEFINE_STATUSCODE(STATUS_NETWORK_ACCESS_DENIED),
    DEFINE_STATUSCODE(STATUS_BAD_DEVICE_TYPE),
    DEFINE_STATUSCODE(STATUS_BAD_NETWORK_NAME),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_NAMES),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_SESSIONS),
    DEFINE_STATUSCODE(STATUS_SHARING_PAUSED),
    DEFINE_STATUSCODE(STATUS_REQUEST_NOT_ACCEPTED),
    DEFINE_STATUSCODE(STATUS_REDIRECTOR_PAUSED),
    DEFINE_STATUSCODE(STATUS_NET_WRITE_FAULT),
    DEFINE_STATUSCODE(STATUS_PROFILING_AT_LIMIT),
    DEFINE_STATUSCODE(STATUS_NOT_SAME_DEVICE),
    DEFINE_STATUSCODE(STATUS_FILE_RENAMED),
    DEFINE_STATUSCODE(STATUS_VIRTUAL_CIRCUIT_CLOSED),
    DEFINE_STATUSCODE(STATUS_NO_SECURITY_ON_OBJECT),
    DEFINE_STATUSCODE(STATUS_CANT_WAIT),
    DEFINE_STATUSCODE(STATUS_PIPE_EMPTY),
    DEFINE_STATUSCODE(STATUS_CANT_ACCESS_DOMAIN_INFO),
    DEFINE_STATUSCODE(STATUS_CANT_TERMINATE_SELF),
    DEFINE_STATUSCODE(STATUS_INVALID_SERVER_STATE),
    DEFINE_STATUSCODE(STATUS_INVALID_DOMAIN_STATE),
    DEFINE_STATUSCODE(STATUS_INVALID_DOMAIN_ROLE),
    DEFINE_STATUSCODE(STATUS_NO_SUCH_DOMAIN),
    DEFINE_STATUSCODE(STATUS_DOMAIN_EXISTS),
    DEFINE_STATUSCODE(STATUS_DOMAIN_LIMIT_EXCEEDED),
    DEFINE_STATUSCODE(STATUS_OPLOCK_NOT_GRANTED),
    DEFINE_STATUSCODE(STATUS_INVALID_OPLOCK_PROTOCOL),
    DEFINE_STATUSCODE(STATUS_INTERNAL_DB_CORRUPTION),
    DEFINE_STATUSCODE(STATUS_INTERNAL_ERROR),
    DEFINE_STATUSCODE(STATUS_GENERIC_NOT_MAPPED),
    DEFINE_STATUSCODE(STATUS_BAD_DESCRIPTOR_FORMAT),
    DEFINE_STATUSCODE(STATUS_INVALID_USER_BUFFER),
    DEFINE_STATUSCODE(STATUS_UNEXPECTED_IO_ERROR),
    DEFINE_STATUSCODE(STATUS_UNEXPECTED_MM_CREATE_ERR),
    DEFINE_STATUSCODE(STATUS_UNEXPECTED_MM_MAP_ERROR),
    DEFINE_STATUSCODE(STATUS_UNEXPECTED_MM_EXTEND_ERR),
    DEFINE_STATUSCODE(STATUS_NOT_LOGON_PROCESS),
    DEFINE_STATUSCODE(STATUS_LOGON_SESSION_EXISTS),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_1),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_2),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_3),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_4),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_5),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_6),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_7),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_8),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_9),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_10),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_11),
    DEFINE_STATUSCODE(STATUS_INVALID_PARAMETER_12),
    DEFINE_STATUSCODE(STATUS_REDIRECTOR_NOT_STARTED),
    DEFINE_STATUSCODE(STATUS_REDIRECTOR_STARTED),
    DEFINE_STATUSCODE(STATUS_STACK_OVERFLOW),
    DEFINE_STATUSCODE(STATUS_NO_SUCH_PACKAGE),
    DEFINE_STATUSCODE(STATUS_BAD_FUNCTION_TABLE),
    DEFINE_STATUSCODE(STATUS_VARIABLE_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_DIRECTORY_NOT_EMPTY),
    DEFINE_STATUSCODE(STATUS_FILE_CORRUPT_ERROR),
    DEFINE_STATUSCODE(STATUS_NOT_A_DIRECTORY),
    DEFINE_STATUSCODE(STATUS_BAD_LOGON_SESSION_STATE),
    DEFINE_STATUSCODE(STATUS_LOGON_SESSION_COLLISION),
    DEFINE_STATUSCODE(STATUS_NAME_TOO_LONG),
    DEFINE_STATUSCODE(STATUS_FILES_OPEN),
    DEFINE_STATUSCODE(STATUS_CONNECTION_IN_USE),
    DEFINE_STATUSCODE(STATUS_MESSAGE_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_PROCESS_IS_TERMINATING),
    DEFINE_STATUSCODE(STATUS_INVALID_LOGON_TYPE),
    DEFINE_STATUSCODE(STATUS_NO_GUID_TRANSLATION),
    DEFINE_STATUSCODE(STATUS_CANNOT_IMPERSONATE),
    DEFINE_STATUSCODE(STATUS_IMAGE_ALREADY_LOADED),
    DEFINE_STATUSCODE(STATUS_ABIOS_NOT_PRESENT),
    DEFINE_STATUSCODE(STATUS_ABIOS_LID_NOT_EXIST),
    DEFINE_STATUSCODE(STATUS_ABIOS_LID_ALREADY_OWNED),
    DEFINE_STATUSCODE(STATUS_ABIOS_NOT_LID_OWNER),
    DEFINE_STATUSCODE(STATUS_ABIOS_INVALID_COMMAND),
    DEFINE_STATUSCODE(STATUS_ABIOS_INVALID_LID),
    DEFINE_STATUSCODE(STATUS_ABIOS_SELECTOR_NOT_AVAILABLE),
    DEFINE_STATUSCODE(STATUS_ABIOS_INVALID_SELECTOR),
    DEFINE_STATUSCODE(STATUS_NO_LDT),
    DEFINE_STATUSCODE(STATUS_INVALID_LDT_SIZE),
    DEFINE_STATUSCODE(STATUS_INVALID_LDT_OFFSET),
    DEFINE_STATUSCODE(STATUS_INVALID_LDT_DESCRIPTOR),
    DEFINE_STATUSCODE(STATUS_INVALID_IMAGE_NE_FORMAT),
    DEFINE_STATUSCODE(STATUS_RXACT_INVALID_STATE),
    DEFINE_STATUSCODE(STATUS_RXACT_COMMIT_FAILURE),
    DEFINE_STATUSCODE(STATUS_MAPPED_FILE_SIZE_ZERO),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_OPENED_FILES),
    DEFINE_STATUSCODE(STATUS_CANCELLED),
    DEFINE_STATUSCODE(STATUS_CANNOT_DELETE),
    DEFINE_STATUSCODE(STATUS_INVALID_COMPUTER_NAME),
    DEFINE_STATUSCODE(STATUS_FILE_DELETED),
    DEFINE_STATUSCODE(STATUS_SPECIAL_ACCOUNT),
    DEFINE_STATUSCODE(STATUS_SPECIAL_GROUP),
    DEFINE_STATUSCODE(STATUS_SPECIAL_USER),
    DEFINE_STATUSCODE(STATUS_MEMBERS_PRIMARY_GROUP),
    DEFINE_STATUSCODE(STATUS_FILE_CLOSED),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_THREADS),
    DEFINE_STATUSCODE(STATUS_THREAD_NOT_IN_PROCESS),
    DEFINE_STATUSCODE(STATUS_TOKEN_ALREADY_IN_USE),
    DEFINE_STATUSCODE(STATUS_PAGEFILE_QUOTA_EXCEEDED),
    DEFINE_STATUSCODE(STATUS_COMMITMENT_LIMIT),
    DEFINE_STATUSCODE(STATUS_INVALID_IMAGE_LE_FORMAT),
    DEFINE_STATUSCODE(STATUS_INVALID_IMAGE_NOT_MZ),
    DEFINE_STATUSCODE(STATUS_INVALID_IMAGE_PROTECT),
    DEFINE_STATUSCODE(STATUS_INVALID_IMAGE_WIN_16),
    DEFINE_STATUSCODE(STATUS_LOGON_SERVER_CONFLICT),
    DEFINE_STATUSCODE(STATUS_TIME_DIFFERENCE_AT_DC),
    DEFINE_STATUSCODE(STATUS_SYNCHRONIZATION_REQUIRED),
    DEFINE_STATUSCODE(STATUS_DLL_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_OPEN_FAILED),
    DEFINE_STATUSCODE(STATUS_IO_PRIVILEGE_FAILED),
    DEFINE_STATUSCODE(STATUS_ORDINAL_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_ENTRYPOINT_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_CONTROL_C_EXIT),
    DEFINE_STATUSCODE(STATUS_LOCAL_DISCONNECT),
    DEFINE_STATUSCODE(STATUS_REMOTE_DISCONNECT),
    DEFINE_STATUSCODE(STATUS_REMOTE_RESOURCES),
    DEFINE_STATUSCODE(STATUS_LINK_FAILED),
    DEFINE_STATUSCODE(STATUS_LINK_TIMEOUT),
    DEFINE_STATUSCODE(STATUS_INVALID_CONNECTION),
    DEFINE_STATUSCODE(STATUS_INVALID_ADDRESS),
    DEFINE_STATUSCODE(STATUS_DLL_INIT_FAILED),
    DEFINE_STATUSCODE(STATUS_MISSING_SYSTEMFILE),
    DEFINE_STATUSCODE(STATUS_UNHANDLED_EXCEPTION),
    DEFINE_STATUSCODE(STATUS_APP_INIT_FAILURE),
    DEFINE_STATUSCODE(STATUS_PAGEFILE_CREATE_FAILED),
    DEFINE_STATUSCODE(STATUS_NO_PAGEFILE),
    DEFINE_STATUSCODE(STATUS_INVALID_LEVEL),
    DEFINE_STATUSCODE(STATUS_WRONG_PASSWORD_CORE),
    DEFINE_STATUSCODE(STATUS_ILLEGAL_FLOAT_CONTEXT),
    DEFINE_STATUSCODE(STATUS_PIPE_BROKEN),
    DEFINE_STATUSCODE(STATUS_REGISTRY_CORRUPT),
    DEFINE_STATUSCODE(STATUS_REGISTRY_IO_FAILED),
    DEFINE_STATUSCODE(STATUS_NO_EVENT_PAIR),
    DEFINE_STATUSCODE(STATUS_UNRECOGNIZED_VOLUME),
    DEFINE_STATUSCODE(STATUS_SERIAL_NO_DEVICE_INITED),
    DEFINE_STATUSCODE(STATUS_NO_SUCH_ALIAS),
    DEFINE_STATUSCODE(STATUS_MEMBER_NOT_IN_ALIAS),
    DEFINE_STATUSCODE(STATUS_MEMBER_IN_ALIAS),
    DEFINE_STATUSCODE(STATUS_ALIAS_EXISTS),
    DEFINE_STATUSCODE(STATUS_LOGON_NOT_GRANTED),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_SECRETS),
    DEFINE_STATUSCODE(STATUS_SECRET_TOO_LONG),
    DEFINE_STATUSCODE(STATUS_INTERNAL_DB_ERROR),
    DEFINE_STATUSCODE(STATUS_FULLSCREEN_MODE),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_CONTEXT_IDS),
    DEFINE_STATUSCODE(STATUS_LOGON_TYPE_NOT_GRANTED),
    DEFINE_STATUSCODE(STATUS_NOT_REGISTRY_FILE),
    DEFINE_STATUSCODE(STATUS_NT_CROSS_ENCRYPTION_REQUIRED),
    DEFINE_STATUSCODE(STATUS_DOMAIN_CTRLR_CONFIG_ERROR),
    DEFINE_STATUSCODE(STATUS_FT_MISSING_MEMBER),
    DEFINE_STATUSCODE(STATUS_ILL_FORMED_SERVICE_ENTRY),
    DEFINE_STATUSCODE(STATUS_ILLEGAL_CHARACTER),
    DEFINE_STATUSCODE(STATUS_UNMAPPABLE_CHARACTER),
    DEFINE_STATUSCODE(STATUS_UNDEFINED_CHARACTER),
    DEFINE_STATUSCODE(STATUS_FLOPPY_VOLUME),
    DEFINE_STATUSCODE(STATUS_FLOPPY_ID_MARK_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_FLOPPY_WRONG_CYLINDER),
    DEFINE_STATUSCODE(STATUS_FLOPPY_UNKNOWN_ERROR),
    DEFINE_STATUSCODE(STATUS_FLOPPY_BAD_REGISTERS),
    DEFINE_STATUSCODE(STATUS_DISK_RECALIBRATE_FAILED),
    DEFINE_STATUSCODE(STATUS_DISK_OPERATION_FAILED),
    DEFINE_STATUSCODE(STATUS_DISK_RESET_FAILED),
    DEFINE_STATUSCODE(STATUS_SHARED_IRQ_BUSY),
    DEFINE_STATUSCODE(STATUS_FT_ORPHANING),
    DEFINE_STATUSCODE(STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT),
    DEFINE_STATUSCODE(STATUS_PARTITION_FAILURE),
    DEFINE_STATUSCODE(STATUS_INVALID_BLOCK_LENGTH),
    DEFINE_STATUSCODE(STATUS_DEVICE_NOT_PARTITIONED),
    DEFINE_STATUSCODE(STATUS_UNABLE_TO_LOCK_MEDIA),
    DEFINE_STATUSCODE(STATUS_UNABLE_TO_UNLOAD_MEDIA),
    DEFINE_STATUSCODE(STATUS_EOM_OVERFLOW),
    DEFINE_STATUSCODE(STATUS_NO_MEDIA),
    DEFINE_STATUSCODE(STATUS_NO_SUCH_MEMBER),
    DEFINE_STATUSCODE(STATUS_INVALID_MEMBER),
    DEFINE_STATUSCODE(STATUS_KEY_DELETED),
    DEFINE_STATUSCODE(STATUS_NO_LOG_SPACE),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_SIDS),
    DEFINE_STATUSCODE(STATUS_LM_CROSS_ENCRYPTION_REQUIRED),
    DEFINE_STATUSCODE(STATUS_KEY_HAS_CHILDREN),
    DEFINE_STATUSCODE(STATUS_CHILD_MUST_BE_VOLATILE),
    DEFINE_STATUSCODE(STATUS_DEVICE_CONFIGURATION_ERROR),
    DEFINE_STATUSCODE(STATUS_DRIVER_INTERNAL_ERROR),
    DEFINE_STATUSCODE(STATUS_INVALID_DEVICE_STATE),
    DEFINE_STATUSCODE(STATUS_IO_DEVICE_ERROR),
    DEFINE_STATUSCODE(STATUS_DEVICE_PROTOCOL_ERROR),
    DEFINE_STATUSCODE(STATUS_BACKUP_CONTROLLER),
    DEFINE_STATUSCODE(STATUS_LOG_FILE_FULL),
    DEFINE_STATUSCODE(STATUS_TOO_LATE),
    DEFINE_STATUSCODE(STATUS_NO_TRUST_LSA_SECRET),
    DEFINE_STATUSCODE(STATUS_NO_TRUST_SAM_ACCOUNT),
    DEFINE_STATUSCODE(STATUS_TRUSTED_DOMAIN_FAILURE),
    DEFINE_STATUSCODE(STATUS_TRUSTED_RELATIONSHIP_FAILURE),
    DEFINE_STATUSCODE(STATUS_EVENTLOG_FILE_CORRUPT),
    DEFINE_STATUSCODE(STATUS_EVENTLOG_CANT_START),
    DEFINE_STATUSCODE(STATUS_TRUST_FAILURE),
    DEFINE_STATUSCODE(STATUS_MUTANT_LIMIT_EXCEEDED),
    DEFINE_STATUSCODE(STATUS_NETLOGON_NOT_STARTED),
    DEFINE_STATUSCODE(STATUS_ACCOUNT_EXPIRED),
    DEFINE_STATUSCODE(STATUS_POSSIBLE_DEADLOCK),
    DEFINE_STATUSCODE(STATUS_NETWORK_CREDENTIAL_CONFLICT),
    DEFINE_STATUSCODE(STATUS_REMOTE_SESSION_LIMIT),
    DEFINE_STATUSCODE(STATUS_EVENTLOG_FILE_CHANGED),
    DEFINE_STATUSCODE(STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT),
    DEFINE_STATUSCODE(STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT),
    DEFINE_STATUSCODE(STATUS_NOLOGON_SERVER_TRUST_ACCOUNT),
    DEFINE_STATUSCODE(STATUS_DOMAIN_TRUST_INCONSISTENT),
    DEFINE_STATUSCODE(STATUS_FS_DRIVER_REQUIRED),
    DEFINE_STATUSCODE(STATUS_NO_USER_SESSION_KEY),
    DEFINE_STATUSCODE(STATUS_USER_SESSION_DELETED),
    DEFINE_STATUSCODE(STATUS_RESOURCE_LANG_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_INSUFF_SERVER_RESOURCES),
    DEFINE_STATUSCODE(STATUS_INVALID_BUFFER_SIZE),
    DEFINE_STATUSCODE(STATUS_INVALID_ADDRESS_COMPONENT),
    DEFINE_STATUSCODE(STATUS_INVALID_ADDRESS_WILDCARD),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_ADDRESSES),
    DEFINE_STATUSCODE(STATUS_ADDRESS_ALREADY_EXISTS),
    DEFINE_STATUSCODE(STATUS_ADDRESS_CLOSED),
    DEFINE_STATUSCODE(STATUS_CONNECTION_DISCONNECTED),
    DEFINE_STATUSCODE(STATUS_CONNECTION_RESET),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_NODES),
    DEFINE_STATUSCODE(STATUS_TRANSACTION_ABORTED),
    DEFINE_STATUSCODE(STATUS_TRANSACTION_TIMED_OUT),
    DEFINE_STATUSCODE(STATUS_TRANSACTION_NO_RELEASE),
    DEFINE_STATUSCODE(STATUS_TRANSACTION_NO_MATCH),
    DEFINE_STATUSCODE(STATUS_TRANSACTION_RESPONDED),
    DEFINE_STATUSCODE(STATUS_TRANSACTION_INVALID_ID),
    DEFINE_STATUSCODE(STATUS_TRANSACTION_INVALID_TYPE),
    DEFINE_STATUSCODE(STATUS_NOT_SERVER_SESSION),
    DEFINE_STATUSCODE(STATUS_NOT_CLIENT_SESSION),
    DEFINE_STATUSCODE(STATUS_CANNOT_LOAD_REGISTRY_FILE),
    DEFINE_STATUSCODE(STATUS_DEBUG_ATTACH_FAILED),
    DEFINE_STATUSCODE(STATUS_SYSTEM_PROCESS_TERMINATED),
    DEFINE_STATUSCODE(STATUS_DATA_NOT_ACCEPTED),
    DEFINE_STATUSCODE(STATUS_NO_BROWSER_SERVERS_FOUND),
    DEFINE_STATUSCODE(STATUS_VDM_HARD_ERROR),
    DEFINE_STATUSCODE(STATUS_DRIVER_CANCEL_TIMEOUT),
    DEFINE_STATUSCODE(STATUS_REPLY_MESSAGE_MISMATCH),
    DEFINE_STATUSCODE(STATUS_MAPPED_ALIGNMENT),
    DEFINE_STATUSCODE(STATUS_IMAGE_CHECKSUM_MISMATCH),
    DEFINE_STATUSCODE(STATUS_LOST_WRITEBEHIND_DATA),
    DEFINE_STATUSCODE(STATUS_CLIENT_SERVER_PARAMETERS_INVALID),
    DEFINE_STATUSCODE(STATUS_PASSWORD_MUST_CHANGE),
    DEFINE_STATUSCODE(STATUS_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_NOT_TINY_STREAM),
    DEFINE_STATUSCODE(STATUS_RECOVERY_FAILURE),
    DEFINE_STATUSCODE(STATUS_STACK_OVERFLOW_READ),
    DEFINE_STATUSCODE(STATUS_FAIL_CHECK),
    DEFINE_STATUSCODE(STATUS_DUPLICATE_OBJECTID),
    DEFINE_STATUSCODE(STATUS_OBJECTID_EXISTS),
    DEFINE_STATUSCODE(STATUS_CONVERT_TO_LARGE),
    DEFINE_STATUSCODE(STATUS_RETRY),
    DEFINE_STATUSCODE(STATUS_FOUND_OUT_OF_SCOPE),
    DEFINE_STATUSCODE(STATUS_ALLOCATE_BUCKET),
    DEFINE_STATUSCODE(STATUS_PROPSET_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_MARSHALL_OVERFLOW),
    DEFINE_STATUSCODE(STATUS_INVALID_VARIANT),
    DEFINE_STATUSCODE(STATUS_DOMAIN_CONTROLLER_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_ACCOUNT_LOCKED_OUT),
    DEFINE_STATUSCODE(STATUS_HANDLE_NOT_CLOSABLE),
    DEFINE_STATUSCODE(STATUS_CONNECTION_REFUSED),
    DEFINE_STATUSCODE(STATUS_GRACEFUL_DISCONNECT),
    DEFINE_STATUSCODE(STATUS_ADDRESS_ALREADY_ASSOCIATED),
    DEFINE_STATUSCODE(STATUS_ADDRESS_NOT_ASSOCIATED),
    DEFINE_STATUSCODE(STATUS_CONNECTION_INVALID),
    DEFINE_STATUSCODE(STATUS_CONNECTION_ACTIVE),
    DEFINE_STATUSCODE(STATUS_NETWORK_UNREACHABLE),
    DEFINE_STATUSCODE(STATUS_HOST_UNREACHABLE),
    DEFINE_STATUSCODE(STATUS_PROTOCOL_UNREACHABLE),
    DEFINE_STATUSCODE(STATUS_PORT_UNREACHABLE),
    DEFINE_STATUSCODE(STATUS_REQUEST_ABORTED),
    DEFINE_STATUSCODE(STATUS_CONNECTION_ABORTED),
    DEFINE_STATUSCODE(STATUS_BAD_COMPRESSION_BUFFER),
    DEFINE_STATUSCODE(STATUS_USER_MAPPED_FILE),
    DEFINE_STATUSCODE(STATUS_AUDIT_FAILED),
    DEFINE_STATUSCODE(STATUS_TIMER_RESOLUTION_NOT_SET),
    DEFINE_STATUSCODE(STATUS_CONNECTION_COUNT_LIMIT),
    DEFINE_STATUSCODE(STATUS_LOGIN_TIME_RESTRICTION),
    DEFINE_STATUSCODE(STATUS_LOGIN_WKSTA_RESTRICTION),
    DEFINE_STATUSCODE(STATUS_IMAGE_MP_UP_MISMATCH),
    DEFINE_STATUSCODE(STATUS_INSUFFICIENT_LOGON_INFO),
    DEFINE_STATUSCODE(STATUS_BAD_DLL_ENTRYPOINT),
    DEFINE_STATUSCODE(STATUS_BAD_SERVICE_ENTRYPOINT),
    DEFINE_STATUSCODE(STATUS_LPC_REPLY_LOST),
    DEFINE_STATUSCODE(STATUS_IP_ADDRESS_CONFLICT1),
    DEFINE_STATUSCODE(STATUS_IP_ADDRESS_CONFLICT2),
    DEFINE_STATUSCODE(STATUS_REGISTRY_QUOTA_LIMIT),
    DEFINE_STATUSCODE(STATUS_PATH_NOT_COVERED),
    DEFINE_STATUSCODE(STATUS_NO_CALLBACK_ACTIVE),
    DEFINE_STATUSCODE(STATUS_LICENSE_QUOTA_EXCEEDED),
    DEFINE_STATUSCODE(STATUS_PWD_TOO_SHORT),
    DEFINE_STATUSCODE(STATUS_PWD_TOO_RECENT),
    DEFINE_STATUSCODE(STATUS_PWD_HISTORY_CONFLICT),
    DEFINE_STATUSCODE(STATUS_PLUGPLAY_NO_DEVICE),
    DEFINE_STATUSCODE(STATUS_UNSUPPORTED_COMPRESSION),
    DEFINE_STATUSCODE(STATUS_INVALID_HW_PROFILE),
    DEFINE_STATUSCODE(STATUS_INVALID_PLUGPLAY_DEVICE_PATH),
    DEFINE_STATUSCODE(STATUS_DRIVER_ORDINAL_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_DRIVER_ENTRYPOINT_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_RESOURCE_NOT_OWNED),
    DEFINE_STATUSCODE(STATUS_TOO_MANY_LINKS),
    DEFINE_STATUSCODE(STATUS_QUOTA_LIST_INCONSISTENT),
    DEFINE_STATUSCODE(STATUS_FILE_IS_OFFLINE),
    DEFINE_STATUSCODE(STATUS_EVALUATION_EXPIRATION),
    DEFINE_STATUSCODE(STATUS_ILLEGAL_DLL_RELOCATION),
    DEFINE_STATUSCODE(STATUS_LICENSE_VIOLATION),
    DEFINE_STATUSCODE(STATUS_DLL_INIT_FAILED_LOGOFF),
    DEFINE_STATUSCODE(STATUS_DRIVER_UNABLE_TO_LOAD),
    DEFINE_STATUSCODE(STATUS_DFS_UNAVAILABLE),
    DEFINE_STATUSCODE(STATUS_VOLUME_DISMOUNTED),
    DEFINE_STATUSCODE(STATUS_WX86_INTERNAL_ERROR),
    DEFINE_STATUSCODE(STATUS_WX86_FLOAT_STACK_CHECK),
    DEFINE_STATUSCODE(STATUS_VALIDATE_CONTINUE),
    DEFINE_STATUSCODE(STATUS_NO_MATCH),
    DEFINE_STATUSCODE(STATUS_NO_MORE_MATCHES),
    DEFINE_STATUSCODE(STATUS_NOT_A_REPARSE_POINT),
    DEFINE_STATUSCODE(STATUS_IO_REPARSE_TAG_INVALID),
    DEFINE_STATUSCODE(STATUS_IO_REPARSE_TAG_MISMATCH),
    DEFINE_STATUSCODE(STATUS_IO_REPARSE_DATA_INVALID),
    DEFINE_STATUSCODE(STATUS_IO_REPARSE_TAG_NOT_HANDLED),
    DEFINE_STATUSCODE(STATUS_REPARSE_POINT_NOT_RESOLVED),
    DEFINE_STATUSCODE(STATUS_DIRECTORY_IS_A_REPARSE_POINT),
    DEFINE_STATUSCODE(STATUS_RANGE_LIST_CONFLICT),
    DEFINE_STATUSCODE(STATUS_SOURCE_ELEMENT_EMPTY),
    DEFINE_STATUSCODE(STATUS_DESTINATION_ELEMENT_FULL),
    DEFINE_STATUSCODE(STATUS_ILLEGAL_ELEMENT_ADDRESS),
    DEFINE_STATUSCODE(STATUS_MAGAZINE_NOT_PRESENT),
    DEFINE_STATUSCODE(STATUS_REINITIALIZATION_NEEDED),
    DEFINE_STATUSCODE(STATUS_DEVICE_REQUIRES_CLEANING),
    DEFINE_STATUSCODE(STATUS_DEVICE_DOOR_OPEN),
    DEFINE_STATUSCODE(STATUS_ENCRYPTION_FAILED),
    DEFINE_STATUSCODE(STATUS_DECRYPTION_FAILED),
    DEFINE_STATUSCODE(STATUS_RANGE_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_NO_RECOVERY_POLICY),
    DEFINE_STATUSCODE(STATUS_NO_EFS),
    DEFINE_STATUSCODE(STATUS_WRONG_EFS),
    DEFINE_STATUSCODE(STATUS_NO_USER_KEYS),
    DEFINE_STATUSCODE(STATUS_FILE_NOT_ENCRYPTED),
    DEFINE_STATUSCODE(STATUS_NOT_EXPORT_FORMAT),
    DEFINE_STATUSCODE(STATUS_FILE_ENCRYPTED),
    DEFINE_STATUSCODE(STATUS_WAKE_SYSTEM),
    DEFINE_STATUSCODE(STATUS_WMI_GUID_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_WMI_INSTANCE_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_WMI_ITEMID_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_WMI_TRY_AGAIN),
    DEFINE_STATUSCODE(STATUS_SHARED_POLICY),
    DEFINE_STATUSCODE(STATUS_POLICY_OBJECT_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_POLICY_ONLY_IN_DS),
    DEFINE_STATUSCODE(STATUS_VOLUME_NOT_UPGRADED),
    DEFINE_STATUSCODE(STATUS_REMOTE_STORAGE_NOT_ACTIVE),
    DEFINE_STATUSCODE(STATUS_REMOTE_STORAGE_MEDIA_ERROR),
    DEFINE_STATUSCODE(STATUS_NO_TRACKING_SERVICE),
    DEFINE_STATUSCODE(STATUS_SERVER_SID_MISMATCH),
    DEFINE_STATUSCODE(STATUS_DS_NO_ATTRIBUTE_OR_VALUE),
    DEFINE_STATUSCODE(STATUS_DS_INVALID_ATTRIBUTE_SYNTAX),
    DEFINE_STATUSCODE(STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED),
    DEFINE_STATUSCODE(STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS),
    DEFINE_STATUSCODE(STATUS_DS_BUSY),
    DEFINE_STATUSCODE(STATUS_DS_UNAVAILABLE),
    DEFINE_STATUSCODE(STATUS_DS_NO_RIDS_ALLOCATED),
    DEFINE_STATUSCODE(STATUS_DS_NO_MORE_RIDS),
    DEFINE_STATUSCODE(STATUS_DS_INCORRECT_ROLE_OWNER),
    DEFINE_STATUSCODE(STATUS_DS_RIDMGR_INIT_ERROR),
    DEFINE_STATUSCODE(STATUS_DS_OBJ_CLASS_VIOLATION),
    DEFINE_STATUSCODE(STATUS_DS_CANT_ON_NON_LEAF),
    DEFINE_STATUSCODE(STATUS_DS_CANT_ON_RDN),
    DEFINE_STATUSCODE(STATUS_DS_CANT_MOD_OBJ_CLASS),
    DEFINE_STATUSCODE(STATUS_DS_CROSS_DOM_MOVE_FAILED),
    DEFINE_STATUSCODE(STATUS_DS_GC_NOT_AVAILABLE),
    DEFINE_STATUSCODE(STATUS_DIRECTORY_SERVICE_REQUIRED),
    DEFINE_STATUSCODE(STATUS_REPARSE_ATTRIBUTE_CONFLICT),
    DEFINE_STATUSCODE(STATUS_CANT_ENABLE_DENY_ONLY),
    DEFINE_STATUSCODE(STATUS_FLOAT_MULTIPLE_FAULTS),
    DEFINE_STATUSCODE(STATUS_FLOAT_MULTIPLE_TRAPS),
    DEFINE_STATUSCODE(STATUS_DEVICE_REMOVED),
    DEFINE_STATUSCODE(STATUS_JOURNAL_DELETE_IN_PROGRESS),
    DEFINE_STATUSCODE(STATUS_JOURNAL_NOT_ACTIVE),
    DEFINE_STATUSCODE(STATUS_NOINTERFACE),
    DEFINE_STATUSCODE(STATUS_DS_ADMIN_LIMIT_EXCEEDED),
    DEFINE_STATUSCODE(STATUS_DRIVER_FAILED_SLEEP),
    DEFINE_STATUSCODE(STATUS_MUTUAL_AUTHENTICATION_FAILED),
    DEFINE_STATUSCODE(STATUS_CORRUPT_SYSTEM_FILE),
    DEFINE_STATUSCODE(STATUS_DATATYPE_MISALIGNMENT_ERROR),
    DEFINE_STATUSCODE(STATUS_WMI_READ_ONLY),
    DEFINE_STATUSCODE(STATUS_WMI_SET_FAILURE),
    DEFINE_STATUSCODE(STATUS_COMMITMENT_MINIMUM),
    DEFINE_STATUSCODE(STATUS_REG_NAT_CONSUMPTION),
    DEFINE_STATUSCODE(STATUS_TRANSPORT_FULL),
    DEFINE_STATUSCODE(STATUS_DS_SAM_INIT_FAILURE),
    DEFINE_STATUSCODE(STATUS_ONLY_IF_CONNECTED),
    DEFINE_STATUSCODE(STATUS_DS_SENSITIVE_GROUP_VIOLATION),
    DEFINE_STATUSCODE(STATUS_PNP_RESTART_ENUMERATION),
    DEFINE_STATUSCODE(STATUS_JOURNAL_ENTRY_DELETED),
    DEFINE_STATUSCODE(STATUS_DS_CANT_MOD_PRIMARYGROUPID),
    DEFINE_STATUSCODE(STATUS_SYSTEM_IMAGE_BAD_SIGNATURE),
    DEFINE_STATUSCODE(STATUS_PNP_REBOOT_REQUIRED),
    DEFINE_STATUSCODE(STATUS_POWER_STATE_INVALID),
    DEFINE_STATUSCODE(STATUS_DS_INVALID_GROUP_TYPE),
    DEFINE_STATUSCODE(STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN),
    DEFINE_STATUSCODE(STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN),
    DEFINE_STATUSCODE(STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER),
    DEFINE_STATUSCODE(STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER),
    DEFINE_STATUSCODE(STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER),
    DEFINE_STATUSCODE(STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER),
    DEFINE_STATUSCODE(STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER),
    DEFINE_STATUSCODE(STATUS_DS_HAVE_PRIMARY_MEMBERS),
    DEFINE_STATUSCODE(STATUS_WMI_NOT_SUPPORTED),
    DEFINE_STATUSCODE(STATUS_INSUFFICIENT_POWER),
    DEFINE_STATUSCODE(STATUS_SAM_NEED_BOOTKEY_PASSWORD),
    DEFINE_STATUSCODE(STATUS_SAM_NEED_BOOTKEY_FLOPPY),
    DEFINE_STATUSCODE(STATUS_DS_CANT_START),
    DEFINE_STATUSCODE(STATUS_DS_INIT_FAILURE),
    DEFINE_STATUSCODE(STATUS_SAM_INIT_FAILURE),
    DEFINE_STATUSCODE(STATUS_DS_GC_REQUIRED),
    DEFINE_STATUSCODE(STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY),
    DEFINE_STATUSCODE(STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS),
    DEFINE_STATUSCODE(STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED),
    DEFINE_STATUSCODE(STATUS_MULTIPLE_FAULT_VIOLATION),
    DEFINE_STATUSCODE(STATUS_NOT_SUPPORTED_ON_SBS),
    DEFINE_STATUSCODE(STATUS_WOW_ASSERTION),
    DEFINE_STATUSCODE(DBG_NO_STATE_CHANGE),
    DEFINE_STATUSCODE(DBG_APP_NOT_IDLE),
    DEFINE_STATUSCODE(RPC_NT_INVALID_STRING_BINDING),
    DEFINE_STATUSCODE(RPC_NT_WRONG_KIND_OF_BINDING),
    DEFINE_STATUSCODE(RPC_NT_INVALID_BINDING),
    DEFINE_STATUSCODE(RPC_NT_PROTSEQ_NOT_SUPPORTED),
    DEFINE_STATUSCODE(RPC_NT_INVALID_RPC_PROTSEQ),
    DEFINE_STATUSCODE(RPC_NT_INVALID_STRING_UUID),
    DEFINE_STATUSCODE(RPC_NT_INVALID_ENDPOINT_FORMAT),
    DEFINE_STATUSCODE(RPC_NT_INVALID_NET_ADDR),
    DEFINE_STATUSCODE(RPC_NT_NO_ENDPOINT_FOUND),
    DEFINE_STATUSCODE(RPC_NT_INVALID_TIMEOUT),
    DEFINE_STATUSCODE(RPC_NT_OBJECT_NOT_FOUND),
    DEFINE_STATUSCODE(RPC_NT_ALREADY_REGISTERED),
    DEFINE_STATUSCODE(RPC_NT_TYPE_ALREADY_REGISTERED),
    DEFINE_STATUSCODE(RPC_NT_ALREADY_LISTENING),
    DEFINE_STATUSCODE(RPC_NT_NO_PROTSEQS_REGISTERED),
    DEFINE_STATUSCODE(RPC_NT_NOT_LISTENING),
    DEFINE_STATUSCODE(RPC_NT_UNKNOWN_MGR_TYPE),
    DEFINE_STATUSCODE(RPC_NT_UNKNOWN_IF),
    DEFINE_STATUSCODE(RPC_NT_NO_BINDINGS),
    DEFINE_STATUSCODE(RPC_NT_NO_PROTSEQS),
    DEFINE_STATUSCODE(RPC_NT_CANT_CREATE_ENDPOINT),
    DEFINE_STATUSCODE(RPC_NT_OUT_OF_RESOURCES),
    DEFINE_STATUSCODE(RPC_NT_SERVER_UNAVAILABLE),
    DEFINE_STATUSCODE(RPC_NT_SERVER_TOO_BUSY),
    DEFINE_STATUSCODE(RPC_NT_INVALID_NETWORK_OPTIONS),
    DEFINE_STATUSCODE(RPC_NT_NO_CALL_ACTIVE),
    DEFINE_STATUSCODE(RPC_NT_CALL_FAILED),
    DEFINE_STATUSCODE(RPC_NT_CALL_FAILED_DNE),
    DEFINE_STATUSCODE(RPC_NT_PROTOCOL_ERROR),
    DEFINE_STATUSCODE(RPC_NT_UNSUPPORTED_TRANS_SYN),
    DEFINE_STATUSCODE(RPC_NT_UNSUPPORTED_TYPE),
    DEFINE_STATUSCODE(RPC_NT_INVALID_TAG),
    DEFINE_STATUSCODE(RPC_NT_INVALID_BOUND),
    DEFINE_STATUSCODE(RPC_NT_NO_ENTRY_NAME),
    DEFINE_STATUSCODE(RPC_NT_INVALID_NAME_SYNTAX),
    DEFINE_STATUSCODE(RPC_NT_UNSUPPORTED_NAME_SYNTAX),
    DEFINE_STATUSCODE(RPC_NT_UUID_NO_ADDRESS),
    DEFINE_STATUSCODE(RPC_NT_DUPLICATE_ENDPOINT),
    DEFINE_STATUSCODE(RPC_NT_UNKNOWN_AUTHN_TYPE),
    DEFINE_STATUSCODE(RPC_NT_MAX_CALLS_TOO_SMALL),
    DEFINE_STATUSCODE(RPC_NT_STRING_TOO_LONG),
    DEFINE_STATUSCODE(RPC_NT_PROTSEQ_NOT_FOUND),
    DEFINE_STATUSCODE(RPC_NT_PROCNUM_OUT_OF_RANGE),
    DEFINE_STATUSCODE(RPC_NT_BINDING_HAS_NO_AUTH),
    DEFINE_STATUSCODE(RPC_NT_UNKNOWN_AUTHN_SERVICE),
    DEFINE_STATUSCODE(RPC_NT_UNKNOWN_AUTHN_LEVEL),
    DEFINE_STATUSCODE(RPC_NT_INVALID_AUTH_IDENTITY),
    DEFINE_STATUSCODE(RPC_NT_UNKNOWN_AUTHZ_SERVICE),
    DEFINE_STATUSCODE(EPT_NT_INVALID_ENTRY),
    DEFINE_STATUSCODE(EPT_NT_CANT_PERFORM_OP),
    DEFINE_STATUSCODE(EPT_NT_NOT_REGISTERED),
    DEFINE_STATUSCODE(RPC_NT_NOTHING_TO_EXPORT),
    DEFINE_STATUSCODE(RPC_NT_INCOMPLETE_NAME),
    DEFINE_STATUSCODE(RPC_NT_INVALID_VERS_OPTION),
    DEFINE_STATUSCODE(RPC_NT_NO_MORE_MEMBERS),
    DEFINE_STATUSCODE(RPC_NT_NOT_ALL_OBJS_UNEXPORTED),
    DEFINE_STATUSCODE(RPC_NT_INTERFACE_NOT_FOUND),
    DEFINE_STATUSCODE(RPC_NT_ENTRY_ALREADY_EXISTS),
    DEFINE_STATUSCODE(RPC_NT_ENTRY_NOT_FOUND),
    DEFINE_STATUSCODE(RPC_NT_NAME_SERVICE_UNAVAILABLE),
    DEFINE_STATUSCODE(RPC_NT_INVALID_NAF_ID),
    DEFINE_STATUSCODE(RPC_NT_CANNOT_SUPPORT),
    DEFINE_STATUSCODE(RPC_NT_NO_CONTEXT_AVAILABLE),
    DEFINE_STATUSCODE(RPC_NT_INTERNAL_ERROR),
    DEFINE_STATUSCODE(RPC_NT_ZERO_DIVIDE),
    DEFINE_STATUSCODE(RPC_NT_ADDRESS_ERROR),
    DEFINE_STATUSCODE(RPC_NT_FP_DIV_ZERO),
    DEFINE_STATUSCODE(RPC_NT_FP_UNDERFLOW),
    DEFINE_STATUSCODE(RPC_NT_FP_OVERFLOW),
    DEFINE_STATUSCODE(RPC_NT_NO_MORE_ENTRIES),
    DEFINE_STATUSCODE(RPC_NT_SS_CHAR_TRANS_OPEN_FAIL),
    DEFINE_STATUSCODE(RPC_NT_SS_CHAR_TRANS_SHORT_FILE),
    DEFINE_STATUSCODE(RPC_NT_SS_IN_NULL_CONTEXT),
    DEFINE_STATUSCODE(RPC_NT_SS_CONTEXT_MISMATCH),
    DEFINE_STATUSCODE(RPC_NT_SS_CONTEXT_DAMAGED),
    DEFINE_STATUSCODE(RPC_NT_SS_HANDLES_MISMATCH),
    DEFINE_STATUSCODE(RPC_NT_SS_CANNOT_GET_CALL_HANDLE),
    DEFINE_STATUSCODE(RPC_NT_NULL_REF_POINTER),
    DEFINE_STATUSCODE(RPC_NT_ENUM_VALUE_OUT_OF_RANGE),
    DEFINE_STATUSCODE(RPC_NT_BYTE_COUNT_TOO_SMALL),
    DEFINE_STATUSCODE(RPC_NT_BAD_STUB_DATA),
    DEFINE_STATUSCODE(RPC_NT_CALL_IN_PROGRESS),
    DEFINE_STATUSCODE(RPC_NT_NO_MORE_BINDINGS),
    DEFINE_STATUSCODE(RPC_NT_GROUP_MEMBER_NOT_FOUND),
    DEFINE_STATUSCODE(EPT_NT_CANT_CREATE),
    DEFINE_STATUSCODE(RPC_NT_INVALID_OBJECT),
    DEFINE_STATUSCODE(RPC_NT_NO_INTERFACES),
    DEFINE_STATUSCODE(RPC_NT_CALL_CANCELLED),
    DEFINE_STATUSCODE(RPC_NT_BINDING_INCOMPLETE),
    DEFINE_STATUSCODE(RPC_NT_COMM_FAILURE),
    DEFINE_STATUSCODE(RPC_NT_UNSUPPORTED_AUTHN_LEVEL),
    DEFINE_STATUSCODE(RPC_NT_NO_PRINC_NAME),
    DEFINE_STATUSCODE(RPC_NT_NOT_RPC_ERROR),
    DEFINE_STATUSCODE(RPC_NT_UUID_LOCAL_ONLY),
    DEFINE_STATUSCODE(RPC_NT_SEC_PKG_ERROR),
    DEFINE_STATUSCODE(RPC_NT_NOT_CANCELLED),
    DEFINE_STATUSCODE(RPC_NT_INVALID_ES_ACTION),
    DEFINE_STATUSCODE(RPC_NT_WRONG_ES_VERSION),
    DEFINE_STATUSCODE(RPC_NT_WRONG_STUB_VERSION),
    DEFINE_STATUSCODE(RPC_NT_INVALID_PIPE_OBJECT),
    DEFINE_STATUSCODE(RPC_NT_INVALID_PIPE_OPERATION),
    DEFINE_STATUSCODE(RPC_NT_WRONG_PIPE_VERSION),
    DEFINE_STATUSCODE(RPC_NT_PIPE_CLOSED),
    DEFINE_STATUSCODE(RPC_NT_PIPE_DISCIPLINE_ERROR),
    DEFINE_STATUSCODE(RPC_NT_PIPE_EMPTY),
    DEFINE_STATUSCODE(RPC_NT_INVALID_ASYNC_HANDLE),
    DEFINE_STATUSCODE(RPC_NT_INVALID_ASYNC_CALL),
    DEFINE_STATUSCODE(RPC_NT_SEND_INCOMPLETE),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_OPCODE),
    DEFINE_STATUSCODE(STATUS_ACPI_STACK_OVERFLOW),
    DEFINE_STATUSCODE(STATUS_ACPI_ASSERT_FAILED),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_INDEX),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_ARGUMENT),
    DEFINE_STATUSCODE(STATUS_ACPI_FATAL),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_SUPERNAME),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_ARGTYPE),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_OBJTYPE),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_TARGETTYPE),
    DEFINE_STATUSCODE(STATUS_ACPI_INCORRECT_ARGUMENT_COUNT),
    DEFINE_STATUSCODE(STATUS_ACPI_ADDRESS_NOT_MAPPED),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_EVENTTYPE),
    DEFINE_STATUSCODE(STATUS_ACPI_HANDLER_COLLISION),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_DATA),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_REGION),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_ACCESS_SIZE),
    DEFINE_STATUSCODE(STATUS_ACPI_ACQUIRE_GLOBAL_LOCK),
    DEFINE_STATUSCODE(STATUS_ACPI_ALREADY_INITIALIZED),
    DEFINE_STATUSCODE(STATUS_ACPI_NOT_INITIALIZED),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_MUTEX_LEVEL),
    DEFINE_STATUSCODE(STATUS_ACPI_MUTEX_NOT_OWNED),
    DEFINE_STATUSCODE(STATUS_ACPI_MUTEX_NOT_OWNER),
    DEFINE_STATUSCODE(STATUS_ACPI_RS_ACCESS),
    DEFINE_STATUSCODE(STATUS_ACPI_INVALID_TABLE),
    DEFINE_STATUSCODE(STATUS_ACPI_REG_HANDLER_FAILED),
    DEFINE_STATUSCODE(STATUS_ACPI_POWER_REQUEST_FAILED),
    DEFINE_STATUSCODE(STATUS_CTX_WINSTATION_NAME_INVALID),
    DEFINE_STATUSCODE(STATUS_CTX_INVALID_PD),
    DEFINE_STATUSCODE(STATUS_CTX_PD_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_CTX_CDM_CONNECT),
    DEFINE_STATUSCODE(STATUS_CTX_CDM_DISCONNECT),
    DEFINE_STATUSCODE(STATUS_CTX_CLOSE_PENDING),
    DEFINE_STATUSCODE(STATUS_CTX_NO_OUTBUF),
    DEFINE_STATUSCODE(STATUS_CTX_MODEM_INF_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_CTX_INVALID_MODEMNAME),
    DEFINE_STATUSCODE(STATUS_CTX_RESPONSE_ERROR),
    DEFINE_STATUSCODE(STATUS_CTX_MODEM_RESPONSE_TIMEOUT),
    DEFINE_STATUSCODE(STATUS_CTX_MODEM_RESPONSE_NO_CARRIER),
    DEFINE_STATUSCODE(STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE),
    DEFINE_STATUSCODE(STATUS_CTX_MODEM_RESPONSE_BUSY),
    DEFINE_STATUSCODE(STATUS_CTX_MODEM_RESPONSE_VOICE),
    DEFINE_STATUSCODE(STATUS_CTX_TD_ERROR),
    DEFINE_STATUSCODE(STATUS_CTX_LICENSE_CLIENT_INVALID),
    DEFINE_STATUSCODE(STATUS_CTX_LICENSE_NOT_AVAILABLE),
    DEFINE_STATUSCODE(STATUS_CTX_LICENSE_EXPIRED),
    DEFINE_STATUSCODE(STATUS_CTX_WINSTATION_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_CTX_WINSTATION_NAME_COLLISION),
    DEFINE_STATUSCODE(STATUS_CTX_WINSTATION_BUSY),
    DEFINE_STATUSCODE(STATUS_CTX_BAD_VIDEO_MODE),
    DEFINE_STATUSCODE(STATUS_CTX_GRAPHICS_INVALID),
    DEFINE_STATUSCODE(STATUS_CTX_NOT_CONSOLE),
    DEFINE_STATUSCODE(STATUS_CTX_CLIENT_QUERY_TIMEOUT),
    DEFINE_STATUSCODE(STATUS_CTX_CONSOLE_DISCONNECT),
    DEFINE_STATUSCODE(STATUS_CTX_CONSOLE_CONNECT),
    DEFINE_STATUSCODE(STATUS_CTX_SHADOW_DENIED),
    DEFINE_STATUSCODE(STATUS_CTX_WINSTATION_ACCESS_DENIED),
    DEFINE_STATUSCODE(STATUS_CTX_INVALID_WD),
    DEFINE_STATUSCODE(STATUS_CTX_WD_NOT_FOUND),
    DEFINE_STATUSCODE(STATUS_CTX_SHADOW_INVALID),
    DEFINE_STATUSCODE(STATUS_CTX_SHADOW_DISABLED),
    DEFINE_STATUSCODE(STATUS_RDP_PROTOCOL_ERROR),
    DEFINE_STATUSCODE(STATUS_CTX_CLIENT_LICENSE_NOT_SET),
    DEFINE_STATUSCODE(STATUS_CTX_CLIENT_LICENSE_IN_USE),
    DEFINE_STATUSCODE(STATUS_PNP_BAD_MPS_TABLE),
    DEFINE_STATUSCODE(STATUS_PNP_TRANSLATION_FAILED),
    DEFINE_STATUSCODE(STATUS_PNP_IRQ_TRANSLATION_FAILED),

    _LASTENTRY
};


/*! \brief Return the description of an NTSTATUS code

 Searches in the NTSTATUS array for the supplied value, and returns a
 description for it if it finds some.

 \param Value
   The NTSTATUS value to be searched for

 \return 
   If the value is found, its alphanumerical description is used; 
   if not, "*UNKNOWN*" is returned.
*/
const UCHAR *
DebugNtStatus(NTSTATUS Value)
{
    int i = 0;

    while (text[i].Value != _MARKLASTENTRY)
    {
        if (text[i].Value == Value)
        {
            return text[i].Name;
        }
        ++i;
    }

    return "*UNKNOWN*";
}

#if DBG

#define USE_SPINLOCK 1

// #define USE_IRQL_ELEVATION 1

static volatile PCHAR DbgMemoryBuffer = NULL;
static volatile ULONG DbgNextWriteMemoryBuffer = 0;

#ifdef USE_SPINLOCK

static KSPIN_LOCK DbgMemoryBufferSpinLock;
static KIRQL DbgMemoryBufferSpinLockIrql;

#else // #ifdef USE_SPINLOCK

static LONG DbgMemoryBufferSpinLock = 0;
static LONG DbgMemoryBufferUsageCounter = 0;

#ifdef USE_IRQL_ELEVATION
    static KIRQL DbgMemoryBufferIrql;
#endif

#endif // #ifdef USE_SPINLOCK

#define DBG_SIZE_MEMORY_BUFFER 0x20000u

/*! \brief Start access to the debug memory buffer.

 This function synchronizes the access to the debug memory
 buffer. It obtains a lock which allows the caller to safely
 access the debug memory buffer.

 When the caller has completed, it has to call
 DbgBufferSynchronizeStop().

 \todo

    If we do not use the spinlock for synchronizing
    access, this function seems not to work at all!
*/

static VOID
DbgBufferSynchronizeStart(VOID)
{
    LONG tmp;
    KIRQL irql; // do not use Irql directly, but only indirectly,
                // as suggested by Doron Holan at
                // http://blogs.msdn.com/doronh/archive/2006/03/08/546934.aspx

#ifdef USE_SPINLOCK

    KeAcquireSpinLock(&DbgMemoryBufferSpinLock, &irql);
    DbgMemoryBufferSpinLockIrql = irql;

#else // #ifdef USE_SPINLOCK

    #ifdef USE_IRQL_ELEVATION

        if (DbgMemoryBufferIrql != PASSIVE_LEVEL)
        {
            REPORT_BUG(0x133, DbgMemoryBufferUsageCounter,
                DbgMemoryBufferSpinLock, DbgMemoryBufferIrql, 0,
                "Not IRQL == PASSIVE_LEVEL");
        }

        KeRaiseIrql(DISPATCH_LEVEL, &DbgMemoryBufferIrql);

    #endif // #ifdef USE_IRQL_ELEVATION

    while (InterlockedExchange(&DbgMemoryBufferSpinLock, 1) == 0)
        ;

    tmp = InterlockedIncrement(&DbgMemoryBufferUsageCounter);
    if (tmp != 1)
    {
        REPORT_BUG(0x130, tmp, DbgMemoryBufferSpinLock, 0, 0,
            "Usage counter bigger than 1 after incrementing!");
    }

#endif // #ifdef USE_SPINLOCK
}

/*! \brief End access to the debug memory buffer.

 This function ends the access to the debug memory
 buffer, which has previously been allocated by
 DbgBufferSynchronizeStart().
*/

static VOID
DbgBufferSynchronizeStop(VOID)
{
    LONG tmp;

#ifdef USE_SPINLOCK

    KeReleaseSpinLock(&DbgMemoryBufferSpinLock, DbgMemoryBufferSpinLockIrql);

#else // #ifdef USE_SPINLOCK

    tmp = InterlockedDecrement(&DbgMemoryBufferUsageCounter);
    if (tmp != 0)
    {
        REPORT_BUG(0x131, tmp, DbgMemoryBufferSpinLock, 0, 0,
            "Usage counter not null after decrementing!");
    }

    tmp = InterlockedExchange(&DbgMemoryBufferSpinLock, 0);
    if (tmp != 1)
    {
        REPORT_BUG(0x132, DbgMemoryBufferUsageCounter, tmp, 0, 0,
            "(own) Spinlock not 1 before releasing.");
    }

    #ifdef USE_IRQL_ELEVATION

        KeLowerIrql(DbgMemoryBufferIrql);
        DbgMemoryBufferIrql = PASSIVE_LEVEL;

    #endif // #ifdef USE_IRQL_ELEVATION

#endif // #ifdef USE_SPINLOCK
}

VOID
DbgInit(VOID)
{
#ifdef USE_SPINLOCK

    KeInitializeSpinLock(&DbgMemoryBufferSpinLock);

#endif // #ifdef USE_SPINLOCK
}

/*! \brief Get storage area for debugging output

 This function allocates memory for the debugging output
 storage.
*/
VOID
DbgAllocateMemoryBuffer(VOID)
{
    DbgBufferSynchronizeStart();

    DbgMemoryBuffer = ExAllocatePoolWithTag(NonPagedPool,
        DBG_SIZE_MEMORY_BUFFER + 1, MTAG_DBGBUFFER);

    if (DbgMemoryBuffer)
    {
        RtlZeroMemory(DbgMemoryBuffer, DBG_SIZE_MEMORY_BUFFER + 1);
    }

    DbgNextWriteMemoryBuffer = 0;

    DbgBufferSynchronizeStop();
}

/*! \brief Free storage area for debugging output

 This function frees the memory of the debugging output.
*/
VOID
DbgFreeMemoryBuffer(VOID)
{
    DbgBufferSynchronizeStart();

    if (DbgMemoryBuffer)
    {
        ExFreePool(DbgMemoryBuffer);
        DbgMemoryBuffer = NULL;
    }

    DbgBufferSynchronizeStop();
}

/*! \brief Output into the debugging buffer

 This function outputs a string into the debugging
 output buffer.

 \param String:
    Pointer to the string which is to be output

 \todo
    More debugging for the sanity checks to find the
    cause why DbgBufferSynchronizeStart() does not work
    without using the SpinLock.
*/
VOID
DbgOutputMemoryBuffer(const char *String)
{
    DbgBufferSynchronizeStart();

    if (DbgMemoryBuffer)
    {
        PCHAR localMemoryBuffer;
        ULONG localNextWriteMemoryBuffer;
        ULONG strLength;

        localMemoryBuffer = DbgMemoryBuffer;
        localNextWriteMemoryBuffer = DbgNextWriteMemoryBuffer;

        if (DbgNextWriteMemoryBuffer > DBG_SIZE_MEMORY_BUFFER)
        {
            REPORT_BUG(0x123, DbgNextWriteMemoryBuffer, DBG_SIZE_MEMORY_BUFFER, -1, 0,
                "DbgNextWriteMemoryBuffer already out of buffer!");
        }
        
        strLength = strlen(String) + 1;

        if (strLength >= 200)
        {
            REPORT_BUG(0x123, DbgNextWriteMemoryBuffer, DBG_SIZE_MEMORY_BUFFER,
                strLength, 0, "string too long");
        }

        // Sanity check

        if ((localMemoryBuffer != DbgMemoryBuffer) 
            || (localNextWriteMemoryBuffer != DbgNextWriteMemoryBuffer))
        {
            REPORT_BUG(0x140, (ULONG_PTR) localMemoryBuffer, (ULONG_PTR) DbgMemoryBuffer, 
                localNextWriteMemoryBuffer, DbgNextWriteMemoryBuffer,
                "local copies do not match the global ones (1)");
        }

        // Does the string fit into the buffer?

        if (DbgNextWriteMemoryBuffer + strLength > DBG_SIZE_MEMORY_BUFFER)
        {
            if (DBG_SIZE_MEMORY_BUFFER - DbgNextWriteMemoryBuffer >= strLength)
            {
                REPORT_BUG(0x124, DbgNextWriteMemoryBuffer, DBG_SIZE_MEMORY_BUFFER,
                    strLength, 0, "");
            }

            // Sanity check

            if ((localMemoryBuffer != DbgMemoryBuffer) 
                || (localNextWriteMemoryBuffer != DbgNextWriteMemoryBuffer))
            {
                REPORT_BUG(0x141, (ULONG_PTR) localMemoryBuffer, (ULONG_PTR) DbgMemoryBuffer, 
                    localNextWriteMemoryBuffer, DbgNextWriteMemoryBuffer,
                    "local copies do not match the global ones (2)");
            }

            RtlZeroMemory(&DbgMemoryBuffer[DbgNextWriteMemoryBuffer],
                DBG_SIZE_MEMORY_BUFFER - DbgNextWriteMemoryBuffer);

            // Sanity check

            if ((localMemoryBuffer != DbgMemoryBuffer) 
                || (localNextWriteMemoryBuffer != DbgNextWriteMemoryBuffer))
            {
                REPORT_BUG(0x142, (ULONG_PTR) localMemoryBuffer, (ULONG_PTR) DbgMemoryBuffer, 
                    localNextWriteMemoryBuffer, DbgNextWriteMemoryBuffer,
                    "local copies do not match the global ones (3)");
            }

            DbgNextWriteMemoryBuffer = 0;
            localNextWriteMemoryBuffer = 0;
        }

        // Sanity check

        if ((localMemoryBuffer != DbgMemoryBuffer) 
            || (localNextWriteMemoryBuffer != DbgNextWriteMemoryBuffer))
        {
            REPORT_BUG(0x143, (ULONG_PTR) localMemoryBuffer, (ULONG_PTR) DbgMemoryBuffer, 
                localNextWriteMemoryBuffer, DbgNextWriteMemoryBuffer,
                "local copies do not match the global ones (4)");
        }

        if (DbgNextWriteMemoryBuffer > DBG_SIZE_MEMORY_BUFFER)
        {
            REPORT_BUG(0x125, DbgNextWriteMemoryBuffer, DBG_SIZE_MEMORY_BUFFER,
                strLength, 0,
                "String does not fit in the buffer (but should have fitted!)");
        }
        
        // Sanity check

        if ((localMemoryBuffer != DbgMemoryBuffer) 
            || (localNextWriteMemoryBuffer != DbgNextWriteMemoryBuffer))
        {
            REPORT_BUG(0x144, (ULONG_PTR) localMemoryBuffer, (ULONG_PTR) DbgMemoryBuffer, 
                localNextWriteMemoryBuffer, DbgNextWriteMemoryBuffer,
                "local copies do not match the global ones (5)");
        }

        if (DbgNextWriteMemoryBuffer > 0)
        {
            DbgMemoryBuffer[DbgNextWriteMemoryBuffer-1] = 13;
        }

        // Sanity check

        if ((localMemoryBuffer != DbgMemoryBuffer) 
            || (localNextWriteMemoryBuffer != DbgNextWriteMemoryBuffer))
        {
            REPORT_BUG(0x145, (ULONG_PTR) localMemoryBuffer, (ULONG_PTR) DbgMemoryBuffer, 
                localNextWriteMemoryBuffer, DbgNextWriteMemoryBuffer,
                "local copies do not match the global ones (6)");
        }

        RtlCopyMemory(&DbgMemoryBuffer[DbgNextWriteMemoryBuffer], String, strLength);
        DbgNextWriteMemoryBuffer += strLength;
        localNextWriteMemoryBuffer += strLength;

        // Sanity check

        if ((localMemoryBuffer != DbgMemoryBuffer) 
            || (localNextWriteMemoryBuffer != DbgNextWriteMemoryBuffer))
        {
            REPORT_BUG(0x146, (ULONG_PTR) localMemoryBuffer, (ULONG_PTR) DbgMemoryBuffer, 
                localNextWriteMemoryBuffer, DbgNextWriteMemoryBuffer,
                "local copies do not match the global ones (7)");
        }

        if (DbgNextWriteMemoryBuffer > DBG_SIZE_MEMORY_BUFFER)
        {
            REPORT_BUG(0x126, DbgNextWriteMemoryBuffer, DBG_SIZE_MEMORY_BUFFER,
                strLength, 0,
                "DbgNextWriteMemoryBuffer out of buffer after write!");
        }
        
        // Sanity check

        if ((localMemoryBuffer != DbgMemoryBuffer) 
            || (localNextWriteMemoryBuffer != DbgNextWriteMemoryBuffer))
        {
            REPORT_BUG(0x147, (ULONG_PTR) localMemoryBuffer, (ULONG_PTR) DbgMemoryBuffer, 
                localNextWriteMemoryBuffer, DbgNextWriteMemoryBuffer,
                "local copies do not match the global ones (8)");
        }
    }

    DbgBufferSynchronizeStop();
}

/*! \brief Give the debug buffer contents to the installer

 This function is used to get the contents of the debug buffer
 for the use of the installer.

 \param Pdx
   Pointer to the device extension.

 \param ReturnBuffer
   Pointer to a buffer which will contain the result.

 \param ReturnLength
   Pointer to a ULONG which contains the length of the ReturnBuffer
   on entry, and which will contain the length of the written
   ReturnBuffer on exit.

 \return 
   If the routine succeeds, it returns STATUS_SUCCESS. Otherwise, it
   returns one of the error status values.
 
 This function copies the last ReturnLength bytes into the buffer.
*/

NTSTATUS
cbm_dbg_readbuffer(IN PDEVICE_EXTENSION Pdx, OUT PCHAR ReturnBuffer,
                   IN OUT PULONG ReturnLength)
{
    FUNC_ENTER();

    DbgBufferSynchronizeStart();

    if (DbgMemoryBuffer)
    {
        PCHAR writePosition;
        ULONG stillToWrite;
        ULONG writtenBytes;

        writePosition = ReturnBuffer;
        stillToWrite = *ReturnLength;
        writtenBytes = 0;


        if (stillToWrite > DbgNextWriteMemoryBuffer)
        {
            ULONG lengthBeforeWrapAround;

            //! \todo

            // First of all, find out if there are any "old" entries
            // from before the wrap-around

            lengthBeforeWrapAround = 
                strlen(&DbgMemoryBuffer[DbgNextWriteMemoryBuffer+1]) + 1;

            if (lengthBeforeWrapAround > 1)
            {
                ULONG lengthToCopy;

                lengthToCopy = stillToWrite - DbgNextWriteMemoryBuffer + 1;

                lengthToCopy = min(lengthToCopy, lengthBeforeWrapAround);

                RtlCopyMemory(writePosition, 
                    &DbgMemoryBuffer[DbgNextWriteMemoryBuffer 
                                     + lengthBeforeWrapAround 
                                     - lengthToCopy],
                    lengthToCopy);

                writePosition += lengthToCopy;
                writtenBytes += lengthToCopy;
                stillToWrite -= lengthToCopy;

                if (stillToWrite > 0)
                {
                    *writePosition++ = 13;
                    ++writtenBytes;
                    --stillToWrite;
                }
            }
        }

        stillToWrite = min(stillToWrite, DbgNextWriteMemoryBuffer);

        RtlCopyMemory(writePosition,
            &DbgMemoryBuffer[DbgNextWriteMemoryBuffer - stillToWrite],
            stillToWrite);

        writtenBytes += stillToWrite;


        *ReturnLength = writtenBytes;
    }

    DbgBufferSynchronizeStop();

    FUNC_LEAVE_NTSTATUS_CONST(STATUS_SUCCESS);
}

#endif
