//---------------------------------------------------------------------------

#include <windows.h>
#include <iostream.h>
#define CAPTION "dpx loader"
#pragma hdrstop

//---------------------------------------------------------------------------

void win_err_message(void)
{
  LPVOID lpMsgBuf;
 
  FormatMessage(
    FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
    NULL,
    GetLastError(),
    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
    (LPTSTR) &lpMsgBuf,
    0,
    NULL);

  MessageBox( NULL, (char *)lpMsgBuf, CAPTION, MB_OK | MB_ICONERROR);

  LocalFree(lpMsgBuf);

}

unsigned long get_dll_size(void)
{

  FILE *f;
  unsigned long ret_val;

  f = fopen("dplayerx.dll", "rb");

  if (!f)
    return 0;

  fseek(f, 0, SEEK_END);
  ret_val = ftell(f);
  fclose(f);

  return ret_val;

}

bool dump_one_function(unsigned char *ptr, unsigned long length, char *file)
{

  FILE *f;

  if (!length)
    return true; // nothing to do !

  // now we write

  f = fopen(file, "wb");

  if (!f)
    return false;

  if (fwrite((void *)ptr, length + 1, 1, f) < 1)
  {
    fclose(f);
    return false;
  }

  fclose(f);
  return true;

}

bool dump_functions(HINSTANCE h_todump, unsigned long size)
{

  long i;
  long version;
  unsigned long base;
  char fname[256];

   base = (unsigned long) h_todump;

  switch(size)
  {
    case 136704 :
    {
      version = 1;
      base += 0x0000650e;
      break;
    }

    case 138752 :
    {
      version = 2;
      base += 0x00006cee;
      break;
    }

    default:
      version = 0;

  }

  if (!version)
  {
    cout << "Dumping does not apply for this dll" << endl;
    return true; // 'tis not an error though
  }

  cout << "Dumping version : " << version << " --> cross thy fingers" << endl;

  for(i = 0; i < 2; i++)
  {

    sprintf(fname, "f%d.bin", i);

    cout << i + 1 << " of " << 2 << " dump_one_function()" << endl;

    if (!dump_one_function((unsigned char *)base, 0x0115, fname))
      return false;

    base += 0x115;

  }

  cout << "dumped the eax modifiers" << endl;

  return true;
}

#pragma argsused
int main(int argc, char **argv)
{

  HINSTANCE h_dpx;
  unsigned long dll_size;
  char display_buffer[256];

  cout << "dpx loader by ArthaXerXes" << endl;
  cout << endl << "---STATUS CONSOLE---" << endl << endl;

  cout << "get_dll_size()" << endl;

  dll_size = get_dll_size();

  if (!dll_size)
  {
    MessageBox(NULL, "Unable to open dplayerx.dll in the current directory", CAPTION, MB_OK);
    return 0;
  }

  sprintf(display_buffer, "Attempting to load dplayerx.dll (%d)", dll_size);

  MessageBox(NULL, display_buffer, CAPTION, MB_OK);

  cout << "h_dpx = LoadLibraryEx(\"dplayerx.dll\", NULL, NULL)" << endl;
  h_dpx = LoadLibraryEx("dplayerx.dll", NULL, NULL);

  if (!h_dpx)
  {
    win_err_message();
    return 0;
  }

  MessageBox(NULL, "Loaded ok.", CAPTION, MB_OK | MB_ICONINFORMATION);

  if (MessageBox(NULL, "Dost thou wish to dump the functions ?", CAPTION, MB_YESNO | MB_ICONQUESTION) == IDYES)
  {
    cout << "dump_functions()" << endl;

    if (!dump_functions(h_dpx, dll_size))
      win_err_message();
    else
      MessageBox(NULL, "It hath been done", CAPTION, MB_OK | MB_ICONINFORMATION);
  }

  cout << "FreeLibrary(h_dpx)" << endl;
  if (!FreeLibrary(h_dpx))
  {
    win_err_message();
    return 0;
  }

  MessageBox(NULL, "Unloaded ok.", CAPTION, MB_OK | MB_ICONINFORMATION);

  return 0;
}
//---------------------------------------------------------------------------
 