//#define DPFLAGS (D3DDP_DONOTLIGHT | D3DDP_DONOTUPDATEEXTENTS | D3DDP_DONOTCLIP)
#define DPFLAGS (D3DDP_DONOTLIGHT | D3DDP_DONOTUPDATEEXTENTS) & 0


class ExeBuffer {
public:
	ExeBuffer();
	~ExeBuffer();

	void SetTex(Tex *);
	void ForceTex(Tex *);

	void AddTri(D3DTLVERTEX &a, D3DTLVERTEX &b, D3DTLVERTEX &c) {
		if (_num == _max) Flush();

		_buf[_num*3] = a;
		_buf[_num*3+1] = b;
		_buf[_num*3+2] = c;

		_num++;
	}

	void Flush() {
		if (!_num) return;

		DX.D3DD->DrawPrimitive(D3DPT_TRIANGLELIST, D3DFVF_TLVERTEX, (void *)_buf, _num*3, DPFLAGS);
		_num = 0;
	}

	D3DTLVERTEX * GetBuffer(int n) {
		if ((_num+n) > _max) Flush();

		_num += n;

		return _buf+((_num-n)*3);
	}
/*
	void AddTri() {
		if (_num == _max) Flush();
		_num++;
	}
*/
	void AddTri(D3DTLVERTEX tri[3]) {
		if (_num == _max) Flush();

		_buf[_num*3] = tri[0];
		_buf[_num*3+1] = tri[1];
		_buf[_num*3+2] = tri[2];

		_num++;
	}

	void SetAlphaTestFunc(int func) {
		if (func != _lastalphatestfunc) {
			Flush();
			DX.D3DD->SetRenderState(D3DRENDERSTATE_ALPHAFUNC, func);
			_lastalphatestfunc = func;
		}
	}

	void SetColorOp(D3DTEXTUREOP op) {
		if (op != _lastcolorop) {
			Flush();
			DX.D3DD->SetTextureStageState(0, D3DTSS_COLOROP, op);
			_lastcolorop = op;
		}
	}

	void SetColorArg1(int arg1) {
		if (arg1 != _lastcolorarg1) {
			Flush();
			DX.D3DD->SetTextureStageState(0, D3DTSS_COLORARG1, arg1);
			_lastcolorarg1 = arg1;
		}
	}
	
	void SetColorArg2(int arg2) {
		if (arg2 != _lastcolorarg2) {
			Flush();
			DX.D3DD->SetTextureStageState(0, D3DTSS_COLORARG2, arg2);
			_lastcolorarg2 = arg2;
		}	
	}	
	
	void SetAlphaOp(D3DTEXTUREOP op) {
		if (op != _lastalphaop) {
			Flush();
			DX.D3DD->SetTextureStageState(0, D3DTSS_ALPHAOP, op);
			_lastalphaop = op;
		}
	}
	
	void SetAlphaArg1(int arg1) {
		if (arg1 != _lastalphaarg1) {
			Flush();
			DX.D3DD->SetTextureStageState(0, D3DTSS_ALPHAARG1, arg1);
			_lastalphaarg1 = arg1;
		}
	}
	
	void SetAlphaArg2(int arg2) {
		if (arg2 != _lastalphaarg2) {
			Flush();
			DX.D3DD->SetTextureStageState(0, D3DTSS_ALPHAARG2, arg2);
			_lastalphaarg2 = arg2;
		}
	}

	void SetAddressMode(int umode, int vmode) {
		if (umode != _lastumode) {
			Flush();
			if (Settings.clamp)		DX.D3DD->SetRenderState(D3DRENDERSTATE_TEXTUREADDRESS, umode);
			else					DX.D3DD->SetTextureStageState(0, D3DTSS_ADDRESSU, umode);
		}

		if (vmode != _lastvmode) {
			Flush();
			if (Settings.clamp)		DX.D3DD->SetRenderState(D3DRENDERSTATE_TEXTUREADDRESS, vmode);
			else					DX.D3DD->SetTextureStageState(0, D3DTSS_ADDRESSV, vmode);
		}
	}

	void ColorKeyEnable(int mode) {
		if (mode != _lastckmode) {
			Flush();

			DX.D3DD->SetRenderState(D3DRENDERSTATE_COLORKEYENABLE, mode);
			_lastckmode = mode;
		}
	}

//	void SetAlphaSrcBlendFunc

private:
	int _lastcolorop, _lastcolorarg1, _lastcolorarg2;
	int _lastalphaop, _lastalphaarg1, _lastalphaarg2;
	int _lastumode, _lastvmode;
	int _lastalphatestfunc;
	int _lastckmode;

	int _num, _max;
	D3DTLVERTEX *_buf;
};