


.



                               Edit Users Manual

          _1.  _I_n_t_r_o_d_u_c_t_i_o_n

          _E_d_i_t is a screen-oriented text editor derived from the stan-
          dard  UNIX editor _e_d.  In addition to the obvious advantages
          of being able to edit  in  two  dimensions,  _e_d_i_t  offers  a
          number of special features, bells, and whistles, including:
              on-line help
              crash recovery
              automatic spell checking of text being entered
              automatic line breaking at word boundaries
              macros
              editing of multiple files
          This document is intended to serve as an introduction to the
          "novel"  (i.e.  different from _e_d) features of _e_d_i_t and as a
          complete reference manual.  For a  tutorial  description  of
          those  features  shared  with  _e_d  (i.e. much of "Commands",
          "Addressing", and "Regular  Expressions")  see  "A  Tutorial
          Introduction  to the UNIX Text Editor" and "Advanced Editing
          on UNIX" in the _U_N_I_X _P_r_o_g_r_a_m_m_e_r'_s _M_a_n_u_a_l.

          _2.  _T_h_e _S_c_r_e_e_n

          The screen is divided into two parts: the command  area  and
          the  window area.  The last two lines of the screen comprise
          the command area and the remainder the window area.

          _2._1.  _T_h_e _W_i_n_d_o_w _A_r_e_a

          The text of  each  file  being  edited  is  displayed  in  a
          seperate  window.   These windows are named after letters of
          the alphabet.  A window may also contain shell commands  and
          output,  or  help information.  Windows are created with the
          "e",  "!",  or  help  commands,  and  deleted  by  the  "q",
          "noshell",  and  "nohelp"  commands.  A maximum of 3 windows
          may be on the screen at one time.

          The bottom line of each  window  is  its  _s_t_a_t_u_s  _l_i_n_e.   It
          displays:
             (1)  The name of the window in the form "File_X:" where  _X
                  is the letter corresponding to the window name.
             (2)  The name of the file displayed in the window.
             (3)  The current line number (".").
             (4)  The number of the last line in the file ("$").
             (5)  The page number on which the current line  would  be
                  found in a _p_r listing.
          All of the spaces in the status line which are not  display-
          ing  information  are filled with carets ('^') as a mnemonic
          reminder that the line is associated with the text above it.

          The remainder of the window contains a portion of  the  text
          of  the file being edited.  For each text line the following
          is displayed:









.
          EDIT USERS MANUAL                                          2


             (1)  the line number
             (2)  an upper case letter denoting the mark, if any
             (3)  a '.' if the line is the current line or a '$' if it
                  is the last line
             (4)  the text itself
          If the text line is longer than the screen line, it is  con-
          tinued  on  the next screen line, but without a line number.
          The continued portion of the line is normally  right  justi-
          fied.

          _2._2.  _T_h_e _C_o_m_m_a_n_d _A_r_e_a

          The bottom line of the  screen  is  the  _c_o_m_m_a_n_d  _l_i_n_e.   It
          begins  with  a  prompt which gives an indication of what is
          expected.  The usual prompt is of the form "_W:  " where _W is
          the name of the current window.  This indicates that _e_d_i_t is
          expecting a command (if the cursor is on the  command  line)
          and  specifies which window that command will affect.  Other
          prompts are described below.  The remainder of  the  command
          line is used to assemble and display the current command (or
          option value, buffer line, or any other input which  is  not
          being entered into one of the files being edited).

          The line above the command line is the _m_e_s_s_a_g_e _l_i_n_e  and  is
          used  to display error messages and to prompt for additional
          input.  It is cleared after  the  successful  completion  of
          each command.

          Each window has a _d_e_f_a_u_l_t _l_i_n_e which is a screen line  about
          2/3  of the way down from the top of the window.  _E_d_i_t tries
          to keep the current text line as close as possible  to  this
          screen line.

          _3.  _M_o_d_e_s

          Edit may be considered to be in one of two modes,  depending
          on  the  location  of the cursor.  When the cursor is on the
          bottom line of the screen, edit is in _c_o_m_m_a_n_d mode and  will
          accept  and  execute  commands  similar  to those of _e_d (see
          "Commands").  When the cursor is in the window area, edit is
          in  _c_u_r_s_o_r mode and changes and additions may be made to the
          text of the file.  In addition, there is a special  case  of
          cursor  mode  called  _i_n_s_e_r_t mode where characters are being
          inserted at the end of the current line ('.').  The distinc-
          tion  between  insert  and cursor modes is rather subtle and
          may be ignored until you hit RETURN.   In  addition,  screen
          mode may be divided into two submodes: _i_n_s_e_r_t where the cur-
          sor is positioned at the end of the current line ("."),  and
          _m_o_d_i_f_y  when  the  cursor is at any other location.  When in
          insert mode, typing RETURN begins a new blank line below the
          current line.  When in modify mode, typing RETURN returns to
          the point at which modify mode was entered.  In either case,
          typing CONTROL-D returns to command mode.



                                    10/2/81






.
          EDIT USERS MANUAL                                          3


          _3._1.  _C_o_m_m_a_n_d _M_o_d_e

          In the command mode edit functions for the most part like _e_d
          except  that  the  results of the commands are automatically
          shown on the screen.

          _3._2.  _C_u_r_s_o_r _M_o_d_e

          Hitting RETURN returns to the point from which  cursor  mode
          was entered (i.e. either command mode or insert mode).

          _3._3.  _I_n_s_e_r_t _M_o_d_e

          _I_n_s_e_r_t mode is  a  modification  of  cursor  mode  which  is
          intended  for  entering  new line of text into the file.  It
          differs from cursor mode in that hitting  RETURN  creates  a
          new  blank text line rather than returning to the point from
          which the mode was entered, and that the kill character will
          delete the entire current line.

          The insert mode is entered via the _a, _c, or _i commands.   It
          is  the  same  as the insert mode in _e_d except that lines of
          text before  and  after  the  line  being  entered  is  also
          displayed.   Also,  character  and line deleting are handled
          differently from their usual UNIX treatment.   Entering  the
          erase character causes the preceeding character to disappear
          and moves the cursor to take its place.  If the erased char-
          acter was a tab, intervening spaces are skipped over and the
          cursor ends up in the correct location.  Entering  the  kill
          character  causes the entire line to disappear and positions
          the cursor at the beginning of the resulting empty line.  If
          either of the erase or kill characters is a printing charac-
          ter it may be entered into the text by preceeding it with  a
          '\'.   No non-printing characters except tab and newline may
          be entered into the text.  If typed, they are ignored.

          _4.  _U_s_i_n_g _E_d_i_t

          _4._1.  _I_n_v_o_k_i_n_g _E_d_i_t

          Before _e_d_i_t can run, it must know what type of  terminal  it
          is talking to.  This is done by setting the TERM environment
          variable to a code specifying the the terminal.  The  safest
          way  to do this is with the program _t_e_r_m_t_y_p_e, which looks in
          the system configuration file to find out what kind of  ter-
          minal  you  are (supposed to be) logged in on.  This can all
          be done automatically by putting the lines:
               TERM='termtype'
               export TERM
          in your .profile file.  If you are using  a  terminal  other
          than  the  one the system thinks you are using you will have
          to explicitly set TERM to the code for this terminal.




                                    10/2/81






.
          EDIT USERS MANUAL                                          4


          Once this detail is attended to you  can  begin  editing  by
          typing
               edit [-<options>] filename
          where filename is the name of the file  to  be  edited,  and
          <options>  is  a string specifying the options you wish set.
          For example, if you want tabs to be  expanded  to  4  spaces
          instead of 8 and no spaces placed between joined lines, type
               edit -jt4 filename
          If you always want the same options to be set you  can  save
          typing  by  setting  the EDIT environment variable to be the
          options string.  To have the same options as above in effect
          for all editing sessions, put the lines
               EDIT=jt4
               export EDIT
          in your .profile file.
          There are several other environment variables used by
          _e_d_i_t.
          These will be discussed below.

          _4._2.
          _B_a_s_i_c _e_d_i_t_i_n_g

          A few seconds after typing "edit  ..."  your  screen  should
          clear  and  fill  with  text  from  the  specified  file  as
          described above in "The screen".   At  this  point  you  can
          begin typing commands just as in _e_d with the difference that
          the results of the commands are immediately visible  on  the
          screen.   Since each line is numbered, it is easy to specify
          the address of any line on the screen.  The current line has
          a  '.' between the line number and the text of the line, and
          if any marked line is on the screen, an  upper  case  letter
          corresponding  to the mark name is displayed to the right of
          the line number.

          To scroll forward through the file, hit  RETURN;  to  scroll
          backward type '-' followed by RETURN.

          Typing one of the commands for entering new  text  into  the
          file  ('a',  'c',  or 'i') opens up a line on the screen and
          places the cursor at the beginning of it.  Subsequent  char-
          acters will be entered into the file until a line consisting
          of a single '.' in the first column is entered.  Again as in
          _e_d  except  that  the  new  lines are seen in context.  Some
          other differences: There is no ambiguity  about  backspacing
          over   tabs.    If   a  non-printing  control  character  is
          accidently hit, it is ignored; it is impossible (or at least
          difficult, see option 'a') to enter a garbage character into
          a file.  If a non-printing character is already  present  in
          the  file, it is made visible in a manner which is dependent
          on terminal type: on the Infoton all control characters  are
          displayed  as  a  cent  sign  (c/),  on  the  2621  they  are
          represented by underlined letters, and on the H19  they  are
          displayed as letters in reverse video.



                                    10/2/81






.
          EDIT USERS MANUAL                                          5


          _4._2._1.   _C_u_r_s_o_r  _m_o_d_e    Pressing  one  of  the  arrow  keys
          (remember  to shift on the HP terminal) moves the cursor one
          position in the indicated direction and  enters  the  _c_u_r_s_o_r
          _m_o_d_e.   Any  subsequent  characters  which are typed will be
          inserted into the text immediately to the left of the cursor
          and  any  text to the right will be moved over to make room.
          If you wish the new characters to replace the existing ones,
          hit  the  enter-overwrite-mode key before typing any charac-
          ters.  If you always want to overwrite rather  than  insert,
          set the

          Pressing the delete-character key deletes the  character  at
          the  cursor  position and shifts any characters to the right
          over.

          There are several line oriented operations which may be per-
          formed  from  cursor  mode.  In particular most command mode
          commands which would make sense (eg. 'a', 'd', 'i', 'j') may
          be  performed  by  prefixing them with ESCAPE.  For example,
          esc-d deletes the line the cursor is on and esc-j joins  the
          current line to its successor.

          This makes it possible to scroll the screen forward by  typ-
          ing  esc-h  and  backwards by typing esc-^.  The screen will
          also scroll if you attempt to move past the  top  or  bottom
          with the arrow keys.

          It is possible to get into cursor mode directly from command
          mode.   Pressing  any  of  the  cursor  mode  keys or escape
          sequences enters cursor mode on the first character  of  '.'
          and  then  performs its particular function.  The find ('f')
          command searches out the next occurrence  of  the  specified
          regular  expression  and enters cursor mode at the beginning
          of the matched string.

          To get out of cursor mode, type RETURN.  This does just what
          the  name  implies: if you had been in command mode you will
          return to command mode, if you had been inserting  you  will
          return  to  the  point where you left off.  Thus, if you are
          entering text and notice an error on a previous  line,  just
          move  to it with the arrows, correct it, hit RETURN and con-
          tinue where you left off.

          _4._3.  _E_d_i_t_i_n_g _T_e_x_t   _E_d_i_t has  several  features  which  are
          oriented  towards  entering text intended for human consump-
          tion (documents as opposed  to  programs).   With  the  word
          break ('w') option set you can enter continuous text without
          having to keep looking at the screen to see if you are  get-
          ting  near  the end of the line.  if a word is entered which
          would extend past the right margin, a new  line  is  started
          and  as  much  of  the  word which had already been typed is
          removed from the end of the previous line and placed at  the
          beginning of the new line.



                                    10/2/81






.
          EDIT USERS MANUAL                                          6


          If you suffer from poor  orthography,  you  can  have  words
          checked for proper spelling as you enter them by setting the
          's' option.  Then, whenever a misspelled  word  is  entered,
          _e_d_i_t beeps and displays a message on the message line.  Typ-
          ing esc-s positions the cursor at the  offending  word.   If
          the  word  in question is really the name of a rare Transyl-
          vanian neurological dysfunction and you get tired  of  being
          beeped  at  every  time you type it, typing esc-o will cause
          _e_d_i_t to accept the spelling as correct.

          _4._4.  _E_d_i_t_i_n_g _P_r_o_g_r_a_m_s   _E_d_i_t also has some features to make
          programmers lives easier.  If you like to display the struc-
          ture of your program by indenting, setting  the  auto-indent
          ('i')  option  will reduce the wear and tear on the tab key.
          With this option set each new line entered is  automatically
          indented  the same amount as the line above it.  To increase
          the level of indenting, add another tab; to decrease,  back-
          space over the excess.

          _E_d_i_t has the ablity to find the proper mate for the bracket-
          ing characters ([], (), {}).  To find a matching parenthesis
          in  a  complicated  expression,  put  the  cursor   at   the
          parenthesis in question and hit esc-m.  The cursor will move
          to the matching parenthesis.  If it moves to someplace unex-
          pected  there  is probably an error in the expression.  This
          feature is also useful for skipping over a  long  procedure.
          Place  the  cursor  at  the '{' at the beginning of the pro-
          cedure, hit esc-m, and the cursor will move to  the  end  of
          the procedure.

          If you have a _p_r listing of the program and wish  to  see  a
          larger  context  than  can  be shown on the screen, the page
          number on the status line tells approximately what  page  of
          the listing to look on.

          _4._5.  _W_i_n_d_o_w_s

          _E_d_i_t allows up to three files to be displayed and edited  at
          the same time.  Each file is displayed in a horizontal strip
          of the screen called a _w_i_n_d_o_w.  When edit is first  invoked,
          it creates a single window, window A, which fills the entire
          window area.  To create another window, type "eb" (or "ec").
          To  have  a  file  read into this window after it is created
          type "eb filename".  To change back and forth  between  win-
          dows, type "ea" or "eb", depending on the window you want to
          be in.  The name of the current window is displayed  as  the
          first  character  of the command line prompt.  To delete the
          extra window from the screen type "qb".

          It is possible to address lines in one window while  working
          in  another  by prefixing the line number by the window name
          and a colon.  For example, to delete line  7  in  window  b,
          type  "b:7d".  A handy phrase is "b:.h" which scrolls window
          b.  Lines from one window can be copied  into  another  with


                                    10/2/81






.
          EDIT USERS MANUAL                                          7


          the  't' command.  "b:3,b:7t." copies lines 3 through 7 from
          window b and places them  after  the  current  line  in  the
          current window.

          Be warned that although it is a perfectly  reasonable  thing
          to  want  to do, editing the same file in two different win-
          dows will not work.  Since each window has its own temporary
          copy  of  the  file,  changes made in one window will not be
          made in the other.  The changes made in whichever window  is
          written  last  will  determine the contents of the file, not
          the sum of all changes made.  It  is  perfectly  alright  to
          look at the same file in two different windows as long a any
          changes are all made in one window.

          _4._6.  _T_h_e _s_h_e_l_l _w_i_n_d_o_w

          A unique feature of _e_d_i_t is that shell  commands  and  their
          output may be placed in a window.

          The line containing the most recently executed shell command
          may  be  addressed by '%'.  If a compilation produces a long
          string of error messages, "%h" will bring the  beginning  of
          the  list  to the top of the shell window.  "%!" will reexe-
          cute the last shell command.

          _4._7.  _M_a_r_k_s _a_n_d _B_u_f_f_e_r_s

          There are several ways to refer  to  a  particular  line  or
          group  of  lines in a file.  One way is to remember the line
          numbers.  However this method is  somewhat  error  prone  in
          that  arbitrary  numbers  are usually difficult to remember,
          and that if any inserting or deleting is done  in  the  file
          above  the  lines in question, the line numbers will change.
          These problems may be solved by _m_a_r_k_i_n_g the line  (or  first
          and  last  of  a  group  of  lines)  using  the 'k' command.
          Thereafter the line (or lines) may be refered to as  '_x  (or
          '_x,'_y),  where  _x is the mark name given in the 'k' command.
          Each mark has a window as well as a line associated with  it
          so  that,  if  marks  a  and  b  are set in window b and the
          current window is a, the command  "'a,'bt."  will  copy  the
          desired group of lines from window b into window a.

          Marks are only aliases for other means of addressing and  so
          can  only  refer to lines that are still in one of the files
          being edited.  Lines which are subsequently deleted  or  are
          in  a  file  no  longer  being  edited may be preserved in a
          _b_u_f_f_e_r.  There are 26 named buffers, one for each letter  of
          the  alphabet.   Text  is  placed  in a buffer with the yank
          ('y') command.  For example "1,5ya" copies lines 1 through 5
          into buffer a.  Text is extracted from a buffer with the put
          ('p') command; ".pa" appends a copy of buffer  a  after  the
          current  line.   There is one more, unnamed, buffer which is
          automatically filled with the lines  most  recently  deleted
          with  a  'd'  or  'c'  command.  Thus if you make a terrible


                                    10/2/81






.
          EDIT USERS MANUAL                                          8


          mistake and accidently delete the wrong lines,  the  command
          ".-1p" will undo the damage.

          Buffers are also used to store macros, which  are  described
          in the next section.

          _4._8.  _M_a_p_s _a_n_d  _M_a_c_r_o_s    _E_d_i_t  has  more  special  function
          escape  sequences  than many terminals have special function
          keys.  If you are one of the lucky people for whom  this  is
          not  the  case, or if some of the keys you do have do things
          you have no desire to do, it is possible to

          _5.  _C_o_m_m_a_n_d _m_o_d_e _f_u_n_c_t_i_o_n_s

          Commands to _e_d_i_t have a simple and regular  structure:  zero
          or  more  _a_d_d_r_e_s_s_e_s  followed by a single character _c_o_m_m_a_n_d,
          possibly followed  by  parameters  to  the  command.   These
          addresses  specify one or more lines in the buffer.  Missing
          addresses are supplied by default.

          Commands may require zero, one, or two addresses.   Commands
          which require no addresses regard the presence of an address
          as an error.  Commands which accept  one  or  two  addresses
          assume  default  addresses when insufficient are given.  For
          example, the  'd'  command  deletes  lines  from  the  file.
          "3,7d"  deletes  lines 3 through 7, "3d" deletes line 3, and
          "d" deletes the current line (the default).

          _5._1.  _T_h_e _C_o_m_m_a_n_d_s

          In  the  following  list  of  _e_d_i_t  commands,  the   default
          addresses are shown in parentheses.  The parentheses are not
          part of the address, but are used to  show  that  the  given
          addresses  are  the  default.   Square  brackets ([]) denote
          optional   parameters   (addresses   are   (almost)   always
          optional).   Underlined  characters  indicate  that a single
          character name is expected.

          (.)a
          <text>
          .
               The append command reads the given text and appends
               it after the addressed line.

          (.)b<regular expression>
               The break command splits the  addressed  line  into
               two lines such that the first character of the reg-
               ular expression  is  the  first  character  of  the
               second line.







                                    10/2/81






.
          EDIT USERS MANUAL                                          9



          (.,.)c
          <text>
          .
               The change command  deletes  the  addressed  lines,
               then accepts input text which replaces these lines.
               '.' is left at the last line input; if  there  were
               none, it is left at the line preceeding the deleted
               lines.  The deleted lines are saved in the  unnamed
               text buffer.

          (.,.)d
               The delete command deletes the addressed lines from
               the  buffer.   The  line  originally after the last
               line deleted becomes the current line; if the lines
               deleted  were  originally  at the end, the new last
               line becomes the current line.  The  most  recently
               deleted lines are saved in the unnamed text buffer.

          e[_w] filename
               The edit command causes the entire contents of  the
               buffer to be deleted, and then the named file to be
               read in. 'filename' is remembered for possible  use
               as  a default file name in a subsequent r or w com-
               mand.  If _w is given

          (.)f<regular expression>
               The find command searches the file beginning at the
               addressed line for the first occurrence of a string
               matching the regular expression, and positions  the
               cursor  at the beginning of this string. The search
               wraps around to the beginning of the file if neces-
               sary.  Note  that there is no space between the 'f'
               and the beginning of the regular expression.

          (1,$)g/regular expression/command
               In the global command, the first step  is  to  mark
               every  line which matches the given regular expres-
               sion. Then for every such line, the  given  command
               is  executed  with  '.' initially set to that line.
               The a, c, i, g, and v commands are not permitted.

          (.)h
               The head command causes the addressed  line  to  be
               moved to the top of the window and the remainder of
               the window to be filled.

          help [subject]
               The help command enables the  help  function  which
               displays help information in a window in the bottom
               half of the screen.  If subject is given,  informa-
               tion  on  that  subject  is displayed if available.
               Otherwise a general help message is displayed.



                                    10/2/81






.
          EDIT USERS MANUAL                                         10



          (.)i
          <text>
          .
               The insert command inserts the  given  text  before
               the  addressed  line.  '.' is left at the last line
               input, or if there were none, at  the  line  before
               the addressed line. This command differs from the a
               command only in the placement of the text.

          (.,.+1)j
               The join command joins the addressed lines  into  a
               single  line.   If  the  'j' option is set (see op-
               tions) a  space  is  inserted  between  all  joined
               lines.

          (.)k_x
               The mark command marks the addressed line with  the
               name  _x, which must be a lower-case letter. The ad-
               dress form "'_x" then addresses this line.

          (.)l
               The list command performs the same function as  the
               "p" command except that all non-printing characters
               (including tabs) are displayed as "\_o_o" where _o_o is
               the octal value of the character.

          (.,.) m <addr>
               The move command repositions  the  addressed  lines
               after the line addressed by <addr>. The last of the
               moved lines becomes the current line.

          M
          <source sequence><SPACE><output sequence><RETURN>
               The map command provides for modifying or  augment-
               ing the default special function mapping (see "Map-
               ping"). The source sequence, which must begin  with
               a  control  character and contain no spaces, is re-
               placed by the output sequence whenever  the  former
               is entered on the keyboard.

          nohelp
               The nohelp command disables the help  function  and
               removes the help window from the screen.

          noshell
               The noshell command removes the shell  window  from
               the  screen and terminates any processes still run-
               ning.  If a shell process is still active, a  warn-
               ing is given.






                                    10/2/81






.
          EDIT USERS MANUAL                                         11



          o<option><new value>
               The  set  option  command  allows  options  to   be
               changed.   <option>  is a single character code for
               the desired option.  <new value> is either a numer-
               ic  value  for numeric options, or one of the words
               "on" or "off" for boolean options.  If either  <op-
               tion> or <new value> is omitted, it will be prompt-
               ed for.  For more information and a list of options
               see "Options".

          (.)p[<buffername>]
               The put command places the contents  of  the  named
               text  buffer after the addressed line. If no buffer
               name is given, the unnamed delete buffer is used.

          (.)P
               The print command clears the  screen  and  displays
               the addressed line at the default position. The ad-
               dressed line becomes the current line. Unless the x
               option is set, no other lines are displayed.

          q[_w]
               The quit command is used to exit the editor  or  to
               delete  a  window from the screen. If a window name
               is given, that window is removed  from  the  screen
               and the remaining windows are expanded.  If no win-
               dow name is given, the editor exits.  No  automatic
               write  of  a file is done. However, if the file has
               been modified, a message is printed and a confirma-
               tion  (i.e.  reentry  of  the  quit command) is re-
               quired.

          (.)r filename
               The read command reads in the given file after  the
               addressed  line.  If  no  file  name  is given, the
               remembered file name, if any, is used (see "e" com-
               mand).  The file name is remembered if there was no
               remembered file name already. Address '0' is  legal
               for  "r"  and causes the file to be read at the be-
               ginning of the buffer.  If the read is  successful,
               '.' is left at the last line read from the file.














                                    10/2/81






.
          EDIT USERS MANUAL                                         12



          (.,.)s/regular expression/replacement/[g]
               The substitute command searches each addressed line
               for  an occurrence of the specified regular expres-
               sion. On each line on which a match is  found,  all
               matched  strings  are  replaced  by the replacement
               specified, if the global replacement indicator  'g'
               appears  after the command. If the global indicator
               does not appear only the first  occurrence  of  the
               matched  string  is  replaced.  Any character other
               than space or newline may be used instead of '/' to
               delimit the regular expression and replacement.  An
               ampersand '&' appearing in the replacement  is  re-
               placed  by  the string matching the regular expres-
               sion. The special meaning of '&'  in  this  context
               may  be  suppressed  by  preceding  it by '\'.  The
               characters '\m' where m is a digit, are replaced by
               the  text matched by the m-th regular subexpression
               enclosed  between  '\('  and  '\)'.  When   nested,
               parenthesized  subexpressions  are  present,  m  is
               determined by counting occurrences of '\(' starting
               from  the left.  Lines may be split by substituting
               newline characters into them.  The newline  in  the
               replacement  string must be escaped by preceding it
               by '\'. Lines may also be split with the  "b"  com-
               mand or with the split key in cursor mode.

          (.,.)t<addr>
               This command acts just like the "m" command  except
               that  a copy of the addressed lines is placed after
               address <addr> (which may be 0). '.' is left on the
               last line of the copy.

          (.)u
               The update command positions the cursor at the  end
               of the addressed line and enters the insert mode.

          (1,$)v/regular expression/command
               This command is the same as the global command  "g"
               except  that  the command is executed with '.' ini-
               tially set to every line _e_x_c_e_p_t those matching  the
               regular expression.

          (1,$)w filename
               The write command writes the addressed  lines  onto
               the  given  file. If the file does not exist, it it
               created with mode 660.  The file name is remembered
               if there was no remembered file name already. If no
               file name is given, the remembered  file  name,  if
               any,  is  used (see "e" command). '.' is unchanged.
               If the read-only option is set an error is indicat-
               ed and no write is performed.




                                    10/2/81






.
          EDIT USERS MANUAL                                         13



          (1,$)W filename
               This command is the same as "w",  except  that  the
               addressed  lines  are  appended to the file, rather
               than replacing it.

          (.)x
               The expand command places the addressed line on the
               screen,  if  necessary, and causes any empty window
               lines to be filled.  If the  expand  size  is  less
               than  the  window  size  (which is the case for low
               baud rates) only a portion of  the  window  may  be
               filled (see option 'z').  Repeated execution of the
               'x' command will eventually fill the entire window.

          X filename
               The execute commands reads the specified  file  and
               executes  its  contents as editor commands. Execute
               commands may be nested.

          (.,.)y[<buffername>]
               The yank command places a  copy  of  the  addressed
               lines into the specified text buffer where they may
               be used in a subsequent put command or in a  macro.
               If  no  buffer  name  is  given, the unnamed delete
               buffer is used.

          <newline>
               An address alone on a  line  causes  the  addressed
               line  to  be  displayed.   A  blank  line  alone is
               equivalent to '.h' and is used  to  scroll  forward
               through the text.

          -
               A minus sign alone on a line moves the  first  line
               on  the  screen  down  to  the default position and
               fills the screen.  It is used to  scroll  backwards
               through the text.

          ^
               A caret performs the same function as a lone  minus
               sign.














                                    10/2/81






.
          EDIT USERS MANUAL                                         14



          !<shell command>
               The remainder of the line after the '!' is sent  to
               sh(1)  to be executed. If not present, a shell win-
               dow is created at the top of the screen. All  input
               to  and  output from the shell and any processes it
               executes appears in this window. The command is ex-
               ecuted  in  the background and editing may continue
               while it is running.

               If an explicit address  range  is  given,  and  the
               shell command is null, the addressed lines are sent
               to the shell, or, if a process  is  currently  run-
               ning,  to  its  standard  input.  If any of the ad-
               dressed lines begins with the current shell  prompt
               string, it is removed before the line is sent.

          >[<buffer name>]
          <text>
          .
               Text is entered into the named buffer until a  line
               consisting  only  of '.' in encountered. While this
               text is being entered, a  message  appears  on  the
               message  line,  and  the  prompt is changed to "_x>"
               where _x is the buffer name. This command is intend-
               ed  mainly  for use in initializing macros, both on
               line and in a file specified in the  X  command  or
               option.

          (.,.)@<buffer name>[<delim><string>[<delim><string>...]]
               For each line in the specified address  range,  the
               lines  in the   named buffer are executed as editor
               commands. If any of the command  lines  contains  a
               string  of the form "$_n" where _n is a digit between
               1 and 9, it is replaced  with  the  n_t_h.  parameter
               string before the command is executed. If string of
               the form "\c" is encountered, where c is any  char-
               acter,  it  is replaced with c. Thus to execute the
               command "s/$/\$/" the  macro  would  have  to  read
               "s/\$/\\\$/". Macros may be nested.

               Note that the command group is  executed  once  per
               line in the address range with the default for each
               command being used.  Thus if buffer 'b' contains "W
               xfile"  then  the  command  "1,5@b"  will  append 5
               copies of the entire current file to xfile, whereas
               if  buffer  'b' is ".W xfile" then the same command
               will append lines 1 through 5 of the  current  file
               to xfile.







                                    10/2/81






.
          EDIT USERS MANUAL                                         15



          <ctl-R>
               Pressing this key causes the entire  screen  to  be
               redrawn as _e_d_i_t thinks it looks.  This is not real-
               ly a command in that it may be done at any time  in
               any mode.

          _5._2.  _A_d_d_r_e_s_s_e_s

          To understand addressing in _e_d_i_t it  is  necessary  to  know
          that  at any time there is a _c_u_r_r_e_n_t _l_i_n_e.  Generally speak-
          ing, the current line is the last line affected  by  a  com-
          mand;  however, the exact effect on the current line is dis-
          cussed under the description of the command.  Addresses  are
          constructed as follows.

          (1)  The character '.' addresses the current line.

          (2)  The character '$' addresses the last line of the file.

          (3)  A decimal number _n addresses the _n-th line of the file.

          (4)  "'_x" addresses the line marked with the  name  _x  which
               must be a lower-case letter.  Lines are marked with the
               _k command described above.

          (5)  A regular expression enclosed in slashes '/'  addresses
               the  line  found  by searching forward from the current
               line and stopping at the first line containing a string
               that  matches the regular expression.  If necessary the
               search wraps around to the beginning of the file.

          (6)  A regular expression enclosed  in  question  marks  '?'
               addresses the line found by searching backward from the
               current line and stopping at the first line  containing
               a  string  that  matches  the  regular  expression.  If
               necessary the search wraps around to  the  end  of  the
               file.

          (7)  An address followed by a plus sign '+' or a minus  sign
               '-' followed by a decimal number specifies that address
               plus (resp. minus) the indicated number of lines.   The
               plus sign may be omitted.

          (8)  If an address begins with '+' or '-'  the  addition  or
               subtraction  is taken with respect to the current line;
               e.g. '-5' is understood to mean '.-5'.

          (9)  If an address ends with '+' or '-',  then  1  is  added
               (resp.  subtracted).  As a consequence of this rule and
               rule 8, the address '-' refers to the line  before  the
               current  line.   Moreover, trailing '+' and '-' charac-
               ters have cumulative effect,  so  '--'  refers  to  the
               current line less 2.


                                    10/2/81






.
          EDIT USERS MANUAL                                         16


          (10) Prefixing any address  construct  with  "_w:"  specifies
               that  the  address is to be sought in window _w.  Other-
               wise the address automatically refers  to  the  current
               window.

          (11) The character '%' refers to the line in the shell  win-
               dow  containing  the most recently submitted shell com-
               mand.

          Addresses are separated from each other typically by a comma
          ','.   They  may  also  be separated by a semicolon ';'.  In
          this case the current  line  '.'  is  set  to  the  previous
          address  before  the  next  address  is  interpreted.   This
          feature can be used to determine the starting line for  for-
          ward  and  backward searches ('/', '?').  The second address
          of any two-address sequence must correspond to a  line  fol-
          lowing the line corresponding to the first address.  If more
          addresses are given than such a command requires,  the  last
          one or two (depending on what is accepted) are used.

          _5._3.  _R_e_g_u_l_a_r _E_x_p_r_e_s_s_i_o_n_s

          _E_d_i_t supports a limited form of _r_e_g_u_l_a_r _e_x_p_r_e_s_s_i_o_n notation.
          A  regular  expression specifies a set of strings of charac-
          ters.  A member of this set of strings is said to be _m_a_t_c_h_e_d
          by the regular expression.

          Regular expressions are used in addresses to  specify  lines
          and  in  one command (see _s above) to specify a portion of a
          line which is to be replaced.  If it is desired to  use  one
          of  the  regular  expression  metacharacters  as an ordinary
          character, that character may be preceded by '\'.  This also
          applies  to  the  character  bounding the regular expression
          (often '/') and to '\' itself.

          In the following specification for regular  expressions  the
          word 'character' means any character but newline.

          (1)  Any  character  except  a  special  character   matches
               itself.   Special characters are the regular expression
               delimiter plus \[.  and sometimes ^*$.

          (2)  A .  matches any character.

          (3)  A \ followed by any character  except  a  digit  or  ()
               matches that character.

          (4)  A nonempty string _s bracketed [_s] (or [^_s]) matches any
               character  in  (or  not  in) _s.  In _s, \ has no special
               meaning, and ] may only appear as the first letter.   A
               substring  _a-_b,  with _a and _b in ascending ASCII order,
               stands for the inclusive range of ASCII characters.




                                    10/2/81






.
          EDIT USERS MANUAL                                         17


          (5)  A regular expression of form 1-4 followed by *  matches
               a  sequence of 0 or more matches of the regular expres-
               sion.

          (6)  A regular expression, _x, of form 1-8, bracketed \(  _x\)
               matches what _x matches.

          (7)  A \ followed by a digit _n matches a copy of the  string
               that  the  bracketed  regular expression beginning with
               the _nth \( matched.

          (8)  A regular expression of form 1-8, _x, followed by a reg-
               ular  expression  of  form 1-7, _y matches a match for _x
               followed by a match for _y, with the _x  match  being  as
               long as possible while still permitting a _y match.

          (9)  A regular expression of form 1-8 preceded by ^ (or fol-
               lowed  by  $),  is constrained to matches that begin at
               the left (or end at the right) end of a line.

          (10) A regular expression of form 1-9 picks out the  longest
               among the leftmost matches in a line.

          (11) An empty regular expression stands for a  copy  of  the
               last regular expression encountered.

          _6.  _C_u_r_s_o_r _M_o_d_e _F_u_n_c_t_i_o_n_s

          In the _c_u_r_s_o_r mode text already displayed on the screen  may
          be  changed  by moving the cursor to the desired position in
          the text then depressing keys to effect the desired change.

          The cursor mode is entered either  by  depressing  a  cursor
          motion or modify function key while in the command or insert
          mode or via the 'f' command.  Typing return leaves the  cur-
          sor mode and returns to the previous mode.

          The keys may be divided into  four  groups:  cursor  motion,
          modify  function, printing characters, and control function.
          The keys given are for the  Infoton  terminal.   Where  dif-
          ferent,   the   keys   for  other  terminals  are  given  in
          parentheses.  In the description of cursor  mode  funcitons,
          the term "current line" refers to the line on which the cur-
          sor is located, not '.'.  However, some of  these  functions
          result  in  '.'  being  set  to the current line.  These are
          noted by "Sets dot" in the description.

          The heading for each key gives the name of the function, the
          corresponding escape sequence, and for each supported termi-
          nal type the key (if any) which generates that  sequence  in
          the default mapping.  Thus the line:
               end-of-line (esc-K; i100: EL, 2621: f3, h19: f5)
          indicates that the escape sequence esc-K performs the end of
          line  function and that this sequence is generated by the EL


                                    10/2/81






.
          EDIT USERS MANUAL                                         18


          key on the Infoton, the f3 key on the HP 2621,  and  the  f5
          key  on  the  Heath H19.  Note that on the 2621 terminal the
          shifted function keys must be used  as  the  unshifted  keys
          transmit no characters.

          _6._1.  _C_u_r_s_o_r _m_o_t_i_o_n _k_e_y_s

          left (esc-D; left arrow)
          right (esc-C; right arrow)
               The left and right arrows move the cursor one posi-
               tion  to  the  left or right respectively, handling
               tabs correctly and refusing to move past the end of
               a line.

          fast left (esc-L; 2621: f1, others: IL)
          fast right (esc-M; 2621: f2, others: DL)
               The fast left and right keys  move  the  cursor  to
               every  eighth  position on the line.  Attempting to
               past the end (begining) of a line wraps  around  to
               the beginning (end) of the next (previous) line.

          up (esc-A; up arrow)
          down (esc-B; down arrow)
               The up and down arrows move the cursor one line  up
               or  down  respectively.  Attempting to move off the
               top or bottom of the window causes  the  window  to
               scroll.

          Home (esc-H; HOME)
               The _h_o_m_e key positions the cursor at the  beginning  of
               the current line ('.').

          end-of-line (esc-K; i100: EL, 2621: f3, h19: f5)
               The end-of-line key positions the cursor  at  the  null
               character at the end of the current line.

          _6._2.  _M_o_d_i_f_y _f_u_n_c_t_i_o_n _k_e_y_s

          delete character (esc-P; 2621: f4, others: DC)
               The delete character key deletes the character  at  the
               current cursor position and shifts the remainder of the
               line to the left to take its place.

          split (esc-1; i100: ST, h19: f2)
               The split key splits the current line  into  two  lines
               such that the current cursor position becomes the first
               character of the second line.  Sets dot.

          join (esc-j) The join key combines the current line and  the
               following text line into a single text line.  Sets dot.






                                    10/2/81






.
          EDIT USERS MANUAL                                         19


          _6._3.  _P_r_i_n_t_i_n_g _c_h_a_r_a_c_t_e_r_s:

          Typing any printing character causes that  character  to  be
          inserted  to the left of the current cursor position and the
          remainder of the line shifted right to make room for  it  if
          the  current  treatment  of  printing  characters  is set to
          insert.  If the current treatment is set to  overwrite,  the
          character  at the current cursor position is replaced by the
          typed character.  Typing  the  erase  character  causes  the
          character to the left of the cursor to be deleted.  The kill
          function is not active in cursor mode.

          _6._4.

          set-insert-mode (esc-@; IC)
               The set-insert-mode key sets the current  treatment  of
               printing  characters  to insert for the duration of the
               current invocation of cursor mode.

          set-overwrite-mode (esc-2; i100: CT, h19: f1)
               The set-overwrite-mode key sets the  current  treatment
               of printing characters to overwrite for the duration of
               the current invocation of cursor mode.

          _7.  _O_p_t_i_o_n_s

          Options may be set in three ways: via the  EDIT  environment
          variable, at invocation as flags, and while running with the
          option command.  There are three types of options:  boolean,
          numeric, and string.

          a  Accept all characters (boolean)
             Normally all control  characters,  except  tab,  newline,
             escape,  and  mapped  characters,  are  ignored.  If this
             option is set, they will be accepted as printing  charac-
             ters.  In  order to enter the erase or kill character, it
             is necessary that this option be set and the character be
             escaped with a '\'.

          b  Shell beep (boolean)
             With this option set, the bell is sounded when  the  com-
             mand running in the shell window completes.

          c  Crash recovery (numeric)
             _E_d_i_t periodically saves the  state  of  each  file  being
             edited  in  a  pair of temporary files: /tmp/exxxxxYa and
             /tmp/exxxxxYb, where xxxxx is the process id of the  edi-
             tor, and Y is the name of the window in which the file is
             being edited.  if _e_d_i_t terminates normally,  these  files
             are  removed.  However, if a system crash or other abnor-
             mal termination occurs during editing,  these  files  are
             preserved  (for a short time).  To recover from the point
             of the last update type:
                  edit -cxxxxx


                                    10/2/81






.
          EDIT USERS MANUAL                                         20


             where xxxxx is the process id mentioned above.  This  may
             be discovered by typing:
                  l /tmp
             and looking for an appropriate pair of files having  your
             user id.  This "option" may only be specified at the time
             the editor is invoked.

          i  Auto-indent
             With this option in effect, a line of text being inserted
             is automatically indented to the same level as the previ-
             ous  line  by  copying  initial  white  space  (tabs  and
             spaces). The level of indentation may be reduced by back-
             spacing. A single '.' as the first character entered ter-
             minates insert mode, regardless of any indenting.

          j  Join spacing (boolean)
             When this option is set a space is inserted between lines
             joined  by the 'j' command and any initial white space is
             deleted from the beginning of the second line created  by
             the  'b'  and  split  commands.  Note that the default is
             set.

          l  Left break (boolean)
             Normally, text lines which are too long to fit on a  sin-
             gle screen line are broken and the last part right justi-
             fied on the following screen line.   If  this  option  is
             set, the remainder will be left justified.

          o  Overwrite mode.
             When on the default treatment of printing  characters  in
             cursor mode is set to overwrite. The default is insert.

          p  Page threshold (numeric)
             Normally, _e_d_i_t scrolls in order to move a line  from  one
             part  of  the screen to another.  If the number of screen
             lines to be moved exceeds the page threshold, the  entire
             window will be cleared and rewritten instead.  A value of
             zero disables paging.

          r  Read-only (boolean)
             When set the execution of all write  commands  is  prohi-
             bited.  Useful  for browsing through a file without inad-
             vertently changing it.

          s  Spell checking (boolean)
             When this option is set a background process  is  started
             to  which  all  words  entered  into the file are passed.
             This process, which is a modified version  of  the  _s_p_e_l_l
             program,  checks  each  word and sends back a message for
             each one which it thinks is misspelled.   Pressing  esc-s
             will position the cursor at the word in question.  Press-
             ing esc-o will cause the spell checker to accept the word
             as corectly spelled henceforth.



                                    10/2/81






.
          EDIT USERS MANUAL                                         21


          t  Tab spacing (numeric)
             Only uniformly spaced tabs are supported.  The default is
             8.

          u  Upper case text (boolean)
             When set, this option causes all text  entered  into  the
             file  to  be  forced  into  upper  case.   Note that text
             entered into the command line remains in whatever case it
             was typed in.

          w  Word break (boolean)
             With this option in effect, whenever a text line  becomes
             longer  than  the  scren  line  size,  a new text line is
             started beginning with the  faulting  word.   Useful  for
             entering text without looking.

          x  Auto expand (boolean)
             When set causes automatic expansion after a 'P' command.

          X  Startup file (string)
             This option, which may only be specified  at  invocation,
             causes the specified file to be read and executed as edi-
             tor commands, as in the 'X' command.  Useful for  setting
             up a standard set of macros.

          z  Expand size (numeric)
             When running at low baud rates, _e_d_i_t reduces  the  number
             of  lines  added to the screen by an expand command or by
             scrolling so as to reduce delays.  This number is a func-
             tion  of  the baud rate, with proportionately fewer lines
             at lower baud rates.  This option allows the  default  to
             be overridden.

          _8.  _M_i_s_c_e_l_l_a_n_e_o_u_s _T_o_p_i_c_s

          _8._1.  _B_u_f_f_e_r_s

          Edit provides 27 text buffers where lines may be  saved  for
          insertion into the text, or for use as macros.  There are 26
          named buffers, each specified by a single  letter,  and  one
          unnamed  buffer.  The unnamed buffer is automatically filled
          with the lines to be removed immediately before each  delete
          or  change  command.   The  named buffers are filled via the
          yank command.  The contents of a buffer may be inserted into
          the text with the put command.

          _8._2.  _M_a_p_p_i_n_g

          Edit provides a capability  for  translating  certain  input
          characters  or  character sequences into different sequences
          before acting on them. This facility is provided to  compen-
          sate  for discrepancies between the special function keys on
          a particular terminal and the escape sequences used to  per-
          form  cursor  mode  functions. For example, if your terminal


                                    10/2/81






.
          EDIT USERS MANUAL                                         22


          has a group of keys  which  transmit  escape  sequences  but
          these are not the same as the default sequences used by edit
          (see "escape sequences"), you can use the  mapping  function
          to  cause  these  keys to perform the desired function.  For
          each supported terminal type there  is  a  default  mapping.
          This  may  be  augmented  or modified in two different ways:
          environment variables or the map command. During initializa-
          tion,  edit  searches  for the environment variables MAP and
          MAP_t_e_r_m, where _t_e_r_m is the code for  the  current  terminal.
          If  present,  the  mappings  defined are merged into the map
          with any existing mappings being overridden.  The format for
          these strings is:
                  <delim><source><delim><target>...
          where <delim> is some character not appearing in any  source
          or  target.   The string "^x", where x is any letter (or '['
          for ESC) is replaced by the corresponding control  character
          wherever  it  appears  in either the source or target.  Some
          restrictions:

          (1)All source strings must begin with a control character.

          (2)No source string may be a left  substring  of  any  other
             source string.

          _9.  _S_u_m_m_a_r_y

          _9._1.  _G_l_o_s_s_a_r_y





























                                    10/2/81






.
          EDIT USERS MANUAL                                         23



          _9._2.  _C_o_m_m_a_n_d_s
          Command   Name                      Description
          ____________________________________________________________

          a         append
7                                  insert text after addressed line
          b         break
7                                  break line at specified regular  ex-
                                  pression
          c         change
7                                  replace addressed lines with insert-
                                  ed text
          d         delete
7                                  delete addressed lines
          e         edit
7                                  begin editing the specified file  in
                                  the   specified   window.   used  to
                                  change windows
          f         find
7                                  position cursor at  next  occurrence
                                  of regular expression
          g         global
7                                  execute command on all lines  match-
                                  ing regular expression
          h         head
7                                  position addressed line  at  top  of
                                  window
          help      help
7                                  display help information
          i         insert
7                                  insert text before addressed line
          j         join
7                                  join addressed lines to form a  sin-
                                  gle line
          k         mark
7                                  associate mark name  with  addressed
                                  line
          l         list
7                                  display line with control characters
                                  expanded
          m         move
7                                  move addressed lines
          M         map
7                                  establish mapping between input  and
                                  output sequences
          nohelp    nohelp
7                                  remove the help window
          noshell   noshell
7                                  remove the shell window
          o         option
7                                  set an option value
          p         put
7                                  put contents of named  buffer  after
                                  addressed line
          P         print
7                                  display only the addressed line
          q         quit
7                                  leave the editor or delete the named
                                  window
          r         read
7                                  read the named file  after  the  ad-
                                  dressed line
          s         substitute
7                                  substitute  the  replacement  string
                                  for the given regular expression
          t         copy
7                                  copy addressed lines
          v         global
7                                  execute command  on  all  lines  not
                                  matching regular expression
          w         write
7                                  write addressed lines to named file
          W         write
7                                  append addressed lines to named file
          x         expand
7                                  fill the screen
          X         execute
7                                  execute the  named  file  as  editor
                                  commands
          y         yank
7                                  fill the named buffer with  the  ad-
                                  dressed lines
          !         shell


                                    10/2/81






.
          EDIT USERS MANUAL                                         24


                                  execute the specified unix command
          >         fill buffer
7                                  enter text into named buffer
          @         macro
7                                  execute the named buffer  as  editor
                                  commands

          _9._3.
          _E_s_c_a_p_e _S_e_q_u_e_n_c_e_s
          Sequence   Function
          _______________________________________________
           esc-@     set insert mode
           esc-^     scroll down
           esc-1     split line at current character
           esc-2     set overwrite mode
           esc-a     append after current line
           esc-A     cursor up 1 line
           esc-B     cursor down 1 line
           esc-C     cursor right 1 character
           esc-d     delete current line
           esc-D     cursor left 1 character
           esc-h     scroll current line to top of screen
           esc-H     cursor to start of '.'
           esc-i     insert above current line
           esc-j     join current line to next line
           esc-K     cursor to end of current line
           esc-L     cursor left 8 characters
           esc-m     goto matching bracket character
           esc-M     cursor right 8 characters
           esc-o     accept misspelled word as correct
           esc-P     delete current character
           esc-s     go to misspelled word

          _9._4.
          _O_p_t_i_o_n_s
          Option    Type                 Description
          _______________________________________________________
            a      boolean   Accept control characters
            b      boolean   Sound bell when shell prompt returns
            c      numeric   Crash recovery
            d      numeric   Debugging
            i      boolean   Auto-indent
            j      boolean   Join spacing (default is on)
            l      boolean   Left break
            o      boolean   Establish overwrite mode as default
            p      numeric   Paging threshold (default is 0)
            r      boolean   Read only mode
            s      boolean   Spell checking
            t      numeric   Tab spacing (default is 8)
            u      boolean   Upper case text
            w      boolean   Word break
            x      boolean   Automatic expand
            X      string    Run time startup file
            z      numeric   Expand size




                                    10/2/81






.
          EDIT USERS MANUAL                                         25



          _9._5.  _S_u_p_p_o_r_t_e_d _T_e_r_m_i_n_a_l _T_y_p_e_s
          Code   Full name
          ____________________________
          2621   Hewlett-Packard 2621A
          h19    Heath H19
          i100   Infoton 100
          v200   Visual 200

          _9._6.  _E_n_v_i_r_o_n_m_e_n_t _V_a_r_i_a_b_l_e_s
          Variable   Function
          ______________________________________________________
          EDIT       Set default options
          TERM       Specify terminal type code
          MAP        Set default mappings for all terminal types
          MAP_t_e_r_m    Set default mappings for specific terminal

          _1_0.  _L_i_m_i_t_a_t_i_o_n_s

          _1_1.  _B_u_g_s

          In addition  to  the  problems  mentioned  above  which  are
          inherent in the implementation of _e_d_i_t there are a number of
          things which might rightly be considered wrong.  These  will
          probably be fixed some day.

          (1)It is not possible to explicitly change  the  size  of  a
             window

          (2)If the same file is being edited in  two  different  win-
             dows, changes made in one window are not reflected in the
             other.
























                                    10/2/81



