/*  omatch.c
*
*	Now we will attempt to match what's at pat[j] against line[i].  If
*	we succeed, we will return TRUE.  Omatch also changes i to point
*	to the next position in line to be matched.  Since the number of spaces 
*	to move i depends on the type of pattern, the variable "bump" will be
*	used to adjust i. If a stack or counter entry is encountered in the
*	pattern, dostck or docntr will be called to return a pointer to the
*	stack of where the entry is that our input text is to match.  We will
*	use the pointer here to try and match that entry in the stack.
*
*	Parameters:
*	   line - pointer to input text; i - current position on input line.
*	   pat - pointer to pattern;     j - current position on pattern.
*	   tagary - the array containing the beginning & ending positions in the
*	            input text which are tagged.
*	   sizlinentry - the number of characters matched. Used to back over
*			 portions of text when a closure fails to match.
*
*	Calls: dostck, docntr, fatal_error, locate, size, specclass
*
*	UE's: "fatal_error" is called if an unrecognizable character appears on
*	      the pattern. Supposedly this can't happen since this pre-processed
*	      pattern is generated by the program.  However, some input errors
*	      which are not caught in the preprocessing stage might pop up here.
*
*					Programmers: Tony Marriott & G. Skillman
*/

omatch(line,i,pat,j,tagary,sizlinentry)

char	*line;		/* input line */
char	*pat;		/* pattern */
int	 *i;		/* offset in line */
int	j;			/* offset in pat */
int	tagary[100][2];		/* Array of tagged positions in input string. */
int	*sizlinentry;		/* # of characters matched. > 1 if stack call */

{
	/* n: a copy of i we can mess up;  eoce: end of counter entry;
	   eose: end of stack entry;  
	   and we don't use the array feature, we must create a dummy array
	   to pass to "dostck" anyway.  */
	int	bump,k,n,end,eoce,eose;  /* marker on line */
	char	*string;
	char	*dostck(),*docntr();
	int	tmp;
	char	charac[2];
	extern char	CHAR,BOL,ANY,ALPHNU,EOS,EOL,CCL,NCCL,TAG,TAGEND,LT;
	extern char	CNTR,STACK;
	extern int	TRUE,FALSE,NO,YES;


	bump = -1;

	if (pat[j] == CHAR)
	  {if (line[*i] == pat[j+1] )
		bump = 1;}

	else if (pat[j] == BOL)
	  {if (*i == 0) bump = 0;}

	else if (pat[j] == ANY) /* 'specclass' handles '?n' where 1 <= n <= 6 */
		   {if (specclass(pat[++j],line[*i]) == YES)
			bump = 1;}

	else if (pat[j] == EOL)
	  {if (line[*i] == EOS || line[*i] == LT)
		bump = 0;}

	else if (pat[j] == CCL)
	   {if (locate(line[*i],pat,j+1) == YES)
		bump = 1;}

  	else if (pat[j] == NCCL )
	{
	  if (line[*i] != LT && locate(line[*i],pat,j+1) != YES)
		bump = 1; 
	}

	/* We will store the line position on the pattern of what is being 
	   tagged.  */

	else if (pat[j] == TAG || pat[j] == TAGEND)
	{
		if (pat[j] == TAG)
			tagary[pat[j + 1]][0] = *i;
		else
			tagary[pat[j + 1]][1] = *i;
		bump = 0;
	}
	else if (pat[j] == STACK)
		if (pat[j + 1] == 1) /* If type 1 stack call. */
		{
			n = *i;

			/* "dostck" will return a pointer to the item in the stack			   
			   we are to match. */
			string = dostck(pat,j,line,tagary,&eose);

			/* for each character in that item, compare it with the text. */
			for (k=0;string[k] != EOS;k++)
			{
				if (string[k] == line[n])
					++n;
				else
					return(FALSE);
			}
			if (k == 0);
			else
			{
				bump = size(string);
				*sizlinentry = bump;
			}
		}
		else  /* else, type 2, 3 or 4 stack call. */
		{
			bump = 0;
			dostck(pat,j,line,tagary,&eose);
		}

	else if (pat[j] == CNTR)
		if (pat[j + 1] == 1) /* If type 1 counter call. */
		{
			n = *i;
			
			/* Here also docntr returns a pointer to an item in the
		           counter array. */
			string = docntr(pat,j,&eoce);
			for (k=0;string[k] != EOS;k++)
			{
				if (string[k] == line[n])
					++n;
				else
				{
					return(FALSE);
				}
			}
				if (k == 0);
				else
				{
					bump = size(string);
					*sizlinentry = bump;
				}
		}
		else  /* else, type 2 or 3 counter call. */
		{
			bump = 0;
			docntr(pat,j,&eoce);
		}

	else
	{
		  printf("pat[j] -- %c %d\n",pat[j],j);
		 fatal_error("OMATCH: illegal pattern construction");
	}

	if (bump >= 0)
	  {
	    *i = *i + bump;
	    *sizlinentry = bump;
	    return(TRUE);		/* have a match */
          }

	else
	{
	  return(FALSE);
	}
}
