//
// Slideshow, Diashow
// Marco Vieth, 29.10.2000
// 0.01  29.10.2000  first tests
// 0.02  07.11.2000  corrected for NE
// 0.03  04.03.2001  image index for change_image is optional (set the first time)
//         04.06.2001  inserted some comments
// 0.04  23.09.2001  all global variables start with g_sshow_*, functions with sshow_*;
//                          new functions sshow_add_image[s](), sshow_change_image_abs()
// 0.05  26.11.2001  no need for form 'Navigate' on page
// 0.06  19.01.2002  new object-oriented design
//         20.01.2002  do not use unnamed functions, prototypes -> useful for old browsers with Javascript 1.1
//


var g_debug_flg = 0;		// global debug flag (1 = debugging activated)

//var g_debug_win;
//function g_debug_win_open() {
//  g_debug_win = window.open("","Debug","width=640,height=300,resizable=yes,scrollbars=yes,dependent=yes");
//  g_debug_win.document.open("text/html", "reuse");
//  g_debug_win.document.write("<h4>Debug output</h4>\n", "<pre>"); // for some older Netscapes...
//  if (!g_debug_win.closed) {
//    g_debug_win.focus();
//  }
//}
//if (g_debug_flg > 0) { g_debug_win_open(); }


// -----------------------------


// Constructor for class Sshow
function Sshow(images, descrs) {
  // attributes
  this.img_idx = 0;      // current image index
  this.curr_img = "";    // current diashow Image in HTML document
  this.cacheload = 2;  // timeout to load next image (sec)
  this.itimer = 0;         // interval timer

  this.inames = new Array();  // image names
  this.idescr = new Array();  // image descriptions (optional)
  this.cimgs = new Array(); // cached images

  // methods
  if (!Sshow.prototype) { // old browsers get the methods directly into the object...
    this.add_image = Sshow_add_image;
    this.add_images = Sshow_add_images;
    this.prepare_image = Sshow_prepare_image;
    this.prepare_all_images = Sshow_prepare_all_images;
    this.change_image = Sshow_change_image;
    this.change_image_abs = Sshow_change_image_abs;
    this.random = Sshow_random;
    this.auto_change_image = Sshow_auto_change_image;
  }

  if (images) {
    this.add_images(images, descrs);
  }
}


//
// normally we would create unnamed functions here but for old browsers...
// Sshow.prototype.add_image = function(image, descr) { ... }
//

// For new browsers (JS 1.2) set the prototypes...
if (Sshow.prototype) {
  Sshow.prototype.add_image = Sshow_add_image;
  Sshow.prototype.add_images = Sshow_add_images;
  Sshow.prototype.prepare_image = Sshow_prepare_image;
  Sshow.prototype.prepare_all_images = Sshow_prepare_all_images;
  Sshow.prototype.change_image = Sshow_change_image;
  Sshow.prototype.change_image_abs = Sshow_change_image_abs;
  Sshow.prototype.random = Sshow_random;
  Sshow.prototype.auto_change_image = Sshow_auto_change_image;
}


// Sshow_add_image - add image to slide show
// in:  <image> <description>
// out: 1=OK
function Sshow_add_image(image, descr) {
  // IE seems to have no push(), so we simulate it...
  this.inames[this.inames.length] = image;
  this.idescr[this.idescr.length] = descr;
}

function Sshow_add_images(images, descrs) {
  for (var i = 0; i < images.length; i++) {
    this.add_image(images[i], (descrs) ? descrs[i] : "");
  }
}

//
// sshow_prepare_image - prepare an image (make it available)
// IN:  idx = image index
// OUT: <image> = image name
function Sshow_prepare_image(idx) {
  if (g_debug_flg > 0) {
    g_debug_win.document.writeln("prepare_image: ", idx);
  }
  if ((!this.cimgs[idx]) && (idx < this.inames.length)) { // image not prepared yet?
    this.cimgs[idx] = new Image();
    this.cimgs[idx].src = this.inames[idx];
    if (g_debug_flg > 0) {
      g_debug_win.document.writeln("prepare_image: new image prepared:", idx);
    }
  }
  return (this.cimgs[idx]) ? this.cimgs[idx].src : "";
}

// if you want to prepare all images onload...
function Sshow_prepare_all_images() {
  for (var i = 0; i < this.inames.length; i++) {
    this.prepare_image(i);
  }
}


var g_sshow_this; // very ugly to save object for timeout...

//
// change_image - change an image
// IN:  <addval> = value to compute new index, [<img>] = image index (optional)
// OUT: <img_idx>
// Add <addval> to the current image index.
// If <img> is (or was already) specified, set the new image to "img.src".
// Also set 'Navigate.Index.value' to the current img_idx +1 and
// 'Navigateimg_idx +1 and
// 'Navigate.description.value' to the description idescr[] or the name from inames[].
// Return the (new) index <img_idx>.
//
function Sshow_change_image(addval, img) {
  if (g_debug_flg > 0) {
    g_debug_win.document.writeln("change_image: ", addval, " ", img);
  }
  var p = this.img_idx + addval;

  if (img) { // if image specified, memorize it
    this.curr_img = img;
  }

  if ((p >= 0) && (p < this.inames.length)) {
    this.img_idx = p;
    var prep_img = this.prepare_image(p);

    if (this.curr_img) {
      this.curr_img.src = prep_img;	// set image
    }

    if ((this.cacheload > 0) && (p < (this.inames.length - 1))) { // caching allowed & some more images defined but not cached yet?
      g_sshow_this = this; // a very ugly way to save the object for timeout...
      window.setTimeout("g_sshow_this.prepare_image("+ (this.img_idx + 1) + ")", this.cacheload * 1000);
      // cache next image after timeout
    }
  }

  if (document.Navigate) {
    var thisdoc = document.Navigate;
    if (thisdoc.Index) {
      thisdoc.Index.value = this.img_idx + 1;
    }
    if (thisdoc.description) {
      thisdoc.description.value = (this.idescr[this.img_idx]) ? this.idescr[this.img_idx] : this.inames[this.img_idx];
    }
  }
  return this.img_idx;
}


// change image absolute
function Sshow_change_image_abs(val, img) {
  if ((val >= 0) && (val < this.inames.length)) {
    this.img_idx = val;
  }
  return(this.change_image(0, img));
}

// return random image index that can be used for change_image_abs...
function Sshow_random() {
  return Math.floor(Math.random() * this.inames.length);
}


//
// auto_change_image - automatically change (image)
// IN:  <delay>, [<callfunc>]
// OUT: -
// Stop a running interval timer and restart it with <delay> seconds to change image automatically.
// Use delay=0 to switch the timer off.
// Note: Before using this function call "change_image()" with an image parameter.
// If specified, <callfunc> is called instead of "change_image(+1)".
//
function Sshow_auto_change_image(delay, callfunc) {
  if (g_debug_flg > 0) {
    g_debug_win.document.writeln("auto_change_image: ", delay, " ", callfunc);
  }
  if (this.itimer > 0) { // timer active?
    window.clearInterval(this.itimer);
    this.itimer = 0;
  }    
  if (delay > 0) {
    if (!callfunc) {
      g_sshow_this = this; // a very ugly way to save the object for timeout...
      callfunc = "g_sshow_this.change_image(+1)";
    }
    this.itimer = window.setInterval(callfunc, delay * 1000);
  }
}

// end
