//
// encode1.js (encode URL)
// Marco Vieth, 2003
//
// 0.01  10.02.2002  first tests
// 0.02  29.07.2003  put into separate script
// 0.021 30.11.2003  extended for JS 1.1
//
//
//  Example usage: see secret_jump1.js
//
// - Required for debugging: debug1.js
var g_debug = null; // maybe changed later...



// for JS 1.1 compatibility...

var g_encode_char2code = null;
var g_encode_code2char = null;

// needed for for JS 1.1 (without charCodeAt, fromCharCode)
function encode_init_codes() {
  var codestr = ' !"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~';
  g_encode_char2code = new Array();
  g_encode_code2char = new Array();
  //var debug_str1 = '';
  for (var i = 32; i <= 126; i++) {
    g_encode_char2code[codestr.charAt(i - 32)] = i;
    g_encode_code2char[i] = codestr.charAt(i - 32);
    //debug_str1 += "DDD: charAt='"+ codestr.charAt(i - 32) +"', ch2c='"+ g_encode_char2code[codestr.charAt(i - 32)] +"', c2ch='"+ g_encode_code2char[i] +"'\n";
  }
  //alert("DEBUG: "+ debug_str1);
  if (g_debug) { g_debug.writeln("encode_init_codes: done."); }
}

// limitations: code range 32..126
function encode_charCodeAt(this1, idx) {
  if (!g_encode_char2code) {
    encode_init_codes();
  }
  var chr1 = this1.charAt(idx); //get character at position idx
  var code1 = g_encode_char2code[chr1]; // "|| 0" does not work with text browser "links"
  if (!code1) {
    code1 = 0;
  }
  if (g_debug) { g_debug.writeln("encode_charCodeAt("+ idx +"): chr1='"+ chr1 +"', code="+ code1); }
  return(code1);
}


// limitations: just for one argument, code range 32..126
function encode_fromCharCode(code1) {
  if (!g_encode_code2char) {
    encode_init_codes();
  }
  var chr1 = g_encode_code2char[code1];
  if (!chr1) {
    chr1 = '';
  }
  if (g_debug) { g_debug.writeln("encode_fromCharCode: code="+ code1 +", char='"+ chr1 +"'"); }
  return(chr1);
}

/*
function debug_codes1() {
  var s1 = ' !"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~';
  var str = "";
  for (var i = 0; i < s1.length; i++) {
    var code1 = encode_charCodeAt(s1, i);
    var ch1 = encode_fromCharCode(code1);
    if (g_debug) { g_debug.writeln("debug_codes1: code="+ code1 +", char='"+ ch1 +"'"); }
    str += "debug_codes1: code="+ code1 +", char='"+ ch1 +"'\n";
  }
  window.alert(str);
}
*/

// end of JS 1.1 compatibility


//
// Note: Konqueror does not like character access with str[i] or Number("a")!
//
function encode_url(str) {
  //debug_codes1();
  //str = escape(str);
  for (var i = str.length; i < 14; i++) {
    str += " ";  // pad string with spaces
  }

/*
  // does not work?
  if (!str.charCodeAt) {
    if (String.prototype) {
      String.prototype.charCodeAt = encode_charCodeAt; // for JS 1.1
    } else {
      str.charCodeAt = encode_charCodeAt; // for JS 1.1
    }
  }
  if (!String.fromCharCode) {
    String.fromCharCode = encode_fromCharCode;  // for JS 1.1
  }
*/

  var hash = 0;
  var mult = 7;
  for (var i = 0; i < str.length; i++) {
    var code = (str.charCodeAt) ? (str.charCodeAt(i) & 0x7f) : (encode_charCodeAt(str, i) & 0x7f); // get 7 bit character code
    hash = hash * mult + ((code >= 32) ? (code - 32) : 0) + 1;
  }
  //alert(hash); // text browser 'links' uses fp arithmetic -> does not work.
  var hstr = String(hash);
  var small_a = (str.charCodeAt) ? "a".charCodeAt(0) : encode_charCodeAt("a", i);
  var url1 = "";
  var fromCharCode1 = (String.fromCharCode) ? String.fromCharCode : encode_fromCharCode; // JS 1.1
  for (var i = 0; i < hstr.length; i++) {
    url1 += (i & 0x03) ? fromCharCode1(small_a + parseInt(hstr.charAt(i))) : hstr.charAt(i);
  }
  if (g_debug) { g_debug.writeln("encode_url='"+ str +"', hash='"+ hash +"', url1='"+ url1 +"'"); }
  return(url1);
}

//end
