//CHECK nested adjective array!!
//
// situ1_main.js - situation main (for debugging with NGS js)
// (c) Marco Vieth, 2003
// http://www.benchmarko.de/
//
// 24.11.2003 1.0  first tests
//
//

//
// Checked with NGS 0.2.5:
//   js -Wall -t -l situ1.js situ1_data1.js timer1.js -f situ1_main.js
// -Wall (all warnings); -t (stack trace), -l (load multiple files) -f (load last file)
//
// Note:
// - *_main.js must be the last file!
// - For debugging:  put debug1.js before *_main.js
//


// You can also append this to the original file (syntax is also ok for browsers).

//
// start this if we are outside of a browser (stand alone JS engines)...
//
function main(args) {
  var loops = 2;
  var separator;
  if (args) {
    if (args.length > 0) {
      loops = parseInt(args[0]);
    }
    if (args.length > 1) {
      separator = args[1]; // separator not for g_situ!
    }
  }
  // Use either global data from file advent1_data_home1.js or (if not specified) some dummy data...
  var situ = g_situ;

  if (!situ) {
    var surroundings1 = new Array("f.S1", "m.S2", "s.S3");
    var events1 = new Array("f.E1", "m.E2", "s.E3");
    var meetings1 = new Array("f.M1", "m.M2", "s.M3");
    var adjectives1 = new Array(new Array("A1", "A2"), new Array("A3", "A4"));
    situ = new Situ(surroundings1, events1, meetings1, adjectives1, separator);
  }
  for (var i = 0; i < loops; i++) {
    var txt = situ.change_text();
    window.document.writeln(txt);
    window.document.writeln("---");
  }
}



// simulate window object for stand alone JS engines...
if (typeof window == "undefined") { // are we outside of a browser in a standalone JS engine?
  function window_open1() {
    return this;
  }

  function window_writeln_system1() { // for NSG JS Engine
    var str = ""; // does not work: arguments.join(" ");
    for (var i = 0; i < arguments.length; i++) {
      str += arguments[i]; // copy arguments
    }
    System.print(str +"\n"); //or: System.stdout.writeln(str);
  }

  function window_writeln_print1() { // for Rhino, SpiderMonkey
    var str = ""; // does not work: arguments.join(" ");
    for (var i = 0; i < arguments.length; i++) {
      str += arguments[i]; // copy arguments
    }
    print(str);
  }

  window = new Object(); // NGS: how to avoid warning about undefined global 'window'?
  window.open = window_open1;
  window.focus = window_open1; // dummy
  window.document = new Object();
  window.document.open = window_open1; // dummy
  window.document.close = window_open1; // dummy
  if (typeof System != "undefined") { // System object is available with NGS JS Engine
    window.document.writeln = window_writeln_system1;
    window.alert = window.document.writeln; // same as writeln
    // convert to integer with standalone engine, use Math.floor for others...
    eval("myint = int"); // set integer cast; avoid warning 'int' is reserved identifier in browsers
    if (typeof ARGS != "undefined") {
      if ((Math.max(5, 8) != 8) || (Math.pow(0.5, 2) != 0.25)) {
        window.alert("ERROR: Buggy NGS Javascript Engine! Correct b_math.c and try again...");
      } else {
        ARGS.shift(); // remove program name in ARGV[0]
        main(ARGS); // start script
      }
    }
  } else { // Rhino, SpiderMonkey...
    if (typeof arguments != "undefined") {
      window.document.writeln = window_writeln_print1; // for Rhino, SpiderMonkey
      window.alert = window.document.writeln; // same as writeln
      main(arguments); // start script
    }
  }
}

// end