//CHECK nested adjective array!!
//
// situ1_main.js - situation main (for debugging with NGS js)
// (c) Marco Vieth, 2003
// http://www.benchmarko.de/
//
// 24.11.2003 1.0  first tests
// 30.01.2006 1.01 support more JS engines
//
//

//
// 1. Checked with NGS 0.2.5:
//   js -Wall -t -l situ1.js situ1_data1.js timer1.js -f situ1_main.js
// -Wall (all warnings); -t (stack trace), -l (load multiple files) -f (load last file)
//
// Note:
// - *_main.js must be the last file!
// - For debugging:  put debug1.js before *_main.js
//
// 2. Spidermonkey 1.5
//   js -f situ1.js -f situ1_data1.js -f timer1.js -f situ1_main.js
//
// 3. Rhino
//   java -jar ~/usr/bin/js.jar -f situ1.js -f situ1_data1.js -f situ1_main.js
//
//

// You can also append this to the original file (syntax is also ok for browsers).

//
// start this if we are outside of a browser (stand alone JS engines)...
//
function main(args) {
  var loops = 2;
  var separator;
  if (args) {
    if (args.length > 0) {
      loops = parseInt(args[0]);
    }
    if (args.length > 1) {
      separator = args[1]; // separator not for g_situ!
    }
  }
  // Use either global data from file advent1_data_home1.js or (if not specified) some dummy data...
  var situ;

  if (typeof g_situ != "undefined") {
    situ = g_situ;
  } else {
    var surroundings1 = new Array("f.S1", "m.S2", "s.S3");
    var events1 = new Array("f.E1", "m.E2", "s.E3");
    var meetings1 = new Array("f.M1", "m.M2", "s.M3");
    var adjectives1 = new Array(new Array("A1", "A2"), new Array("A3", "A4"));
    situ = new Situ(surroundings1, events1, meetings1, adjectives1, separator);
  }
  for (var i = 0; i < loops; i++) {
    var txt = situ.change_text();
    window.document.writeln(txt);
    window.document.writeln("---");
  }
}


// ---------------------------------------

// simulate window object for stand alone JS engines...

// DMDScript does not like functions inside "if", so define them outside...
  function window_open1() {
    return this;
  }

  function window_writeln1() {
    var str = ""; // does not work: arguments.join(" ");
    for (var i = 0; i < arguments.length; i++) {
      str += arguments[i]; // copy arguments
    }
    switch(window.js_engine1) {
      case 1: // NGS JS Engine
        System.print(str +"\n"); //or: System.stdout.writeln(str);
      break;
      case 2: // Rhino, SpiderMonkey
        print(str);
      break;
      case 3: // DMDScript
        println(str);
      break;
      case 4: // Windows JScript (cscript)
        WScript.Echo(str);
      break;
    }
  }

if (typeof window == "undefined") { // are we outside of a browser in a standalone JS engine?
  window = new Object(); // NGS: how to avoid warning about undefined global 'window'?
  window.open = window_open1;
  window.focus = window_open1; // dummy
  window.document = new Object();
  window.document.open = window_open1; // dummy
  window.document.close = window_open1; // dummy
  window.js_engine1 = 0; // js engine for writeln
  window.document.writeln = window_writeln1;
  window.alert = window.document.writeln; // same as writeln
  if (typeof System != "undefined") { // System object is available with NGS JS Engine
    window.js_engine1 = 1;
    // convert to integer with NGS JS Engine engine, use Math.floor for others...
    eval("myint = int"); // set integer cast; avoid warning 'int' is reserved identifier in browsers
    if (typeof ARGS != "undefined") {
      if ((Math.max(5, 8) != 8) || (Math.pow(0.5, 2) != 0.25)) {
        window.alert("ERROR: Buggy NGS Javascript Engine! Correct b_math.c and try again...");
      } else {
        ARGS.shift(); // remove program name in ARGV[0]
        main(ARGS); // start script
      }
    }
  } else if (typeof arguments != "undefined") { // Rhino, SpiderMonkey, DMDScript...
    if (typeof println != "undefined") { // DMDScript
      window.js_engine1 = 3;
      // Note: arguments for DMDScript do not work.
    } else { // Rhino, SpiderMonkey
      window.js_engine1 = 2;
    }
    main(arguments); // start script
  } else if (typeof WScript != "undefined") { // JScript (cscript)...
    window.js_engine1 = 4;
    var args = new Array(); // copy arguments into array
    for (var i = 0; i < WScript.Arguments.length; i++) {
      args[i] = WScript.Arguments(i);
    }
    main(args);
  } else {
    main(); // unknown engine, call without arguments
  }
}

// end
