#!/usr/bin/perl -w
# bmftp1.pl - BM PerlGen v1.0 - FTP transfer
# Benchmarko Perl Generator for Websites - FTP upload to server
# (c) Marco Vieth, 2001
#
# 1.00  25.09.2001  initial release
#
#
use 5.004; 
use strict;

use Getopt::Std;
use File::Basename;
use File::Find;  # find 
use IO::File;

use Net::FTP;


$::g_debug = 0;


# statistics class
$::g_stat = "";

%::g_para = ();
%::g_rfiles = (); # remote files

sub ftp_copy_filenames() {
  if (-f $_) {
    $::g_stat->add_val('30 - files checked', 1);
    if ($::g_debug > 3) {
      printf STDERR "DEBUG: copy_filenames: processing file '%s'\n", $File::Find::name;
    }
    my $ftp = $::g_para{'ftp'};
    my $dir = $::g_para{'basedir'} . "/" . $File::Find::dir;

    my $check_new_f = 0;
    if ($File::Find::dir ne $::g_para{'lastdir'}) {
      print "Checking dir '$File::Find::dir'...\n";
      $check_new_f = 1;
    }

    if (!$check_new_f || $ftp->cwd($dir)) {
      if ($check_new_f) { # first time in this directory?
        my $entrie_p = $ftp->ls() || (warn("WARNING: FTP->ls()\n"), return 1);
        foreach my $f1 (@$entrie_p) {
          if ($f1 =~ /^\./) { next; }
          if (! -r $f1) { # does something not exist locally?
            $::g_rfiles{"$File::Find::dir/$f1"} = "-1". " D"; # we can delete this file/dir!
            $::g_stat->add_val('40 - files to delete', 1);
          }
        }
      }
      my $time1;
      $time1 = $ftp->mdtm($_) || "0"; # maybe not there
      my ($time2) = (stat($_))[9] || "0";
      #printf STDERR "DEBUG: mdtm='$t1', '$t2'\n";
      if ($::g_para{'force_f'} || $time1 < $time2) {
        print (($time1 > 0) ? "Updating" : "Copying");
        print " file '$File::Find::name'...\n";
        $ftp->put($_) || (warn("WARNING: FTP->put($_)\n"), return 1);
        if ($::g_debug > 0) {
          if ($time1 > 0) { # got a timestamp from remote file?
            printf STDERR "DEBUG: file updated: '$_'\n";
          } else {
            printf STDERR "DEBUG: file copied: '$_'\n";
          } 
        }
        my $t1 = $ftp->mdtm($_) || (warn("WARNING: FTP->mdtm($_)\n"), return 1);
        $::g_rfiles{$File::Find::name} = $t1 . (($time1 > 0) ? " U" : " C");
        if ($time1 > 0) {
          $::g_stat->add_val('32 - files updated', 1);
        } else {
          $::g_stat->add_val('31 - files copied', 1);
        }
      } else {
        $::g_rfiles{$File::Find::name} = $time1 ." I";
        $::g_stat->add_val('34 - files ignored', 1);
      }
      #if ($::g_para{'force_f'} || (! -f $dest) || -M $src < -M $dest) { }
    } else {
      my $newdir = $dir;
      $ftp->mkdir($newdir, 1) || (warn("WARNING: FTP->mkdir($newdir)\n"), return 1);
      if ($::g_debug > 0) {
        printf STDERR "DEBUG: remote directory created: $newdir\n";
      }
      $ftp->cwd($newdir) || (warn("WARNING: FTP->cwd($newdir)\n"), return 1);
      print "Copying file '$File::Find::name'...\n";
      $ftp->put($_) || (warn("WARNING: FTP->put($_)\n"), return 1);
      if ($::g_debug > 0) {
        printf STDERR "DEBUG: file copied: '$_'\n";
      }
      my $t1 = $ftp->mdtm($_) || (warn("WARNING: FTP->mdtm($_)\n"), return 1);
      $::g_rfiles{$File::Find::name} = $t1 ." C";
      $::g_stat->add_val('31 - files copied', 1); 
    }
    #$ftp->cwd($pwd) || (warn("WARNING: FTP->cwd($pwd)\n"), return 1);
    $::g_para{'lastdir'} = $File::Find::dir;
  }
}


#
# main
#
sub main() {
  my %opts = (
   'f' => 0,
   'r' => undef,
   'u' => "anonymous",
   'p' => "anonymous",
   'l' => "./",
   's' => undef,
   'd' => "0",
  );
  if (!getopts("fr:u:p:l:hd:", \%opts) or (@ARGV == 0) or exists($opts{'h'})) {
    print STDERR "Usage: ". basename($0) ." [options] <destination dir>\n";
    #print STDERR "-f         : force copy\n";
    print STDERR "-r <host>  : remote host\n";
    print STDERR "-u <user>  : user\n";
    print STDERR "-p <passwd>: password\n";
    print STDERR "-l <loc>   : location (directory)\n";
    print STDERR "-h         : help\n";
    print STDERR "-d  level  : debug level (0=off, 1=normal, >1=extended)\n";
    print STDERR "\n";
    exit 1;
  }
 
  $::g_debug = $opts{'d'};
 
  if ($::g_debug > 0) {
    printf STDERR "DEBUG: Debugging switched on.\n";
    printf STDERR "DEBUG: remote host: '$opts{r}', user: '$opts{u}', passwd: '$opts{p}'\n";
    printf STDERR "DEBUG: location: '$opts{l}'\n";
  }

  $::g_stat = Mystat->new();

  #my $s_dir = cwd();
  #print "Using source directory '$s_dir'\n";
 
  my $d_dir = $ARGV[0];
  print "Using source directory '$d_dir'\n";
  if (! -d $d_dir) {
    warn "WARNING: Directory does not exist: '$d_dir'\n";
    return 1;
  }

  my $ftp = Net::FTP->new($opts{'r'}, Debug => 0) || (warn("WARNING: FTP->new($opts{r})\n"), return 1);
  $ftp->login($opts{'u'}, $opts{'p'}) || (warn("WARNING: FTP->login\n"), return 1);
  if (!$ftp->cwd($opts{'l'})) { # dir does not exist?
    $ftp->mkdir($opts{'l'}, 1) || (warn("WARNING: FTP->mkdir($opts{'l'})\n"), return 1);
    if ($::g_debug > 0) {
      printf STDERR "DEBUG: remote directory created: $opts{'l'}\n";
    }
    $ftp->cwd($opts{'l'}) || (warn("WARNING: FTP->cwd(", $opts{'l'}, ")\n"), return 1);
  }
  $ftp->binary() || (warn("WARNING: FTP->binary()\n"), return 1);
  my $pwd = $ftp->pwd() || (warn("WARNING: FTP->pwd()\n"), return 1);
  $::g_para{'basedir'} = $pwd;
  $::g_para{'lastdir'} = "";
  $::g_para{'ftp'} = $ftp;
  $::g_para{'force_f'} = $opts{'f'};
  #$::g_para{'ldir'} = $opts{'l'};
  
  find(\&ftp_copy_filenames, $d_dir);
  $ftp->quit();

  my $f = "$d_dir/inc_ftp.txt";
  my $outf = new IO::File($f, "w") || (warn("WARNING: Open $!: '$f'\n"), return 1);
  print $outf "# Filelist of $opts{'r'}:$opts{'l'}\n";
  
  foreach (sort keys %::g_rfiles) {
    my @ps = split(' ', $::g_rfiles{$_});
    printf $outf "%-12d %s %s\n", $ps[0], $ps[1], $_;
  }
  close($outf);
  print "Filelist written to '$f'.\n";

  print "Summary:\n"; 
  $::g_stat->print_all();
 
  return 0;
}
 
exit(main());
 
 
################################################


package Mystat;

use strict;

sub new {
  my $class = shift;
  my $self = {};
  $self->{'debug'} = 0;
  %{$self->{'stat'}} = ();
  bless($self, $class);
  if (@_ > 0) {
    die "Unknown parameter: '@_'\n";
  }
  return $self;
}


sub set_debug {
  my($self, $debug) = @_;
  $self->{'debug'} = $debug;
  return 1;
}


#
# debug_msg - print a debug message
# IN : <preamble> <message>
# OUT: 1=ok
# The message is written to STDERR.
#
sub debug_msg {
  my($self, $preamble, $message) = @_;
  print STDERR "$preamble: ${message}\n";
  return 1;
}

sub set_val($$) {
  my($self, $key, $value) = @_;
  $self->{'stat'}->{$key} = $value;
  return 1;
}

sub add_val($$) {
  my($self, $key, $value) = @_;
  #print STDERR "DEBUG: add_val: '$key' += '$value'\n";
  $self->{'stat'}->{$key} += $value;
  return 1;
}

sub get_val($) {
  my($self, $key) = @_;
  return $self->{'stat'}->{$key};
}


sub print_all() {
  my($self, $key) = @_;
  #print STDERR "DEBUG: print_all\n";
  foreach my $i (sort keys %{$self->{'stat'}}) {
    print "$i: $self->{'stat'}->{$i}\n";
  }
}

# end
