#!/usr/bin/perl -w
# bmcreate1.pl - BM PerlGen v1.07
# Benchmarko Perl Generator for Websites
# (c) Marco Vieth, 2001
#
# 1.00  02.02.2001 first tests;
#                  copy only modified files (with newer timestamps);
#                  rename files to index.html, if they are named like the directory;
# 1.01  03.02.2001 replace special characters
#                  nested '##INCLUDE "<file>"' possible!
# 1.02  09.02.2001 ##DEFINE <key>='<value>' (value can be a ##<file>)
#                  ##INCLUDE '##<file>' (no double quotes any more, '##' needed to search file)
# 1.03  10.02.2001 destination tree check; some statistical output
# 1.04  13.02.2001 support index_e.html for English pages
# 1.05  14.09.2001 ##VFILE to create virtual files
#       17.09.2001 new internal parameter _BM_TAG to modify the tag '##', _BM_NOCOPY;
#                  open optional definition file bmcreate1.def first
# 1.06  11.11.2001 support for French and Spanish pages;
#                  new commands ##IF, ##ELSE, ##ENDIF
#       12.11.2001 parameters are now defined in one html file context only
# 1.07  19.01.2002 Problem with uppercase filenames under Windows: convert all to lowercase
# 1.071 31.08.2003 some pattern warnings with Perl 5.8 removed
# 1.072 04.04.2004 adapted to use Bm package
# 1.073 10.02.2006 put template generation into Template::Bmcreate; allow same filenames in different dirs
# 1.074 04.03.2006 use File::Spec to create and simplify relative pathnames
# 1.075 22.07.2006 all in one executable
#
#
# To Do:
# - not existing names from virtual files are reported as having no source
#
  $VERSION = '1.075';
  use 5.004;
  use strict;

  use Getopt::Std ();
  use File::Find ();  # find
  use File::Copy ();  # copy
  use File::Path ();  # mkpath
  use Cwd ();         # cwd

  #use Bm ();
  #use Bm_finalstat ();

  $::g_debug = 0;

#############

# some predefined parameters '##<parameter>'
%::g_para = (
  'AUTHOR' =>    'Marco Vieth',
  'DATE' =>      '',    # will be set later
  'GENERATOR' => 'BM PerlGen v'. $::VERSION,
  'MAILTO' =>    'mail@benchmarko.de',
  'TIME' =>      '',    # will be set later
  'CHARMAP' =>   '1',   # replace special characters
  '_BM_TAG' =>   '##',  # the tag for new parameters
  '_BM_NOCOPY' => '^(?:inc_.*\.txt|.*\.(?:bat|bak|swp)|.*~)$', # do not copy includes, .bat...
);

# html extension
$::g_htmlext = '.html';

$::g_index = 'index';

# language markers/signs
# If we find <name>/<name><langsign>.html, we convert it to <name>/$::g_index<langsign>.html
$::g_langsigns = '|_e|_f|_s'; # the first empty extension '' is default (not needed here)


# some characters to convert
#%::g_charmap_gr_unused1 = (
#  # German
#  '' => '&auml;',
#  '' => '&Auml;',
#  '' => '&ouml;',
#  '' => '&Ouml;',
#  '' => '&uuml;',
#  '' => '&Uuml;',
#  '' => '&szlig;',
#  # French
#  '' => '&agrave;',
#  '' => '&ccedil;',
#  '' => '&eacute;',
#  '' => '&egrave;',
#  '' => '&icirc;',
#  #'?' => '&lsquo;',
#  #'?' => '&ldquo;',
#  #'?' => '&rdquo;',
#  # Spanish
#  '' => '&ntilde;',
#  '' => '&aacute;',
#  '' => '&oacute;',
#  '' => '&uacute;',
#  '' => '&iquest;',
#  '' => '&iexcl;',
#);


# Charmap named HTML entities ISO 8859-1 (since HTML 3.2)
%::g_charmap = (
  '' => '&iexcl;',
  '' => '&cent;',
  '' => '&pound;',
  '' => '&curren;',
  '' => '&yen;',
  '' => '&brvbar;',
  '' => '&sect;',
  '' => '&uml;',
  '' => '&copy;',
  '' => '&ordf;',
  '' => '&laquo;',
  '' => '&not;',
  '' => '&shy;',
  '' => '&reg;',
  '' => '&macr;',
  '' => '&deg;',
  '' => '&plusmn;',
  '' => '&sup2;',
  '' => '&sup3;',
  '' => '&acute;',
  '' => '&micro;',
  '' => '&para;',
  '' => '&middot;',
  '' => '&cedil;',
  '' => '&sup1;',
  '' => '&ordm;',
  '' => '&raquo;',
  '' => '&frac14;',
  '' => '&frac12;',
  '' => '&frac34;',
  '' => '&iquest;',
  '' => '&Agrave;',
  '' => '&Aacute;',
  '' => '&Acirc;',
  '' => '&Atilde;',
  '' => '&Auml;',
  '' => '&Aring;',
  '' => '&AElig;',
  '' => '&Ccedil;',
  '' => '&Egrave;',
  '' => '&Eacute;',
  '' => '&Ecirc;',
  '' => '&Euml;',
  '' => '&Igrave;',
  '' => '&Iacute;',
  '' => '&Icirc;',
  '' => '&Iuml;',
  '' => '&ETH;',
  '' => '&Ntilde;',
  '' => '&Ograve;',
  '' => '&Oacute;',
  '' => '&Ocirc;',
  '' => '&Otilde;',
  '' => '&Ouml;',
  '' => '&times;',
  '' => '&Oslash;',
  '' => '&Ugrave;',
  '' => '&Uacute;',
  '' => '&Ucirc;',
  '' => '&Uuml;',
  '' => '&Yacute;',
  '' => '&THORN;',
  '' => '&szlig;',
  '' => '&agrave;',
  '' => '&aacute;',
  '' => '&acirc;',
  '' => '&atilde;',
  '' => '&auml;',
  '' => '&aring;',
  '' => '&aelig;',
  '' => '&ccedil;',
  '' => '&egrave;',
  '' => '&eacute;',
  '' => '&ecirc;',
  '' => '&euml;',
  '' => '&igrave;',
  '' => '&iacute;',
  '' => '&icirc;',
  '' => '&iuml;',
  '' => '&eth;',
  '' => '&ntilde;',
  '' => '&ograve;',
  '' => '&oacute;',
  '' => '&ocirc;',
  '' => '&otilde;',
  '' => '&ouml;',
  '' => '&divide;',
  '' => '&oslash;',
  '' => '&ugrave;',
  '' => '&uacute;',
  '' => '&ucirc;',
  '' => '&uuml;',
  '' => '&yacute;',
  '' => '&thorn;',
  '' => '&yuml;',
);


#
#
#

# filenames and directories under source
%::c_fname = ();

# statistics class
$::g_stat = '';



# rename HTML file to index[_x].html, if same name as directoy
#
sub adapt_fname($$) {
  my($fname, $dir) = @_;
  if ($fname =~ /(\w+)$::g_htmlext$/o) { # html file? (once)
    my $find = $1;
    my $langext = '';
    if ($find =~ s/($::g_langsigns)$//o) { # remove language extension from filename
      $langext = $1; # memorize language extension, if found
    }
    if ($dir =~ /${find}$/) { # name of file (without language ext.) also found in path?
      if ($::g_debug) { Bm::debug_msg("adapt_fname: dir='$dir', file='$fname' => '$::g_index$langext$::g_htmlext', find='$find', langext='$langext'", 1); }
      $fname = $::g_index . $langext . $::g_htmlext; # yes, use index<langext>.html
    }
  }
  return($fname);
}



#
# copy files from source to publishing destination
#
sub copyfiles($$$$) {
  my($src_dir, $dest_dir, $fpath_r, $force_f) = @_;

  foreach my $f1 (keys %$fpath_r) {
   foreach my $p1 (@{$fpath_r->{$f1}}) {
    if ($f1 =~ /$::g_para{'_BM_NOCOPY'}/) {
      $::g_stat->add_val('20 - files ignored (nocopy)', 1);
      if ($::g_debug) { Bm::debug_msg("copyfiles: ingoring file '$p1/$f1'", 1); }
      next;
    }
    if ($::g_debug) { Bm::debug_msg("copyfiles: processing file '$p1/$f1'", 2); }
    my $src = "${src_dir}/$p1/$f1";
    my $dest = "${dest_dir}/$p1/". adapt_fname($f1, $p1);
      # rename HTML file to index.html, if same name as directoy

    if ($force_f || (! -f $dest) || -M $src < -M $dest) {
      if (! -d "${dest_dir}/$p1") {
        File::Path::mkpath("${dest_dir}/$p1", ($::g_debug > 3), 0711);
      }
      if ($f1 =~ /(.*)$::g_htmlext$/o) { # (once)
        if ($::g_debug) { Bm::debug_msg("$::g_htmlext: '$p1/$f1'", 0); }
        Template::Bmcreate::copy_html($src, $dest, $p1, $f1, $fpath_r, $src_dir, $dest_dir, \&adapt_fname);
      } else {
        if ($::g_debug) { Bm::debug_msg("Copying '$src' -> '$dest'", 0); }
        File::Copy::copy($src, $dest) || Bm::warn_msg("'$src'->'$dest': $!");
        $::g_stat->add_val('22 - files copied', 1);
      }
    } else {
      $::g_stat->add_val('21 - files ignored (timestamp)', 1);
    }
   }
  }
}


{
  my $is_windows = undef();
  sub is_windows() {
    #my() = @_;
    if (!defined $is_windows) {
      $is_windows = $^O eq 'MSWin32'; # 'MSWin32' (all Windows platforms), 'hpux', 'VMS', ...
      if ($::g_debug) { Bm::debug_msg("is_windows = '$is_windows'", 0); }
    }
    return $is_windows;
  }
}

sub win_lc($) {
  return (is_windows()) ? lc($_[0]) : $_[0];
}

#
# collect filenames from source tree
#
sub collectfilenames_s() {
  if ($::g_debug) { Bm::debug_msg("collectfilenames_s: processing file '$File::Find::name'...", 2); }
  if (-f $_) {
    my $fn = win_lc($_); # needed for Windows: convert to lowercase
    $::g_stat->add_val('10 - source files (total)', 1);
    if (defined $::c_fname{$fn}) {
      if ($::g_debug) { Bm::debug_msg("collectfilenames_s: File '$fn' already defined: '$File::Find::name'", 0); }
      #Bm::warn_msg("collectfilenames_s: File '$fn' already defined: '$File::Find::name'!");
      $::g_stat->add_val('11 - source files (same name)', 1);
    }
    push @{$::c_fname{$fn}}, win_lc($File::Find::dir);
      # $::c_fname{$fn} =~ s/^\.\///; # remove leading './' from directory path
  }
}



my $loc_dest_path = '';

#
# check filenames from destination tree
#
sub checkfilenames_d() {
  if ($::g_debug) { Bm::debug_msg("checkfilenames_d: processing file '$File::Find::name'...", 3); }
  if (-f $_) {
    my $fn = win_lc($_); # needed for Windows: convert to lowercase
    if ($fn =~ /$::g_index($::g_langsigns)$::g_htmlext/) { #renamed file index_x.html?
      my $langext = $1; # memorize language extension
      if (win_lc($File::Find::dir) =~ /$loc_dest_path.*\/([^ \/]+)$/) {
        $fn = $1 . $langext . $::g_htmlext;
      }
      #print STDERR "DDD: strange name found: ", $File::Find::dir, ": '$fn'\n";
    }
    $::g_stat->add_val('80 - destination files (total)', 1);
    if (!defined $::c_fname{$fn}) {
      if ($fn =~ /^ws_ftp\.log$/) { # ignore this... (fast hack)
        $::g_stat->add_val('81 - destination files ignored', 1);
      } else {
        Bm::warn_msg("checkfilenames_d: File without source: '$File::Find::name'");
        $::g_stat->add_val('82 - destination files without source', 1);
      }
    }
  }
}


sub do_bmcreate($$) {
  my($dest_dir, $force_flg) = @_;

  my $datetime = Bm::get_ltime();
  ($::g_para{'DATE'}, $::g_para{'TIME'}) = split(' ', $datetime); # initialize date, time

  $::g_stat = Bm_finalstat->new();

  my $s_dir = Cwd::cwd();
  Bm::print_msg("Using source directory '$s_dir'");

  Bm::print_msg("Using destination directory '$dest_dir'");
  if (! -d $dest_dir) {
    Bm::note_msg("Creating destination directory '$dest_dir'");
    File::Path::mkpath($dest_dir, ($::g_debug > 2), 0711) || (Bm::warn_msg("$!: '$dest_dir'"), return);
  }

  File::Find::find(\&collectfilenames_s, ".");

  # to adapt...
  #my $def_file = "bmcreate1.def";
  #if (-r $def_file) {
  #  print "Copying definition file '$def_file' first...\n";
  #  copy_html("$s_dir$def_file", "$dest_dir$def_file", "", $def_file, \%::c_fname, $s_dir, $dest_dir);
  #  delete $::c_fname{$def_file}; # remove def_file from file list
  #}

  copyfiles($s_dir, $dest_dir, \%::c_fname, $force_flg);

  # additional check
  $loc_dest_path = $dest_dir;
  $loc_dest_path =~ tr#/.#.#; # pattern for destination path, which should be found in directory if index_x.html found
  #print "DDD: path='$loc_dest_path'\n";
  File::Find::find(\&checkfilenames_d, $dest_dir);

  print "Summary:\n";
  $::g_stat->print_all();
  return 1;
}


#
# main
#
sub main() {
  my %opts = (
   'f' => 0,
  );
  if (!Getopt::Std::getopts("fhDd:", \%opts) or (@ARGV == 0) or exists($opts{'h'})) {
    require File::Basename;  # load dynamically for help
    print STDERR "Usage: ". File::Basename::basename($0) ." [options] <destination dir>\n";
    print STDERR "-f       : force copy\n";
    print STDERR "-D       : dup STDOUT to STDERR\n";
    print STDERR "-h       : help\n";
    print STDERR "-d level : debug level (0=off, 1=normal, >1=extended)\n";
    print STDERR "\n";
    exit 1;
  }

  Bm::set_debug($opts{'d'});
  if ($opts{'D'}) { # dup flag
    open(STDERR, ">&STDOUT") || (err_msg("Cannot dup STDOUT to STDERR!"));
    Bm::file_autoflush(*STDERR); # needed on some weird Perl 5.6.1 on Windows...
    $| = 1; # set autoflush for STDOUT (normally not needed, but to see messages at correct places...)
  }

  Bm::script_msg();

  if ($::g_debug > 0) {
    printf STDERR "DEBUG: Debugging switched on.\n";
  }

  my $rc = do_bmcreate($ARGV[0], $opts{'f'});

  return Bm::get_exit_code();
}

exit(main());

#
#

package Template::Bmcreate;
  #$VERSION = '0.01';
  use strict;

  use File::Spec (); # abs2rel
#

#
# copy from one file to another until a pattern found and convert special characters
# (If $outf is undefined, output is ignored.)
#
sub copy_until_pattern($$$@) {
  my($in_f, $out_f, $charmap_f, @patterns) = @_;
  my $pattern = join('|', @patterns);

  my $findchars = join('', keys %::g_charmap); # "???"

  if ($::g_debug) { Bm::debug_msg("copy_until_pattern: pattern='$pattern'", 1); }
  if ($pattern ne "") {
    while (<$in_f>) {
      if ($charmap_f) {
        $_ =~ s/([$findchars])/$::g_charmap{$1}/g; # convert 'Umlaute' to HTML notation (not needed for HTML 4.0)
      }
      if (/$pattern/) {
        if ($::g_debug) { Bm::debug_msg("Pattern found in: '$_'", 1); }
        return $_;
      }
      if (defined $out_f) {
        print $out_f ($_);
      }
    }
  } else {
    if ($::g_debug) { Bm::debug_msg("Copy rest of file...", 1); }
    while (<$in_f>) { if (defined $out_f) { print $out_f ($_); } }
  }
  return(defined($_) ? $_ : '');
}


sub compute_path_diff($$) {
  my($dir1, $dir2) = @_;
  if ($dir1 eq $dir2) {
    return 0;
  } else {
     my @ds1 = split(/\//, $dir1);
     my @ds2 = split(/\//, $dir2);
     # remove common parts...
     while (@ds1 && @ds2 && ($ds1[0] eq $ds2[0])) {
       shift(@ds1);
       shift(@ds2);
     }
     my $diff = @ds1 + @ds2;
     if ($::g_debug) { Bm::debug_msg("compute_path_diff: ds1='@ds1', ds2='@ds2', path_diff='$diff'", 1); }
     return $diff;
  }
}


# get pathnames for file $f from hash $fpath_r
# and select "closest" one depending on dir...
sub get_path($$$) {
  my($fpath_r, $f, $dir) = @_;
  my $paths_r = $fpath_r->{$f};
  if (@$paths_r <= 1) { #exactly one path?
    return $paths_r->[0]; #use it, no choice
  }
  if ($::g_debug) { Bm::debug_msg("get_path: pathlist='@$paths_r', f='$f', dir='$dir'", 1); }
  my $min_diff = 1e9;
  my $min_diff_pos = 0;
  for (my $i = 0; $i < @$paths_r; $i++) {
    my $p1 = $paths_r->[$i];
    my $diff = compute_path_diff($dir, $p1);
    if ($diff < $min_diff) { # compute minimum
      $min_diff = $diff;
      $min_diff_pos = $i;
    }
  }

  return $paths_r->[$min_diff_pos]; #?? TTT first one...
}


#
# copy html file
# convert special patterns starting with '##' and special characters
# src_dir, dest_dir are maybe needed for VFILE
#
sub copy_html($$$$$$$$) {
  my($in_fn, $out_fn, $dir, $fname, $fpath_r, $src_dir, $dest_dir, $adapt_fname_func) = @_;
  my $rc = 1;

  my %l_para = %::g_para; # get global parameter into local ones
  my $bm_tag = $l_para{'_BM_TAG'}; # normally '##'
  if ($::g_debug) { Bm::debug_msg("copy_html: in_fn='$in_fn', out_fn=$out_fn'", 0); }
  $::g_stat->add_val('30 - files analyzed (HTML)', 1);

  my %stat = (
    'I' => 0,  # includes
    'D' => 0,  # defines
    'V' => 0,  # virtual files
    'ud' => 0, # used defines
    'uf' => 0  # used files
  );

  my $in_f = Bm::file_open("<$in_fn") || (Bm::warn_msg("$!: '$in_fn'"), return);
  my @in_f = ();
  push(@in_f, $in_f); # descriptor to stack of input files
  my $out_f = Bm::file_open(">$out_fn") || (Bm::warn_msg("$!: '$out_fn'"), return);

  #printf STDERR "'$dir', NUM=%d\n", scalar(($dir =~ tr#/#/#));
  # my $dirback = "../" x scalar(($dir =~ tr#/#/#)); # not used any moe
  my $tmp_line;
  my $tmp;
  my $f; # temporary filename
  my @condition = (1); # condition array for nested ifs, 1= output is active
  while ($in_f = pop(@in_f)) {
    while (($tmp_line = copy_until_pattern($in_f, ($condition[0]) ? $out_f : undef(), $l_para{'CHARMAP'}, $bm_tag)) ne "") {
      my $cond = ""; # no condition (control command)
      my $cmd = ""; # no command
      while ($tmp_line =~ /$bm_tag([\w.\/]+)/g) { # run through all bm_tags in line...
        $f = $1;
        #print "TEST: '$1'\n";
        if ($f =~ /^(IF|ELSE|ENDIF)$/o) { # control command?
          $cond = $1;
          #print STDERR "DEBUG: f='$f', cond='$cond'\n";
          $tmp_line =~ s/$bm_tag/aa/; # modify parameter so it will not be replaced below ??

        } elsif ($f =~ /^(INCLUDE|DEFINE|VFILE)$/o) { # special command?
          $cmd = substr($1, 0, 1); # set command for later
          #print STDERR "f= '$f', cmd='$cmd'\n";
          $tmp_line =~ s/$bm_tag/$cmd$cmd/; # modify parameter so it will not be replaced below
          $stat{$cmd}++;

        } elsif (exists $l_para{$f}) { # parameter set?
          if ($::g_debug) { Bm::debug_msg("File '$fname': Replacing '$f' -> '$l_para{$f}'", 0); }
          $tmp_line =~ s/$bm_tag([\w.\/]+)/$l_para{$f}/;
          $stat{'ud'}++;

        } else { # assume it is a file
          #$f = $x0; # short filename to find
          if (exists $fpath_r->{$f}) { # assume filename
            my $p1 = get_path($fpath_r, $f, $dir); # get path (maybe multiple)
            #$tmp = "${dirback}$p1/". $adapt_fname_func->($f, $p1); # ok, but sometimes too long
            # rename HTML file to index.html, if same name as directoy?
            #$tmp =~ s/\/\.\//\//; # replace '/./' -> '/' (still needed?)
            $tmp = File::Spec->abs2rel($src_dir .'/'. $p1 .'/'. $adapt_fname_func->($f, $p1), $src_dir .'/'. $dir); # shorten relative paths which go back and forth
            #print "DDD: '$tmp' : '$tmp2'\n";
            if ($::g_debug) { Bm::debug_msg("File '$fname': Replacing '$f' -> '$tmp'", 0); }
            $tmp_line =~ s/$bm_tag([\w.\/]+)/$tmp/;
            $stat{'uf'}++;
          } else {
            if ($condition[0]) { # only if output is active
              Bm::warn_msg("File '$fname': referenced file/definition not found: '$f'.");
              $::g_stat->add_val('41 - references not found', 1);
            }
          }
        }
      }

      if ($cond eq '') {
        ; # nothing to do
      } elsif ($cond eq 'IF') {
        if ($tmp_line =~ /IF\s*(\w+)\s*(=|!=)\s*'(.*?)'/) {
          if ($::g_debug) { Bm::debug_msg("File '$fname': IF '$1' $2 '$3'", 0); }
          if (!$condition[0]) { # condition false?
            unshift(@condition, 0); # yes, do not analyze new condition
          } elsif ($2 eq '=') {
            unshift(@condition, (defined $l_para{$1}) ? ($l_para{$1} eq $3) : 0);
          } elsif ($2 eq '!=') {
            unshift(@condition, (defined $l_para{$1}) ? ($l_para{$1} ne $3) : 0);
          }
          if ($::g_debug) { Bm::debug_msg("File '$fname': IF: condition='$condition[0]'", 0); }
        } else {
          chomp $tmp_line;
          Bm::warn_msg("File '$fname': Ignoring line '$tmp_line'");
        }

      } elsif ($cond eq 'ELSE') {
        $condition[0] = !$condition[0]; # invert flag

      } elsif ($cond eq 'ENDIF') {
        if ($#condition > 0) {
          shift(@condition); # remove condition from stack
        } else {
          Bm::warn_msg("File '$fname': 'ENDIF' without 'IF'!");
        }
      }
      #print STDERR "DEBUG: f='$f', condition='$condition[0]'\n";

      if (!$condition[0] || ($cond ne '')) {
        if ($::g_debug) { chomp $tmp_line; Bm::debug_msg("File '$fname': Condition false. Ignoring line '$tmp_line'.", 0); }
        $cmd = "";
        #next; # ignore output, command

      } elsif ($cmd eq "") { # no special cmd -> print line
        print $out_f ($tmp_line);

      } elsif ($cmd eq 'I') { # INCLUDE
        #print STDERR "DEBUG ($fname): tmp_line='$tmp_line'\n";
        if ($tmp_line =~ /IIINCLUDE\s*(.)([\w.\/-]+)\1/) {
          $f = "$dir/$2";
          if ($::g_debug) { Bm::debug_msg("File '$fname': Including '$f'...", 0); }
          if (-r $f) {
            push(@in_f, $in_f); # current descriptor back on stack
            $in_f = Bm::file_open("<$f") || (Bm::warn_msg("Open Include: $!: '$f'"), pop(@in_f));
          } else {
            Bm::warn_msg("File '$fname': Include file not found: '$f'!");
          }
        } else {
          chomp $tmp_line;
          Bm::warn_msg("File '$fname': Ignoring line '$tmp_line'");
        }

      } elsif ($cmd eq 'D') { # DEFINE
        #print STDERR "DEBUG ($fname): '$tmp_line'\n";
        if ($tmp_line =~ /DDDEFINE\s*(\w+)\s*=\s*'(.*?)'/) {
          if ($::g_debug) { Bm::debug_msg("File '$fname': Define '$1' = '$2'", 0); }
          $l_para{$1} = $2;
          if ($1 eq '_BM_TAG') {
            $bm_tag = $2; # set also to local variable
          }
        } else {
          chomp $tmp_line;
          Bm::warn_msg("File '$fname': Ignoring line '$tmp_line'");
        }

      } elsif ($cmd eq 'V') { # VFILE
        #print STDERR "DEBUG ($fname): '$tmp_line'\n";
        if ($tmp_line =~ /VVVFILE\s*(.)([\w.\/-]+)\1/) {
          $f = $2;
          if ((my $ri = rindex($f, '/')) > 0) { # path specified?
            #$dir .= "/" . substr($f, 0, $ri);
            $dir = '.'. substr($f, 0, $ri);
            #$dirback = "../" x scalar(($dir =~ tr#/#/#)); # set new dirback #??
            if (! -d "$dest_dir/$dir") { # maybe we need a new path
              File::Path::mkpath("$dest_dir/$dir", ($::g_debug > 3), 0711) || (Bm::warn_msg("mkpath: $!: '$dest_dir/$dir'"), return);
            }
            #$dir = "$src_dir/$dir";
            if (! -d "$src_dir/$dir") { # create dir also in source tree!
              Bm::note_msg("File '$fname': VFILE: directory created in SOURCE: '$src_dir/$dir'.");
              File::Path::mkpath("$src_dir/$dir", ($::g_debug > 3), 0711) || (Bm::warn_msg("mkpath: $!: '$src_dir/$dir'"), return);
            }
          } else { # just a filename
            #$f = "$src_dir/$f"; # ???
          }
          if ($::g_debug) {
            Bm::debug_msg("File '$fname': Creating virtual file '$f'...", 0);
            if (-r $f) {
              Bm::debug_msg("File '$fname': Virtual file already exists: '$f'!", 0);
            }
          }
          #print "Note: ($fname): should create virtual file '$f'.\n";
          # start new output file...
          close($out_f) || (Bm::warn_msg("$!: '$out_fn'"), return);
          $out_fn = "$dest_dir/$f";
          $out_f = Bm::file_open(">$out_fn") || (Bm::warn_msg("$!: '$out_fn'"), return);

        } else {
          chomp $tmp_line;
          Bm::warn_msg("File '$fname': Ignoring line '$tmp_line'");
        }

      } else { # undefined command (programming error?)
        chomp $tmp_line;
        Bm::warn_msg("File '$fname': Undefined command '$cmd' in line '$tmp_line'");
      }
    }
    close($in_f) || (Bm::warn_msg("$!: '$in_fn'"), return);
  }
  close($out_f) || (Bm::warn_msg("$!: '$out_fn'"), return);

  if ($stat{'I'}) { $::g_stat->add_val('31 - ##INCLUDE', $stat{'I'}); }
  if ($stat{'D'}) { $::g_stat->add_val('32 - ##DEFINE', $stat{'D'}); }
  if ($stat{'ud'}) { $::g_stat->add_val('33 - ##<define>', $stat{'ud'}); }
  if ($stat{'uf'}) { $::g_stat->add_val('34 - ##<file>', $stat{'uf'}); }
  if ($stat{'V'}) { $::g_stat->add_val('35 - ##VFILE', $stat{'V'}); }

  return $rc;
}

#
#

# Bm.pm - Module with basic functionality (simplified)
#
# Marco Vieth, 04.04.2004
#
# 1.03  18.03.2004  separated from Bm_base.pm
#
package Bm;
  #$VERSION = '1.03';
  use strict;

######################################

sub set_debug($) {
  #my($debug) = @_;
  if (defined $_[0]) { $::g_debug = $_[0]; } # overwrite only if defined
}


{
  my $prg_preamble_func = sub { '' };
  my @msg_counts = (0, 0, 0, 0, 0, 0); # number of messages (debug, notes, warnings, errors, other, prints) (not initialized?)

  sub set_msg_counts($$$$$$) {
    #my($debug_cnt, $note_cnt, $warn_cnt, $err_cnt, $other_cnt, $print_cnt) = @_;
    @msg_counts = @_;
  }
  # get message counts
  sub get_msg_counts() {
    return @msg_counts;
  }

  sub _msg_out1($$$$) {
    #my($message, $msg_level, $preamble, $out_f) = @_;
    print { $_[3] } ($prg_preamble_func ? &{$prg_preamble_func} : '') . $_[2] . $_[0] ."\n";
    $msg_counts[$_[1]]++;
  }

  # debug_msg - print a debug message
  sub debug_msg($$;$) {
    #my($message, $level, $preamble) = @_;
    if (($::g_debug > ($_[1] || 0)) && $_[0]) { # level > debug level, message not empty?
      _msg_out1($_[0], 0, ($_[2]) ? $_[2] .': ' : 'DEBUG('. (($_[1] || 0) + 1) .'): ', *STDERR);
    }
  }

  # note_msg - print a notice message
  sub note_msg($) {
    #my($message) = @_;
    if ($_[0]) { # only if message is not empty
      _msg_out1($_[0], 1, 'NOTE: ', *STDERR);
    }
  }

  # warn_msg - print a warn message
  sub warn_msg($) {
    #my($message) = @_;
    if ($_[0]) {
      _msg_out1($_[0], 2, 'WARNING: ', *STDERR);
    }
  }

  # err_msg - print an error message
  sub err_msg($) {
    #my($message) = @_;
    if ($_[0]) {
      _msg_out1($_[0], 3, 'ERROR: ', *STDERR);
    }
  }

  # print_msg - print a standard message (to stdout)
  sub print_msg($) {
    #my($message) = @_;
    if ($_[0]) {
      _msg_out1($_[0], 5, '', *STDOUT);
    }
  }
}

#
# get_ltime -  get local time
# IN : [timeval]
# OUT: ($sec, $min, $hour, $day, $mon, $year)
# Get the current local time time, either as a string or in components.
#
sub get_ltime(;$) {
  #my($val) = @_;
  my ($sec, $min, $hour, $day, $month, $year) = localtime((defined $_[0]) ? $_[0] : time());
  if (wantarray) {
    return (sprintf("%02d", $sec), sprintf("%02d", $min), sprintf("%02d", $hour), sprintf("%02d", $day),
      sprintf("%02d", $month + 1), sprintf("%04d", $year + 1900));
  } else {
    return sprintf("%02d.%02d.%04d %02d:%02d:%02d", $day, $month + 1, $year + 1900, $hour, $min, $sec);
  }
}


sub file_open($) {
  #my($fname) = @_;
  local *FH;
  open(FH, $_[0]) || return;
  return *FH;
}

sub file_autoflush($) {
  #my($fh) = @_;
  select((select($_[0]), $| = 1)[0]);
}

sub file_close($) {
  #my() = @_;
  CORE::close($_[0]);
}


sub dir_open($) {
  #my($dname) = @_;
  local *FH;
  opendir(FH, $_[0]) || return undef();
  return *FH;
}

sub get_exit_code() {
  #my() = @_;
  my($warn_cnt, $err_cnt) = (get_msg_counts())[2,3]; # get number of warnings, errors
  return (wantarray) ? ($err_cnt, $warn_cnt) : $err_cnt + $warn_cnt;
}

sub script_msg(;$$) {
  #my($stop_f, $script) = @_;
  if (!$_[0]) {
    set_msg_counts(0, 0, 0, 0, 0, 0); # initialize
  }
  return get_exit_code();
}

1;


#
# Bm_finalstat.pm - Final Statistics
#
# Marco Vieth, 04.04.2004
#
# 0.01  04.04.2004 taken from Mystat
# 0.011 22.07.2006 simplified
#
package Bm_finalstat;
  #$VERSION = '0.011';
  use strict;

######################################


sub new {
  my $class = shift;
  my $self = bless({}, $class);
  $self->_init(@_);
}

#($)
sub _init {
  my $self = shift;
  return $self;
}


#($$)
sub set_val {
  my($self, $key, $value) = @_;
  $self->{$key} = $value;
  return 1;
}

#($$)
sub add_val {
  my($self, $key, $value) = @_;
  $self->{$key} += $value;
  return 1;
}


#($)
sub get_val {
  my($self, $key) = @_;
  return $self->{$key};
}


#()
sub print_all {
  my($self) = @_;
  foreach my $i (sort keys %$self) {
    print "$i: $self->{$i}\n";
  }
}

1;

__END__
