//: BGI.H -- class to "wrap" around Borland Graphics Interface
// Taken from Bruche Eckel: C++ Inside & Out, Osborne McGraw-Hill 1993
// 31.12.1994
//

#ifndef BGI_H_
#define BGI_H_

#include <graphics.h>

class Graphics {
  static int gdriver;
  static int gmode;
  static int errorcode;
  static int X_max;	// maximum graphics screen coordinates
  static int Y_max;
  static int X_win;
  static int Y_win;
public:
  static COLORS maxcolor;
  // default: request auto detection
  Graphics(char *path = "", graphics_drivers gdriv = DETECT);
  ~Graphics() { close(); }
  static void on();
  static void off();
  static void close() { closegraph(); }
  static int xmax() { return X_max; }
  static int ymax() { return Y_max; }
  // Text output in graphics mode on the bottom line:
  static void bottomprompt(char *prompt);
  //
  static void window(int x_width, int y_width);
  static void clearwindow();
  static void move(const double x, const double y) {
    moveto(x * X_win, Y_win - (y * Y_win)); }
  static void draw(const double x, const double y) {
    lineto(x * X_win, Y_win - (y * Y_win)); }
  static void plot(const double x, const double y) {
    line(x * X_win, Y_win - (y * Y_win), x * X_win, Y_win - (y * Y_win)); }
  static void circle(const double x, const double y, const double r) {
    ellipse(x * X_win, Y_win - (y * Y_win), 0, 360, r*X_win, r*Y_win); }
};

#endif	// BGI_H_
