//: KOHONEN.CPP - Kohonen's Algorithm
// 31.12.1994
//

#include <iostream.h>
#include <conio.h>	// kbhit()
#include <stdlib.h>	// random
#include <math.h>	// sqrt

#include "k_matrix.h"
#include "k_fmap.h"
#include "bgi.h"


// BGI initialization: see main()


void g_menu(featuremap& fm, int ani_flg) {
  Graphics::on();

  char ch = 'C';
  do {
    Graphics::bottomprompt("");
    if (ch != 'P') {
      if (ani_flg) { fm.simulate(); }
      else {
	fm.simulate(1);
      }
    }
    Graphics::bottomprompt("Press return to end, a,s,c) to continue, p) print"
      "Postscript");
    ch = getch();
    if ((ch >= 'a') && (ch <= 'z')) ch -= 'a' - 'A';
    if (ch == 'P') {
      fm.ps_print();
    }
  } while ((ch == 'C') || (ch == 'P') || (ch == 'A') || (ch == 'S'));
  Graphics::off();
}


void main_menu() {
  const int x1_neurons = 10;
  const int x2_neurons = 10;
  const invec = 2;	// # components in the input vector (always 2 for setup!)

  featuremap fm(invec, x1_neurons, x2_neurons);
  cout <<
    "Kohonen -- Kohonen's Algorithm to simulate a Self Organizing Map\n"
    << "Marco Vieth, 2.1.1995";

  char select;
  do {
    cout << "\n\n";
    fm.print_state();
    cout << "A)nimate, S)tep, I)nitialize, N)ew mapsize, D)isplay options, P)arameters,\n"
     "R)egion for Input, Q)uit\n\n";
    cout << "Your choice: ";
    cin >> select;
    cin.get();
    cout << endl << endl;

    if ((select >= 'a') && (select <= 'z')) select -= 'a' - 'A';
    switch(select) {
      case 'A' :
	cout << "animate\n";
	g_menu(fm, 1);
      break;

      case 'S' :
	cout << "step\n";
	g_menu(fm, 0);
      break;

      case 'I' :
	cout << "initialize map\n";
	fm.init_map();
      break;

      case 'N' :
	cout << "new map\n";
	fm.resize_map();
      break;

      case 'D' :
	cout << "change display options\n";
	fm.displ_options();
      break;

      case 'P' :
	cout << "change simulation parameters\n";
	fm.parameters();
      break;

      case 'R' :
	cout << "specify input region/pattern\n";
	fm.inp_option();
      break;

      case 'Q' :	// end
      break;

      default :
	cout << "only what you see.\n";
      break;
    }
  } while (select != 'Q');
  cout << "Bye." << endl;
}


int main() {
  Graphics BGI("c:\\borlandc\\bgi\\");	// path with BGI files
  Graphics::off();
  randomize();
  main_menu();
  return(0);
}
//end
