//: K_FMAP.H -- Kohonens Feature Map class
//. 2.1.1995
//

#ifndef K_FMAP_H_
#define K_FMAP_H_


class featuremap : matrix {

  enum shapes { RECTANGLE, TRIANGLE, CIRCLE, L_SHAPE };
  enum ini_modes { RANDOM, GRID };

  matrix *f_map;
  int num_x1, num_x2;	// number of neurons in x1- and x2-direction
  double alpha;		// factor for adaption
  double alpha_dec;	// alpha decrease
  double alpha_min;	// minimum alpha, stop decreasing
  double sigma;		// factor for neighbourhood
  double sigma_dec;	// sigma decrease
  double sigma_min;	// minimum sigma
  long k_step;		// time step

  int shw_points;	// flag: show input vectors as points?
  int displ_adapt;	// # adaptions before display
  int x_width;  	// display window size
  int y_width;

  enum shapes inp_shape;
  double inp_s1;	// parameter for shape, e.g. radius for circle

  enum ini_modes ini_mode;  // init mode RANDOM or GRID
  double ini_distrib;	// init distribution parameter
  char print_file[12];	// Postscript output file

  void error(char *msg1, char *msg2 = "");
public:
  featuremap(int n_input, int n_x1, int n_x2);
/*
  scalar& val(int row, int col) {	// same as matrix::val()
    return matrix::val(row, col);
  }
*/
  void simulate(int steps = 32000);
	// simulate until keypressed or steps = 0
  void init_map();

  void displ_options(void);
  void parameters();
  void print_state();
  void inp_option();
  void resize_map();
  void ps_print();
private:
  // for simulate():
  void adapt(matrix& invec);
  void show();
  void init_parameter();

  // for inp_options() ...
  int input_yn(char *msg, int oldpara);
  double input_double(char *msg, const double oldpara,
    const double min, const double max);
};

#endif // K_FMAP_H_
