/* evcnt_feat_ix86.h - evcnt features of the ix86 */

/*
 * 19.01.2001 0.22 MV  adapted for AMD Athlon
 *
 */   

#ifndef _EVCNT_FEAT_H
#define _EVCNT_FEAT_H

#include <linux/ioctl.h>        /* _IOR, _IOW */

#define FEATURE_OFFSET 50

/* some additional commands: */
#define EV_GETTSC	_IOW(EVCNT_MAJOR, FEATURE_OFFSET + 0, hint)
#define EV_GETFEATURE	_IOW(EVCNT_MAJOR, FEATURE_OFFSET + 1, hint)
#define EV_SETFEATURE	_IOW(EVCNT_MAJOR, FEATURE_OFFSET + 2, hint)


/* feature bits */
#if defined(I586_EVCNT) || defined(I586MMX_EVCNT)
#define EV_FEA_BTB_DI 0x01	/* TR12: disable BTB (branch target buffer) */
#define EV_FEA_VPIPE_DI 0x04	/* TR12: disable V-pipeline */
#define EV_FEA_L1_DI 0x08	/* TR12: disable L1 cache */
#endif  /* I586_EVCNT */


/* additional (secret) commands */
#if defined(I586_EVCNT) || defined(I586MMX_EVCNT)
#define EVCNT_MSR_NUM 0x13	/* number of MSRs */
#endif  /* I586_EVCNT */

#if defined(I686_EVCNT) || defined(I686MMX_EVCNT)
#define EVCNT_MSR_NUM 0x188 /* number of MSRs (last used+1) */
#endif  /* I686_EVCNT */

#if defined(ATHLON_EVCNT)
#define EVCNT_MSR_NUM 0xc0010008 /* number of MSRs (last used+1) */
#endif  /* ATHLON_EVCNT */


#define EV_GETMSR	_IOWR(EVCNT_MAJOR, FEATURE_OFFSET + 3, hint[2])
#define EV_SETMSR	_IOWR(EVCNT_MAJOR, FEATURE_OFFSET + 4, hint[2])	


#endif /* _EVCNT_FEAT_H */
/* end */
