/* evcnt.h - event counter device for i586, i686, Athlon under Linux */

/*
 * 19.01.2001 0.22 MV  adapted for AMD Athlon
 *
 */

#ifndef _EVCNT_H
#define _EVCNT_H

#include <linux/ioctl.h>        /* _IOR, _IOW */

/* hint = huge int */
typedef struct { 
  unsigned long lo;	/* bit 0..31 */
  unsigned long hi;	/* bit 32..63 */
} hint;       

#define EV_VER_I586 3
#define EV_VER_I586MMX 4
#define EV_VER_I686 5
#define EV_VER_I686MMX 6
#define EV_VER_ATHLON 7

#define EVCNT_CYCNT	/* with cycle counter */

#ifdef EVCNT_CYCNT
#define EVCNT_CNUM 3    /* number of counters (hint elements) */
#else
#define EVCNT_CNUM 2
#endif /* EVCNT_CYCNT */

#define EVCNT_NAME "evcnt"
#define EVCNT_DEVICE "/dev/" EVCNT_NAME  /* define not used by the driver */

#define EVCNT_MAJOR 63	/* major number 0 -> use highest possible */
#define EVCNT_MINOR 0	/* minor number of simple evcnt device */


#define EV_GETCNTS	_IOW(EVCNT_MAJOR, 0, hint[2])
#define EV_SETCNTS	_IOR(EVCNT_MAJOR, 1, hint[2])
#define EV_SETMODE	_IOR(EVCNT_MAJOR, 2, hint[2])
#define EV_VERSION	_IOR(EVCNT_MAJOR, 3, int)

/* and some additional commands for in evcnt_feat_i.h ... */

#endif /* _EVCNT_H */
/* end */
