/* msr_ix86.h - Model Specific Registers of the ix86 */

/*
 * 19.01.2001 0.22 MV  adapted for AMD Athlon
 *
 */

#ifndef _MSR_IX86_H
#define _MSR_IX86_H

/* Internal defines, macros for the device driver */

#if defined(I586_EVCNT) || defined(I586MMX_EVCNT)
/* machine-specific register for i585 */
#define MSR_FEATURE_R 0x0e
#define MSR_EVCTL_R 0x11
#define MSR_CNT0_R 0x12 
#define MSR_CNT1_R 0x13

#define EVCTL_ES0 0x3f		/* event selection counter 0 (b0..5) */
#define EVCTL_CPL0 0xc0		/* CPL selection counter 0 (b6, b7) */
#define EVCTL_TYPE0 0x100 	/* type control counter 0 (b8) */
#define EVCTL_PC0 0x200		/* pin control counter 0 (b9) */

#define EVCTL_ES1 0x3f0000	/* event selection counter   (b16..21) */
#define EVCTL_CPL1 0xc00000	/* CPL selection counter 1 (b22, b23) */
#define EVCTL_TYPE1 0x1000000	/* type control counter 1 (b24) */
#define EVCTL_PC1 0x2000000	/* pin control counter 1 (b25) */

#endif	/* I586_EVCNT */


#if defined(I686_EVCNT) || defined(I686MMX_EVCNT)
/* machine-specific register */
/* #define MSR_FEATURE_R 0x0e */
#define MSR_EVCTL0_R 0x186	/* EVNTSEL0 */
#define MSR_EVCTL1_R 0x187      /* EVNTSEL1 */
#define MSR_CNT0_R 0xc1 	/* PERFCTR0 */
#define MSR_CNT1_R 0xc2         /* PERFCTR1 */

#define EVCTL_ES          0xff	/* event selection (b0..b7) */
#define EVCTL_US        0xff00	/* user mask (b8..b15) */
#define EVCTL_CPL      0x30000	/* user/OS selection (b16, b17) */
#define EVCTL_TYPE     0x40000 	/* type control (b18), 1=event */
#define EVCTL_PC       0x80000	/* pin control (b19) */
#define EVCTL_INT     0x100000	/* int (b20) */
#define EVCTL_EI      0x400000	/* enable (cnt 0 for both cnts) (b22) */
#define EVCTL_INV     0x800000	/* invert (b23) */
#define EVCTL_CMASK 0xff000000	/* compare mask (b24..b31) */

#endif	/* I686_EVCNT */


#if defined(ATHLON_EVCNT)
/* machine-specific register */
/* Note that the Athlon supports 4 performance counters!
 * Due to limitations of the library interface only 2
 * of them are currently supported.
 */
/* #define MSR_FEATURE_R 0x0e */
#define MSR_EVCTL0_R 0xc0010000 /* EVNTSEL0 */
#define MSR_EVCTL1_R 0xc0010001 /* EVNTSEL1 */
#define MSR_EVCTL2_R 0xc0010002 /* EVNTSEL2 */
#define MSR_EVCTL3_R 0xc0010003 /* EVNTSEL3 */

#define MSR_CNT0_R 0xc0010004   /* PERFCTR0 */
#define MSR_CNT1_R 0xc0010005   /* PERFCTR1 */
#define MSR_CNT2_R 0xc0010006   /* PERFCTR2 */
#define MSR_CNT3_R 0xc0010007   /* PERFCTR3 */

/* (nearly) same as with i686, see b22 */ 
#define EVCTL_ES          0xff  /* event selection (b0..b7) */
#define EVCTL_US        0xff00  /* user mask (b8..b15) */
#define EVCTL_CPL      0x30000  /* user/OS selection (b16, b17) */
#define EVCTL_TYPE     0x40000  /* type control (b18), 1=event */
#define EVCTL_PC       0x80000  /* pin control (b19) */
#define EVCTL_INT     0x100000  /* int (b20) */
#define EVCTL_EI      0x400000  /* enable (cnt 0 for THIS counter) (b22) */
#define EVCTL_INV     0x800000  /* invert (b23) */
#define EVCTL_CMASK 0xff000000  /* compare mask (b24..b31) */
 
#endif  /* ATHLON_EVCNT */



/* general for all ix86, Athlon */

#define RDTSC ".byte 0x0f, 0x31\n\t"	/* read timestamp counter (instr) */
#define RDMSR ".byte 0x0f, 0x32\n\t"	/* read machine-specific register (instr) */
#define WRMSR ".byte 0x0f, 0x30\n\t"	/* write machine-specific register (instr) */


/*
 * read time stamp counter (unsigned long lo, unsigned long hi)
 * in:  -
 * out: eax -> lo, edx -> hi
 * All parameter may be registers.
 */
#define read_tsc(lo, hi) \
  __asm__ volatile ( \
      RDTSC \
      "movl %%eax,%0\n\t"  \
      "movl %%edx,%1\n\t" : "=r" (lo), "=r" (hi) : : "ax", "dx" \
  )

/*
 * In /usr/src/linux/arch/i386/kernel/time.c they do the following:
 *   static unsigned long long init_timer_cc = 0;
 *   __asm__(".byte 0x0f,0x31"
 *     :"=a" (((unsigned long *) &init_timer_cc)[0]),
 *      "=d" (((unsigned long *) &init_timer_cc)[1]));
 */


/*
 * read machine specific register (unsigned long lo, unsigned long hi, index)
 * in:  index -> ecx
 * out: eax -> lo, edx -> hi
 * All parameter may be registers.
 */
#define read_msr(lo, hi, rnum) \
  __asm__ volatile ( \
      "movl %2,%%ecx\n\t" \
      RDMSR \
      "movl %%eax,%0\n\t" \
      "movl %%edx,%1\n\t" : "=r" (lo), "=r" (hi) : "ir" (rnum) : "ax", "cx", "dx" \
  )


/*
 * write machine specific register (unsigned long lo, unsigned long hi, index)
 * in:  index -> ecx, lo -> eax, hi -> edx
 * out: eax -> lo, edx -> hi
 * All parameter may be registers. ???
 */
#define write_msr(lo, hi, rnum) \
  __asm__ volatile ( \
      "movl %2,%%ecx\n\t" \
      "movl %0,%%eax\n\t" \
      "movl %1,%%edx\n\t" \
      WRMSR : : "r" (lo), "r" (hi),"ir" (rnum) : "ax", "cx", "dx" \
  )



#endif /* _MSR_IX86_H */
/* end */
