/* prf.h */

#ifndef _PRF_H
#define _PRF_H

#include "evcnt_ix86.h" /* for compatibility with simple evcnt */

#include "linux/param.h"		/* NCPU */

#include "../../../include/general.h"	/* ad_t */

#ifndef NCPU
#define NCPU 24  /* or use NR_CPUS from /usr/include/linux/tasks.h */
#endif

#define WITH_CMDSTR     /* with command string */


#define PRF_NCPU NCPU
#define PRF_NAME "evcnt1"
#define PRF_DEVICE "/dev/"PRF_NAME  /* define not used by the driver */

#define PRF_MAJOR EVCNT_MAJOR  /* major number 0 -> use highest possible */
#define PRF_MINOR 1

#define PRF_P_CNT_NUM EVCNT_CNUM  /* number of physical event counters */



#ifdef WITH_CMDSTR
#define PRF_CMDLEN 16
#endif

struct prfctr_s {
  ad_t vaddr;		/* virtual address (32 or 64 bit) */
  unsigned ev_cnt[PRF_P_CNT_NUM];	/* event counter 0,1 */
  int pid;			/* PID, 0=kernel address */
  int ppid;			/* parent PID */
  unsigned ticks;		/* time in HZ since last boot */
  int cpu;			/* CPU number */

  int sample_pos;
#ifdef WITH_CMDSTR
  char cmdstr[PRF_CMDLEN];      /* test !! */
#endif
};

struct prf_mode_s {
  unsigned ev_mode[2];    /* event mode */
};

/* prfstat bits */
#define PRF_ON	1	/* profiler collecting samples (do not change value!) */
#define PRF_ALLOC 2	/* memory allocated (initialized) */
#define PRF_EVWRITE 4	/* event sampling active */
#define PRF_RESULT 8	/* counter block can be read */
#define PRF_OFLOW 16	/* buffer overflow */

/* ioctl commands */
#define PRF_GETCNTS EV_GETCNTS	/* evcnt function */
#define PRF_SETCNTS EV_SETCNTS	/* evcnt function */
#define PRF_SETMODE EV_SETMODE	/* evcnt function */
#define PRF_VERSION EV_VERSION
#define PRF_INIT 4
#define PRF_FREE 5
#define PRF_RD_STATE 6
#define PRF_RD_BUFNUM 7
#define PRF_IO_MCONTROL 8
#define PRF_RD_IDX 9
#define PRF_RD_CPUCNT 10
#define PRF_RESET 11
#define PRF_SET_RDCPU 12
#define PRF_SET_EVENTS 13
#define PRF_SET_PID 14


#endif /* _PRF_H */
/* end */
