/* cm_lib_i586_evcnt.h */
/* machine depending defines for evcnt device library */


#ifndef CM_LIB_I586_EVCNT_H_
#define CM_LIB_I586_EVCNT_H_ 

#ifdef LINUX
#include "../driver/linux/ix86/evcnt_ix86.h"
#endif
#ifdef SOLARIS
#include "../driver/solaris/ix86/evcnt_ix86.h"
#endif

/* general parameters */
#define CM_TYPE CM_T_I586	/* defined in cm_lib.h */
#define CM_VERSION 0		/* version of CPU monitor library */
#define CM_P_CNT_NUM EVCNT_CNUM	/* number of physical counters */
#define CM_EVENT_NUM 0x2b	/* number of events */
#define CM_P_CNT_BITS 40 	/* physical counter bits */
#define CM_USER_MODE_F 3	/* special user mode measurement */

#define CM_NEED_SETCNTS0	/* need to use 0 to init with EV_SETCNTS */
/* #define CM_SETEV_RESET */	/* SET_EVENT resets the counters with 0 */

/* user mode parameters */
#define CPL2_RANGE 0x01
#define USER_RANGE 0x02	/* CPL3 */
/* #define ALL_RANGE (USER_RANGE | CPL2_RANGE) */


#define CM_GET_RANGE(mask) \
  ((mask & 0x02) ? USER_RANGE : 0) | \
  ((mask & 0x01) ? CPL2_RANGE : 0)


/* get counter, for which event is possible; return cnt, if all possible */
#define CM_GET_CNT(event, cnt) ((event < 0x2a) ? (cnt & 1) : 2) /* <cnt */

/* get mode (counter group) the event belongs to; return 0, if no modes. */
#define CM_GET_MODE(event) 0


/* event texts, CM_EVENT_NUM different */
#define CM_EVENT_TXT \
    "ld", "st", "dTLBmiss", "pdcm_ld", "pdcm_st", "ME_wr", \
    "dcl_wbk", "dc_sno", "dc_sno_hit", "mem_conf", "bank_conf", \
    "data_misa", "code_rd", "cTLBmiss", "picm", "seg_ld", "seg_c", \
    "seg_c_hit", "branch", "BTBhit", "branch_tkn", "pipe_flu", \
    "inst", "inst_v", "bus_wait", "wrt_s", "dta_rd_s", \
    "ME_wr_s", "bus_lock", "IO_rdwr", "nonc_rd", "AGI_s", \
    "", "", "float", "brk_0", "brk_1", "brk_2", "brk_3", \
    "hard_int", "ldst", "pdcm", "cycles"


/* event descriptions */
#define CM_EVENT_DESCR \
    "load (Data Read)", \
    "store (Data Write)", \
    "data TLB miss (Data TLB Miss)", \
    "primary data cache miss during load (Data Read Miss)", \
    "primary data cache miss during store (Data Write Miss)", \
    "modified or exclusive write (Write (hit) to M or E state lines)", \
    "data cache lines written back (Data Cache Lines Written Back)", \
    "data cache snoops (External Data Cache Snoops)", \
    "data cache snoop hits (External Data Cache Snoop Hits)", \
    "memory conflicts (Memory Accesses in Both Pipes)", \
    "bank conflicts (Bank Conflicts)", \
    "data misaligned (Misaligned Data Memory or I/O References)", \
    "code read (Code Read)", \
    "code TLB miss (Code TLB Miss)", \
    "primary instruction cache miss (Code Cache Miss)", \
    "segment register load (Any Segment Register Loaded)", \
    "segment cache (Segment Descriptor Cache Access; undocumented)", \
    "segment cache hits (Segment Descriptor Cache Hits; undocumented)", \
    "branches (Branches)", \
    "BTB hits (Branch Target Buffer predictions)", \
    "branch taken (Taken Branch or BTB hit)", \
    "pipeline flushes (Pipeline Flushes)", \
    "instructions (Instructions Executed)", \
    "instructions V (Instructions Executed in the V-pipe)", \
    "bus wait (Clocks while a bus cycle is in progress; bus utilisation)", \
    "write stall (Number of clocks stalled due to full write buffers)", \
    "data read stall (Pipeline stalled waiting for data memory read)", \
    "modified exclusive write stall (Stall on write to an E or M state line)", \
    "bus locked (Locked Bus Cycles; undocumented)", \
    "I/O read write (I/O Read or Write Cycle)", \
    "non-cacheable reads (Non-cacheable memory reads)", \
    "AGI stalls (Pipeline stalled because of an address generation interlock)", \
    "(Reserved)", \
    "(Reserved)", \
    "floating-point operations (FLOPs)", \
    "breakpoint 0 match (Breakpoint match on DR0 Register)", \
    "breakpoint 1 match (Breakpoint match on DR1 Register)", \
    "breakpoint 2 match (Breakpoint match on DR2 Register)", \
    "breakpoint 3 match (Breakpoint match on DR3 Register)", \
    "hardware interrupts (Hardware Interrupts)", \
    "load store (Data Read or Data Write)", \
    "primary data chache misses (Data Read Miss or Data Write Miss)", \
    "cycles (Clock cycles; cycles from time stamp counter)"


#define CM_I586_TYPE_TICKS 0

/* Convert sample (event numbers) to coded mode value for the device driver */
/* In: ev0 = event number 0, ev1 = event number 1, range_flg = ALL_RANGE,... */
/* Out: ev0 = mode value 0, ev1 = mode value 1 */
#define CM_SAMPLE2MODE \
  ev0 = ev0 | ((CM_I586_TYPE_TICKS << 2) | range_flg) << 16; \
  ev1 = ev1 | ((CM_I586_TYPE_TICKS << 2) | range_flg) << 16;


#endif /* CM_LIB_I586_EVCNT_H_ */
/* end */
