/* cm_lib_pa1_evcnt.h */
/* machine depending defines for evcnt device library */


#ifndef CM_LIB_PA1_EVCNT_H_
#define CM_LIB_PA1_EVCNT_H_ 

#include "../driver/hpux/pa1/evcnt_pa1.h"

/* general parameters */
#define CM_TYPE CM_T_PA1	/* defined in cm_lib.h */
#define CM_VERSION 0		/* version of CPU monitor library */
#define CM_P_CNT_NUM EVCNT_CNUM	/* number of physical counters */
#define CM_EVENT_NUM 0x0	/* number of events */
#define CM_P_CNT_BITS 32 	/* physical counter bits */
#define CM_USER_MODE_F 1	/* special user mode measurement */

/* #define CM_NEED_SETCNTS0 */	/* need to use 0 to init with EV_SETCNTS */
/* #define CM_SETEV_RESET */	/* SET_EVENT resets the counters with 0 */

/* user mode parameters */
#define USER_RANGE 0x01

#define CM_GET_RANGE(mask) \
  ((mask & 0x01) ? USER_RANGE : 0)


/* get counter, for which event is possible; return cnt, if all possible */
#define CM_GET_CNT(event, cnt) (cnt) /* <cnt */

/* get mode (counter group) the event belongs to; return 0, if no modes. */
#define CM_GET_MODE(event) 0


/* event texts, CM_EVENT_NUM different */
#define CM_EVENT_TXT \
    "nothing"

/* event descriptions */
#define CM_EVENT_DESCR \
    "nothing" 



/* Convert sample (event numbers) to coded mode value for the device driver */
/* In: ev0 = event number 0, ev1 = event number 1, range_flg = ALL_RANGE,... */
/* Out: ev0 = mode value 0, ev1 = mode value 1 */
#define CM_SAMPLE2MODE \
  ev0 = ev0; \
  ev1 = ev1;


#endif /* CM_LIB_PA1_EVCNT_H_ */
/* end */
