
/* general.h
 * general prototypes & defines
 * MV, 1.10.1996
 */

#ifndef GENERAL_H_
#define GENERAL_H_ 

/* #define MY_ASSERT */  /* assertions for program developement */
/* To speed it up after a testing phase, you can undefine this. */

#define USE_CM_LIB	/* use cm_lib */


#ifndef OK
typedef int ErrCode;
#define OK 0
#define ERROR 1
typedef char * ad_t;	/* same as addr_t in <sys/types.h> */
#endif	/* ifndef OK */

#define MAX_ADDR (size_t)0xffffffffU    /* maybe change to 64 bit constant! */
/* the following macro allows printf of 32 or 64 bit addresses */
#define PRINTF_ADDR(addr) \
  ((sizeof(ad_t) == 4) ? "%0*x" : "%0*llx"), sizeof(ad_t) * 2, ((sizeof(ad_t) == 4) ? ((size_t)(addr)) : (size_t)(addr))


/* Some architecture dependend defines are following ... */

/* 
 * Possible defines are:
 * TIME_CORRECT_10	10ms timer correction (for SINIX)
 * MIPS_MCONTEXT	use mcontext for MIPS (for SINIX)
 * USE_ELF		allow ELF binaries in stab.c (otherwise only ASCII mode)
 * USE_MON		allow mon.h in cm_prof
 * WITH_PROFIL		with profil() (only tools), if available on the system
 * PROFIL_TRICK		SINIX needs a profil trick for reliable itimer signals
 * SIM_GETCOUNTER	simulate getcounter (from SINIX) by gettimeofday
 * WITH_PENTIUM_TSC	use Time Stap Counter from Pentium (with SIM_GETC...)
 * MALLOC_SIMULATE0	allows malloc(0) on some systems (AIX) (memutil)
 *
 * GETTIMEOFDAY		some systems expect a second timezone parameter
 * TIMES_NO_TOTAL	BSD systems return no total ticks from times().
 *			Use gettimeofday instead.
 *
 * SIGHAND_PARA		Signal handler parameter.
 * UCONTEXT_GET_PC	defines how to get the PC from the ucontext structure
 *			(undefined = impossible)
 * UCONTEXT_INCLUDE	Include file to get SIGHAND_PARA
 * PTRACE_INCLUDE	Include to get register names for ptrace
 * PTRACE		ptrace system call (AIX, HPUX need additional parameter)
 * PTRACE_REQ_TRACEME	request: trace me (says the child) (0)
 * PTRACE_REQ_CONTINUE  request: continue (says the parent) (7)
 * PTRACE_REQ_RD_USER	request: read user context (3)
 * PTRACE_PC		parameter to get the PC from user context
 *
 * NM_COMMAND		nm command with options to read the symbol table of
 *			a program <hex addr> <type char> <name>, if no
 *			libelf exists.
 * WITH_CUR_MENU	With curses menu (AIX, HPUX have none).
 *
 */

#ifdef SINIX
  #define TIME_CORRECT_10
  #define MIPS_MCONTEXT
  #define USE_ELF
  #define USE_MON
  #define WITH_PROFIL
  #define PROFIL_TRICK
  #define GETTIMEOFDAY(tp) gettimeofday(tp, NULL)
  #define SIGHAND_PARA int sig_num, void *sig_info, struct ucontext *uc
  #define UCONTEXT_GET_PC (ad_t)uc->uc_mcontext.gpregs[CXT_EPC]
  #define UCONTEXT_INCLUDE <ucontext.h>
  #define PTRACE ptrace
  #define PTRACE_REQ_TRACEME PT_TRACE_ME
  #define PTRACE_REQ_CONTINUE PT_CONTINUE
  #define PTRACE_REQ_RD_USER PT_READ_U
  #define PTRACE_PC PC
  #define NM_COMMAND "nm -x -p -h"
  #define WITH_CUR_MENU
#endif /* SINIX */


#ifdef LINUX
  #define SIM_GETCOUNTER
  /* #define WITH_PENTIUM_TSC */
  #define GETTIMEOFDAY(tp) gettimeofday(tp, NULL)
  #define SIGHAND_PARA int sig_num
  #define PTRACE ptrace
  #define PTRACE_REQ_TRACEME PTRACE_TRACEME
  #define PTRACE_REQ_CONTINUE PTRACE_CONT
  #ifdef PTRACE_PEEKUSR
    #define PTRACE_REQ_RD_USER PTRACE_PEEKUSR
  #else	/* gnulibc 2.7.2.3 */
    #define PTRACE_REQ_RD_USER PTRACE_PEEKUSER
  #endif
  #define PTRACE_PC (EIP * 4)
  #define NM_COMMAND "nm"
  #define WITH_CUR_MENU
#endif /* LINUX */


#ifdef SOLARIS	/* Solaris 2.6 = SunOS 5.6 */
  #define SIM_GETCOUNTER
  #define USE_ELF
  #define USE_MON
  #define WITH_PROFIL
  #define GETTIMEOFDAY(tp) gettimeofday(tp, NULL)
  #define SIGHAND_PARA int sig_num, void *sig_info, struct ucontext *uc 
/*  #define UCONTEXT_GET_PC (ad_t)uc->uc_mcontext.gregs[REG_PC] */  /* SunOS 5.5 */
  #define UCONTEXT_GET_PC (ad_t)uc->uc_mcontext.gregs[PC]  /* Solaris 2.6 */
  #define UCONTEXT_INCLUDE <ucontext.h>
  #define PTRACE ptrace
  #define PTRACE_REQ_TRACEME PTRACE_TRACEME
  #define PTRACE_REQ_CONTINUE PTRACE_CONT
  #define PTRACE_REQ_RD_USER PTRACE_PEEKUSER
  /* #define PTRACE_PC (REG_PC * 4) */  /* SunOS 5.5 */
  #define PTRACE_PC (PC * 4)  /* Solaris 2.6 */
  #define NM_COMMAND "nm -x -p -h"
  #define WITH_CUR_MENU
#endif /* SOLARIS */


#ifdef AIX
  #define SIM_GETCOUNTER
  #define MALLOC_SIMULATE0
  #define GETTIMEOFDAY(tp) gettimeofday(tp, NULL)
  #define SIGHAND_PARA int sig_num, int sig_code, struct sigcontext *sc
  #define UCONTEXT_GET_PC (ad_t)sc->sc_jmpbuf.jmp_context.iar
  #define UCONTEXT_INCLUDE <signal.h>
  #define PTRACE_INCLUDE <sys/reg.h>
  #define PTRACE(req, pid, addr, data) ptrace(req, pid, (int *)addr, data, 0)
  #define PTRACE_REQ_TRACEME PT_TRACE_ME
  #define PTRACE_REQ_CONTINUE PT_CONTINUE
  #define PTRACE_REQ_RD_USER PT_READ_GPR
  #define PTRACE_PC IAR
  #define NM_COMMAND "nm -x -B -e -h"
#endif	/* AIX */


#ifdef IRIX	/* SGI IRIX 6.2 */
  #define SIM_GETCOUNTER
  #define USE_ELF
  #define USE_MON
  #define WITH_PROFIL
  #define GETTIMEOFDAY(tp) gettimeofday(tp, NULL)
  #define SIGHAND_PARA int sig_num, void *sig_info, struct ucontext *uc 
  #define UCONTEXT_GET_PC (ad_t)uc->uc_mcontext.gregs[CTX_EPC]
  #define UCONTEXT_INCLUDE <ucontext.h>
  #define PTRACE ptrace
  #define PTRACE_REQ_TRACEME PTRC_SELFTRACE
  #define PTRACE_REQ_CONTINUE PTRC_CONTINUE
  #define PTRACE_REQ_RD_USER PTRC_RD_REG
  #define PTRACE_PC (PC * 4)
  #define NM_COMMAND "nm -x -p -h"
  #define WITH_CUR_MENU
#endif /* SOLARIS */

#ifdef BSD /* SunOS4.1.3 */
  #define SIM_GETCOUNTER
  #define USE_MON
  #define WITH_PROFIL
  #define GETTIMEOFDAY(tp) gettimeofday(tp, NULL)
  #define TIMES_NO_TOTAL
  #define SIGHAND_PARA int sig_num, void *sig_info, struct sigcontext *sc 
  #define UCONTEXT_GET_PC (ad_t)sc->sc_pc
  #define UCONTEXT_INCLUDE <signal.h>
  #define PTRACE_INCLUDE <machine/reg.h>
  #define PTRACE ptrace
  #define PTRACE_REQ_TRACEME PTRACE_TRACEME
  #define PTRACE_REQ_CONTINUE PTRACE_CONT
  #define PTRACE_REQ_RD_USER PTRACE_PEEKUSER
  #define PTRACE_PC (PC)
  #define NM_COMMAND "nm"
  #define WITH_CUR_MENU

  #define SA_RESTART 0    /* define this as unused for BSD */
  extern char *optarg;  /* SunOS4.3 (BSD) needs this */

  #include <sys/stdtypes.h>	/* size_t */
  typedef size_t ssize_t;
  extern int optind;
#endif	/* BSD */

#ifdef HPUX /* */
  #define SIM_GETCOUNTER
  /* #define USE_ELF no ELF library */
  #define USE_MON
  #define WITH_PROFIL
  #define GETTIMEOFDAY(tp) gettimeofday(tp, NULL)
  #define SIGHAND_PARA int sig_num, void *sig_info, struct sigcontext *sc
  #define UCONTEXT_GET_PC sc->sc_ctxt.sx.sl_uc.uc_mcontext.ss_narrow.ss_rp  /* sc->sc_rp */
    /* (ad_t)uc->uc_mcontext.gregs[REG_PC] */
    /* (ad_t)sc->sc_pc */
  #define UCONTEXT_INCLUDE <signal.h>
  #define PTRACE_INCLUDE <sys/reg.h>
  #define PTRACE(req, pid, addr, data) ptrace(req, pid, addr, data, 0)
  #define PTRACE_REQ_TRACEME PT_SETTRC
  #define PTRACE_REQ_CONTINUE PT_CONTIN
  #define PTRACE_REQ_RD_USER PT_RUREGS
  #define PTRACE_PC (31 * 4) /* still not correct! */
  /* offset in struct save_state_t (<machine/save_state.h>) */
  #define NM_COMMAND "nm -x -p -h"
  /* #define WITH_CUR_MENU HPUX has none */

#endif  /* HPUX */


#endif	/* GENERAL_H_ */
/* end */
