/* plg_lib.h */

#ifndef PLG_LIB_H_
#define PLG_LIB_H_ 

#include "general.h"

#ifdef R4K_EVCNT
#include "../driver/sinix/rxk_prf/prf_rxk.h"	/* test! */
#endif /* R4K_EVCNT */

#ifdef R10K_EVCNT
#include "../driver/sinix/rxk_prf/prf_rxk.h"
#endif /* R10K_EVCNT */

#ifdef LINUX
#ifdef I586_EVCNT
#include "../driver/linux/ix86/prf_ix86.h"
#endif /* I586_EVCNT */

#ifdef I586MMX_EVCNT
#include "../driver/linux/ix86/prf_ix86.h"
#endif /* I586MMX_EVCNT */

#ifdef I686_EVCNT
#include "../driver/linux/ix86/prf_ix86.h"
#endif /* I686_EVCNT */

#ifdef I686MMX_EVCNT
#include "../driver/linux/ix86/prf_ix86.h"
#endif /* I686MMX_EVCNT */

#ifdef ATHLON_EVCNT
#include "../driver/linux/ix86/prf_ix86.h"
#endif /* ATHLON_EVCNT */

#endif	/* LINUX */

#ifdef SOLARIS
#ifdef I586_EVCNT
#include "../driver/solaris/ix86/prf_ix86.h"
#endif /* I586_EVCNT */

#ifdef I586MMX_EVCNT
#include "../driver/solaris/ix86/prf_ix86.h"
#endif /* I586MMX_EVCNT */

#ifdef I686_EVCNT
#include "../driver/solaris/ix86/prf_ix86.h"
#endif /* I686_EVCNT */

#ifdef I686MMX_EVCNT
#include "../driver/solaris/ix86/prf_ix86.h"
#endif /* I686MMX_EVCNT */
#endif	/* SOLARIS */


#ifdef PPC604_EVCNT
#include "../driver/aix/ppc604/prf_ppc604.h"
#endif /* PPC604_EVCNT */

#ifdef PA1_EVCNT
#include "../driver/hpux/pa1/prf_pa1.h"
#endif /* PA1_EVCNT */




#define PLG_DEFAULT_MASK 255


typedef unsigned int plg_counter_t;

enum plgi_type_e {
  PLG_T_UNKNOWN, PLG_T_R4K, PLG_T_R10K, PLG_T_I586, PLG_T_I586MMX, 
  PLG_T_I686, PLG_T_I686MMX, PLG_T_PPC604
};


/* CPU monitor info structure */
struct plg_info_s {
  int type;		/* type of CPU monitor, 0=unknown, 1=R4K (cpum), */
    /* 2=R10K, 3=i586, 4=i586mmx, 5=i686, 6=i686mmx, 7=PowerPC604 */
  int version;		/* version number */
  int event_num;	/* number of events */
  int p_cnt_num;	/* number of physical counters */
  int p_cnt_bits;	/* physical counter bits */
  int user_mode_f;	/* set, if counters support user mode counting */
    /* in addition to system wide counting */
};


struct plg_lib_c {
  int fd;
  int col_pid;		/* PID >=0 to collect samples for, -1 = all */
  int event_num;	/* number of events in use */
  int *events;		/* event numbers */

  int sample_num;
  int *samples;
  struct prf_mode_s *pmd; /* event mode array (for all samples) */

  int cpu_num;		/* number of CPUs (reported from device */
};


extern ErrCode plg_get_info(struct plg_info_s *cmi);
extern char *plg_get_eventtxt(const int event);
extern char *plg_get_eventdescr(const int event);
extern ErrCode plg_test_cnt_event(const int p_cnt, const int event);

extern ErrCode plg_open(struct plg_lib_c *cml, const int event_num, const int *events, const int measure_mask, const int buf_num, const int col_pid, int *cpu_num);
extern ErrCode plg_get_sample_num(struct plg_lib_c *cml, int *sample_num);
extern ErrCode plg_get_sample(struct plg_lib_c *plgl, const int sample_pos, int *sample);
extern ErrCode plg_close(struct plg_lib_c *cml);
extern ErrCode plg_reset(struct plg_lib_c *cml);
extern ErrCode plg_start(struct plg_lib_c *cml);
extern ErrCode plg_stop(struct plg_lib_c *cml);
extern ErrCode plg_read_1log(struct plg_lib_c *cml, const int cpu, struct prfctr_s *buf, int *buf_num);
extern ErrCode plg_read_log(struct plg_lib_c *cml, struct prfctr_s *buf, int *buf_num);

#endif /* PLG_LIB_H_ */
/* end */
