/* util.h */

#ifndef UTIL_H_
#define UTIL_H_ 

#include "general.h"	/* ErrCode */

/* for SIGHAND_PARA */
#ifdef UCONTEXT_INCLUDE
#include UCONTEXT_INCLUDE
  /* if defined(AIX) || defined(BSD) || defined(HPUX) : <signal.h>
   * otherwise (SINIX, Solaris, IRIX): <ucontext.h>
   */ 
#endif


extern ErrCode util_check_stat(const char *fn1, const char *fn2);
extern int util_is_bigendian(void);
extern int util_conv_int(const int value);
extern double util_conv_double(const double dvalue);
extern ad_t util_conv_addr(const ad_t addr);
extern ErrCode util_get_uname(char **buf);
extern ErrCode util_init_t_time(void);
extern ErrCode util_get_times(double *u_time, double *s_time, double *t_time);
extern int util_get_timtype(int *signum);
extern ErrCode util_set_timtype(const int timtype);
extern ErrCode util_sigset_d(const int signum, void (*handler)(SIGHAND_PARA));
extern ErrCode util_sigset(void (*handler)(SIGHAND_PARA));
extern ErrCode util_sigign(void);
extern ErrCode util_setitim(const long rate_s_us);

#endif	/* UTIL_H_ */
/* end */
