;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;             CP/M for the PCW16              ;
; FID_D_MESS client - prints FID-supplied     ;
;            error messages                   ;
;                                             ;
; Copyright (c) John Elliott 1998             ;
; You may not redistribute this alpha-test    ;
; software                                    ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;
get_message:
;
;F = Carry set if OK, else error
;B = error message returned by the FID.
;
;Return A=0 and Carry set to Ignore, NC Z to retry, NC NZ to cancel.
;
	ret	c
	ld	(gmerr),a
	jr	z,cancl		;Enter with Z set for auto-cancel
	ld	a,(drive)
	add	a,'A'
	ld	(derrdv),a
	call	FID_D_MESS	;Return HL=address of message
	jr	nc,cancl
	call	strlen
	ld	a,50		;A = 50 - string length
	sub	e
	srl	a		;No. of packing spaces	
	push	de
	ld	de,derrmg
	call	fillsp
	pop	bc		;Copy the actual text
	ld	a,b
	or	c
	jr	z,nomsg
	ldir
nomsg:	ex	de,hl		;Pack the rest with spaces.
noms1:	ld	a,(hl)
	or	a
	jr	z,noms2
	ld	(hl),' '
	inc	hl
	jr	noms1	
;
noms2:	ld	hl,derrdlg
	ld	de,derre-derrdlg
	in	a,(0F1h)	;Assume we're in the 4000h-8000h range
	ld	c,a
	ld	a,os_alert
	call	ANNE
	or	a
	ret	z		;0 => Retry	
	dec	a
	scf			;1 => Ignore
	ret	z

cancl:	ld	a,1
	and	a		;NZ NC
	ld	a,(gmerr)
	ret
;	
gmerr:	defb	0	;Error returned by FID in A
;
fillsp:	or	a
	ret	z
	push	af
	ld	a,' ' 
	ld	(de),a
	inc	de
	pop	af
	dec	a
	jr	fillsp
;
strlen:	push	hl
	ld	e,0
	ld	b,50
strl1:	ld	a,(hl)
	or	a
	jr	z,strl2
	inc	a
	jr	z,strl2
	inc	e
	inc	hl
	djnz	strl1
strl2:	pop	hl
	ret
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Error on character device...
;
cerr:	ld	hl,cerrdlg
        ld	de,cerre-cerrdlg
        in	a,(0F1h)        ;Assume we're in the 4000h-8000h range
        ld	c,a
        ld	a,os_alert
        call	ANNE
	or	a
        ret	z               ;0 => Retry
	scf
	ret			;1 => Cancel	
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
derrdlg:
	defb	'Error on drive '
derrdv:	defb	'*:',0
derrmg:	defb    '1...5...10...15...20...25...30...35...40...45...50',0
	defb    0
        defb    3                       ;3 buttons.
        defb    0FBh, 80h               ;Green Tick
        defb     0Dh, 80h               ;CR
        defb    'r',  80h               ;R
        defb    ' ',  80h               ;SPACE
        defb    ' ',1Fh,'Retry ',0A5h,' ',0;"Retry"
        defb    0FAh,80h                ;Yellow
        defb    0F9h,80h                ;Blue
        defb    'i',80h
        defb    'i',80h
        defb    ' ',1Fh,'Ignore ',0     ;"Ignore"
        defb    0FCh,80h                ;Red cross
        defb    0FEh,80h                ;Stop
        defb    'c',80h                 ;C
        defb    'c',80h
        defb    ' ',1Fh,'Cancel ',0A4h,' ',0
derre:
;
cerrdlg:
        defb    'The device '
obstrp:	defb    'XYZZY '
	defb    ' is not responding. ',0
	defb	'To wait for it to respond, click Retry.',0
	defb	'To deactivate it, click Cancel.',0
        defb    0
        defb    2                       ;2 buttons.
        defb    0FBh, 80h               ;Green Tick
        defb     0Dh, 80h               ;CR
        defb    'r',  80h               ;R
        defb    ' ',  80h               ;SPACE
        defb    ' ',1Fh,'Retry ',0A5h,' ',0;"Retry"
        defb    0FCh,80h                ;Red cross
        defb    0FEh,80h                ;Stop
        defb    'c',80h                 ;C
        defb    'c',80h
        defb    ' ',1Fh,'Cancel ',0A4h,' ',0
cerre:
;



	END



