;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;             CP/M for the PCW16 - parallel port driver                       ;
;                                                                             ;
;   Copyright (C) 1998-1999, John Elliott <jce@seasip.demon.co.uk>            ;
;                 1998,      Trevor Gowen                                     ;
;                                                                             ;
;    This program is free software; you can redistribute it and/or modify     ;
;    it under the terms of the GNU Library General Public License as          ;
;    published by the Free Software Foundation; either version 2 of the       ;
;    License, or(at your option) any later version.                           ;
;                                                                             ;
;    This program is distributed in the hope that it will be useful,          ;
;    but WITHOUT ANY WARRANTY; without even the implied warranty of           ;
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            ;
;    GNU Library General Public License for more details.                     ;
;                                                                             ;
;    You should have received a copy of the GNU Library General Public        ;
;    License along with this program; if not, write to the Free Software      ;
;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                ;
;                                                                             ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;/*
;[JCE] To support M80 and Z80ASM, this file is supplied as a .H file and the
;     C preprocessor does assembler-dependent conversion.
;
; Under Unix, "gcc -E -P -C -DZ80ASM par.h >par.zsm " will do this.
; Under CP/M, "cpp -E -P -C -DM80"   par.h >par.zsm " (CPP.COM from Hi-Tech C) 
;                                                     will do it. 
;

;;
; FID for the Amstrad PcW16 running "CP/M 3.1" from John Elliott
;;
; This FID use Z80 opcodes and needs to be assembled as follows:
;
;	M80 PPRT16.REL,PPRT16.PRN=PPRT16.Z80 /Z
;	LINK PPRT16 [OP]
;	RENAME PPRT16.FID=PPRT16.PRL
;	FIDCSUM PPRT16
;
; Author F. Trevor Gowen <Trevor.Gowen@src.bae.co.uk>,
;                     or <trevor.gowen@physics.org>.
;        (with assistance from John Elliott)
;;
; [JCE] The C-style comment braces are to stop gcc's preprocessor 
;        warning about apostrophes.
;
; Based upon the author's RSX LSTPCW16 0.1F etc.
;
;
;         Last Revision: 0.08  03/10/1998 JCE Written to use the C 
;                              preprocessor, so that the same source
;                              can be used in both build environments
;                        0.07E 04/11/1998 FTG Init. dialog "removed". Error
;                              dialog call moved.
;                        0.07D 03/11/1998 FTG Temporary init. dialog added.
;                        0.07C 28/10/1998 FTG Error dialog added.
;                        0.07B 18/10/1998 FTG Minor change to ensure proper
;                              PRL file generation (ORG 100H --> CSEG).
;                        0.07A 11/10/1998 FTG JCE's mods. converted for
;                              M80 assembly.
;                        0.07  06/10/1998 JCE FID completed and version
;                              number unified.
;                        0.00  03/10/1998 FTG Incomplete FID code within
;                              LSTPCW16.Z80 .
;*/
;;
;	Useful definitions
;;
BELL      EQU  07H            ; bell
BS        EQU  08H            ; backspace
LF        EQU  0AH            ; linefeed
FF        EQU  0CH            ; formfeed
CR        EQU  0DH            ; carriage return
EOT       EQU  '$'            ; BDOS PRINT End Of Text
ESC       EQU  1BH            ; escape
NULL      EQU  00H            ; )
OFF       EQU  00H            ; } escape seq. codes
ON        EQU  01H            ; )
YES       EQU  0FFH
NO        EQU  0
;;

#ifdef	Z80ASM		

        include org.inc     ; /* Part of JCE's build process */
        include anneos.inc  ; Rosanne func. call names {JCE}
	include	ver.inc	    ; Single version number for all files in project
#else	
	;Z80ASM

VERSION	EQU	0008H		;0.8
	.Z80			;Saves /Z on command line
	CSEG			;Not ORG 0100h

#endif	
	;Z80ASM  

REVISION  EQU  'a'            ; ' ' if no (minor) revisions


ANNE      EQU  003BH          ; Rosanne entry point
OSALERT   EQU  4CH
;;
; Super I/O Printer Port control register addresses
;;
PORTBASE  EQU  0038H
PTRDATA   EQU  PORTBASE       ; Read/Write
PTRSTAT   EQU  PORTBASE+1     ; Read only
PTRCTRL   EQU  PORTBASE+2     ; Read/Write
;;
SVCCHOOK  EQU  $ + 0FE04H     ; $ = 100H
SVCSCB    EQU  $ + 0FE03H     ; SCB {JCE}
;;
; Standard 32-byte FID header ...
;;
FIDHDR:   JP   FIDEMS
          DEFB  'ANNE    '
          DEFB  'FID'
FIDVSN:   DEFW VERSION
          DEFW 0000H
          DEFB 00H
          DEFB 00H
          DEFB 0,0,0,0,0,0,0,0,0,0,0,0
;;
; Dummy jumpblock ...
;;
FIDJBK:   JP   FDCINIT
          JP   FDCINST
          JP   FDCINST        ; no FDCINPUT, "returns" with A=0
          JP   FDCOUTST
          JP   FDCOUTPT
          JP   FDCOUTST       ; No specials
          JP   FDCOUTPT       ; for messages
;;
; Dummy private jumpblock ...
;;
FIDPJB:   JP   CDPPINIT
          JP   CDPPSTAT
;;
; Dummy character DEVice TABle ...
;;
FDDEVTAB: DEFB  'PPRT16'      ; Parallel PoRT on the PcW 16
          DEFB 02H            ; output only
          DEFB 00H            ; no baud rate
;;
; Messages ...
;;
SIGNON:   DEFB  'PPRT16 v'

#ifdef	M80

          DEFB (HIGH VERSION) + '0','.'
          DEFB ((LOW VERSION) AND 0F0H) + '0'
          DEFB ((LOW VERSION) AND 0FH) + '0'

#else	/* M80 */

          include version.inc ; unified version no. scheme {JCE}

#endif	/* M80 */

          DEFB REVISION
          DEFB  ' installed'
          DEFB CR,LF,0FFH
EMSERR:   DEFB  'PPRT16 not installed'
          DEFB CR,LF,0FFH
;;
; Live FIDEMS ...
;;
FIDEMS:   LD   A,D
          OR   A              ; carry cleared
          JR   NZ,EMSFAIL     ; major version not recognised
          LD   DE,FIDJBK      ; JumpBlocK
          LD   HL,FDDEVTAB    ; character DEVice TABle
          LD   B,1            ; PcW16 device type, 1=LPT
          CALL SVCCHOOK       ; HOOK Character device
;; JCE >>>
          JR   NC,EMSFAIL     ; If it worked, do a DEVICE LST:=PPRT16
          LD   HL,SVCSCB      ; B now = device number
          LD   A,H
          OR   L              ; CP/M 2, no SCB!
          JR   Z,FIDEMS2      ; [JCE] Don't _fail_ if there's no SCB. Just
          LD   DE,2AH	      ;      return success.
          ADD  HL,DE
          LD   DE,8000H       ; device bitmap
          LD   A,B
          OR   A
          JR   Z,FIDEMS1
FIDEMS0:  SRL  D
          RR   E
          DJNZ FIDEMS0
FIDEMS1:  LD   (HL),E
          INC  HL
          LD   (HL),D         ; Store new device entry in the SCB
FIDEMS2:  SCF
;; JCE <<<
EMSFAIL:  LD   HL,EMSERR      ; FAILure message
          RET  NC             ; exit if error
          LD   HL,SIGNON      ; message
          SCF
          RET
;;
FDCINIT:  
;          CALL INITDIAL       ; Used only for test purposes
          JR   CDPPINIT
;;
FDCINST:            ; never any input
          XOR  A              ; A-->0, carry cleared
          RET
;;
FDCOUTST: CALL CDPPSTAT
          AND  28H            ; test for "Paperend" or "Error"
;
; [JCE] Deleted because it gets on very badly with the new FID support code
;      in BIOS 0.08 
; 
;;;          CALL NZ,ERRDIAL     ; display dialog if an error
BUSYSTAT: CALL CDPPSTAT       ; no dialog or dismissed - re-check
          AND  80H            ; test for "Busy" (carry is cleared)
          RET  NZ             ; carry cleared
          SCF
          RET
;;
FDCOUTPT: PUSH BC             ; char. to print in C
FDCOLOOP: CALL PAUSE
          CALL BUSYSTAT
          JR   NC,FDCOLOOP
          POP  DE             ; char. now in E
          LD   BC,PTRDATA
          OUT  (C),E
          CALL PAUSE
          LD   BC,PTRCTRL
          IN   A,(C)
          OR   01H            ; lower strobe (inverted)
          OUT  (C),A
          CALL PAUSE
          CALL PAUSE
UPSTROBE: LD   BC,PTRCTRL
          IN   A,(C)
          AND  0CH            ; raise strobe (inverted)
          OUT  (C),A
          RET
PAUSE:    EX   (SP),HL        ; pause for ~4.06us (inc. "CALL")
          EX   (SP),HL
          RET
;;
; Private routines:
;;
CDPPINIT: JR UPSTROBE         ; just raise strobe for now
;;
CDPPSTAT:           ; return status flags (some inverted) in A
                    ; FID version in DE
          LD   HL,FIDVSN
          LD   E,(HL)
          INC  HL
          LD   D,(HL)
          LD   BC,PTRSTAT
          IN   A,(C)
          XOR  0C8H           ; invert "Busy", "Ack" and "Error" bits
          RET
;;
; Error dialog - uses Rosanne, much help provided by JCE via a listing of
; his ADRIVE.FID
;;
ERRDIAL:            ; display error dialog
          PUSH  AF
          PUSH  BC
          PUSH  DE
          PUSH  HL
          LD    HL,EDGBGN
          CALL  EXPADD       ; create 24-bit addr. {JCE}
          LD    DE,EDGEND-EDGBGN
          LD    A,OSALERT
          CALL  ANNE         ; "Printer Offline..."
          POP   HL
          POP   DE
          POP   BC
          POP   AF
          RET
; INITDIAL:           ; display initialisation dialog
; 	    PUSH  AF
; 	    PUSH  BC
; 	    PUSH  DE
; 	    PUSH  HL
; 	    LD    HL,IDGBGN
; 	    CALL  EXPADD       ; create 24-bit addr. {JCE}
; 	    LD    DE,IDGEND-IDGBGN
; 	    LD    A,OSALERT
; 	    CALL  ANNE         ; "Printer FID Initialised"
; 	    POP   HL
; 	    POP   DE
; 	    POP   BC
; 	    POP   AF
; 	    RET
;; JCE >>>
; Expand a 16-bit address to a PCW16 24-bit address
;;
EXPADD:   LD    A,H
          AND   0C0H
          JR    Z,INF0
          CP    40H
          JR    Z,INF1
          CP    80H
          JR    Z,INF2
          IN    A,(0F3H)
          LD    C,A
          RET
INF0:     IN    A,(0F0H)
          LD    C,A
          RET
INF1:     IN    A,(0F1H)
          LD    C,A
          RET
INF2:     IN    A,(0F2H)
          LD    C,A
          RET
;; JCE <<<
;;
; Dialog definitions
;;
EDGBGN:   DEFB  'Printer Offline or Out-of-paper!'
          DEFB 0,0
          DEFB 1                             ; 1 button
          DEFB 0FBH,80H                      ; Green Tick
          DEFB  0DH,80H                      ; {CR}
          DEFB  'o',80H                      ; O (of OK)
          DEFB  ' ',80H                      ; {space-bar}
          DEFB  ' ',1FH,'OK ',0A5H,' ',0     ; "OK"
EDGEND:
;;
; IDGBGN:   DEFB  'Printer FID Initialised'
; 	    DEFB 0,0
; 	    DEFB 1                             ; 1 button
; 	    DEFB 0FBH,80H                      ; Green Tick
; 	    DEFB  0DH,80H                      ; {CR}
; 	    DEFB  'o',80H                      ; O (of OK)
; 	    DEFB  ' ',80H                      ; {space-bar}
; 	    DEFB  ' ',1FH,'OK ',0A5H,' ',0     ; "OK"
; IDGEND:
;;
FIDSIZE   EQU  $ - FIDHDR
;;
          END



