/*
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;             CP/M for the PCW16                                              ;
;                                                                             ;
;   Copyright (C) 1998-1999, John Elliott <jce@seasip.demon.co.uk>            ;
;                                                                             ;
;    This program is free software; you can redistribute it and/or modify     ;
;    it under the terms of the GNU General Public License as published by     ;
;    the Free Software Foundation; either version 2 of the License, or        ;
;    (at your option) any later version.                                      ;
;                                                                             ;
;    This program is distributed in the hope that it will be useful,          ;
;    but WITHOUT ANY WARRANTY; without even the implied warranty of           ;
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            ;
;    GNU General Public License for more details.                             ;
;                                                                             ;
;    You should have received a copy of the GNU General Public License        ;
;    along with this program; if not, write to the Free Software              ;
;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                ;
;                                                                             ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
*/
/* This program takes a .XBM as produced by xv(1) and turns it
 * into Z80 source. It assumes <=15 bytes per line, 
 * bitmap width = 8.
 *
 * The comments it adds to the Z80 source only make sense if the XBM
 * contains a 64-column Spectrum font with characters 6 bytes high,
 * but the source is usable (and used) for other fonts such as PCW 8x8.
 */

#include <stdio.h>
#include <string.h>

char buf[90];
int byte[20];

int mirror(int c)
{
	int d, n;
	for (n = d = 0; n < 8; n++)
	{
		d = d << 1;
		if (c & 1) d |= 1;
		c = c >> 1;
	}
	return d;

}

int scan_commas(char *s)
{
	int n,c;
	char *s1 = s;
	int l = strlen(s);

	for (n = c = 0; (n < l && s[n] != '\n'); ++n)
	{
		if (s[n] == ',')
		{
			sscanf(s1," 0x%02x,", &byte[c]);
			++c;
			s1 = s + n + 1;
		}
		if (s[n] == '}' && n > 0 && s[n-1] != ' ')
		{
			sscanf(s1," 0x%02x}", &byte[c]);
			++c;
			return c;
		}
	}
	return c;
}



void main(int argc, char **argv)
{
	int ch = 32;
	int c = 0, b;
	int lc = 0;
	char * s;
	FILE *fp = fopen(argv[1], "r");


	fgets(buf, 90, fp); printf(";%s", buf);	/* 1st line */
	fgets(buf, 90, fp); printf(";%s", buf); /* 2nd line */
	fgets(buf, 90, fp); printf(";%s", buf); /* 3rd line */

	do
	{
		s = fgets(buf, 90, fp);
		if (!s) continue;
		b = scan_commas(buf);
		if (lc == 0) printf("\tDEFB\t");	
		for (c = 0; c < b; c++)
		{
			printf("0%02xh",mirror(byte[c]));
			++lc;
			if (lc == 6 || lc == 12) 
			{
				if (ch < 126) printf("\t;%c %c", ch, ch+1);
				else	      printf("\t;%02x %02x", ch, ch+1);
				ch+=2;
				printf("\n\tDEFB\t");	
				lc = 6;
			}
			else printf(", ");
		}
	} while (s);

	printf("\n;\n");

	fclose(fp);


}
