/* Minimum `Software Configuration Management' Header */
/*
 * PROGNAM, AUTHOR, VERSION and LASTMOD
 * must be defined and passed as strings
 * in the main (.c) file!!!
 * eg.:
 * #define PROGNAM "utility"
 * #define AUTHOR  "A. Non."
 * #define VERSION "0.14"
 * #define LASTMOD "18/08/1997"
 */

#ifdef GCC

void print_scm(char * a, char * b, char * c, char * d);
               /* PRINT SCM information */
void print_us(char * a, char * b);
              /* PRINT USage information */

void print_scm(char * prog,
	       char * auth,
	       char * vsn,
	       char * last)
{
/* Print program name, version, last modification date and author */
/* Call thus: print_scm(PROGNAM, AUTHOR, VERSION, LASTMOD); */
  printf (prog);
  printf (" Version ");
  printf (vsn);
  printf (" [");
  printf (last);
  printf ("], (c) ");
  printf (auth);
  puts (" & B.Ae. S.R.C.");
}

void print_us(char * prog,
	      char * usage)
{
/* Use it in this manner: 
 * ...
 * if (argc < 2)
 *   {
 *     print_us(PROGNAM, "[path/]filenam1[.tg1] ...");
 *     ...
 *     exit(1);
 *   }
 * ...
 */
  printf ("Usage ");
  printf (prog);
  putchar(' ');
  puts (usage);
}

#else

void print_scm();        /* PRINT SCM information */
void print_us();         /* PRINT USage information */

void print_scm(prog, auth, vsn, last)
  char prog[],auth[],vsn[],last[];
{
/* Print program name, version, last modification date and author */
/* Call thus: print_scm(PROGNAM, AUTHOR, VERSION, LASTMOD); */
  printf (prog);
  printf (" Version ");
  printf (vsn);
  printf (" [");
  printf (last);
  printf ("], (c) ");
  printf (auth);
  puts (" & B.Ae. S.R.C.");
}

void print_us(prog, usage)
  char prog[],usage[];
{
/* Use it in this manner: 
 * ...
 * if (argc < 2)
 *   {
 *     print_us(PROGNAM, "[path/]filenam1[.tg1] ...");
 *     ...
 *     exit(1);
 *   }
 * ...
 */
  printf ("Usage ");
  printf (prog);
  putchar(' ');
  puts (usage);
}

#endif
