/*
 * Decompiled with CFR 0.152.
 */
package info.seasip.ao3scraper;

import info.seasip.ao3scraper.DownloaderEventHandler;
import info.seasip.ao3scraper.DownloaderEventListener;
import info.seasip.ao3scraper.Work;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class Downloader
extends Thread {
    private String user;
    private ArrayList listeners;
    private int works;
    ArrayList workList = new ArrayList();
    private boolean stopped = false;
    static final int DONE = 1;
    static final int FAILED = 2;
    static final int PROGRESS = 3;
    private static final String HEADER_MODULE = "<div class=\"header module\">";
    private static final String DATETIME = "<p class=\"datetime\">";

    public Downloader(String u) {
        this.user = u;
        this.listeners = new ArrayList();
    }

    public String getUsername() {
        return this.user;
    }

    public void addDownloadListener(DownloaderEventListener listener) {
        this.listeners.add(listener);
    }

    private void done() {
        int size = this.workList.size();
        String message = size == 1 ? "1 work found." : Integer.toString(size) + " works found.";
        for (int n = 0; n < this.listeners.size(); ++n) {
            DownloaderEventListener listener = (DownloaderEventListener)this.listeners.get(n);
            DownloaderEventHandler e = new DownloaderEventHandler(1, this, listener, message);
            SwingUtilities.invokeLater(e);
        }
    }

    private void failed(String err) {
        for (int n = 0; n < this.listeners.size(); ++n) {
            DownloaderEventListener listener = (DownloaderEventListener)this.listeners.get(n);
            DownloaderEventHandler e = new DownloaderEventHandler(2, this, listener, err);
            SwingUtilities.invokeLater(e);
        }
    }

    private void progress(String s, int tot, int cur) {
        for (int n = 0; n < this.listeners.size(); ++n) {
            DownloaderEventListener listener = (DownloaderEventListener)this.listeners.get(n);
            DownloaderEventHandler e = new DownloaderEventHandler(3, this, listener, s, tot, cur);
            SwingUtilities.invokeLater(e);
        }
    }

    private String readPage(BufferedReader rdr) throws IOException {
        String line;
        StringBuilder b = new StringBuilder();
        while ((line = rdr.readLine()) != null) {
            b.append(line);
        }
        return b.toString();
    }

    private boolean countWorks(String page) {
        int n0;
        int idx = page.indexOf(" Works by");
        if (idx <= 0) {
            return false;
        }
        for (n0 = idx; n0 > 0 && Character.isDigit(page.charAt(n0 - 1)); --n0) {
        }
        String wks = page.substring(n0, idx);
        try {
            this.works = Integer.parseInt(wks);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private int parseStat(String header, String title) {
        int bracketDepth = 0;
        String match = "<dt>" + title + ":";
        int idx1 = header.indexOf(match);
        if (idx1 <= 0) {
            return 0;
        }
        idx1 += match.length();
        while (idx1 < header.length()) {
            char ch = header.charAt(idx1);
            if (ch == '<') {
                ++bracketDepth;
            }
            if (ch == '>') {
                --bracketDepth;
            }
            if (Character.isDigit(ch) && bracketDepth == 0) {
                char ch2;
                StringBuilder b = new StringBuilder();
                int idx2 = idx1;
                while ((ch2 = header.charAt(idx2)) != '<') {
                    if (Character.isDigit(ch2)) {
                        b.append(ch2);
                    }
                    ++idx2;
                }
                return Integer.parseInt(b.toString());
            }
            ++idx1;
        }
        return 0;
    }

    private void parseHeader(String header) {
        int idx2;
        Work work = new Work();
        int idx1 = header.indexOf(DATETIME);
        if (idx1 >= 0) {
            idx2 = idx1 + DATETIME.length();
            while (header.charAt(idx2) == ' ') {
                ++idx2;
            }
            SimpleDateFormat format = new SimpleDateFormat("dd MMM yyyy");
            try {
                work.date = format.parse(header.substring(idx2));
                Date today = new Date();
                long diff = today.getTime() - work.date.getTime();
                work.age = (int)(diff / 86400000L);
            }
            catch (ParseException pe) {
                // empty catch block
            }
        }
        if ((idx1 = header.indexOf("<a href=\"/works/")) >= 0 && (idx2 = header.indexOf(62, idx1)) >= 0) {
            idx1 = header.indexOf(60, idx2);
            work.title = header.substring(idx2 + 1, idx1);
        }
        work.hits = this.parseStat(header, "Hits");
        work.bookmarks = this.parseStat(header, "Bookmarks");
        work.comments = this.parseStat(header, "Comments");
        work.kudos = this.parseStat(header, "Kudos");
        work.words = this.parseStat(header, "Words");
        this.workList.add(work);
    }

    private void parse(String page) {
        int idx1 = -1;
        int idx2 = 0;
        while ((idx1 = page.indexOf(HEADER_MODULE, idx1 + 1)) >= 0) {
            idx2 = page.indexOf(HEADER_MODULE, idx1 + 1);
            String header = idx2 >= 0 ? page.substring(idx1, idx2) : page.substring(idx1);
            this.parseHeader(header);
        }
        return;
    }

    public void fillTable(JTable table) {
        Object[][] rows = new Object[this.workList.size()][8];
        Object[] headers = new Object[]{"Title", "Hits", "Kudos", "Comments", "Bookmarks", "Date", "Age", "Words"};
        for (int r = 0; r < this.workList.size(); ++r) {
            Work wk = (Work)this.workList.get(r);
            rows[r][0] = wk.title;
            rows[r][1] = new Integer(wk.hits);
            rows[r][2] = new Integer(wk.kudos);
            rows[r][3] = new Integer(wk.comments);
            rows[r][4] = new Integer(wk.bookmarks);
            rows[r][5] = wk.formattedDate();
            rows[r][6] = new Integer(wk.age);
            rows[r][7] = new Integer(wk.words);
        }
        table.setModel(new DefaultTableModel(rows, headers));
    }

    public void saveStats(File output) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(output));
        out.write("Title\tHits\tKudos\tComments\tBookmarks\tDate\tAge\tWords\n");
        for (int n = 0; n < this.workList.size(); ++n) {
            Work wk = (Work)this.workList.get(n);
            out.write(wk.title);
            out.write(9);
            out.write(Integer.toString(wk.hits));
            out.write(9);
            out.write(Integer.toString(wk.kudos));
            out.write(9);
            out.write(Integer.toString(wk.comments));
            out.write(9);
            out.write(Integer.toString(wk.bookmarks));
            out.write(9);
            out.write(wk.formattedDate());
            out.write(9);
            out.write(Integer.toString(wk.age));
            out.write(9);
            out.write(Integer.toString(wk.words));
            out.write(10);
        }
        out.close();
    }

    public synchronized void onStop() {
        this.stopped = true;
    }

    public void run() {
        this.workList.clear();
        String pageroot = "http://archiveofourown.org/users/" + this.user + "/works";
        try {
            this.progress("Downloading " + pageroot, 100, 0);
            URL url = new URL(pageroot);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String page = this.readPage(in);
            in.close();
            if (!this.countWorks(page)) {
                this.failed("Cannot find 'nnn Works by ' text in result.");
                return;
            }
            for (int n = 0; n < this.works && !this.stopped; n += 20) {
                if (n > 0) {
                    String nextPageName = pageroot + "?page=" + Integer.toString(n / 20 + 1);
                    this.progress("Downloading " + nextPageName, this.works, n);
                    URL nextPage = new URL(nextPageName);
                    in = new BufferedReader(new InputStreamReader(nextPage.openStream()));
                    page = this.readPage(in);
                    in.close();
                }
                this.progress("Analysing", this.works, n);
                this.parse(page);
            }
        }
        catch (Exception ex) {
            this.failed(ex.getClass().getName() + ": " + ex.getMessage());
            return;
        }
        this.done();
    }
}

