/*
 * Decompiled with CFR 0.152.
 */
package info.seasip.ao3scraper;

import info.seasip.ao3scraper.AboutBox;
import info.seasip.ao3scraper.Downloader;
import info.seasip.ao3scraper.DownloaderEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class MainFrame
extends JFrame
implements DownloaderEventListener {
    JPanel ctls = new JPanel();
    JPanel status = new JPanel();
    JButton download = new JButton("Download");
    JButton about = new JButton("About...");
    JButton stop = new JButton("Stop");
    JTextField ao3user = new JTextField("", 50);
    JLabel result = new JLabel("Ready.");
    JProgressBar progress = new JProgressBar();
    JTable table = new JTable();
    Downloader activeDownloader = null;

    MainFrame() {
        this.setTitle("AO3 Stats Downloader");
        this.ctls.setLayout(new FlowLayout());
        this.ctls.add(new JLabel("AO3 username:"));
        this.ctls.add(this.ao3user);
        this.ctls.add(this.download);
        this.ctls.add(this.stop);
        this.ctls.add(this.about);
        this.status.setLayout(new BorderLayout());
        this.status.add((Component)this.result, "Center");
        this.status.add((Component)this.progress, "East");
        this.add((Component)this.ctls, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)this.status, "South");
        this.pack();
        this.stop.setEnabled(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainFrame.this.dispose();
            }

            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
        this.ao3user.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                MainFrame.this.checkUser();
            }
        });
        this.checkUser();
        this.ao3user.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MainFrame.this.onDownload();
            }
        });
        this.download.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MainFrame.this.onDownload();
            }
        });
        this.stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MainFrame.this.onStop();
            }
        });
        this.about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MainFrame.this.onAbout();
            }
        });
    }

    public static void main(String[] args) {
        MainFrame mf = new MainFrame();
        mf.setVisible(true);
    }

    public void downloadComplete(Downloader d, String message) {
        this.stop.setEnabled(false);
        this.activeDownloader = null;
        this.download.setEnabled(true);
        this.result.setText(message);
        this.progress.setMaximum(1);
        this.progress.setValue(1);
        this.table.removeAll();
        d.fillTable(this.table);
        JFileChooser dlg = new JFileChooser();
        dlg.setName(d.getUsername() + ".tab");
        int val = dlg.showSaveDialog(this);
        if (val == 0) {
            try {
                d.saveStats(dlg.getSelectedFile());
            }
            catch (Exception e) {
                this.result.setText(e.getClass().getName() + ": " + e.getMessage());
            }
        }
    }

    public void downloadFailed(Downloader d, String why) {
        this.stop.setEnabled(false);
        this.activeDownloader = null;
        this.progress.setValue(0);
        this.download.setEnabled(true);
        this.result.setText(why);
    }

    public void downloadProgress(Downloader d, String msg, int tot, int cur) {
        this.result.setText(msg);
        this.progress.setIndeterminate(false);
        this.progress.setMaximum(tot);
        this.progress.setValue(cur);
    }

    private void checkUser() {
        this.download.setEnabled(!this.ao3user.getText().equals(""));
    }

    private void onAbout() {
        AboutBox box = new AboutBox(this);
        box.setVisible(true);
    }

    private void onStop() {
        if (this.activeDownloader != null) {
            this.activeDownloader.onStop();
        }
    }

    private void onDownload() {
        String user = this.ao3user.getText();
        this.activeDownloader = new Downloader(user);
        this.stop.setEnabled(true);
        this.progress.setIndeterminate(true);
        this.activeDownloader.addDownloadListener(this);
        this.result.setText("Processing");
        this.download.setEnabled(false);
        this.activeDownloader.start();
    }
}

