/*  AO3Scraper 2.0: Scrapes AO3 to extract work statistics
    Copyright (C) 2013  John Elliott  <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
package info.seasip.ao3scraper;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;

/** A simple About box. 
 *
 * @author John Elliott  jce@seasip.demon.co.uk
 */
public class AboutBox extends JDialog {
    
    /** Licence text. */
    private static final String GPL =
    "AO3Scraper 2.0: Scrapes AO3 to extract work statistics\n" +
    "Copyright (C) 2013  John Elliott  <jce@seasip.demon.co.uk>\n" +
    "\n" +
    "This program is free software; you can redistribute it and/or modify\n" +
    "it under the terms of the GNU General Public License as published by\n" +
    "the Free Software Foundation; either version 2 of the License, or\n" +
    "(at your option) any later version.\n" +
    "\n" +
    "This program is distributed in the hope that it will be useful,\n" +
    "but WITHOUT ANY WARRANTY; without even the implied warranty of\n" +
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" +
    "GNU General Public License for more details.\n" +
    "\n" +
    "You should have received a copy of the GNU General Public License\n" +
    "along with this program; if not, write to the Free Software\n" +
    "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.";

    /** Constructor.
     * 
     * @param parent The parent window.
     */
    AboutBox(Frame parent) {
        super(parent, "About AO3 Stats Downloader");
        JButton ok = new JButton("OK");

        JTextArea area = new JTextArea(GPL);
        area.setEditable(false);
        add(area, BorderLayout.CENTER);
        JPanel p1 = new JPanel();
        p1.setLayout((new FlowLayout()));
        p1.add(ok);
        add(p1, BorderLayout.SOUTH);
        
        // Event handlers: Clicking OK or Close will dispose of this window.
        ok.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                dispose();
            }
        });
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) { 
                dispose();
            }
        });
        pack();
    }        
}
