/*  AO3Scraper 2.0: Scrapes AO3 to extract work statistics
    Copyright (C) 2013  John Elliott  <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
package info.seasip.ao3scraper;

/** A helper class to call DownloaderEventListeners on the UI thread..
 *
 * @author John Elliott  jce@seasip.demon.co.uk
 */
public class DownloaderEventHandler implements Runnable {

    DownloaderEventListener listener;
    Downloader source;
    int type;
    int total;
    int current;
    String message;
    
    /** Constructor for DONE or FAILED events. 
     * 
     * @param t Event type. Downloader.DONE or Downloader.FAILED 
     * @param d Event source -- the Downloader that raised this event
     * @param l Event destination -- the listener that will receive this event
     * @param m Associated message
     */
    DownloaderEventHandler(int t, Downloader d, DownloaderEventListener l, String m) {
        type = t;
        source = d;
        listener = l;
        message = m;
    }
    
    /** Constructor for PROGRESS events. 
     * 
     * @param t Event type. Downloader.PROGRESS
     * @param d Event source -- the Downloader that raised this event
     * @param l Event destination -- the listener that will receive this event
     * @param m Associated message
     * @param tot The total number of ticks in the progress bar
     * @param cur The current number of ticks in the progress bar
     */
    DownloaderEventHandler(int t, Downloader d, DownloaderEventListener l, 
            String m, int tot, int cur) {
        type = t;
        source = d;
        listener = l;
        message = m;
        total = tot;
        current = cur;
    }

    /** Called from SwingUtilities.InvokeLater. */
    public void run() {
        switch(type) {
            case Downloader.DONE: listener.downloadComplete(source, message); break;
            case Downloader.FAILED: listener.downloadFailed(source, message); break;
            case Downloader.PROGRESS: listener.downloadProgress(source, message, total, current); break;
              
        }
    }
}
