/*  AO3Scraper 2.0: Scrapes AO3 to extract work statistics
    Copyright (C) 2013  John Elliott  <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
package info.seasip.ao3scraper;

/** Interface to handle events from the Downloader.
 *
 * @author John Elliott  jce@seasip.demon.co.uk
 */
public interface DownloaderEventListener {
    
    /** Called if the download is successful.
     * 
     * @param source The Downloader that sent this event.
     * @param result A string giving the number of works successfully parsed.
     */
    public void downloadComplete(Downloader source, String result);

    /** Called if the download fails.
     * 
     * @param source The Downloader that sent this event.
     * @param result A string giving the error message.
     */
    public void downloadFailed(Downloader source, String reason);
    
    
    /** Called to give an update on progress.
     * 
     * @param source The Downloader that sent this event.
     * @param result The message saying how the downloader is getting on.
     */
    public void downloadProgress(Downloader source, String progress, int total, int current);

}
