/*  AO3Scraper 2.0: Scrapes AO3 to extract work statistics
    Copyright (C) 2013  John Elliott  <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
package info.seasip.ao3scraper;

import java.text.SimpleDateFormat;
import java.util.Date;

/** A data class representing an AO3 work.
 *
 * @author John Elliott  jce@seasip.demon.co.uk
 */
public class Work {
    /** The title of the work. */
    public String title = "";
    
    /** The number of hits the work has received. */
    public int hits = 0;

    /** The number of times the work has been given kudos. */
    public int kudos = 0;
    
    /** The number of comments on the work. */
    public int comments = 0;
    
    /** The number of times the work has been bookmarked. */
    public int bookmarks = 0;
    
    /** The date the work was published. */
    public Date date = null;
    
    /** Get the date as an ISO 8601 formatted string. 
     * 
     * @return The formatted date.
     */
    public String formattedDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }
    
    /** The number of days since the work was published. */
    public int age = 0;
    
    /** The number of words in the work. */
    public int words = 0;
}
