// Saver.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Saver.h"
#include "drawwnd.h"
#include "Saverdlg.h"
#include "saverwnd.h"

#ifdef _WIN16
	#include <ctype.h>

	int __argc;
	char FAR *__argv[3];
#endif


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSaverApp

BEGIN_MESSAGE_MAP(CSaverApp, CWinApp)
	//{{AFX_MSG_MAP(CSaverApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

TCHAR szConfig[]=_T("Config");

/////////////////////////////////////////////////////////////////////////////
// CSaverApp construction

CSaverApp::CSaverApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CSaverApp object

CSaverApp theApp;

BOOL MatchOption(LPTSTR lpsz, LPTSTR lpszOption)
{
	if (lpsz[0] == '-' || lpsz[0] == '/')
		lpsz++;
	char c1 = *lpsz;
	char c2 = *lpszOption;

	if (islower(c1)) c1 = toupper(c1);
	if (islower(c2)) c2 = toupper(c2);

	return (c1 == c2);
}

/////////////////////////////////////////////////////////////////////////////
// CSaverApp initialization

BOOL CSaverApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _WIN16
	__argc    = 2;
	__argv[1] = m_lpCmdLine;
	if (!__argv[1][0]) __argc = 1;

	Ctl3dRegister(AfxGetInstanceHandle());
	
#else

	Enable3dControls();
	SetRegistryKey(_T("Blob Screensaver"));
#endif

	if (__argc == 1 || MatchOption(__argv[1], _T("c")))
		DoConfig();
	else if (MatchOption(__argv[1], _T("a")))
		AfxMessageBox("Sorry, this screensaver does not support passwords.");
#ifdef _WIN32
	else if (MatchOption(__argv[1], _T("p")))
	{
		CWnd* pParent = CWnd::FromHandle((HWND)atol(__argv[2]));
		ASSERT(pParent != NULL);
		CDrawWnd* pWnd = new CDrawWnd();
		CRect rect;
		pParent->GetClientRect(&rect);
		pWnd->Create(NULL, WS_VISIBLE|WS_CHILD, rect, pParent, NULL);
		m_pMainWnd = pWnd;
		return TRUE;
	}
#endif
	else if (MatchOption(__argv[1], _T("s")))
	{
		CSaverWnd* pWnd = new CSaverWnd;
		pWnd->Create();
		m_pMainWnd = pWnd;
		return TRUE;
	}
	return FALSE;
}

void CSaverApp::DoConfig()
{
	CSaverDlg dlg;
	dlg.m_nSpeed = GetProfileInt(szConfig, _T("Speed"), 100);
	m_pMainWnd = &dlg;
	if (dlg.DoModal() == IDOK)
	{
		WriteProfileInt(szConfig, _T("Speed"), dlg.m_nSpeed);
	}
}
    
    
BOOL CSaverApp::ExitInstance()
{
#ifdef _WIN16                            
	Ctl3dUnregister(AfxGetInstanceHandle());                            
#endif                            
	return CWinApp::ExitInstance();
}