nolist
if 1
  read "frogintro.asm"
  list
  ds #4000 - $
else
  run game_start
endif
nolist
org #4000

.skip_frogs	equ 0
.debugint	equ 0
.inf_lives	equ 0

.start_lives		equ 3
.max_lives_shown	equ 10
.points_extra		equ #2000	; (#2000 = 20,000)
.croc_first_level	equ 2		; 2
.croc_always_level	equ 5		; 5
.snake_level		equ 3		; 3
.two_snake_level	equ 6		; 6

charset '0',#80
charset '1','9',1
charset ' ',10
charset 'A','Z',11
charset '-',37
charset 'c',38	; Copyright

macro asic switch
  if 'switch' = 'off'
    ld a,asic_off
  else
    ld a,asic_on
  endif
  ld i,a
  ld b,#7f
  out (c),a
endm

macro descr:rst #00:endm
macro dma_channels:rst #10:endm

.main_start

org #0000,@
limit #3fff

; Z = #47
; X = #3f
; ; = #1c
; / = #1e
; C = #3e
; 1 = #40
; 2 = #41

.asic_on equ #7fb8
.asic_off equ #7fa0

.border		equ #6420
.raster_int	equ #6800
.split_line	equ #6801
.split_start	equ #6802
.soft_scroll	equ #6804
.dma0_start	equ #6c00
.dma1_start	equ #6c04
.dma2_start	equ #6c08
.dma_control	equ #6c0f

.blue_back	equ #0004

if 0
.frogger_speed	equ 1
.frogger_speed2	equ 1
.points_wait    equ 1
.points_wait2	equ 1
.score_wait	equ 1
.coin_wait	equ 1
else
.frogger_speed	equ 8
.frogger_speed2	equ #20
.points_wait    equ #30
.points_wait2	equ #80
.score_wait	equ #ff
.coin_wait	equ #ff
endif

.dma_work	equ #f800	; F8,F9,FA
.dma1		equ #fb00	; FB
.dma2		equ #fc00	; FC
.ktab		equ #fd00	; FD
.stack_base	equ #fe00	; FD

.code_start

.descr_rst00	; D=x, E=y   ; RST 0
ld a,d
add 4
ex de,hl
add hl,hl
ld h,bases / 256
add (hl)
inc l
ld h,(hl)
ex de,hl
ld e,a
ret nc
inc d
ret

align 8

.dma_channels_rst10
ld iy,dma_work
ld bc,DMA_PAL * 256 + DMA_AMA
.soundaddr0 equ $ + 1
call sound0
inc hy
ld bc,DMA_PBL * 256 + DMA_AMB
.soundaddr1 equ $ + 1
call sound0
inc hy
ld bc,DMA_PCL * 256 + DMA_AMC
.soundaddr2 equ $ + 1
call sound0
ld (hl),20:inc l		; Close enough
ld (hl),DMA_PAU:inc l
ret

list
ds #38 - $
.intrt
nolist
ei	;exx
ret	;ex af,af'
out (c),c
if debugint
ld a,(hl):ld (#6420),a
endif
ld b,(hl):ldi		; Split scan line
ldi:ld c,(hl)
push bc:ldi		; Split start address
ld a,(hl):inc l		; Soft-scroll
ld (save_stack),sp
ld sp,hl
pop bc			; Ink 1
pop de			; Ink 2
ld (soft_scroll),a
pop af			; Ink 3
ld sp,#6408
push af			; Set Ink 3
push de			; Set Ink 2
push bc			; Set Ink 1
inc l
jr nz,no_mid
xor a
ld (#6400),a
ld (frame),a

ld sp,(save_stack)
pop bc
call do_sound

; Key scan routine
ld hl,ktab + 9
ld bc,#f40e
out (c),c
ld bc,#f6c0
out (c),c
out (c),l
ld bc,#f792
out (c),c
ld c,#49
.sclp
ld b,#f6
out (c),c
ld b,#f4
ind
dec c
bit 6,c
jr nz,sclp
ld bc,#f782
out (c),c

ld hl,road0_int
jr first_char

.save_stack equ $ + 1
.no_mid
ld sp,0
pop bc
set 6,c
ld a,b
add 8
nop
ld (split_line),a
ld a,c
ld (split_start + 1),a
ld a,l
cp road4_int + 6
jr z,main_int
add 5
ld l,a
call m,do_sound
.first_char
ld de,raster_int
ldi
ld bc,asic_on
if debugint
xor a
ld (#6420),a
endif
ld a,i
out (c),a
ex af,af'
exx
ei
ret

.main_int
.sprite2 equ $ + 2
ld hl,#c000
ld de,#4200
ld bc,#b0
call sprloop48

ld c,h
ld a,#df
ld (split_line),a
ld hl,#ac20
ld (split_start),hl
ld hl,(scrolls + 0):ld (water0_int + 3),hl
ld hl,(scrolls + 2):ld (water1_int + 3),hl
ld hl,(scrolls + 4):ld (water2_int + 3),hl
ld hl,(scrolls + 6):ld (water3_int + 3),hl

ld a,#80
ld (frame),a
.ink1_line1c equ $ + 1
ld hl,0
ld (#6402),hl
ld (soft_scroll),a
.ink2_line1c equ $ + 1
ld hl,0
ld (#6404),hl
.ink3_line1c equ $ + 1
ld hl,#ddf
ld (#6406),hl

ld h,c
ld l,e
ld c,#50
call sprloop16

.sprite3 equ $ + 1
ld h,#c4
ld c,#70
call sprloop48

ld c,h
.ink1_line1e equ $ + 1
ld hl,0
ld (#6402),hl
.ink2_line1e equ $ + 1
ld hl,0
ld (#6404),hl
.ink3_line1e equ $ + 1
ld hl,#ddf
ld (#6406),hl

ld h,c
ld l,e
ld c,#60
call sprloop32

ld c,h
.ink2_line1f equ $ + 1
ld hl,0
ld (#6404),hl
.ink3_line1f equ $ + 1
ld hl,#ddf
ld (#6406),hl

ld hl,(scrolls + 8):ld (water4_int + 3),hl
ld hl,(scrolls + 10):ld (road0_int + 3),hl
ld hl,(scrolls + 12):ld (road1_int + 3),hl
ld hl,(scrolls + 14):ld (road2_int + 3),hl
ld hl,(scrolls + 16):ld (road3_int + 3),hl
ld hl,(scrolls + 18):ld (road4_int + 3),hl

ld h,c
ld l,e
ld c,#30
call sprloop48

.sprite4 equ $ + 1
ld h,#c1
call hwsprite

ld a,blue_back
ld (#6400),a
;.ink1_line0 equ 0
;ld hl,#4ff
;ld (#6402),hl
.ink2_line0
ld hl,#ddf
ld (#6404),hl
.ink3_line0 equ $ + 1
ld hl,#ddf
ld (#6406),hl

.sprite5 equ $ + 1
ld h,#c2
call hwsprite

.sprite0 equ $ + 1
ld h,#c2
ld d,#40
call hwsprite

.sprite1 equ $ + 1
ld h,#c2
inc b
call sprloop

.ink1_line3 equ $ + 1
ld hl,0
ld (#6402),hl
.ink2_line3 equ $ + 1
ld hl,0
ld (#6404),hl
.ink3_line3 equ $ + 1
ld hl,#ddf
ld (#6406),hl

ld hl,#fff0
.last_beaver equ $ + 1
ld (#6040),hl
ex de,hl
ld sp,spritepos
pop hl:ld a,h:ld (#6002),a:ld h,c:add hl,hl:add hl,de:ld (#6000),hl	; Sprite 0
pop hl:ld a,h:ld (#600a),a:ld h,c:add hl,hl:add hl,de:ld (#6008),hl	; Sprite 1
pop hl:ld a,h:ld (#6012),a:ld h,c:add hl,hl:add hl,de:ld (#6010),hl	; Sprite 2
pop hl:ld a,h:ld (#601a),a:ld h,c:add hl,hl:add hl,de:ld (#6018),hl	; Sprite 3
pop hl:ld a,h:ld (#6022),a:ld h,c:add hl,hl:add hl,de:ld (#6020),hl	; Sprite 4
pop hl:ld a,h:ld (#602a),a:ld h,c:add hl,hl:add hl,de:ld (#6028),hl	; Sprite 5
pop hl:ld a,h
.beaver_y_addr equ $ + 1
ld (#6042),a:ld h,c:add hl,hl:add hl,de
.beaver_x_addr equ $ + 1
ld (#6040),hl								; Beaver
.blue_inks equ $ + 1
ld hl,blue_inks1
ld de,#643a
ldi:ldi:ldi:ldi:ldi:ldi
ld sp,(save_stack):pop bc
ld a,(beaver_x_addr)
ld (last_beaver),a

ld hl,(dma_pos)
dec l
ld (hl),DMA_STP / 256
dec l
ld (hl),DMA_STP
ld l,0
ld (dma0_start),hl
ld a,h
.dma1h equ dma1 / 256
.dma2h equ dma2 / 256
xor dma1h xor dma2h
ld h,a
ld de,dma_control
ld a,(de)
and #f8
ld (de),a
ld (dma_pos),hl
or 1
ld (de),a

ld a,(ktab + 7)
and #40
jr nz,nocoin

.coin_debounce equ $ + 1
ld a,#40
or a
jr z,nocoin2

ld a,(credits)
inc a
daa
ld (credits),a

.players equ $ + 1
ld a,0
or a
jr nz,nocoinsnd

ld hl,sound1
ld (soundaddr0),hl

.nocoinsnd
xor a
.nocoin
ld (coin_debounce),a
.nocoin2
call do_sound
ld hl,int_table
jp first_char

.start
ldir
ld bc,#bd1d
out (c),c
ld hl,#158
ld (score1),hl
ei
.start_main
ld de,0
ld bc,#1c20
ld l,#ff
ld a,d
call clear_box
ld b,20
.wait1
call wait
djnz wait1
call clear_main
call clear_all
ld hl,#0f0
ld (ink3_line0),hl
call show_scores
ld bc,#bd1d
out (c),c

if skip_frogs
jp do_demo
endif

.show_frogs
call check_credits
call show_credits
asic on			;call need_asic
call hide_sprites
ld a,#30
call set_beaver
xor a
call set_frog_pal
ld a,5
call set_frog_pal
ld a,spr_frog_up1
ld (sprite0),a
ld (sprite1),a
ld (sprite2),a
ld (sprite3),a
ld (sprite4),a
ld (sprite5),a
ld h,a
ld d,#46
call hwsprite

ld hl,#0807
ld ix,spritepos
.more_frogs
ld de,#3710
.frog_loop
push hl
ld b,frogger_speed
call wait_credits
call halt7
push de
call clear_tile
pop de
dec d
ld a,d
cp h
jr z,end_frog
call gethop
call tile2
pop hl
jr frog_loop
.end_frog
pop hl
add a:add a:add #10
ld (ix + 1),#80
ld (ix + 0),a
inc ix:inc ix
ld a,h
add 6
ld h,a
dec l
jr nz,more_frogs

ld e,#80
.up_loop
ld b,frogger_speed
call wait_credits
call halt7
ld a,e
sub 4
ld e,a
ld hl,spritepos + 1
ld b,7
.up_sprites
ld (hl),e
inc l:inc l
djnz up_sprites
push de
ld a,e
call gethop2
ld a,b
ld (sprite0),a
ld (sprite1),a
ld (sprite2),a
ld (sprite3),a
ld (sprite4),a
ld (sprite5),a
ld d,#46
ld h,a
call hwsprite
pop de
ld a,e
cp #30
jr nz,up_loop

ld hl,spritepos
ld de,#0806
ld ix,frogger_tiles
.frogger_lp
ld b,frogger_speed2
call wait_credits
halt:halt
ld a,(ix + 0)
or a
jr z,end_frogger
inc ix
call tile2
ld a,d:add 6:ld d,a
ld (hl),0
inc l:inc l
jr frogger_lp

.end_frogger
asic off
ld hl,#ff0
ld (water3_int + 9),hl
ld (grass_int + 9),hl
ld (road0_int + 7),hl
ld (road2_int + 7),hl
ld hl,#0f0
ld (grass_int + 7),hl
ld (road1_int + 7),hl
ld (road2_int + 9),hl
ld hl,#ddf
ld (water2_int + 9),hl
ld de,#8512
ld c,#ff
call print
db "-POINT TABLE-",0
call konami
ld b,points_wait
call wait_credits
ld de,#8688
call print
db "10 PTS FOR EACH STEP",0
ld b,points_wait2
call wait_credits
ld de,#8244
call print
db "50 PTS FOR EVERY FROG",0
ld c,#0f
ld e,#7e
call print
db "ARRIVED HOME SAFELY",0
ld b,points_wait2
call wait_credits
ld de,#8788
call print
db "1000 PTS BY SAVING FROGS",0
ld de,#4608
call print
db "INTO FIYE HOMES",0
ld b,points_wait2
call wait_credits
ld de,#4708
call print
db "PLUS BONUS",0
ld e,#88
ld c,#ff
call print
db "10 PTS X REMAINING SECOND",0
ld b,points_wait2
call wait_credits
ld b,192
call wait_credits

.do_highs
call clear_menu
.show_highs
xor a
ld (start_shown),a
dec c
call konami
ld de,#8614
call print
db "SCORE RANKING",0
ld hl,#ff0
ld (water3_int + 9),hl
ld b,8
.high_pal
ld hl,pal1
ld a,b
call set_row_pal
dec b
bit 2,b
jr nz,high_pal
ld ix,highs
ld de,#4192
call printscore
db "1 ST",0
ld de,#8288
call printscore
db "2 ND",0
ld de,#8792
call printscore
db "3 RD",0
ld de,#4692
call printscore
db "4 TH",0
ld de,#4792
call printscore
db "5 TH",0
ld bc,#bc01
out (c),c
ld bc,#bd1d
out (c),c
ld a,(credits)
ld d,a
ld b,score_wait
.wait_score
call wait
call check_start
ld a,(credits)
cp d
jp nz,show_start
djnz wait_score

.check_coin
call check_credits
call clear_main
ld hl,#d20
ld (water3_int + 9),hl
ld hl,#ff0
ld (road1_int + 9),hl
dec c
ld de,#8696
call print
db "INSERT COIN",0
ld de,#468e
call print
db "3 FROGS PER PLAYER",0
ld b,coin_wait
call wait_credits

.do_demo
call init_demo
call wait
call check_credits
call halt6

.demo_time_down
call do_croc
call do_turtles
if debugint
call show_finish
endif
call wait
call check_credits
call demo_move
ld a,(frogy)
cp #31
call c,check_home
call cont_move
call down_time
call check_speed
call frog_collision
call update_death
call do_scroll
call update_turtles
ld a,(no_move)
or a
jr z,demo_time_down
dec a
ld (no_move),a
jr demo_time_down

.check_credits
ld a,(credits)
or a
ret z

.show_start
asic off
.start_shown equ $ + 1
ld a,0
or a
jr nz,wait_start
inc a
ld (start_shown),a
call hide_sprites
call reset_scrolls
call clear_main
call show_credits
ld hl,#4ff
ld (water3_int + 9),hl
ld de,#401c
call print
db "PUSH",0
ld de,#8694
call print
db "START BUTTON",0
ld hl,#0f0
ld (road1_int + 9),hl
ld de,#4608
call print
db "ONE EXTRA FROG ",0
ld hl,points_extra
call show_score
call print
db " PTS",0

.wait_start
call wait
call show_num_credits
ld a,(credits)
dec a
jr z,oneonly
ld hl,#ff0
ld (grass_int + 9),hl
ld de,#8284
call print
db "ONE OR TWO PLAYERS",0
jr two_start

.oneonly
ld hl,#ddf
ld (grass_int + 9),hl
ld de,#8286
call print
db "ONE PLAYER ONLY",0

.two_start
call check_start
jr wait_start

.check_start
ld a,(ktab + 8)
ld c,a
ld a,(credits)
or a
ret z
cp 2
jr c,less2
ld a,2
bit 1,c
jr z,start_game
dec a
.less2
bit 0,c
ret nz

.start_game	; A = num players
ld c,a
ld sp,stack_base
xor a
ld (start_shown),a
ld hl,credits
ld a,(hl)
sub c
daa
ld (hl),a
ld a,c
ld (players),a
ld (player_scores),a
call init_vars
call hide_sprites
call reset_scrolls
call wait
call halt7
xor a
ld h,a
ld l,a
ld (score),hl
inc a
call set_level
ld a,start_lives
ld (lives),a
ld a,32
ld (start_delay),a
call stopsound
ld a,9
call playnew
ld a,10
call playnew
ld a,11
call playnew
ld hl,346
ld (tune_count),hl
call clear_all
call init_palette
call init_screen
call init_frog
call set_layout
call draw_row_items
call init_time
call show_lives
call show_level
call to_p1
call to_p2
call show_scores
ld bc,#bd1d
out (c),c

.time_down
if debugint
call show_finish
endif
call do_turtles
call draw_scores
if debugint
call show_finish
endif
call wait
call do_croc_mouth
call do_croc
ld hl,(tune_count)
ld a,h
or l
jr z,no_main_tune
dec hl
ld (tune_count),hl
ld a,h
or l
jr nz,no_main_tune
ld a,15
call playnew
ld a,22
call playnew
xor a
ld (done_snake_snd),a
.no_main_tune
ld a,(num_home)
sub 5
jr nz,not5home
ld (num_home),a
ld (home),a
ld l,a
ld h,a
ld (home + 1),hl
ld (home + 3),hl
ld (fly_shown),a
ld a,255
ld (wink_pos),a
ld a,64
ld (wink_wait),a
ld a,17
call playnew
ld a,18
call playnew
ld a,1
ld (need_start),a
ld hl,layout
ld a,(hl)
inc a
cp 5
jr nz,notlay5
xor a
.notlay5
ld (hl),a
call set_layout
call reset_scrolls
call draw_row_items

.not5home
.wink_wait equ $ + 1
ld a,0
or a
jr z,no_dec_wait
dec a
ld (wink_wait),a
jr no_time_down

.no_dec_wait
.wink_pos equ $ + 1
ld a,0
or a
jr z,no_dec_wink
dec a
ld (wink_pos),a
jr no_time_down

.no_dec_wink
.start_delay equ $ + 1
ld a,0
or a
jr z,do_time_down
dec a
ld (start_delay),a
jr no_time_down

.do_time_down
call down_time
call croc_fly_move

.need_start equ $ + 1
ld a,0
dec a
jr nz,check_clear
ld (need_start),a
dec a
ld (start_clear),a
ld hl,start_msg
call fast8290
ld hl,#0040
ld (tune_count),hl

.check_clear
.start_clear equ $ + 1
ld a,0
or a
jr z,no_time_down
dec a
ld (start_clear),a
jr nz,no_time_down

call clear_grass

.no_time_down
call update_turtles
call check_speed
ld a,(items_water1)
ld e,a
ld a,(items_water4)
ld d,a
push de
ld a,(turtles1 + 1)
or a
jr nz,nodec1
ld hl,items_water1
dec (hl)
.nodec1
ld a,(turtles4 + 1)
or a
jr nz,nodec4
ld hl,items_water4
dec (hl)
.nodec4
call frog_collision
pop de
ld a,d
ld (items_water4),a
ld a,e
ld (items_water1),a
call update_death
call do_scroll
call snake_beaver
ld a,(wink_pos)
or a
call nz,show_wink
ld a,(no_move)
or a
jp z,time_down
dec a
ld (no_move),a
jp time_down

.show_wink
ld c,1
cp #c0
jr z,draw_wink
inc c
cp #90
jr z,draw_wink
inc c
cp #70
jr z,draw_wink
inc c
cp #50
jr z,draw_wink
inc c
cp #30
jr z,draw_wink
cp #10
ret nz

ld c,1
.next_home
call clear_home
inc c
ld a,c
cp 6
jr nz,next_home
ld a,(level)
inc a
ld b,a
call set_level
ld a,b
cp 15
jr c,levl15
ld a,15
.levl15
add a
ld e,a
ld d,0
ld hl,#8204
sbc hl,de
ex de,hl
ld a,40
ld c,#ff
jp charde

.change_loop
xor a
ld (beaverx),a
ld (done_snake_snd),a
ld b,64
.change_lp
push bc
call wait
;call do_croc_mouth
call do_croc
call do_scroll
call check_speed
pop bc
djnz change_lp
jp time_down

.draw_wink
ld e,48
jp home_tile

.snake_beaver
ld a,(level)
cp snake_level
ret c
ld ix,snake1_vars
ld hl,snake1ax
call do_snake
ld a,(level)
cp two_snake_level
jr c,beaver
ld lx,snake2_vars
ld hl,snake2ax
call do_snake
.beaver
call check_need_beaver
ld a,(beavery)
or a
ret z
call move_beaver
ld hl,(beaver_scroll)
ld a,(hl)
.beaver_ofs equ $ + 1
sub 0
ld (beaver_x),a
ld (beaverx),a
call beaver_collision
.beaver_spr equ $ + 1
ld a,#40
.beaver_dir equ $ + 1
add 0
.set_beaver
ld (beaver_x_addr),a
inc a:inc a
ld (beaver_y_addr),a
ret

.check_need_beaver
ld a,(beavery)
or a
ret nz
call random
ld b,a
ld a,(level)
add a:add a:add a:add #80
cp b
ret c
call random
and 7
cp 5
ret nc
ld c,a
add a:add a:inc a:add a:ld l,a
add a:add #2c
ld lx,a
ld h,items_water0 / 256
ld (beaver_scroll),hl
ld d,(hl)		; Current Scroll
ld a,c
add beaver_widths
ld l,a
ld h,beaver_widths / 256
ld e,(hl)		; Width
ld a,c
add a
add layout_data
ld l,a
ld h,layout_data / 256
ld a,(hl)		; Gap
add a:add a
sub #10
ld c,a
inc l
ld b,(hl)		; Num Items
ld a,d
.next_gap
sub e
ret c
sub c
jr c,use_gap
djnz next_gap
.use_gap
add c
ld b,a
ld a,d
ld (beaver_ofs),a
sub b
ld (beaver_min),a
add c
ld (beaver_max),a
call random
and #10
ld (beaver_dir),a
ld a,#40
ld (beaver_spr),a
ld (beaver_count),a
ld a,lx
ld (beavery),a
ret

.move_beaver
ld a,(beavery)
or a
ret z
.beaver_count equ $ + 1
ld a,8
dec a
and 7
ld (beaver_count),a
ret nz

.beaver_scroll equ $ + 1
ld de,0
ld a,(beaver_x)
ld b,a
ld hl,beaver_ofs
ld a,(beaver_dir)
or a
ld a,(de)
jr z,beaver_right

.beaver_max equ $ + 1
sub 0
cp b
jr nc,remove_beaver
inc (hl)
ret

.beaver_right
.beaver_min equ $ + 1
sub 0
cp b
jr c,remove_beaver
dec (hl)
ret

.remove_beaver
ld a,(dying)
or a
ret nz
ld (beaver_x),a
ld h,a
ld l,a
ld (beaverx),hl
pop hl
ret

.beaver_collision
ld hl,frogy
ld a,(beavery)
cp (hl)
ret nz
dec l
ld a,(beaver_dir)
or a
ld a,(beaver_x)
jr nz,beaver_left
add #18
.beaver_left
sub 4
sub (hl)
ret c
cp #10
ret nc
ld a,1
ld (dying),a
ld a,#48
ld (beaver_spr),a
ret

.do_snake
push hl
call check_need_snake
pop hl
call set_snake_sprite
call snake_move
call set_snake_x
ld a,(ix + snake_spr)
or a
ret z
.snake_sound
.done_snake_snd equ $ + 1
ld a,0
or a
ret nz
inc a
ld (done_snake_snd),a
ld a,21
jp playnew

.snake_maxx	equ 0
.snake_minx	equ 1
.snake_logx	equ 2
.snake_grsx	equ 3
.snake_y	equ 4
.snake_dir	equ 5
.snake_spr	equ 6
.snake_moved	equ 7
.snake_spr_cnt	equ 8
.snake_move_cnt	equ 9
.snake_needed	equ 10

.check_need_snake
dec (ix + snake_needed)
ret nz
ld a,(ix + snake_spr)
or a
ret nz
call random
ld b,a
ld a,(level)
add a:add a:add a:add #80
cp b
ret c
call random
and 3
jr z,use_grass

ld a,(items_water2)
ld b,a
ld de,#4440
ld a,(items_water2 + 1)
sub #10
jr c,use_grass

.check_log
sub e
jr c,use_log
sub d
jr c,use_grass
djnz check_log

.use_grass
ld (ix + snake_y),#7e
call random
rrca
jr nc,grass_right
ld (ix + snake_dir),0
ld (ix + snake_grsx),#f0
jr grass_left

.use_log		; Snake on log
add e
ld b,a
ld a,(items_water2 + 1)
ld (ix + snake_logx),a
sub b
ld (ix + snake_minx),a	; Turn left position
add e
ld (ix + snake_maxx),a	; Turn right position
ld (ix + snake_y),#4e	; Y for log

.grass_right
ld (ix + snake_dir),#20	; Facing right
ld (ix + snake_grsx),0	; Pos on grass

.grass_left
ld (ix + snake_spr_cnt),11
ld (ix + snake_move_cnt),8
ld a,1
jr snake_sprite

.set_snake_sprite
dec (ix + snake_spr_cnt)
ret nz
ld (ix + snake_spr_cnt),12
ld a,(ix + snake_spr)
or a
ret z
dec a

.snake_sprite
ld c,a
and 3
jr nz,no_spr_ovf
ld c,4
ld a,2
.no_spr_ovf
ld (ix + snake_spr),c
add a
add #ce
or (ix + snake_dir)
bit 3,l
jr nz,snake2_spr
ld (sprite2),a
inc a
ld (sprite3),a
ret

.snake2_spr
ld (sprite4),a
inc a
ld (sprite5),a
ret

.snake_move
ld a,(ix + snake_spr)
or a
ret z
.snake_bite equ $ + 1
ld a,0
dec a
ret z
dec (ix + snake_move_cnt)
ret nz
ld (ix + snake_move_cnt),8
ld (ix + snake_moved),1
ld a,(ix + snake_y)
cp #60
jr nc,snake_on_grass	; On log?

ld a,(ix + snake_dir)
or a
jr nz,snake_right_log

ld a,(items_water2 + 1)
sub (ix + snake_maxx)
ret c
cp (hl)
jr nc,snake_turn
inc (ix + snake_logx)
ret

.snake_right_log
ld a,(items_water2 + 1)
sub (ix + snake_minx)
cp (hl)
jr c,snake_turn
dec (ix + snake_logx)
ret

.snake_on_grass
ld a,(ix + snake_dir)
or a
jr z,snake_grass_left
ld a,2
jr snake_grass_move

.snake_grass_left
ld a,-2
.snake_grass_move
add (ix + snake_grsx)
ld (ix + snake_grsx),a
ret

.snake_turn
ld a,(ix + snake_dir)
xor #20
ld (ix + snake_dir),a
ld a,(ix + snake_spr)
jp snake_sprite

.set_snake_x
ld a,(ix + snake_spr)
or a
ret z
ld a,(ix + snake_y)
ld b,a
cp #60
jr nc,snake_on_grass2

ld a,(items_water2 + 1)
sub (ix + snake_logx)
jr snake_on_any

.snake_on_grass2
ld a,(ix + snake_grsx)

.snake_on_any
ld (hl),a
ld c,a
inc l
ld (hl),b
inc l:inc l
ld (hl),b
inc b
inc b
dec l
ld a,(ix + snake_dir)
or a
ld de,(frogx)
ld a,d
jr nz,snake_right

; Snake left
cp b
jr nz,no_snake_coll1
ld a,c
sub e
jr c,no_snake_coll1
cp #10
jr nc,no_snake_coll1

ld a,1
ld (dying),a
ld (snake_bite),a

.no_snake_coll1
ld a,#0f
add c
ld (hl),a
inc a
ret nz
jr snake_any_dir

.snake_right
cp b
jr nz,no_snake_coll2
ld a,c
add #10
sub e
jr c,no_snake_coll2
cp #10
jr nc,no_snake_coll2

ld a,1
ld (dying),a
ld (snake_bite),a

.no_snake_coll2
ld a,#f1
add c
ld (hl),a
ld a,c
or a
ret nz

.snake_any_dir
ld a,(ix + snake_moved)
or a
ret z
; Remove snake
xor a
ld (hl),a
inc l:inc l
ld (hl),a
ld (ix + snake_moved),a
ld (ix + snake_spr),a
ld (ix + snake_needed),32
ret

.croc_fly_move
call croc_collision
call open_shut_croc
call update_croc
call update_blue_frog
call check_car_noise
.bonus_time equ $ + 1
ld a,0
or a
jr z,no_hide_bonus
dec a
ld (bonus_time),a
jr nz,no_hide_bonus
dec a
ld (bluey),a
ld hl,blue_inks2
ld (blue_inks),hl
ld a,asic_on
ld i,a
ld b,#7f
out (c),a
ld hl,#fff0
ld (#6060),hl
ld (#6068),hl
ld a,asic_off
ld i,a
ld b,#7f
out (c),a
.no_hide_bonus
call inc_fly_pos
.fly_time equ $ + 1
ld a,0
inc a
ld (fly_time),a
.fly_or_mouth equ $ + 1
call check_fly
ld a,(frogy)
cp #31
jp c,check_home

.control_frog
ld a,(no_move)
or a
ret nz
.move_delay equ $ + 1
ld a,0
or a
jr z,do_move
dec a
ld (move_delay),a

.inc_fly_pos
.fly_pos equ $ + 1
ld a,0
inc a
cp 6
jr nz,notfly6
xor a
.notfly6
ld (fly_pos),a
ret

.do_move
ld a,(dying)
or a
ret nz

;A = 0
ld ix,ktab
ld de,frogy
ld hl,moving_down
ld bc,debounce_down
cp (hl)
jp nz,cont_down
bit 6,(ix + 3)
jp z,down2
bit 1,(ix + 9)
jp z,down2
ld (bc),a
inc l
inc c
cp (hl)
jp nz,cont_up
inc l
cp (hl)
jr nz,right_or_left2
inc l
cp (hl)
jr nz,right_or_left
bit 4,(ix + 3)
jp z,up2
bit 0,(ix + 9)
jp z,up2
ld (bc),a

.right_or_left
dec l
.right_or_left2
inc c
dec e
cp (hl)
jp nz,cont_right
bit 7,(ix + 7)
jp z,right2
bit 3,(ix + 9)
jp z,right2
ld (bc),a
inc c
inc l
cp (hl)
jp nz,cont_left
bit 7,(ix + 8)
jp z,left2
bit 2,(ix + 9)
jp z,left2
ld (bc),a
ret

.check_fly
jr z,set_fly
cp #70
ret nz
.clear_fly
ld a,(dying)
or a
ret nz
.fly_shown equ $ + 1
ld a,1
or a
ret z
ld c,a
add home - 1
ld l,a
xor a
ld b,a
ld (fly_shown),a
ld h,home / 256
ld a,(hl)
or a
ret nz

.clear_home
ld a,c
add a:add c:add a:add a:sub 10
ld d,a
ld e,4
jp clear_tile

.set_fly
ld e,a		; Zero
.set_mouth
ld a,(fly_pos)
ld (fly_shown),a
.do_fly_tile
or a
ret z
ld c,a
add home - 1
ld l,a
ld h,home / 256
ld a,(hl)
or a
ret nz
ld a,e
ld (fly_tile),a
jp home_tile

.check_mouth
ld e,49		; Mouth half open
jr z,set_mouth
cp #b0
jr z,clear_fly
cp #50
ret nz
ld e,37		; Full croc mouth open
ld a,(fly_shown)
jr do_fly_tile

.croc_collision
ld a,(croc_or_log)
or a
ret z
;ld a,(level)
;cp croc_first_level
;ret c
ld a,(frogy)
cp #2a - 8
ret c
cp #3b - 8
ret nc
ld a,(frogx)
add #08
ld b,a
ld a,(croc_pos)
ld c,a
add #08
cp b
ret c
ld a,c
sub #20
cp b
ret nc
ld a,c
sub #08
cp b
ld a,1
jp c,set_drown
ld (dying),a
ld hl,spr_croc_shut
ld (croc_row + #70),hl
ret

.open_shut_croc
ld a,(croc_pos)
or a
jr z,setshut
ld a,(croc_or_log)
or a
ret z
ld a,(croc_entering)
or a
ret nz
.shut_count equ $ + 1
ld a,0
inc a
ld hl,spr_croc_shut
cp #40
jr z,setcroc
cp #70
jr nz,setshut
ld hl,spr_croc_open
xor a
.setcroc
ld (croc_row + #70),hl
.setshut
ld (shut_count),a
ret

.update_croc
.croc_or_log equ $ + 1
ld c,0
ld a,(level)
cp croc_first_level
ret c
cp croc_always_level
jr c,less_always
ld c,0
.less_always
.croc_entering equ $ + 1
ld a,0
or a
jr nz,is_entering
ld a,(croc_pos)
or a
ret nz
ld a,c
xor 1
ld (croc_or_log),a
ld de,croc_row + #7f
ld hl,end_log
jr z,islog
ld hl,end_croc
.islog
ld a,(speeds + 1)
and #0f:add a:add a:add a
ld (croc_entering),a
ld (croc_count),a
.part_croc
ldd:ldd:ldd:ldd
ld (next_part),hl
ld (next_tile),de
ld a,e
sub croc_row + #5f
ret nz
ld (croc_entering),a
ret

.is_entering
dec a
ld (croc_entering),a
ret nz
.croc_count equ $ + 1
ld a,0
ld (croc_entering),a
.next_part equ $ + 1
ld hl,end_log
.next_tile equ $ + 1
ld de,croc_row + #7f
jr part_croc

.show_blue
ld a,(blue_shown)
or a
ret nz
ld a,(allow_blue)
xor 1
ld (allow_blue),a
jr nz,hide_blue
ld a,spr_blue_up
ld (sprite0),a
ld a,#60
ld (bluey),a
ld hl,blue_inks1
ld (blue_inks),hl
ld a,1
ld (blue_shown),a
ld (blue_step),a
ld a,60
ld (blue_count),a
jr update_blue

.hide_blue
ld a,(blue_shown)
or a
ret z
.clear_blue
xor a
ld (blue_shown),a
ld (blue_over),a
ld a,#ff
ld (bluex),a
ret

.update_blue_frog
.blue_over equ $ + 1
ld a,0
or a
jr nz,overlay_blue

ld a,(items_water3 + 1)
or a
jr z,show_blue
.allow_blue equ $ + 1
ld a,0
or a
jr nz,hide_blue
.blue_shown equ $ + 1
ld a,0
or a
ret z

.update_blue
call move_blue
ld hl,(frogx)
ld a,h
cp #5a
ret c
cp #68
ret nc
ld a,(bluex)
ld b,a
ld a,l
add 4
cp b
ret c
sub 8
cp b
ret nc
ld a,1
ld (blue_over),a
ld a,24
call playnew

.overlay_blue
ld hl,(frogx)
inc h:inc h
ld (bluex),hl
ld a,(sprite1)
add 8
ld (sprite0),a
ret

.move_blue
.blue_count equ $ + 1
ld a,0
or a
jr z,next_blue
dec a
ld (blue_count),a
cp 30
.blue_step equ $ + 1
ld a,0
jr z,face_blue
and #7f
inc a
add blue_log_ofs
ld l,a
ld h,blue_log_ofs / 256
ld a,(items_water3 + 1)
add (hl)
ld (bluex),a
ret

.face_blue
rra:rra
and #20
or spr_blue_left
ld (sprite0),a
ret

.next_blue
ld a,(blue_step)
bit 7,a
jr z,inc_blue
dec a:dec a
.inc_blue
inc a
ld (blue_step),a
and #7f
add blue_log_ofs
ld l,a
ld h,blue_log_ofs / 256
ld a,(hl)
cp 1
jr c,turn_blue
jr z,set_blue_count
ld hl,items_water3 + 1
add (hl)
ld (bluex),a
ret

.turn_blue
ld a,(blue_step)
xor #80
ld (blue_step),a
ld a,spr_blue_up
ld (sprite0),a
.set_blue_count
ld a,60
ld (blue_count),a
ret

.check_car_noise
ld a,(speeds + 13)
cp 2			; Previously checked between 2 and 14, But only uses #12,#02 and #01
ret nz
ld a,(car_pos)
or a
ret nz
ld a,23
jp playnew

.show_lives
ld de,#81ce
ld a,(lives)
cp 2
jr c,life_space
dec a
ld b,a
ld c,41
cp max_lives_shown
jr c,docharsde
ld b,max_lives_shown
.docharsde
call fastcharsde
.life_space
ld a,' '
jp fastcharde

.show_level
ld a,(level)
cp 15
jr c,less15
ld a,15
.less15
ld b,a
ld c,40
add a
ld e,a
ld d,0
ld hl,#8204
sbc hl,de
ex de,hl

.fastcharsde
push bc
ld a,c
call fastcharde
pop bc
djnz fastcharsde
ret

.frog_collision
;ld a,(new_frog)		; Not dying!
;or a
;ret nz
ld a,(frogy)
ld b,a
ld c,a
and #0f
cp 9
ld hx,1
call c,test_coll
ld a,(frogy)
add 15
ld c,a
ld b,0
and #0f
cp 5
ret c
ld hx,2

.test_coll
ld a,(dying)
or a
ret nz
ld a,c
rra:and #78
sub #18
ret c
cp #28
ret z
cp #58
ret nc
add width_water0
ld l,a
ld h,width_water0 / 256
ld c,(hl)
inc l
ld a,(frogx)
add 3
bit 7,b
jr nz,noadjx
add 9
.noadjx
ld d,a
add c
ld e,a
ld b,(hl)
jr c,wraptest

.normtest
inc hl
ld a,(hl)
cp d
jr c,fail1
cp e
jr c,collision
.fail1
djnz normtest

.nocoll
ld a,(frogy)
cp #80
ret nc

dec hx
ret z

.test_drown
cp #30
jr c,only_dying

.set_drown
ld hl,death_stages2
ld (death_stage),hl
.only_dying
ld (dying),a
ret

.collision
ld a,(frogy)
cp #80
jr nc,only_dying
dec hx
ret nz
pop hl
ret

.wraptest
inc hl
ld a,(hl)
cp d
jr nc,collision
cp e
jr c,collision
djnz wraptest
jr nocoll

.update_death
ld a,(dying)
or a
ret z
ld a,(croc_or_log)
;or a
;jr z,no_croc_need
ld (need_croc),a
;.no_croc_need
call hide_blue
ld hl,death_count
ld a,(hl)
inc a
and #f
ld (hl),a
ret nz
ld hl,(death_stage)
ld a,(hl)
inc hl
or a
jr z,done_dying
ld (death_stage),hl
or a
set 7,a
ld (sprite1),a
ret m
call stopsound
ld hl,0
ld (tune_count),hl
ld a,(sprite1)
cp spr_blow1
ld a,3
jp z,playnew
dec a
jp playnew

.death_stages
db spr_blow1 - #80,spr_blow1,spr_blow2,spr_blow3,spr_skull,0
.death_stages2
db spr_drown1 - #80,spr_drown2,spr_drown3,spr_skull,0

.done_dying
xor a
ld (dying),a
ld hl,moving_down
ld b,8
call clrmem
call clear_fly
ld a,6
ld (death_tune),a
ld hl,death_stages
ld (death_stage),hl
call clear_grass
ld a,(players)
or a
jr z,next_life
ld hl,lives
if inf_lives
  or (hl)
else
  dec (hl)
endif
push af
call to_p
pop af
ld a,(players)
jr z,isout
cp 2
jr nz,next_life

.swap_players
ld a,(player)
xor 1
ld (player),a
call clear_rows
call from_p
ld a,#11
ld (water1_int + 2),a
ld (water4_int + 2),a
call init_screen
call show_homes
call init_time
call show_level
call show_scores
ld hl,change_loop
ex (sp),hl
.next_life
call show_lives
ld bc,#bd1d
out (c),c
jp init_frog

.isout
or a
jr z,next_life		; Demo mode ???
push af
ld hl,game_over_msg
ld de,#8254
call fastprint
ld a,12
call playnew
ld a,13
call playnew
ld b,90
.over_lp
call wait
djnz over_lp
pop af
dec a
ld (players),a
jr nz,swap_players

call insert_highs
ld sp,stack_base
call clear_rows
call reset_scrolls
call show_scores
call show_credits
jp do_highs

.check_home
ld hl,(frogx)
ld c,1
ld a,l
cp #15
jr c,not_home
cp #1d
jr c,is_home
cp #45
jr c,not_home
inc c
cp #4d
jr c,is_home
cp #75
jr c,not_home
inc c
cp #7d
jr c,is_home
cp #a5
jr c,not_home
inc c
cp #ad
jr c,is_home
cp #d5
jr c,not_home
inc c
cp #dd
jr c,is_home

.not_home
ld a,h
cp #2a
jp nc,control_frog

.eaten_home
ld a,1
ld (dying),a
asic off
ret

.is_home
ld a,c
add home - 1
ld e,a
ld d,home / 256
ld a,(de)
or a
ret nz
ld a,h
cp #2a
jp nc,control_frog
asic on
ld a,l
and #f0
ld l,a:ld h,0
add hl,hl
ld b,#05		; Standard score for getting home
ld a,(fly_shown)
cp c
jr nz,no_fly
.fly_tile equ $ + 1
ld a,0
cp 37
jr z,eaten_home
or a
jr nz,no_fly
ld (#6060),hl		; Sprite 12 X
ld b,#25
.no_fly
ld a,(blue_over)
dec a
jr nz,noblue
ld (#6068),hl		; Sprite 13 X
ld (blue_over),a
ld (blue_shown),a
dec a
ld (bluex),a		; Clear blue frog
ld a,b
add #20
ld b,a
.noblue
ld a,b
ld (de),a
cp #05			; Still standard score?
jr z,no_bonus
ld a,#a0
ld (bonus_time),a	; Time for Bonus score (fly or blue frog)
.no_bonus
push bc
ld a,(time_decimal)
add b
daa
ld e,a
ld d,0
ld hl,num_home
inc (hl)
ld a,(hl)
cp 5
jr nz,doaddsc
call clear_blue
inc d
.doaddsc
call add_score_de
ld a,(players)
or a
jr z,no_show_time
ld hl,time_msg
call fast8290
ld a,(time_decimal)
call fast_dec_a
ld a,255
ld (start_clear),a
call stopsound
ld hl,0
ld (tune_count),hl
ld a,16
call playnew
ld a,(num_home)
cp 5
jr z,no_show_time

ld a,(tune8)
add 4
cp tune8end
jr nz,not40
ld a,tune8tab
.not40
ld (tune8),a
sub tune8tab
rrca
add tune_durations
ld l,a
ld h,tune_durations / 256
ld e,(hl)
inc l
ld d,(hl)
ld (tune_count),de 
ld a,8
call playnew
ld a,14
call playnew

.no_show_time
pop bc
ld e,12
call home_tile
ld a,#20
ld (no_move),a
ld a,#10
ld (move_delay),a
call init_frog	;Maybe do this in next loop
xor a
ld (moving_up),a
asic off
ret

.add_score_de
ld a,(players)
or a
ret z
ld hl,score
ld a,e
add (hl)
daa
ld (hl),a
ld e,a
inc hl
ld a,d
adc (hl)
daa
ld (hl),a
ld d,a
ld hl,(high)
or a
sbc hl,de
jr nc,no_high
ld (high),de
.no_high
ld hl,points_extra - 1
sbc hl,de
ret nc
ld hl,had_extra
ld a,(hl)
or a
ret nz
inc (hl)
ld hl,lives
ld a,(hl)
inc (hl)
cp max_lives_shown + 1
push af
ld a,7
call playnew
pop af
ret nc
ld de,#81cc
add a
add e
ld e,a
jr nc,noadjd
inc d
.noadjd
ld a,41
jp fastcharde

.do_scroll
ld b,0			; Frog row
ld lx,b
ld a,(frogy)
sub #30
cp #43
jr nc,ns_frog
ld c,a
and #f
cp 3
jr c,test_frog1
dec lx
cp 12
jr c,ns_frog
ld a,c
add #10
ld c,a
.test_frog1
ld a,c:and #f0
rrca:rrca:rrca:rrca
inc a
ld b,a
.ns_frog
ld a,b
add a
ld hl,scrolls + 1
add l
ld hx,a
ld de,speeds
ld c,items_water0
call scroll_right
ld c,items_water1
call scroll_left
ld c,items_water2
call scroll_right
ld c,items_water3
call scroll_right
ld c,items_water4
call scroll_left
ld c,items_road0
call scroll_left
ld c,items_road1
call scroll_right
ld c,items_road2
call scroll_left
ld c,items_road3
call scroll_right
ld c,items_road4
jp scroll_left

.demo_move
ld a,(no_move)
or a
ret nz
ld a,(dying)
and a
ret nz
ld hl,demo_count
ld a,(hl)
or a
jr z,next_move
dec (hl)
ret

.next_move
ld (hl),#30
.demo_step equ $ + 1
ld hl,0
ld e,(hl)
inc hl
ld d,(hl)
inc hl
ld (demo_step),hl
ld hl,frogy
ex de,hl
jp (hl)

.demo_steps
dw right,left,left,left,up,up,right,up
dw left,up,up,up,none,up,up,none
dw up,none,up,none,up,none,up,right
dw right,up,right,left,down,right,up,finish

.down2
ld a,(bc)
or a
ret nz
.down
ld a,(de)
cp #f0
ret nc
ld hl,moving_down
ld a,(hl)
or a
ret nz
call hop

.cont_down
ld a,(debounce_down)
or a
ret nz
dec (hl)
jr nz,adjust_down
inc a
ld (debounce_down),a
ld a,spr_frog_down1
ld (sprite1),a
ret

.adjust_down
ld a,(de)
add 2
ld (de),a
ld a,spr_frog_down2
ld (sprite1),a
ret

.up2
ld a,(bc)
or a
ret nz
.up
ld hl,moving_up
ld a,(hl)
or a
ret nz
call hop

.cont_up
call inc_fly_pos
ld a,(debounce_up)
or a
ret nz
dec (hl)
jr nz,adjust_up
inc a
ld (debounce_up),a
ld a,spr_frog_up1
ld (sprite1),a
ld a,(de)
cp #30
ret c
ld hl,frog_min_y
cp (hl)
ret nc
ld (hl),a
ld de,1
jp add_score_de

.adjust_up
ld a,(de)
sub 2
ld (de),a
ld a,spr_frog_up2
ld (sprite1),a
ret

.cont_move
xor a
ld de,frogy
ld hl,moving_down
ld bc,debounce_down
cp (hl)
jr nz,cont_down
ld (bc),a
inc hl
inc bc
cp (hl)
jr nz,cont_up
ld (bc),a
inc hl
inc bc
dec e
cp (hl)
jr nz,cont_right
ld (bc),a
inc hl
inc bc
cp (hl)
jr nz,cont_left
ld (bc),a
ret

.right2
ld a,(bc)
or a
ret nz
inc e
.right
ld a,(de)
cp #30
ret c
dec e
ld a,(de)
cp #e0
ret nc
ld hl,moving_right
ld a,(hl)
or a
ret nz
call hop

.cont_right
ld a,(debounce_right)
or a
ret nz
dec (hl)
jr nz,adjust_right
inc a
ld (debounce_right),a
ld a,spr_frog_right1		; Frog normal right
ld (sprite1),a
ret

.adjust_right
ld a,(de)
add 2
ld (de),a
ld a,spr_frog_right2		; Frog legs out right
ld (sprite1),a
ret

.left2
ld a,(bc)
or a
ret nz
inc e
.left
ld a,(de)
cp #30
ret c
dec e
ld a,(de)
cp #20
ret c
ld hl,moving_left
ld a,(hl)
or a
ret nz
call hop

.cont_left
ld a,(debounce_left)
or a
ret nz
dec (hl)
jr nz,adjust_left
inc a
ld (debounce_left),a
ld a,spr_frog_left1
ld (sprite1),a
ret

.adjust_left
ld a,(de)
sub 2
ld (de),a
ld a,spr_frog_left2
ld (sprite1),a
.none
ret

.hop
ld (hl),9
push de
push hl
ld a,4
call playnew
pop hl
pop de
ret

.finish
pop hl
call reset_scrolls
call hide_sprites
call clear_main
jp show_frogs

.update_turtles
ld hl,turtle_stage
ld a,(hl)
inc a
cp #30
jr nz,notts3
xor a
.notts3
ld (hl),a
rra:rra:rra
and #06
or #40
call set_turtle_base
ld de,spr_turtle3
cp #11
jr c,ist13
ld de,spr_turtle1
jr z,ist13
ld de,spr_turtle2
.ist13
ld hl,turtle_stage1
inc (hl)
ld a,(hl)
ld h,d
ld l,e
ld b,#d0
cp #50
call nc,get_turtles
ld (turtles1),hl
ld hl,turtle_stage4
ld a,(hl)
inc a:inc a
ld (hl),a
ex de,hl
cp #a0
jr nc,not4
add #50
ld b,#c0
call get_turtles
.not4
ld (turtles4),hl
ret

.get_turtles
cp #80
ld hl,sunk_turtle1
ret c
cp b
ret nc
ld hl,sunk_turtle2
cp #a0
ret c
cp #b0
ret nc
ld hl,0
ret

.do_turtles
ld a,(frame)
or a
jr nz,do_turtles
.turtle_base equ $ + 1
ld a,0
ld (water1_int + 2),a
ld (water4_int + 2),a
ld a,(scrolls + 2)
dec a
add a
ld hx,a 
ld a,(last_turtles1)
ld e,a
.row1_base equ $ + 1
ld d,#40
ld b,2
.turtles1 equ $ + 1
ld hl,sunk_turtle1
call sunk_turtles

ld a,(scrolls + 8)
dec a
add a
ld hx,a
ld a,(last_turtles4)
ld e,a
.row4_base equ $ + 1
ld d,#41
ld b,3
.turtles4 equ $ + 1
ld hl,sunk_turtle2

.sunk_turtles
ld a,h
or l
jr z,sunk_clear

.draw_turtle
push bc
push hl
res 6,e
ld a,e
sub hx
jp p,t1ok
set 6,e
.t1ok
call fasttile2
add #84:ld e,a
ld d,b:res 5,d
pop hl
pop bc
djnz draw_turtle
ret

.sunk_clear
ld h,b
.sunk_clear_lp
res 6,e
ld a,e
sub hx
jp p,t2ok
set 6,e
.t2ok
call clear_fast
ld a,e:add #84:ld e,a
ld d,b:res 5,d
dec h
jr nz,sunk_clear_lp
ret

.init_demo
call init_vars
call init_time
call hide_sprites
call reset_scrolls
call init_palette
call init_screen
call init_frog
call set_layout
call draw_row_items
ld hl,demo_steps
ld (demo_step),hl
ret

.init_frog
ld hl,#e080
ld (frogx),hl
ld a,spr_frog_up1
ld (sprite1),a
ld a,h			; E0
ld (frog_min_y),a
ld (snake_bite),a	; So snake keeps moving
ld a,1
ld (need_time),a
ret

.croc_tile
or a
ld e,#c
rra:rr e
rra:rr e
add sprites / 256
ld d,a

.set_croc_tile
dec l
ld (hl),d
dec l
ld (hl),e
dec l
ld (hl),d
dec l
dec e
ld (hl),e
dec l
ld (hl),d
dec l
dec e
ld (hl),e
dec l
ld (hl),d
dec l
dec e
ld (hl),e
ret

.draw_row_items
ld hl,croc_row
ld de,half_blank
.croc_row_lp
ld (hl),e:inc l
ld (hl),d:inc l
jr nz,croc_row_lp
ld ix,(layout_data)	; LX = Gap, HX = count
ld a,(need_croc)
or a
jr z,croc_row_lp2
ld l,#f8
ld bc,croc
jr place_croc
.croc_row_lp2
ld bc,medium_log
ld a,(bc):inc bc
call croc_tile
.place_croc
ld a,(bc):inc bc
call croc_tile
ld a,(bc):inc bc
call croc_tile
ld a,(bc)
call croc_tile
ld a,l:sub lx:sub lx:ld l,a
dec hx
jr nz,croc_row_lp2

ld bc,layout_data
ld de,#8404		; Screen base & log length
ld hl,medium_log
ld ix,items_water0
call draw_row
ld de,#4002
ld hl,turtle3
ld lx,items_water1
call draw_row
ld a,(last_item)
ld (last_turtles1),a
dec bc:dec bc
ld de,#4202
ld hl,turtle1
call draw_row
dec bc:dec bc
ld de,#4402
ld hl,turtle2
call draw_row
ld de,#8506
ld hl,long_log
ld lx,items_water2
call draw_row
ld de,#8603
ld hl,short_log
ld lx,items_water3
call draw_row
ld de,#4103
ld hl,turtle3
ld lx,items_water4
call draw_row
dec bc:dec bc
ld a,(last_item)
ld (last_turtles4),a
ld de,#4303
ld hl,turtle1
call draw_row
dec bc:dec bc
ld de,#4503
ld hl,turtle2
call draw_row
ld de,#8702
ld hl,truck
ld lx,items_road0
call draw_row
ld de,#4601
ld hl,fast_car
ld lx,items_road1
call draw_row
ld de,#4701
ld hl,sedan
ld lx,items_road2
call draw_row
ld de,#c601
ld hl,dozer
ld lx,items_road3
call draw_row
ld de,#c701
ld hl,race_car
ld lx,items_road4

.draw_row
ld a,e
ld (item_length),a
push ix
push hl
push bc
call clear_row
pop bc
pop hl
ld a,(bc)
inc bc
ld (gap_size),a
ld a,(bc)
inc bc
push bc
ld b,a			; Num items
ld e,#3c
.row_loop
push bc
push hl
ld a,e
add 4			; This seems to be the right value
add a:add a		; First item = #f8
ld (ix + 1),a
inc ix
ld a,(need_croc)
dec a
jr nz,norm_item
ld (need_croc),a
ld e,#38
ld hl,croc
ld b,3
call item_lp
jr finish_row
.norm_item
call do_item
.finish_row
ld a,e
.gap_size equ $ + 1
sub 0
ld e,a
pop hl
pop bc
djnz row_loop
push hl
ld e,#40
ld h,d:ld l,0
call copy_row
pop hl
pop bc
pop de
ld a,lx
sub e
ld (de),a
ld lx,e
ret

.do_item
.item_length equ $ + 1
ld b,0
.item_lp
ld a,e
ld (last_item),a
ld a,(hl)
inc hl
push bc
push hl
call fasttile
sub #84
ld e,a
ld d,b
res 5,d
pop hl
pop bc
djnz item_lp
ret

.copy_row
call row_copy
ld a,d:sub #40:ld d,a
ld a,h:sub #40:ld h,a
set 7,e
set 7,l

.row_copy
push de
push hl
ld bc,#40
ldir
pop hl
ld a,h:add 8:ld h,a
pop de
ld a,d:add 8:ld d,a
and #38
jr nz,row_copy
ret

.clear_row
ld e,0
call clear_row_part
ld e,#80

.clear_row_part
ld h,d
ld l,e
inc e
ld bc,#3f
ld (hl),b
ldir
res 6,e
ld a,d:add 8:ld d,a
and #38
jr nz,clear_row_part
ld a,d:sub #40:ld d,a
ret

.init_screen
ld a,(player)
or a
ld a,#40
jr z,is_score1
ld a,#62
.is_score1
ld (score_pos),a
ld e,16
call grass_row
ld e,28
call grass_row
ld de,#80ae
ld hl,#2f2c
ld bc,#2b30
call grass_top
ld hl,#310a
ld bc,#2d30
call grass_top
ld h,#2e
ld bc,#2a2c

.grass_top
ld hx,10
ld (grass_mid),bc
.grass_top_lp
push hl
call part_top
.grass_mid equ $ + 1
ld hl,0
call part_top
pop hl
jr nz,grass_top_lp
inc e:inc de
ret

.part_top
ld c,#ff
ld a,h
call charde
dec hx
ret z
ld a,l
call charde
ld a,l
call charde
or h
ret

.set_layout
ld a,(layout)
ld b,a:add a:add a:add b:add a:add a	; * 20
add layout1info
ld l,a
ld a,layout1info / 256
adc 0
ld h,a
ld de,layout_data
ld bc,20
ldir
ret

.init_palette
ld hl,#4f0
ld (ink1_line3),hl
ld hl,#d20
ld (ink2_line3),hl
ld hl,#d0f
ld (ink3_line3),hl
ld hl,sprite_inks + 14
xor a
call set_row_pal
ld a,2
call set_row_pal
ld a,3
call set_row_pal
ld hl,pal_turtles
ld a,1
call set_row_pal
ld a,4
call set_row_pal
ld a,6
call set_row_pal
ld a,7
call set_row_pal
ld a,9
call set_row_pal
ld hl,sprite_inks + 8
ld a,8
call set_row_pal
ld hl,sprite_inks + 20
ld a,10
call set_row_pal
ld hl,#09f
ld (ink1_line1c),hl
ld hl,#00f
ld (ink2_line1c),hl
ld hl,#0f0
ld (ink3_line1c),hl
ld hl,pal_grass
ld a,5
jp set_row_pal

.grass_row
ld c,#ff
ld h,50
push de
call grass_lp
pop de
inc e
inc h:inc h
.grass_lp
ld d,0
descr
ld l,14
.grass_lp2
ld a,h
call charde
ld a,h
inc a
call charde
dec l
jr nz,grass_lp2
ret

.down_time
ld a,(dying)
or a
ret nz
.death_tune equ $ + 1
ld a,0
or a
jr z,no_death_tune
call playnew
xor a
ld (death_tune),a
ld hl,140
ld (tune_count),hl
.no_death_tune
.need_time equ $ + 1
ld a,0
or a
call nz,reset_time
ld hl,time_count
dec (hl)
ret nz
ld (hl),#20
inc hl
ld a,(hl)
or a
jp z,time_over
dec a
daa
ld (hl),a
cp #10
jr nz,not_low
push hl
ld hl,#ddf
ld (ink3_line1f),hl
ld hl,#0f0
ld (ink2_line1f),hl
ld a,5
call playnew
pop hl
.not_low
inc hl
inc (hl)
ld a,(hl)
or a
rra
ld l,a
ld h,#82
ld a,#03
jr nc,first_two
xor a
.first_two
ld (hl),a:ld h,#8a
ld (hl),a:ld h,#92
ld (hl),a:ld h,#9a
ld (hl),a:ld h,#a2
ld (hl),a:ld h,#aa
ld (hl),a:ld h,#b2
ld (hl),a:ld h,#ba
ld (hl),a
ret

.time_over
ld a,1
ld (dying),a
ld hl,time_over_msg
jp fast8290

.init_time
call clear_bottom
ld hl,#ff0
ld (ink3_line1e),hl
ld hl,#0ff
ld (ink1_line1e),hl
ld hl,#d20
ld (ink2_line1e),hl
ld c,#ff
ld de,#8238
call print
db "TIME",0

.reset_time
ld hl,#ff0
ld (ink3_line1f),hl
ld hl,#d20
ld (ink2_line1f),hl
ld hl,#821a
.time_row
push hl
ld b,30
ld a,#0f
.draw_time
ld (hl),a
inc l
djnz draw_time
pop hl
ld a,h
add 8
ld h,a
cp #c0
jr c,time_row
ld hl,#6020
ld (time_count),hl
ld a,#1a * 2 - 1
ld (time_pos),a
xor a
ld (need_time),a
ret

.printscore
ld c,#0f
ld a,(scorepos1)
cp lx
jr z,highlight
ld a,(scorepos2)
cp lx
jr z,highlight
ld c,#ff
.highlight
ex (sp),hl
call print_hl
ex (sp),hl
ld hl,6
add hl,de
ex de,hl
ld l,(ix + 0)
ld h,(ix + 1)
inc ix
inc ix
call show_score
call print
db " PTS",0
ret

.konami
ld hl,#ddf
ld (ink3_line1c),hl
ld de,#8166
call print
db "KONAMI  c  1981",0
ret

.frogger_tiles
db 38,39,40,46,46,47,39,0

.gethop
xor 3
and 3
add 16
cp 19
ret nz
ld a,16
ret

.gethop2
add 4
and #0c
ld bc,spr_frog_up2 * #100 + #38	;#c138
ret z
cp #0c
ret z
cp #04
ld bc,spr_frog_up1 * #100 + #18	;#c018
ret z
ld bc,spr_frog_up3 * #100 + #58	;#db58
ret

.set_frog_pal
ld hl,sprite_inks + 2

.set_row_pal	; Row in A, Palette in HL
ld b,a:add a:add a:add b:add a:add b
add water0_int + 5
ld e,a
ld a,water0_int / 256
adc 0
ld d,a
ld c,d
push hl
ldi:ldi:ldi:ldi:ldi:ldi
pop hl
ret

.show_scores
ld c,#0f
ld de,#8008
ld a,1
call n_up
ld e,#14
call print
db "HI-SCORE",0
ld e,#2a
.player_scores equ $ + 1
ld a,1
cp 2
call z,n_up
ld e,#40
ld c,#ff
ld hl,(score1)
call show_score
ld e,#50
ld hl,(high)
call show_score
ld a,(player_scores)
cp 2
ret nz
ld e,#62
ld hl,(score2)

.show_score
call show_dec_hl
xor a
jp show_digit

.n_up
call charde
call print
db "-UP",0
ret

.show_credits
ld hl,#d0f
ld (ink3_line1f),hl
call clear_bottom
ld de,#822c
ld c,#ff
call print
db "CREDIT ",0
.show_num_credits
ld de,#823a
ld c,#ff
.credits equ $ + 1
ld a,0
jp show_dec_a

.do_croc_mouth
ld de,#8438
ld a,(scrolls)
cp #1e
jr c,mouth_left
ld e,#78
.mouth_left
ld hl,(croc_row + #70)
jp fasttile2

.do_croc
ld hl,scrolls + 1
ld a,(hl):dec l
ld b,a
cp #88
ld a,(hl)
rla
sub 4
and #3f
ld c,a
add a
add #80
ld l,a
ld h,croc_row / 256
ld e,(hl):inc l
ld d,(hl):inc l
ex de,hl
ld d,#84
bit 1,b
jr z,no40
set 6,c
.no40
ld e,c

.tile_column
ld c,l
ld b,d
ld a,(hl):ld (de),a:set 2,l:set 3,d
ld a,(hl):ld (de),a:ld l,c:set 3,l:ld d,b:set 4,d
ld a,(hl):ld (de),a:set 2,l:set 3,d
ld a,(hl):ld (de),a:set 4,c:ld l,c:set 5,b:ld d,b
ld a,(hl):ld (de),a:set 2,l:set 3,d
ld a,(hl):ld (de),a:ld l,c:set 3,l:ld d,b:set 4,d
ld a,(hl):ld (de),a:set 2,l:set 3,d
ld a,(hl):ld (de),a
set 7,e:ld a,l:add 4:ld l,a:ld c,l:res 5,b:ld d,b
.part_tile_column
ld a,(hl):ld (de),a:set 2,l:set 3,d
ld a,(hl):ld (de),a:ld l,c:set 3,l:ld d,b:set 4,d
ld a,(hl):ld (de),a:set 2,l:set 3,d
ld a,(hl):ld (de),a:set 4,c:ld l,c:set 5,b:ld d,b
ld a,(hl):ld (de),a:set 2,l:set 3,d
ld a,(hl):ld (de),a:ld l,c:set 3,l:ld d,b:set 4,d
ld a,(hl):ld (de),a:set 2,l:set 3,d
ld a,(hl):ld (de),a
ret

.draw_scores
ld hl,(score)
.score_pos equ $ + 1
ld de,#8040
ld c,#ff
call fast_dec_hl
ld hl,(high)
ld e,#50

.fast_dec_hl
ld a,h
call fast_dec_a
ld a,l
.fast_dec_a
ld h,a
rrca
rrca
rrca
rrca
call fast_digit
ld a,h
.fast_digit
and #f

.fastcharde
push hl
add a:add a:ld l,a
ld h,0
add hl,hl:add hl,hl
ld a,h:add chars / 256:ld h,a
ld c,h
ld b,d
ldi
ld a,(hl):inc l:ld (de),a:set 3,d
ld a,(hl):inc l:ld (de),a:dec e
ld a,(hl):inc l:ld (de),a:ld d,b:set 4,d
ldi
ld a,(hl):inc l:ld (de),a:set 3,d
ld a,(hl):inc l:ld (de),a:dec e
ld a,(hl):inc l:ld (de),a:set 5,b:ld d,b
ldi
ld a,(hl):inc l:ld (de),a:set 3,d
ld a,(hl):inc l:ld (de),a:dec e
ld a,(hl):inc l:ld (de),a:ld d,b:set 4,d
ldi
ld a,(hl):inc l:ld (de),a:set 3,d
ld a,(hl):inc l:ld (de),a:dec e
ldi
ld hl,-#3800 + 1
add hl,de
ex de,hl
pop hl
ret

.init_vars
xor a
ld (player),a
ld (blue_shown),a
ld (blue_over),a
ld (death_tune),a
ld (demo_count),a
ld (need_start),a
ld (start_clear),a
ld hl,score + 2
ld b,end_vars - score - 2
call clrmem
jr set_speed

.check_speed
ld a,(croc_entering)
or a
ret nz
ld a,(items_road4 + 1)
or a
ret nz
ld hl,speed_count
ld a,(hl)
or a
jr nz,dec_speed_count
ld (hl),21
dec hl
ld a,(hl)
inc a
cp 10
jr nz,new_speed
xor a
ld (hl),a
ret

.new_speed
ld (hl),a
dec a

.set_speed	; Speed in A
ld b,a
add a:add a:add b:add a
add speed_tab
ld l,a
ld h,speed_tab / 256
ld de,speeds + 1
ldi:inc e:ldi:inc e:ldi:inc e:ldi:inc e:ldi:inc e
ldi:inc e:ldi:inc e:ldi:inc e:ldi:inc e:ldi
ret

.dec_speed_count
dec (hl)
ret

.scroll_right
ld a,(de)
or a
jr nz,delay_right
inc e
ld a,(de)
dec e
bit 4,a
jr nz,delay_right

.do_scroll_right
ld b,a
add a
add (hl)
cp #90
jr nc,right_over
ld (hl),a
.frog_right
xor a
ld (de),a
inc e:inc e
inc l:inc l
push hl
ld a,l
cp hx
jr nz,no_r_frog
ld hl,frogx
ld a,(hl)
add b
ld (hl),a
sub #e7
cp #21
jr nc,no_r_frog
ld a,lx
inc a
jr z,no_r_frog
ld (dying),a
.no_r_frog
ld l,c
ld c,b
ld h,items_water0 / 256
ld b,(hl):inc l
.right_items
ld a,(hl)
add c
ld (hl),a
inc l
djnz right_items
pop hl
ret

.right_over
sub #10
ld (hl),a
dec l
ld a,(hl)
rlca:sub 2:rrca:and #9f
ld (hl),a
inc l
jr frog_right

.delay_right
and #f
cp 1
jr z,do_scroll_right
dec a
ld (de),a
inc e:inc e
inc l:inc l
ret

.scroll_left
ld a,(de)
or a
jr nz,delay_left
inc e
ld a,(de)
dec e
bit 4,a
jr nz,delay_left

.do_scroll_left
ld b,a
ld a,(hl)
sub b
sub b
jp p,left_over
ld (hl),a
.frog_left
xor a
ld (de),a
inc e:inc e
inc l:inc l
push hl
ld a,l
cp hx
jr nz,no_l_frog
ld hl,frogx
ld a,(hl)
sub b
ld (hl),a
sub #e7
cp #21
jr nc,no_l_frog
ld a,lx
inc a
jr z,no_l_frog
ld (dying),a
.no_l_frog
ld l,c
ld c,b
ld h,items_water0 / 256
ld b,(hl):inc l
.left_items
ld a,(hl)
sub c
ld (hl),a
inc l
djnz left_items
pop hl
ret

.left_over
add #10
ld (hl),a
dec l
ld a,(hl)
rlca:add 2:rrca:and #9f
ld (hl),a
inc l
jr frog_left

.delay_left
and #f
cp 1
jr z,do_scroll_left
dec a
ld (de),a
inc e:inc e
inc l:inc l
ret

list
.tab_size equ 11 * 5 + 6
.space_size equ -tab_size - $ and #ff
nolist
ds space_size
.int_table
;; Format +0: Prev data - Raster int.
;;        +1: Split-Scan, +2: Split-Address (2), +4: Soft-scroll,
;;        +5: Ink 1, +7: Ink 2: +9: Ink 3
.water0_int
db #2e,#2f,#22,#00,#82:dw #f0f,#00f,#ddf
.water1_int
db #3e,#3f,#10,#00,#84:dw #808,#008,#ddf
.water2_int
db #4e,#4f,#22,#80,#86:dw #404,#004,#ddf
.water3_int
db #5e,#5f,#23,#00,#88:dw #c0c,#00c,#ddf
.water4_int
db #6e,#6f,#10,#80,#8a:dw #f0f,#00f,#ddf
list
.grass_int
nolist
db #7e,#7f,#21,#1f,#80:dw #0ff,#d20,#ddf
.road0_int
db #8e,#8f,#23,#80,#82:dw #f0f,#000,#ddf
.road1_int
db #9e,#9f,#13,#00,#84:dw #808,#008,#ddf
.road2_int
db #ae,#af,#13,#80,#86:dw #404,#004,#ddf
.road3_int
db #be,#bf,#33,#00,#88:dw #c0c,#00c,#ddf
.road4_int
db #ce,#cf,#33,#80,#8a:dw #f0f,#00f,#ddf
.end_int_tab

.clear_grass
ld hl,grass_msg
.fast8290
ld de,#8290
.fastprint
ld a,(hl)
or a
ret z
inc hl
call fastcharde
jr fastprint

.print_hl
ld a,(hl)
inc hl
or a
ret z
call charde
jr print_hl

.show_dec_hl
ld a,h
call show_dec_a
ld a,l
.show_dec_a
ld h,a
rrca
rrca
rrca
rrca
call show_digit
ld a,h
.show_digit
and #f

.charde		; Char A to DE, C = AND Mask
push hl
add a:add a:ld l,a
ld h,0
add hl,hl:add hl,hl
ld a,h:add chars / 256:ld h,a
ld b,d
ld a,(hl):inc l:and c:ld (de),a:inc e
ld a,(hl):inc l:and c:ld (de),a:set 3,d
ld a,(hl):inc l:and c:ld (de),a:dec e
ld a,(hl):inc l:and c:ld (de),a:ld d,b:set 4,d
ld a,(hl):inc l:and c:ld (de),a:inc e
ld a,(hl):inc l:and c:ld (de),a:set 3,d
ld a,(hl):inc l:and c:ld (de),a:dec e
ld a,(hl):inc l:and c:ld (de),a:set 5,b:ld d,b
ld a,(hl):inc l:and c:ld (de),a:inc e
ld a,(hl):inc l:and c:ld (de),a:set 3,d
ld a,(hl):inc l:and c:ld (de),a:dec e
ld a,(hl):inc l:and c:ld (de),a:ld d,b:set 4,d
ld a,(hl):inc l:and c:ld (de),a:inc e
ld a,(hl):inc l:and c:ld (de),a:set 3,d
ld a,(hl):inc l:and c:ld (de),a:dec e
ld a,(hl):inc l:and c:ld (de),a
ld hl,-#3800 + 2
add hl,de
ex de,hl
pop hl
ret

.wait	; Wait for B frames
xor a
ld (frame),a
.frame equ $ + 1
.wait_frame
cp 0
jr z,wait_frame
ret

.priorities
db 5,10,13,24,7,14,12,6,21,20,19,16,15,4,22,3,18,17,2,9,8,1,22,23

list
.before_chars
align 256
nolist

read "chars.asm"
list
.end_chars
nolist
.scrolls
db #01,#80, #01,#80, #81,#80, #01,#80, #81,#80
db #81,#80, #01,#80, #81,#80, #01,#80, #81,#80
.end_scrolls

.soundtab
dw sound1,sound2,sound3,sound4,sound5,sound6,sound7,sound8
dw sound9,sound10,sound11,sound12,sound13,sound14,sound15,sound16
dw sound17,sound18,sound0,sound0,sound21,sound22,sound23,sound24

.sprite_inks
dw #000, #0ff, #d20, #ff0, #f90, #d0f, #4ff, #6d5
dw #ddf, #695, #0f0, #ff0, #09f, #00f, #0f0, #ddf
.blue_inks1 equ sprite_inks + 8
.blue_inks2 equ sprite_inks + 26

.pal1 equ $ - 2
dw #4ff, #ddf

.pal_grass
dw #09f, #00f, #0f0

.pal_turtles equ $ - 2
dw #ddf, #d20

.def_scrolls
db #01,#80, #01,#80, #81,#80, #01,#80, #81,#80
db #81,#80, #01,#80, #81,#80, #01,#80, #81,#80

list
.pad1
align 256
nolist

.bases
dw #7ffc,#8036, #8070,#80aa, #80e4,#811e
.r1base equ $ + 5
.r4base equ $ + 17
dw #8400,#8480, #4000,#4080, #8500,#8580, #8600,#8680, #4100,#4180
dw #823c,#8276
dw #8700,#8780, #4600,#4680, #4700,#4780, #c600,#c680, #c700,#c780
dw #8156,#8190, #81ca,#8204

.spritepos	;Do not move!!
.bluex		db 0	; Sprite 0
.bluey		db 0
.frogx		db 0	; Sprite 1
.frogy		db 0
.snake1ax	db 0	; Sprite 2
.snake1ay	db 0
.snake1bx	db 0	; Sprite 3
.snake1by	db 0
.snake2ax	db 0	; Sprite 4
.snake2ay	db 0
.snake2bx	db 0	; Sprite 5
.snake2by	db 0
.beaverx	db 0	; Beaver (Sprites 8 - 11)
.beavery	db 0

.croc
db 37,36,35

.long_log
db 8,7,7,7,7,6

.medium_log
db 8,7,7,6

.short_log
db 8,7,6

.turtle1
db 2,2,2

.turtle2
db 3,3,3

.turtle3
db 4,4,4

.truck
db 28,27

.fast_car
db 25

.sedan
db 1

.dozer
db 26

.race_car
db 5

list
.pad2
align #80
nolist
.croc_row
ds #80

list
.start_sprites
nolist

read "sprites.asm"
list
.end_sprites
nolist

.layout1info	; Gap, Number
db 6,3, 6,4, 8,2, 8,3, 4,4	; River
db 14,2, 6,1, 12,3, 12,3, 14,3	; Road

.layout2info
db 6,3, 4,5, 8,1, 6,3, 12,3	; River
db 14,3, 6,2, 14,4, 12,4, 14,4	; Road

.layout3info
db 6,2, 8,4, 8,1, 12,3, 6,3	; River
db 10,3, 14,2, 10,5, 14,4, 12,4	; Road

.layout4info
db 6,2, 10,3, 8,1, 14,2, 8,3	; River
db 8,4, 12,3, 14,4, 10,4, 14,4	; Road

.layout5info
db 6,1, 14,3, 8,1, 10,2, 14,2	; River
db 6,3, 10,4, 8,5, 12,4, 10,5	; Road

.moving_down	db 0
.moving_up	db 0
.moving_right	db 0
.moving_left	db 0
.debounce_down	db 0
.debounce_up	db 0
.debounce_right	db 0
.debounce_left	db 0

.speeds
ds 20

; This is page-aligned
.width_water0	db #3c
.items_water0	ds 7	;4
.width_water1	db #1f
.items_water1	ds 7	;6
.width_water2	db #5c
.items_water2	ds 7	;3
.width_water3	db #2c
.items_water3	ds 7	;4
.width_water4	db #2f
.items_water4	ds 7	;5
.unused_1	ds 8
.width_road0	db #22
.items_road0	ds 7	;5
.width_road1	db #12
.items_road1	ds 7	;5
.width_road2	db #12
.items_road2	ds 7	;6
.width_road3	db #12
.items_road3	ds 7	;5
.width_road4	db #12
.items_road4	ds 7	;6
.end_items

.croc_pos 	equ items_water0 + 1
.car_pos	equ items_road1 + 1

.speed_tab
db #13,#12,#11,#16,#12, #12,#13,#14,#15,#16
db #12,#13,#12,#15,#01, #13,#02,#12,#13,#12
db #12,#12,#13,#14,#12, #12,#01,#13,#12,#13
db #12,#01,#12,#13,#13, #12,#02,#12,#01,#14
db #13,#12,#01,#12,#12, #12,#01,#01,#12,#13
db #13,#01,#12,#13,#13, #01,#02,#12,#13,#12
db #12,#12,#13,#12,#12, #12,#01,#13,#12,#13
db #13,#13,#12,#13,#01, #13,#02,#12,#01,#12
db #12,#12,#13,#12,#12, #12,#01,#01,#12,#13
db #13,#01,#12,#01,#13, #01,#02,#12,#13,#13
db #12,#12,#01,#12,#12, #01,#01,#13,#12,#12

.layout_data
ds 20

.turtle_stage	db 0
.turtle_stage1	db 0
.turtle_stage4	db 0
.last_turtles1	db 0	; E for last turtles - row 1
.last_turtles4	db 0	; E for last turtles - row 4
.frog_min_y	db 0
.no_move	db 0	; Count for no move when home

.time_count	db #20
.time_decimal	db #60
.time_pos	db #54

.dying		db 0

.demo_count	db 0
.death_count	db 0
.death_stage	dw death_stages

.scorepos1	db highs + 6
.scorepos2	db highs + 10

.high   dw #0463
.highs  dw #0463,#0205,#0197,#0158,#0127
dw 0

.last_item	db 0

.beaver_widths
db #50,#30,#70,#40,#40

list
.pad3
align 256
nolist
.DMA_PAL equ #00
.DMA_PAH equ #01
.DMA_PBL equ #02
.DMA_PBH equ #03
.DMA_PCL equ #04
.DMA_PCH equ #05
.DMA_PNS equ #06
.DMA_EN  equ #07
.DMA_AMA equ #08
.DMA_AMB equ #09
.DMA_AMC equ #0a
.DMA_PEV equ #0b
.DMA_EVT equ #0c

.DMA_PAU equ #10
.DMA_REP equ #20
.DMA_NOP equ #4000
.DMA_LP  equ #4001
.DMA_INT equ #4010
.DMA_STP equ #4020

.sound0
ret

.sound1
ld a,9:ld (iy + 1),a
ld (hl),a:inc l:ld (hl),c:inc l
ld (hl),18:inc l:ld (hl),b:inc l
ld a,32:ld (iy + 0),a
ld (hl),a:inc l:inc b:ld (hl),b:inc l
ld a,sound1b
.setcont
pop bc:dec c:dec c:ld (bc),a:dec sp:dec sp
ret

.sound1b
dec (iy + 0)
ret nz
ld a,(iy + 1)
dec a
jr z,sound24
ld (iy + 0),32
ld (iy + 1),a
ld (hl),a:inc l:ld (hl),c:inc l
ret

.sound24
ld a,#ad
ld (hl),a:inc l:ld (hl),b:inc l
ld (iy + 2),a
ld (iy + 3),a
ld a,1
ld (hl),a:inc l:inc b:ld (hl),b:inc l
ld (iy + 4),a
ld (hl),8:inc l:ld (hl),c:inc l
ld (iy + 0),3
ld (iy + 1),20
ld a,sound1c
jr setcont

.sound1c
dec (iy + 0)
ret nz
ld (iy + 0),3
ld a,(iy + 2):sub 4:ld (iy + 2),a
ld (hl),a:inc l:ld (hl),b:inc l
jr nc,nos1h
xor a
ld (hl),a:inc l:inc b:ld (hl),b:inc l
.nos1h
dec (iy + 1)
ret nz
ld a,sound1d
jr setcont

.sound1d
ld (iy + 1),20
ld a,(iy + 3):sub 18
jr nc,nodc1d
dec (iy + 4)
.nodc1d
ld (hl),a:inc l:ld (hl),b:inc l
ld e,(iy + 4)
ld (hl),e:inc l:inc b:ld (hl),b:inc l
cp #8d
jr z,end1d
ld (iy + 3),a
ld (iy + 2),a
ld a,sound1c
jp setcont

.end1d
ld a,8
.setamptoend
ld (iy + 0),a
ld a,amptoend
jp setcont

.amptoend
ld a,(iy + 0)
dec a
ld (iy + 0),a
ld (hl),a:inc l:ld (hl),c:inc l
or a
ret nz
.setnop
ld de,sound0
ld (iy + #7f),0
.setcontde
pop bc
dec c
ld a,d
ld (bc),a
dec c
ld a,e
ld (bc),a
dec sp
dec sp
ret

.check5
ld a,(iy + #7f)
sub 5
jr nz,zeroampend
ld (playing5),a
.zeroampend
xor a
ld (hl),a:inc l:ld (hl),c:inc l
jr setnop

.setdelay
ld (iy + 0),b
ld (iy + 1),e
ld (iy + 2),d
ld de,delay
jr setcontde

.delay
dec (iy + 0)
ret nz
ld e,(iy + 1)
ld d,(iy + 2)
jr setcontde

list
align 256
.sound2
nolist
ld (hl),62:inc l:ld (hl),b:inc l
ld (hl),0:inc l:inc b:ld (hl),b:inc l
ld (hl),14:inc l:ld (hl),c:inc l
ld de,sound2b
ld b,16
jr setdelay

.sound2b
ld de,sound2c
ld b,64
.amp0delay
xor a
.ampadelay
ld (hl),a:inc l:ld (hl),c:inc l
jr setdelay

.sound2c
ld (hl),33:inc l:ld (hl),b:inc l
ld de,sound2d
ld b,16
ld a,11
jr ampadelay

.sound2d
ld de,sound2e
ld b,32
jr amp0delay

.sound2e
ld a,143:ld (iy + 0),a
ld (hl),a:inc l:ld (hl),b:inc l
ld a,10
ld (iy + 1),a
ld (hl),a:inc l:ld (hl),c:inc l
ld a,sound2f
jp setcont

.sound2f
ld a,(iy + 0)
dec a
ld (iy + 0),a
ld (hl),a:inc l:ld (hl),b:inc l
cp 143 - 64
ret nz
ld a,(iy + 1)
dec a
jp z,zeroampend
ld (iy + 1),a
ld (hl),a:inc l:ld (hl),c:inc l
ld a,sound2g
jp setcont

.sound2g
ld a,(iy + 0)
inc a
ld (iy + 0),a
ld (hl),a:inc l:ld (hl),b:inc l
cp 143
ret nz
ld a,sound2f
jp setcont

.sound3
ld (hl),10:inc l:ld (hl),c:inc l
ld (iy + 0),#90
ld (iy + 1),#02
ld a,143:ld (iy + 2),a
ld (hl),a:inc l:ld (hl),b:inc l
xor a:ld (iy + 3),a
ld (hl),a:inc l:inc b:ld (hl),b:inc l
ld a,sound3b
jp setcont

.sound3b
ld a,(iy + 0)
dec a
ld (iy + 0),a
jr z,s3bz
inc a
jr nz,s3bnc
dec (iy + 1)
.s3bnc
and 1
ld e,a
inc e
ld a,(iy + 2)
add e
ld (iy + 2),a
ld (hl),a:inc l:ld (hl),b:inc l
ret nc
ld a,(iy + 3)
inc a
ld (iy + 3),a
ld (hl),a:inc l:inc b:ld (hl),b:inc l
ret

.s3bz
or (iy + 1)
jr nz,s3bnc
jp zeroampend

align 2
.dma_reset
db 0,8, 0,9, 0,10, 0,0, 0,1, 0,2, 0,3, 0,4, 0,5, 0,6
db #38,DMA_EN, 0,8, 0,9, 0,10, 0,11, 0,12, 0,13:dw DMA_STP

list
align 256
.sound4
nolist
ld a,(playing5)
or a
jp nz,zeroampend
ld bc,tune_hop
ld e,cont4
jr start_tune4

.sound5
ld a,1
ld (playing5),a		; TODO - Need to clear 5
ld bc,tune_low_time
jr start_tune

.sound6
ld bc,tune_camptown_ladies
jr start_tune

.sound14
ld a,(tune8)
add 2
jr tune14

.sound9
xor a
ld (playing5),a
ld bc,tune9
jr start_tune

.sound10
ld bc,tune10
jr start_tune

.sound11
ld bc,tune11
jr start_tune

.sound12
ld bc,tune12
jr start_tune

.sound13
ld bc,tune13
jr start_tune

.sound15
xor a
ld (playing5),a
ld bc,tune15
jr start_tune

.sound17
xor a
ld (playing5),a
ld bc,tune17
jr start_tune

.sound18
ld bc,tune18
jr start_tune

.sound22
ld bc,tune22
jr start_tune

.sound8
.tune8 equ $ + 1
ld a,tune8end - 4
.tune14
ld e,a
ld d,tune8tab / 256
ld a,(de)
ld c,a
inc e
ld a,(de)
ld b,a

.start_tune
ld e,cont_tune
.start_tune4
ld a,(bc):add a:dec a:inc c:ld (iy + 4),a	; Base note
ld a,(bc):inc c:ld (iy + 5),a			; Tempo
ld a,(bc):inc c:ld (iy + 6),a			; Amplitude
ld (iy + 2),c:ld (iy + 3),b
ld (iy + 0),1:ld (iy + 1),1
ld a,e
jp setcont 

.cont4
ld a,(playing5)
or a
jp nz,zeroampend

.cont_tune
dec (iy + 1)
ret nz
ld a,(iy + 5)
ld (iy + 1),a
ld a,(iy + 0)
dec a
jr z,new_note
ld (iy + 0),a
and 1
ret z
ld a,(iy + 7)
sub 1
ret m
ld (iy + 7),a
ld (hl),a:inc l:ld (hl),c:inc l
ret

.new_note
ld e,(iy + 2)
ld d,(iy + 3)
ld a,(de)
or a
jp z,check5
inc e
ld (iy + 2),e
ld e,a
ld d,durations / 256
ld a,(de)
ld (iy + 0),a
ld a,e
and #1f
jr z,note_amp
add (iy + 4)
add a
ld e,a
ld d,periods / 256
ld a,(de):inc e
ld (hl),a:inc l:ld (hl),b:inc l
ld a,(de)
ld (hl),a:inc l:inc b:ld (hl),b:inc l
ld a,(iy + 6)
.note_amp
ld (iy + 7),a
ld (hl),a:inc l:ld (hl),c:inc l
ret

.sound7c
ld a,(iy + 3)
dec a
ld (iy + 3),a
ld (hl),a:inc l:ld (hl),c:inc l
or a
ret nz
dec (iy + 4)
jp z,zeroampend
ld de,sound7b
ld b,12
jp setdelay

.sound7
ld (iy + 4),16
ld (hl),45:inc l:ld (hl),b:inc l
xor a
ld (iy + 3),a
ld (hl),a:inc l:inc b:ld (hl),b:inc l
ld (hl),a:inc l:ld (hl),c:inc l
ld a,sound7b
jp setcont

.sound7b
ld a,(iy + 3)
inc a
ld (iy + 3),a
ld (hl),a:inc l:ld (hl),c:inc l
cp #0d
ret nz
ld de,sound7c
ld b,8
jp setdelay

.sound16
ld a,45:ld (hl),a:inc l:ld (hl),b:inc l
ld (iy + 5),a
xor a:ld (hl),a:inc l:inc b:ld (hl),b:inc l
ld (iy + 4),9
ld (iy + 7),18
.sound16c
ld (hl),13:inc l:ld (hl),c:inc l
ld a,sound16b
jp setcont

.sound16b
dec (iy + 4)
jr z,end16b
ld a,(iy + 5)
xor 45 xor 51
ld (iy + 5),a
ld (hl),a:inc l:ld (hl),b:inc l
ret

.end16b
ld a,(iy + 7)
add a
ld (iy + 7),a
cp 144
jp z,zeroampend
ld (iy + 4),9
ld de,sound16c
ld b,a
jp amp0delay

.sound21
ld (hl),0:inc l:inc b:ld (hl),b:inc l:dec b
.start21
ld a,143:ld (hl),a:inc l:ld (hl),b:inc l
ld (iy + 5),a
ld (hl),6:inc l:ld (hl),c:inc l
ld (iy + 4),8
ld a,sound21b
jp setcont

.sound21b
dec (iy + 4)
ret nz
ld (iy + 4),8
ld a,(iy + 5)
sub 9
cp 31
jr c,end21b
ld (iy + 5),a
ld (hl),a:inc l:ld (hl),b:inc l
ret

.end21b
ld (hl),0:inc l:ld (hl),c:inc l
ld (iy + 4),4
ld de,sound21c
ld b,31
jp setdelay

.sound21c
ld a,54:ld (hl),a:inc l:ld (hl),b:inc l
ld (iy + 5),a
ld (hl),2:inc l:ld (hl),c:inc l
ld de,sound21d
ld b,4
jp setdelay

.sound21d
ld (hl),4:inc l:ld (hl),c:inc l
ld a,sound21e
jp setcont

.sound21e
dec (iy + 4)
ret nz
ld (iy + 4),4
ld a,(iy + 5)
add 9
cp 214
jr nc,start21
ld (iy + 5),a
ld (hl),a:inc l:ld (hl),b:inc l
ret

.s23change
ld (iy + 0),#68
bit 0,(iy + 2)
jr nz,s23down
ld a,(iy + 1)
inc a
ld (iy + 1),a
cp 7
jr nz,s23cont
ld (iy + 2),1
jr s23cont

.sound23
ld e,c
ld d,noiseen / 256
ld a,(de)
ld (senable),a
ld (hl),13:inc l:ld (hl),6:inc l
ld (hl),a:inc l:ld (hl),7:inc l
ld a,4
ld (hl),a:inc l:ld (hl),c:inc l
ld (iy + 0),#68
ld (iy + 1),a
ld (iy + 2),a
ld a,sound23b
jp setcont

.sound23b
ld e,(iy + 0)
dec e
ld (iy + 0),e
jr z,s23change
.s23cont
ld a,e
and #04
jr z,s23vol0
ld a,(iy + 1)
.s23vol0
ld (hl),a:inc l:ld (hl),c:inc l
ret

.s23down
ld a,(iy + 1)
sub 1
ld (iy + 1),a
jr nc,s23cont

.end23
ld a,#38
ld (hl),a:inc l:ld (hl),7:inc l
jp zeroampend

.soundst0
ld de,sound0
ld a,#08
ld b,#01 xor #ff
jr soundst

.soundst1
ld de,sound0
ld a,#10
ld b,#02 xor #ff
jr soundst

.soundst2
ld de,sound0
ld a,#20
ld b,#04 xor #ff

.soundst
ld (hl),0
inc l
ld (hl),c
inc l
.senable equ $ + 1
ld c,#38
or c
and b
cp c
jp z,setcontde
ld (senable),a
ld (hl),a
inc l
ld (hl),7
inc l
jp setcontde

list
align 256
.durations
nolist
ds #20,#80, #20,#01, #20,#02, #20,#04, #20,#08, #20,#10, #20,#20, #20,#40

.periods
dw #04b4,#0470,#0431,#03f4
dw #03bb,#0386,#0353,#0323
dw #02f7,#02cc,#02a4,#027e
dw #025a,#0238,#0218,#01fa
dw #01de,#01c3,#01aa,#0192
dw #017b,#0166,#0152,#013f
dw #012d,#011c,#010c,#00fd
dw #00ef,#00e2,#00d5,#00c9
dw #00bd,#00b3,#00a9,#009f
dw #0096,#008e,#0086,#007f
dw #0078,#0071,#006a,#0065
dw #005f,#0059,#0054,#0050
dw #004b,#0047,#0043,#003f
dw #003c,#0038,#0035,#0032
dw #002f,#002d,#002a,#0028

.tune_hop
db #0f,#05,#09
db #6d,#71,#74,#79,#d6,0

.tune_low_time
db #02,#07,#09
db #94,#8d,#88,#94,#8d,#88,#94,#8d
db #88,#94,#8d,#c8,0

.tune_camptown_ladies
db #0b,#0f,#06
db #8f,#60,#6f,#93,#96,#bb,#a0,#98
db #60,#78,#9b,#98,#b6,#a0,0

.tune8a0
db #0b,#10,#06, #9b,#60
db #7d,#bb,#a6,#9b,#60,#7d,#bb,#b8
db #9b,#60,#7b,#bd,#80,#9b,#99,#93
db #b8,#a0,#8f,#60,#6f,#8f,#93,#b6
db #8f,#60,#6f,#8f,#94,#b8,#9b,#60
db #7b,#bd,#80,#9b,#99,#93,#b4,#a0
db 0

.tune8a1
db #0b,#10,#06, #98,#60,#77,#b8
db #b4,#98,#60,#77,#b8,#b4,#98,#60
db #76,#b5,#80,#95,#96,#97,#b4,#a0
db #8f,#60,#6f,#8f,#93,#b6,#8f,#60
db #6d,#8c,#8f,#b4,#98,#60,#76,#b4
db #80,#93,#8f,#8d,#ac,#a0,0

align 256

.tune8b0
db #0b,#10,#06, #8d,#96
db #b6,#80,#97,#b6,#94,#8d,#b4,#8d
db #97,#b7,#80,#99,#b7,#96,#8d,#b6
db #96,#99,#b9,#80,#9b,#b9,#97,#96
db #94,#92,#91,#94,#9b,#99,#97,#91
db #d2,#a0,0

.tune8b1
db #0b,#10,#06, #8d,#92,#b2,#80
db #91,#b2,#91,#8d,#b1,#8d,#94,#b4
db #80,#96,#b4,#92,#8d,#b2,#92,#96
db #b6,#80,#97,#b6,#94,#92,#91,#8f
db #8d,#91,#97,#96,#94,#8d,#d2,#a0
db 0

.tune8c0
db #0b,#10,#06, #c0,#a0
db #94,#60,#75,#96,#9e,#96,#9e,#b6
db #96,#60,#75,#94,#9d,#94,#9d,#b4
db #9d,#60,#73,#b2,#bb,#b9,#b8,#b9
db #bb,#bd,#94,#60,#75,#96,#92,#96
db #92,#b6,#96,#60,#79,#94,#99,#94
db #99,#bd,#94,#60,#74,#b4,#bb,#b9
db #b8,#d9,#c0,0

.tune8c1
db #05,#10,#06, #e0,#b2,#80,#8d
db #92,#ad,#92,#ad,#80,#88,#8d,#a8
db #8d,#a8,#80,#88,#88,#a8,#88,#ad
db #80,#88,#8d,#94,#91,#8d,#b2,#80
db #8d,#92,#ad,#92,#ad,#80,#88,#8d
db #a8,#8d,#88,#94,#83,#94,#88,#94
db #88,#94,#e0,0

.tune8e0
db #0b,#10,#06, #98,#98
db #98,#98,#98,#98,#96,#98,#99,#b1
db #80,#b1,#b1,#96,#96,#96,#96,#b6
db #94,#96,#98,#af,#80,#af,#af,#98
db #98,#98,#98,#98,#98,#96,#98,#99
db #99,#99,#99,#b1,#91,#94,#93,#b3
db #80,#8f,#8f,#98,#96,#d4,#a0,0

align 256

.tune8e1
db #05,#10,#06, #a8,#80,#88,#c8
db #aa,#80,#8a,#ca,#af,#80,#8f,#cf
db #b4,#80,#8f,#af,#ac,#a8,#80,#88
db #c8,#aa,#80,#8a,#ca,#a3,#80,#83
db #c3,#a8,#c0,0

.tune8d0
db #0b,#10,#06, #b8,#80
db #96,#96,#94,#b3,#b1,#80,#af,#8d
db #ac,#ca,#af,#b6,#db,#9b,#80,#8c
db #8d,#af,#b8,#94,#80,#8c,#8d,#af
db #b8,#94,#80,#98,#99,#b8,#b6,#b8
db #b6,#d4,#a0,0

.tune8d1
db #05,#10,#06, #a3,#80,#af,#8f
db #af,#a3,#80,#af,#8f,#af,#a3,#af
db #af,#af,#a3,#af,#8f,#8f,#83,#83
db #a8,#b4,#a8,#b4,#a8,#b4,#a8,#b4
db #aa,#b3,#af,#b3,#b4,#af,#88,#80
db 0

.tune8f0
db #0b,#10,#06, #94,#60
db #72,#91,#94,#b9,#9b,#99,#96,#99
db #af,#9b,#60,#79,#98,#60,#76,#94
db #94,#96,#94,#d4,#94,#60,#72,#91
db #94,#b9,#9b,#99,#96,#99,#af,#9b
db #60,#79,#98,#60,#76,#94,#94,#96
db #98,#d9,0

.tune8f1
db #0b,#10,#06, #94,#60,#72,#91
db #94,#b9,#98,#94,#92,#91,#b2,#92
db #60,#76,#94,#60,#74,#92,#92,#92
db #92,#d1,#94,#60,#72,#91,#94,#b9
db #98,#94,#92,#91,#b2,#92,#60,#76
db #94,#60,#74,#92,#92,#92,#92,#d1
db 0

.tune8h0
db #0b,#10,#06, #94,#99
db #99,#9b,#9b,#9d,#9d,#98,#9b,#b9
db #b6,#b4,#80,#92,#91,#8f,#91,#92
db #94,#b4,#99,#98,#94,#96,#98,#b9
db #80,#92,#91,#8f,#91,#92,#94,#b4
db #99,#98,#94,#96,#98,#b9,0

; Boundary
.tune8g0
db #0b,#10,#06, #88,#86
db #65,#68,#6d,#71,#b4,#80,#92,#71
db #74,#6d,#71,#a8,#80,#91,#6f,#72
db #6c,#6f,#a8,#80,#92,#71,#74,#6d
db #71,#a8,#88,#60,#66,#65,#68,#6d
db #71,#b4,#8d,#60,#6b,#6a,#6d,#72
db #76,#b9,#98,#96,#94,#60,#71,#96
db #60,#71,#94,#60,#71,#72,#68,#6c
db #6f,#b4,#80,#92,#71,#68,#6d,#71
db #b4,#80,#91,#6f,#68,#71,#60,#6f
db #68,#71,#60,#6f,#68,#74,#60,#d9
db 0

.tune8l0
db #0b,#10,#06, #8f,#60
db #6f,#8f,#60,#6f,#91,#60,#71,#93
db #60,#73,#74,#74,#74,#60,#94,#60
db #76,#d8,#b9,#b9,#98,#60,#b9,#60
db #8f,#60,#6f,#91,#60,#d2,#60,#94
db #60,#76,#94,#60,#72,#91,#60,#71
db #92,#60,#d4,#60,#a0,#74,#76,#78
db #60,#b9,#b9,#98,#60,#b9,#60,#8f
db #60,#6f,#91,#60,#72,#80,#60,#76
db #94,#60,#73,#94,#80,#b2,#b1,#8f
db #60,#cd,0

.tune8l1
db #05,#10,#06, #b9,#b9,#b9,#b9
db #b8,#b2,#b1,#af,#ad,#b4,#b6,#b6
db #b6,#b6,#b6,#b6,#b8,#b8,#b8,#b8
db #b4,#b1,#bd,#b4,#b4,#b4,#b6,#b6
db #b6,#b6,#b6,#b6,#98,#80,#a0,#b6
db #b4,0

.tune8h1
db #0b,#10,#06, #94,#94,#94,#94
db #94,#94,#94,#92,#92,#b1,#b3,#b4
db #80,#8f,#8d,#8c,#8d,#8f,#8f,#8f
db #b4,#92,#92,#92,#92,#b1,#80,#8f
db #8d,#8c,#8d,#8f,#8f,#8f,#b4,#92
db #92,#92,#92,#b1,0

align 256
;Boundary
.tune8g1
db #0b,#10,#06, #a0,#ad,#ac,#a0
db #aa,#a8,#a0,#a6,#a5,#a0,#a8,#a6
db #a0,#ad,#a7,#a0,#aa,#a8,#a0,#a5
db #a6,#a5,#a8,#a6,#a0,#a8,#a5,#a0
db #a6,#a8,#a6,#c5,0

.tune8i0
db #0b,#10,#06, #87,#60
db #68,#aa,#80,#8f,#8e,#60,#6c,#ca
db #8f,#60,#6f,#6e,#71,#94,#9a,#60
db #78,#96,#8e,#8f,#93,#8a,#80,#87
db #60,#68,#aa,#80,#8f,#8e,#60,#6c
db #ca,#8f,#60,#6f,#6e,#71,#94,#9a
db #60,#78,#96,#8e,#cf,0

.tune8i1
db #0b,#10,#06, #87,#60,#68,#aa
db #80,#8f,#8e,#60,#6c,#ca,#8f,#60
db #6f,#6e,#6e,#91,#96,#60,#74,#91
db #88,#87,#88,#87,#80,#87,#60,#68
db #aa,#80,#87,#88,#60,#68,#c7,#8f
db #60,#6f,#6e,#6e,#91,#96,#60,#74
db #91,#88,#c7,0

.tune8k0
db #0b,#11,#06, #b4,#91
db #8d,#b9,#98,#96,#b4,#99,#91,#8f
db #b4,#80,#94,#94,#94,#94,#96,#94
db #91,#8d,#99,#99,#99,#99,#9b,#99
db #96,#92,#94,#94,#94,#94,#96,#94
db #91,#8d,#99,#99,#99,#99,#9b,#99
db #96,#92,#94,#91,#80,#91,#b9,#b1
db #94,#cf,0

.tune8k1
db #05,#11,#06, #d9,#d6,#d9,#d8
db #8d,#91,#88,#91,#8d,#91,#88,#91
db #8d,#92,#8a,#92,#8d,#92,#8a,#92
db #8d,#91,#88,#91,#8d,#91,#88,#91
db #8d,#92,#8a,#92,#8d,#92,#8a,#92
db #8d,#91,#88,#91,#8d,#91,#88,#91
db #8f,#94,0

.tune8m1
db #0b,#01,#06,0

align 256

.tune8j0
db #0b,#10,#06, #8a,#8f
db #8e,#91,#aa,#8c,#8e,#8f,#93,#aa
db #8a,#8f,#8e,#91,#aa,#8c,#8e,#8f
db #93,#aa,#87,#60,#68,#aa,#80,#8f
db #8e,#60,#6c,#ca,#8f,#60,#6f,#6e
db #71,#94,#9a,#60,#78,#96,#8e,#cf
db 0

.tune8j1
db #0b,#10,#06, #8a,#87,#88,#88
db #a8,#88,#88,#87,#8a,#a7,#87,#87
db #88,#88,#a8,#88,#88,#87,#8a,#a7
db #87,#60,#68,#aa,#80,#87,#88,#60
db #68,#c7,#8f,#60,#6f,#6e,#6e,#91
db #96,#60,#74,#91,#88,#c7,0

.tune8m0
db #0b,#10,#06, #92,#97
db #97,#99,#9b,#97,#9b,#99,#92,#97
db #97,#99,#9b,#b7,#96,#92,#97,#97
db #99,#9b,#9c,#9b,#99,#97,#96,#92
db #94,#96,#b7,#97,#80,0

.tune8n0
db #0b,#10,#06, #94,#60
db #76,#94,#92,#94,#96,#b7,#92,#60
db #74,#92,#90,#8f,#90,#92,#80,#94
db #60,#76,#94,#92,#94,#96,#97,#94
db #94,#97,#96,#99,#b7,#97,#80,0

.tune8n1
db #0b,#10,#06, #90,#60,#70,#90
db #92,#90,#90,#b0,#8f,#60,#70,#8f
db #8d,#8b,#8b,#8b,#80,#90,#60,#70
db #90,#92,#90,#90,#90,#90,#8f,#92
db #92,#90,#af,#8f,#80,0

.tune8p0
db #0b,#10,#06, #8a,#af
db #8e,#8c,#aa,#80,#8a,#ac,#ae,#af
db #8a,#8a,#8c,#8a,#88,#87,#8c,#8a
db #88,#87,#a5,#aa,#aa,#80,0

.tune8p1
db #0b,#10,#06, #8a,#af,#8e,#8c
db #aa,#80,#8a,#a9,#a8,#a7,#87,#83
db #88,#87,#85,#83,#a3,#a5,#a1,#80
db 0

align 256

.tune8o0
db #0b,#10,#06, #72,#74
db #b6,#96,#b6,#96,#b7,#96,#b6,#7b
db #7b,#b9,#96,#96,#94,#92,#b4,#94
db #b4,#80,#b6,#96,#b6,#96,#b7,#96
db #b6,#9b,#b9,#96,#94,#96,#94,#b2
db #92,#b2,#80,0

.tune8o1
db #0b,#10,#06, #72,#74,#b6,#8d
db #8d,#8f,#8d,#af,#92,#b2,#80,#ad
db #8d,#8f,#91,#92,#b2,#91,#b1,#72
db #74,#b6,#8d,#8d,#8f,#8d,#af,#92
db #b2,#97,#b6,#92,#91,#92,#9d,#aa
db #8a,#aa,#80,0

.tune8r0
db #0b,#10,#06, #8f,#93
db #b6,#b6,#bb,#9a,#98,#96,#96,#93
db #94,#96,#80,#ba,#98,#98,#94,#98
db #96,#96,#9b,#9b,#9a,#98,#96,#9a
db #9b,#80,#8f,#93,#b6,#b6,#bb,#9a
db #98,#96,#96,#93,#94,#96,#80,#ba
db #98,#98,#94,#98,#96,#96,#9b,#9b
db #9a,#98,#96,#9a,#9b,#80,#a0,0

.tune8r1
db #0b,#10,#06, #8f,#8f,#b3,#b3
db #b8,#96,#94,#93,#93,#8f,#91,#93
db #80,#b6,#94,#94,#8f,#94,#93,#93
db #93,#93,#96,#93,#8f,#91,#93,#80
db #8f,#8f,#b3,#b3,#b8,#96,#94,#93
db #93,#8f,#91,#93,#80,#b6,#94,#94
db #8f,#94,#93,#93,#93,#93,#96,#93
db #8f,#91,#93,#80,#a0,0

.tune8s0
db #0b,#10,#06, #8d,#92
db #96,#b9,#99,#96,#b7,#97,#94,#b6
db #b9,#80,#96,#97,#99,#bb,#9b,#9b
db #9b,#99,#9b,#9c,#dd,#a0,#9d,#9d
db #bd,#9b,#99,#bb,#99,#97,#9b,#80
db #b9,#a0,#96,#97,#b9,#98,#99,#bb
db #99,#97,#d6,0

align 256

;Boundary
.tune8s1
db #0b,#10,#06, #8d,#92,#96,#b6
db #96,#92,#b4,#94,#91,#b2,#b6,#80
db #92,#94,#96,#b7,#97,#97,#97,#96
db #97,#98,#d9,#a0,#99,#99,#b9,#97
db #96,#b7,#96,#94,#97,#80,#b6,#a0
db #92,#94,#b6,#95,#96,#b7,#96,#94
db #d2,0

.tune8q0
db #0b,#10,#06, #8a,#87
db #8a,#8a,#8a,#8c,#8a,#8a,#8a,#87
db #8a,#8a,#8a,#8c,#8a,#8a,#8a,#af
db #b1,#93,#60,#6f,#8f,#8f,#b1,#ae
db #af,#80,0

.tune8q1
db #0b,#10,#06, #87,#83,#87,#87
db #87,#86,#87,#87,#87,#83,#87,#87
db #87,#87,#85,#87,#88,#aa,#aa,#8a
db #60,#67,#87,#8a,#a8,#a8,#a7,#80
db 0

.tune8t0
db #0b,#10,#06, #8c,#b1
db #91,#94,#b8,#80,#8c,#90,#90,#90
db #93,#b6,#a0,#b6,#98,#96,#94,#94
db #93,#91,#93,#93,#94,#96,#b8,#a0
db #96,#76,#74,#96,#76,#74,#ac,#b0
db #d1,0

.tune8t1
db #05,#10,#06, #80,#b1,#b1,#b1
db #b1,#ac,#ac,#ac,#ac,#aa,#aa,#aa
db #aa,#ac,#ac,#ac,#ac,#8a,#80,#8a
db #80,#ac,#ac,#b1,0

.tune9
db #0b,#14,#07, #91,#8d
db #8d,#8d,#91,#8d,#8d,#8d,#92,#92
db #91,#91,#af,#a0,#92,#92,#91,#91
db #8f,#8f,#96,#96,#94,#92,#91,#8f
db #ad,#a0,0

.tune10
db #05,#14,#07, #8d,#91,#88,#91
db #8d,#91,#88,#91,#8f,#92,#88,#92
db #8f,#92,#88,#92,#8f,#92,#88,#92
db #8f,#92,#88,#92,#8f,#92,#88,#92
db #b1,#a0,0

align 256

.tune11
db #05,#14,#07, #80,#8d,#80,#8d
db #80,#8d,#80,#8d,#80,#8f,#80,#8f
db #80,#8f,#80,#8f,#80,#8f,#80,#8f
db #80,#8f,#80,#8f,#80,#8f,#80,#8f
db #ad,#a0,0

.tune12
db #0c,#0a,#07, #ad,#80
db #8a,#b2,#b2,#b6,#74,#72,#71,#6f
db #cd,#ab,#ad,#a8,#ad,#aa,#ad,#c6
db 0

.tune13
db #06,#0a,#07, #aa,#ad,#aa,#ad
db #a6,#ad,#aa,#ad,#a8,#ad,#ab,#ad
db #a6,#ad,#ca,0

.tune18
db #0b,#11,#07, #85,#88,#85,#88
db #85,#88,#85,#88,#85,#88,#85,#88
db #85,#88,#85,#88,#85,#88,#85,#88
db #85,#88,#85,#88,#86,#88,#86,#88
db #c5,0

.tune15
db #0b,#11,#05, #b4,#91
db #8d,#b9,#98,#96,#b4,#99,#91,#8f
db #b4,#80,#80,#94,#94,#94,#94,#91
db #8f,#8d,#80,#99,#99,#99,#9b,#99
db #98,#96,#94,#91,#80,#91,#b9,#b1
db #94,#cf,#80,#a0,#80,#91,#91,#92
db #94,#96,#98,#d6,#c0,#80,#92,#92
db #94,#b6,#98,#99,#d8,#a0,#b4,#d9
db #99,#98,#96,#94,#d8,#b6,#b6,#b4
db #bb,#b9,#b8,#d9,#c0,#99,#99,#99
db #99,#99,#99,#98,#96,#d9,#b4,#91
db #91,#af,#8f,#8f,#99,#99,#98,#96
db #d6,#d4,#94,#91,#91,#91,#b1,#8f
db #8d,#92,#91,#92,#94,#b6,#a0,#94
db #92,#8f,#8f,#af,#8d,#8c,#8d,#8c
db #8d,#8f,#d1,#94,#91,#91,#91,#b1
db #8f,#8d,#92,#91,#92,#94,#b6,#98
db #96,#b4,#94,#96,#94,#92,#91,#8f
db #ca,#ac,#af,#cd,#c0,0

align 256
.tune22
db #05,#11,#05, #d9,#d6,#d9,#d8
db #8d,#91,#88,#91,#8d,#91,#88,#91
db #8d,#92,#8a,#92,#8d,#92,#8a,#92
db #8d,#91,#88,#91,#8d,#91,#88,#91
db #8f,#94,#88,#94,#8a,#94,#8c,#94
db #8d,#91,#88,#91,#8d,#91,#88,#91
db #8d,#92,#8a,#92,#8d,#92,#8a,#92
db #8d,#92,#8a,#92,#8d,#92,#8a,#92
db #8f,#94,#88,#94,#8f,#94,#88,#94
db #8d,#91,#88,#91,#8d,#91,#88,#91
db #8d,#91,#89,#91,#8a,#92,#8f,#92
db #8f,#94,#88,#94,#8f,#94,#88,#94
db #8d,#91,#88,#91,#ad,#a0,#d2,#c0
db #d1,#c0,#df,#c0,#d2,#d2,#8d,#91
db #88,#91,#8d,#91,#88,#91,#8d,#92
db #8a,#92,#8d,#92,#8a,#92,#8f,#94
db #88,#94,#8f,#94,#88,#94,#8d,#91
db #88,#91,#8d,#91,#88,#91,#8d,#91
db #88,#91,#8d,#91,#88,#91,#8d,#92
db #8a,#92,#8d,#92,#8a,#92,#8f,#94
db #88,#94,#8f,#94,#88,#94,#d2,#d4
db #8d,0

.tune8tab
dw tune8a0,tune8a1, tune8b0, tune8b1
dw tune8c0,tune8c1, tune8d0, tune8d1
dw tune8e0,tune8e1, tune8f0, tune8f1
dw tune8g0,tune8g1, tune8h0, tune8h1
dw tune8i0,tune8i1, tune8j0, tune8j1
dw tune8k0,tune8k1, tune8l0, tune8l1
dw tune8m0,tune8m1, tune8n0, tune8n1
dw tune8o0,tune8o1, tune8p0, tune8p1
dw tune8q0,tune8q1, tune8r0, tune8r1
dw tune8s0,tune8s1, tune8t0, tune8t1
.tune8end

align 256
.noiseen
ds 8:db #31,#2a,#1c

.tune17
db #0b,#11,#07, #8d,#8f
db #91,#92,#b4,#b1,#8d,#8f,#91,#8f
db #ad,#ad,#8d,#8f,#91,#92,#b4,#b1
db #94,#92,#91,#8f,#cd,0

.tune_durations
dw 453,453,746,587,587,533,640,453,453,453
dw 613,746,427,427,533,533,320,640,640,587

.blue_log_ofs
db #00,#ee,#ec,#ea,#e8,#e6,#e4,#e2
db #e0,#01,#de,#dc,#da,#d8,#d6,#d4
db #d2,#d0,#00,#d0

.player 	db 0

;P1 data
.score		dw #0158
.layout		db 0
.level		db 0
.lives		db 0
.num_home	db 0
.home		ds 5
.had_extra	db 0
.speed		db 0
.speed_count	db 0
.beaver_x	db 0
.snake1_vars	ds #10
.snake2_vars	ds #10
.need_croc	db 0
.end_vars

.tune_count	dw 0

dw spr_log_left,spr_log_left + 1,spr_log_left + 2,spr_log_left + 3
dw spr_log_centre,spr_log_centre  + 1,spr_log_centre + 2,spr_log_centre + 3
dw spr_log_centre,spr_log_centre  + 1,spr_log_centre + 2,spr_log_centre + 3
dw spr_log_right,spr_log_right + 1,spr_log_right + 2,spr_log_right + 3
.end_log equ $ - 1

dw spr_croc_tail,spr_croc_tail + 1,spr_croc_tail + 2,spr_croc_tail + 3
dw spr_croc_body,spr_croc_body + 1,spr_croc_body + 2,spr_croc_body + 3
dw spr_croc_open,spr_croc_open + 1,spr_croc_open + 2,spr_croc_open + 3
dw half_blank,half_blank,half_blank,half_blank
.end_croc equ $ - 1

list
.end
nolist
org #dc00,@
limit #ddff

.rand_tab
db #10,#39,#40,#d7,#a7,#0f,#3c,#36
db #10,#39,#40,#d7,#a7,#0f,#3c,#36
db #10,#39,#40,#d7,#a7,#0f,#3c,#36
db #10,#39,#40,#d7,#a7,#0f,#3c,#36

.hwsprite
ld bc,#100
ld l,c
ld e,c
.sprloop
ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi
ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi	; 16
.sprloop48
ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi
ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi	; 32
.sprloop32
ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi
ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi	; 48
.sprloop16
ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi
ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi	; 64
jp pe,sprloop
ret

.playnew	; A = sound
ld b,a
ld a,(players)
or a
ret z
ld a,b
add priorities - 1
ld l,a
ld h,priorities / 256
ld c,(hl)
ld a,b
ld hl,dma_work + #27f
cp (hl)
jr z,empty
dec h
cp (hl)
jr z,empty
dec h
cp (hl)
jr z,empty
xor a
cp (hl)
jr z,empty
inc h
cp (hl)
jr z,empty
inc h
cp (hl)
jr z,empty
dec l
ld a,(hl)
ld d,h
dec h
cp (hl)
jr c,pgrt1
ld a,(hl)
ld d,h
.pgrt1
dec h
cp (hl)
jr c,pgrt2
ld a,(hl)
ld d,h
.pgrt2
cp c
ret nc	; Can't find a queue with lower priority
inc l
ld h,d

.empty
ld (hl),b
dec l
ld (hl),c
ld a,b
add a
add soundtab - 2
ld l,a
ld a,h
ld h,soundtab / 256
ld c,(hl)
inc l
ld h,(hl)
ld l,c
sub dma_work / 256 + 1
jr c,sethl0
jr z,sethl1
ld (soundst2 + 1),hl
ld hl,soundst2
ld (soundaddr2),hl
ret
.sethl0
ld (soundst0 + 1),hl
ld hl,soundst0
ld (soundaddr0),hl
ret
.sethl1
ld (soundst1 + 1),hl
ld hl,soundst1
ld (soundaddr1),hl
ret

.playing5 equ dma_work + #80

.soundreset
ld a,tune8end - 4
ld (tune8),a

.stopsound
ld hl,sound0
ld (soundaddr0),hl
ld (soundaddr1),hl
ld (soundaddr2),hl
ld hl,dma1
ld (dma_pos),hl
ld hl,playing5
xor a
ld (hl),a
dec l
ld (hl),a
inc h
ld (hl),a
inc h
ld (hl),a
ld a,i
push af
asic on		;call need_asic
ld hl,dma_reset
ld (dma0_start),hl
ld hl,dma_control
ld a,(hl)
and #f8
or 1
ld (hl),a
jr reset_asic 

.hide_sprites
ld a,i
push af
asic on		;call need_asic
xor a
ld b,7
ld hl,spritepos
.hide_spr1
ld (hl),a
inc l:inc l
djnz hide_spr1
ld hl,#20
ld de,#fff0
ld (#6062),hl	; Sprite 12 Y = #20 (Fly bonus)
add hl,de
ld (#606a),hl	; Sprite 13 Y = #10 (Blue bonus)
ld hl,#6000
ld bc,#1009
.hide_spr2
ld (hl),e
inc l
ld (hl),d
inc l:inc l:inc l
ld (hl),c
ld a,l:add 4:ld l,a
djnz hide_spr2
.reset_asic
pop af
ld i,a
ld b,#7f
out (c),a
ret

.clear_bottom
ld e,#1e
ld c,2
jr clear

.clear_menu
ld e,8
ld c,#16
jr clear

.clear_main
ld e,2
ld c,#1c

.clear
ld b,#1c
xor a
ld l,a
ld d,a

.clear_box	;D=x, E=y, B=width, C=height, A=char, L=mask
ld h,a
.clr_down
push bc
push de
ld c,l
ld l,b
sla d:descr
.clr_across
ld a,h
call charde
dec l
jr nz,clr_across
ld l,c
pop de
inc e
pop bc
dec c
jr nz,clr_down
ret

.wait_credits
call wait
call check_credits
djnz wait_credits
ret

.print
ex (sp),hl
call print_hl
ex (sp),hl
ret

.time_msg
db "TIME ",0

.grass_msg
db 53,52,53,52,53,52,53,52,53,0

.start_msg
db " START ",0

.time_over_msg
db "TIME OVER",0

.game_over_msg
db "GAME OVER",0

list
.end2
nolist

org #e400,@
limit #e5ff

.do_sound
push hl
.dma_pos equ $ + 1
ld hl,dma1
dma_channels
dma_channels
ld (dma_pos),hl
pop hl
ret

.tile2
push de
push hl
call tile
pop hl
pop de
ret

.show_homes
ld hl,home + 4
ld c,5
.home_lp
ld a,(hl)
dec hl
or a
jr z,no_home
push bc
push hl
ld e,12
call home_tile
pop hl
pop bc
.no_home
dec c
jr nz,home_lp
ret

.home_tile	; E = tile, C = home
ld a,c
add a:add c:add a:add a:sub 10
ld d,a
ld a,e
ld e,4

.tile		; Tile A at D, E
or a
ld l,0
rra:rr l
rra:rr l
add sprites / 256
ld h,a
push de
call part_tile
pop de
inc e
.part_tile
descr
ld a,e:ld b,d:ld c,d
jr fast_part_tile

.fasttile	; DE = screen adress
or a
ld l,0
rra:rr l
rra:rr l
add sprites / 256
ld h,a
.fasttile2	; DE = screen address, HL = tile address
ld c,d
ld a,e:ld b,d
ldi:ldi:ldi:ldi:ld e,a:set 3,d
ldi:ldi:ldi:ldi:ld e,a:ld d,b:set 4,d
ldi:ldi:ldi:ldi:ld e,a:set 3,d
ldi:ldi:ldi:ldi:ld e,a:set 5,b:ld d,b
ldi:ldi:ldi:ldi:ld e,a:set 3,d
ldi:ldi:ldi:ldi:ld e,a:ld d,b:set 4,d
ldi:ldi:ldi:ldi:ld e,a:set 3,d
ldi:ldi:ldi:ldi
set 7,a:ld e,a:res 5,b:ld d,b
.fast_part_tile
ldi:ldi:ldi:ldi:ld e,a:set 3,d
ldi:ldi:ldi:ldi:ld e,a:ld d,b:set 4,d
ldi:ldi:ldi:ldi:ld e,a:set 3,d
ldi:ldi:ldi:ldi:ld e,a:set 5,b:ld d,b
ldi:ldi:ldi:ldi:ld e,a:set 3,d
ldi:ldi:ldi:ldi:ld e,a:ld d,b:set 4,d
ldi:ldi:ldi:ldi:ld e,a:set 3,d
ldi:ldi:ldi:ldi
ret

.clear_tile	; At D, E
push de
call clear_part
pop de
inc e
.clear_part
descr
xor a
ld b,d
jr clear_part3

.clear_fast	; At DE (scroll row)
xor a
ld b,d
call clear_part3
res 5,b:ld d,b:set 7,e
.clear_part3
ld (de),a:inc e:ld (de),a:inc e:ld (de),a:inc e:ld (de),a:set 3,d
ld (de),a:dec e:ld (de),a:dec e:ld (de),a:dec e:ld (de),a:ld d,b:set 4,d
ld (de),a:inc e:ld (de),a:inc e:ld (de),a:inc e:ld (de),a:set 3,d
ld (de),a:dec e:ld (de),a:dec e:ld (de),a:dec e:ld (de),a:set 5,b:ld d,b
ld (de),a:inc e:ld (de),a:inc e:ld (de),a:inc e:ld (de),a:set 3,d
ld (de),a:dec e:ld (de),a:dec e:ld (de),a:dec e:ld (de),a:ld d,b:set 4,d
ld (de),a:inc e:ld (de),a:inc e:ld (de),a:inc e:ld (de),a:set 3,d
ld (de),a:dec e:ld (de),a:dec e:ld (de),a:dec e:ld (de),a
ret

.reset_scrolls
ld hl,def_scrolls
ld de,scrolls
ld bc,20
ldir
xor a
ld (need_croc),a
ld (croc_or_log),a
ld (croc_entering),a
ld (allow_blue),a
ld (fly_shown),a
ld (fly_pos),a
ld (fly_time),a
ld (turtle_stage1),a
ld (turtle_stage4),a
ld (beaver_x),a
ld a,#10
ld (water1_int + 2),a
ld (water4_int + 2),a
ld a,#40

.set_turtle_base
ld (row1_base),a
inc a
ld (row4_base),a
rra
xor #30
ld (turtle_base),a
ret

.insert_highs
ld de,(score1)
ld hl,(score2)
ld a,h
cp d
jr nz,hnotd
ld a,l
cp e
.hnotd
jr c,s1first
ex de,hl
.s1first
call insert_high
ld (scorepos1),a
ex de,hl
.insert_high	; Insert high score DE
ld b,5
ld ix,highs + 10
.high_lp
ld c,(ix - 1)
ld a,c
cp d
jr c,move_high
jr nz,place_high
ld a,(ix - 2)
cp e
jr nc,place_high
.move_high
ld a,(ix - 2)
ld (ix + 0),a
ld (ix + 1),c
dec ix:dec ix
djnz high_lp
.place_high
ld (ix + 0),e
ld (ix + 1),d
ld a,lx
ld (scorepos2),a
ret

list
.end3
nolist

org #ec00,@
limit #edff

.halt7
halt
.halt6
halt:halt
.halt4
halt:halt
halt:halt
ret

.random
ld hl,rand_tab
ld a,(hl)
dec a
jr nz,no_res_rand
ld a,31
.no_res_rand
ld (hl),a
ld d,h
ld e,a
add 13
cp 32
jr c,no_rand_ovf
sub 31
.no_rand_ovf
ld l,a
ld a,(de)
xor (hl)
ld (hl),a
ret

.clear_rows
call hide_sprites
call do_turtles
ld a,(row4_base)
ld b,a
ld a,(row1_base)
call setbases
call clear_all
ld a,#40
ld b,#41
.setbases
ld (r1base),a
ld (r1base + 2),a
ld a,b
ld (r4base),a
ld (r4base + 2),a
ret

.clear_all
ld d,#3e
.clr_all_lp
ld e,#1f
.clr_all_lp2
push de
ld a,e		; 6 - F, 12 - 1B
sub 6
cp #0a		; F - 6
jr c,dupcc
sub #0c 	; 12 - 6
cp #0a		; 1C - C - 6	
jr nc,normcc
.dupcc
descr
res 6,e
ld a,' '
call fastcharde
dec de:dec e
set 6,e
ld a,' '
call fastcharde
jr endcc
.normcc
ld a,d
cp #38
jr nc,endcc
descr
ld a,' '
call fastcharde
.endcc
pop de
ld b,e
dec e
bit 7,e
jr z,clr_all_lp2
ld c,#10
.wait_clr
djnz wait_clr
dec c
jr nz,wait_clr
dec d:dec d
bit 7,d
jr z,clr_all_lp
ld bc,#bc01
out (c),c
inc b:dec c
out (c),c
ret

.clrmem
ld (hl),a:inc hl
djnz clrmem
ret

.set_level
ld (level),a
ld hl,check_fly
rra
jr c,use_fly
ld hl,check_mouth
.use_fly
ld (fly_or_mouth),hl
ret

.to_p
ld a,(player)
or a
jr z,to_p1

.to_p2
ld de,p2vars
jr set_to

.to_p1
ld de,p1vars
.set_to
ld hl,score
ld bc,end_vars - score
ldir
ld hl,speeds
ld c,end_items - speeds
ldir
ld hl,scrolls
ld c,end_scrolls - scrolls
ldir
ld ix,varpos
.morevars
ld l,(ix + 0)
ld h,(ix + 1)
inc ix
inc ix
ld a,h
or l
ret z
ld a,(hl)
ld (de),a
inc de
jr morevars

.from_p
ld a,(player)
or a
jr z,from_p1

.from_p2
ld hl,p2vars
jr set_from
.from_p1
ld hl,p1vars
.set_from
ld de,score
ld bc,end_vars - score
ldir
push hl
call set_layout
call draw_row_items
pop hl
ld de,speeds
ld bc,end_items - speeds
ldir
ld de,scrolls
ld c,end_scrolls - scrolls
ldir
ld ix,varpos
.morefrom
ld e,(ix + 0)
ld d,(ix + 1)
inc ix
inc ix
ld a,d
or e
ret z
ld a,(hl)
inc hl
ld (de),a
jr morefrom

.show_finish
asic on		;call need_asic
ld a,#22
ld (#6400),a
asic off
ret

.varpos
dw croc_entering, croc_count, croc_or_log, shut_count, next_tile, next_tile + 1
dw next_part, next_part + 1, beaver_x_addr, beaver_y_addr, beavery
dw beaver_scroll, beaver_scroll + 1, beaver_ofs, beaver_spr, beaver_dir
dw beaver_count, beaver_max, beaver_min
dw allow_blue, blue_shown, fly_pos, fly_time
dw turtle_stage, turtle_stage1, turtle_stage4
dw fly_or_mouth, fly_or_mouth + 1
dw sprite2, sprite3, sprite4, sprite5
dw 0

.vars_size equ $ - varpos - 2 / 2

.p1vars equ #82b2
.score1 equ p1vars

list
.vars_total equ end_vars - score + end_items - speeds + vars_size + end_scrolls - scrolls
.var_end equ p1vars + vars_total
nolist

.p2vars equ #8ab2
.score2 equ p2vars

list
.end4
nolist

read "froginit.asm"