	.Z80		
		
	ORG 0100H
			
START:	

	JP MAIN

; 1. Read console - returns an ascii character
; 2. Write console - Sends an ascii character
; 3. Read reader
; 4. Write punch
; 5. Write list
; 6. Direct console input/output. Send FF to receive character status
; 7. Get I/O status of device
; 8. Set I/O status
; 9. Print buffer. Send entire string starting with address and ending With $
; 10. Read buffer. Send address of buffer and return with filled buffer
; 11. Interrogate console ready (If LSB is 1 then console character is ready)
; 12. Lift disk head and return version number of CP/M
; 13. Reset disk system.
; 14. Select disk. 1=A, 2=B etc
; 15. Open file.
; 16. Close file.
; 17. Search for a file.
; 18. Search for next occurrence.
; 19. Delete file
; 20. Read sequentially the next 128 bytes.
; 21. Write sequentially the next 128 bytes.
; 22. Make new file and open it.
; 23. Rename file.
; 24. Return login vector (which disks are online).
; 25. Return current disk.
; 26. Set DMA address (to find data records in other parts of memory.Usually boot+80H)
; 27. Get allocation vector (for STAT to calculate remaining space)
; 28. Write protect disk.
; 29. Get read/write status of disk.
; 30. Set file attributes (read only etc)
; 31. Get disk parameter block address.
; 32. Get or set user code.
; 33. Read randomly.
; 34. Write randomly.
; 35. Compute file size for random files.
; 36. Set random record position. 

			
FDOS	EQU	0005H	; COMMON ENTRY POINT FOR BIOS AND BDOS
UART	EQU	068H	; UART LOCATION
			
		
TEST_TEXT:		DB	'HELLO WORLD$'
TEST_STRING:	DB	'SAVING TEST.TXT$'
PROMPT_STRING:	DB	'ENTER A CHARACTER$'
UCOPYATOU		DB	'COPY FILE FROM DRIVE A TO UDRIVE$'
CRLF:			DB	13,10,'$'
READBUFF:		DB	'ABCDEFGHIJKLMNOPQRSTUVWXYZ$'
FCB:			DB 	0,'FILENAMECOM',0,0,0,0,0
 			DB 	'           ',0,0,0,0,0,0,0,0
UDRIVE_STRING:	DB	'UDRIVE INITIALISED AT CURRENT BAUD RATE$'
ERRORSTRING:	DB	13,10,'ERROR$'
DIRECTORYLIST:	DB	'DIRECTORY LISTING OF DRIVE U:$'
FINISH:		DB	'FINISHED$'
ASCIIBIN:		DB	'12345$' 
BINASCII:		DB	'12345$'
FILENAME:		DB	'12345678$'	; 1 to 8 characters long, no padding, space for 8
FILEEXT:		DB	'COM$'	; always 3 characters long
COMMAND_STRING:	DB	'12345678901234567890123456789012$'    ; 32 BYTES PER STRING, END WITH $



STRING1:		DB	'ABCDEFGHIJKLabc67890123456789012$'    ; 32 BYTES PER STRING, END WITH $
STRING2:		DB	'12345678901234567890123456789012$'    ; 32 BYTES PER STRING, END WITH $
STRING3:		DB	'12345678901234567890123456789012$'    ; 32 BYTES PER STRING, END WITH $
STRING4:		DB	'12345678901234567890123456789012$'    ; 32 BYTES PER STRING, END WITH $
STRING5:		DB	'12345678901234567890123456789012$'    ; 32 BYTES PER STRING, END WITH $
STRING6:		DB	'12345678901234567890123456789012$'    ; 32 BYTES PER STRING, END WITH $
STRING7:		DB	'TEST32$'
STRING8:		DB	'TXT$'


; ************************************************
		
MAIN:	

	CALL USTART			; uncomment this and call the program USTART
;	CALL UDIR			; uncomment this and call the program UDIR
;	CALL UREAD			; uncomment this and call the program UREAD
;	CALL UWRITE			; uncomment this and call the program UWRITE
;	CALL UERASE			; uncomment this and call the program UERASE



	RET		; back to cp/m
; ************************************************
		
FILL_DMA:
	LD B,128
	LD A,'A'
	LD HL,080H	; DMA LOCATION
FILL1:	
	LD (HL),A
	INC HL
	DJNZ FILL1
	RET
; ************************************************			
; bdos calls that preserve registers 			
WARM_BOOT:
	LD C,0
	CALL FDOS
	RET			; probably doesn't need a RET!
READ_CONSOLE:		; returns answer in A
	LD C,1
	CALL FDOS
	RET
WRITE_CONSOLE:		; prints letter in E
	LD C,2		; FUNCTION NUMBER
	CALL FDOS
	RET	
WRITE_STRING:		; prints string at DE (ends with $)
	LD C,9
	CALL FDOS
	RET
WRITE_STRING_CR:		; prints string and new line at end
	LD C,9
	CALL FDOS
	LD DE,CRLF
	LD C,9
	CALL FDOS
	RET

READ_BUFFER:		;like input in basic, reads a string from keyboard
	LD C,10
	LD DE,READBUFF
	CALL FDOS
	RET
OPEN_FILE:			; if opening a file for write to drive A etc, need to call create_file first
	CALL SET_DMA
	LD C,15
	LD DE,FCB
	CALL FDOS
	RET
CLOSE_FILE:
	LD C,16
	LD DE,FCB
	CALL FDOS
	RET
DELETE_FILE:
	LD C,19
	LD DE,FCB
	CALL FDOS
	RET
READ_SEQ:
	; returns a=0 for success, a=1 for fail (a=1 for eof as well)
	; 128 bytes at set_dma location (80H)
	LD C,20
	LD DE,FCB
	CALL FDOS
	RET
WRITE_SEQ:
	LD C,21
	LD DE,FCB
	CALL FDOS
	RET
CREATE_FILE:
	CALL SET_DMA
	LD C,22
	LD DE,FCB
	CALL FDOS
	RET
GET_DRIVE:
	LD C,25
	CALL FDOS
	RET
SET_DMA:
	LD C,26
	LD DE,080H	; STANDARD DMA ADDRESS IS 80H
	CALL FDOS
	RET

FILE_SIZE:
	LD C,35
	LD DE,FCB	; PASS FCB CONTAINING FILE NAME
	CALL FDOS	; RETURNS RECORDS IN FCB+33,35,35 
			; ALSO RECORDS IN CDE
	LD DE,FCB	; MOVE BYTES TO CDE 24 BIT NUMBER
	LD HL,33	; BUT WOULD ALWAYS BE A 16 BIT NUMBER
	ADD HL,DE	; AS 65535*128 IS 8MB
	LD A,(HL)	; SO ANSWER REALLY IS DE RECORDS
	LD E,A
	INC HL
	LD A,(HL)
	LD D,A
	INC HL
	LD A,(HL)
	LD C,A
	RET		; answer in DE number of records


; ************************************************
; print registers  00000 to 65535 (A is 00000 to 00255)
PRINT_A:
	LD L,A
	LD H,0
	CALL BINTOASCII
	CALL WRITE_STRING_CR
	RET
PRINT_HL:
	CALL BINTOASCII
	CALL WRITE_STRING_CR
	RET
PRINT_DE:
	EX DE,HL
	CALL BINTOASCII
	CALL WRITE_STRING_CR
	RET
PRINT_BC:
	PUSH BC
	POP HL
	CALL BINTOASCII
	CALL WRITE_STRING_CR
	RET



; ************************************************

		
PORT_0:
	PUSH AF
	PUSH BC
	PUSH DE
	PUSH HL
	LD A,10			; DELAY BEFORE CHANGE A PORT, NOT AFTER!
	CALL DELAY		; DELAY OF 1 WORKS, THE UDRIVE JUST NEEDS A BRIEF PAUSE
	LD A,00000000B		; CHANGE TO PORT 0
	OUT (97),A
	POP HL
	POP DE
	POP BC
	POP AF
	RET
	
PORT_1:	
	PUSH AF
	PUSH BC
	PUSH DE
	PUSH HL
	LD A,10			; DELAY BEFORE CHANGE A PORT, NOT AFTER!
	CALL DELAY
	LD A,01000000B		; CHANGE TO PORT 1
	OUT (97),A
	POP HL
	POP DE
	POP BC
	POP AF
	RET
			
PORT_3:	
	PUSH AF
	PUSH BC
	PUSH DE
	PUSH HL
	LD A,10			; DELAY BEFORE CHANGE A PORT, NOT AFTER!
	CALL DELAY
	LD A,11000000B		; CHANGE TO PORT 3
	OUT (97),A
	POP HL
	POP DE
	POP BC
	POP AF
	RET

; ************************************************

SET_8255:
	LD 	A,10000001B		; A=OUT B,OUT, C HIGH=IN, CLOW=OUT
	OUT 	(99),A			; 99=CONTROL
	LD 	A,00000000B		; PORT A TO ZERO 
	OUT	(96),A			; 96=PORT A
	CALL 	DATAHIGH	
	CALL 	CLOCKHIGH
	RET
		
PORTCBIT4HIGH:
;bit 7=0, 654=don't care, 321 binary value of bit and 0=0 or 1	
	LD 	A,01111001B	; SEE THE 8255 DATA SHEET
	OUT (99),A
	CALL 	SDELAY
	RET
		
PORTCBIT4LOW:	
	LD 	A,01111000B	; SEE THE 8255 DATA SHEET
	OUT (99),A
	CALL	SDELAY
	RET
		
PORTCBIT5HIGH:	
	LD 	A,01111011B		; BIT 5 HIGH
	OUT (99),A
	CALL	SDELAY
	RET
		
PORTCBIT5LOW:	
	LD 	A,01111010B
	OUT (99),A
	CALL	SDELAY
	RET

PORTCBIT6LOW:
	LD A,01111100B
	OUT (99),A
	CALL SDELAY	
	RET

PORTCBIT6HIGH:
	LD A,01111101B
	OUT (99),A
	CALL SDELAY	
	RET

			
DATALOW:	JP PORTCBIT4LOW			; DATA LOW ETC IS EASIER TO UNDERSTAND
DATAHIGH:	JP PORTCBIT4HIGH
CLOCKLOW:	JP PORTCBIT5LOW
CLOCKHIGH:	JP PORTCBIT5HIGH

		
SDELAY:	;SHORT DELAY FOR 8MHZ AS THIS IS JUST A BIT FAST FOR THE LCD
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RET
; ************************************************
; fcb to string returns COMMAND_STRING
; eg MYPROG TEST.TXT 	will put TEST.TXT$ into the DE string.
GET_ERROR_STRING:		DB	'MISSING PARAMETER EG FILENAME.TXT$'

GET_COMMAND_STRING:
	LD HL,82H		; location of the parameter passed
	LD DE,COMMAND_STRING
	LD A,(HL)
	CP 0
	JP Z,GET_COMMAND_ERROR
FCBSTRING1:
	LD A,(HL)		; get the byte
	CP 0			; is it zero for end of the command line
	JP Z,FCBSTRING2	; yes then jump to end
	LD (DE),A		; no so store it
	INC DE		; +1
	INC HL		; +1
	JP FCBSTRING1	; loop and check again
FCBSTRING2:
	LD A,'$'		; add end of string marker
	LD (DE),a		; save it
	RET
GET_COMMAND_ERROR:
	LD DE,GET_ERROR_STRING	; if no command entered print error
	CALL WRITE_STRING_CR
	JP WARM_BOOT	; abort program


; ************************************************
; split the fcb string to filename$ and fileext$
; strings_instr:	; check string de, find byte c, number returned in A
; strings_mid:	; check string de, returns in hl, b bytes starting at c
; STRINGS_LEFT:	; check string de, returns string in hl, number of bytes in B
; check for the . and use this to build the other two strings
SPLIT_COMMAND:
	LD DE,COMMAND_STRING
	LD C,'.'		      ; find the .
	CALL STRINGS_INSTR	; returns A
	DEC A				; 1 less
	LD B,A
	LD DE,COMMAND_STRING	; use command string
	LD HL,FILENAME		; return filename
	CALL STRINGS_LEFT		; get n-1 characters
	LD DE,COMMAND_STRING
	LD C,'.'		      ; find the .
	CALL STRINGS_INSTR	; returns A
	INC A				; plus 1
	LD C,A			; start at C
	LD B,3			; 3 bytes
	LD DE,COMMAND_STRING	; start with command string
	LD HL,FILEEXT		; extension
	CALL STRINGS_MID		; get mid$
	RET
	


; ************************************************

USTART_MESSAGE:	DB	'Booting uDrive at current baud rate$'
		
USTART:
; INITIALISE AT THE SAME BAUD RATE AS THE TERMINAL
; MAY END UP CHANGING THIS TO A HIGHER RATE IF IT WORKS
; reset pin is pin 11 on the 8255 (port C bit 6)
	LD DE,USTART_MESSAGE
	CALL WRITE_STRING_CR
	CALL SET_8255	; SETUP PORTS
	CALL PORTCBIT6HIGH; high low high pulse to reset
	LD A,10
	CALL DELAY
	CALL PORTCBIT6LOW	; RESET
	LD A,10		; 0.1 sec delay
	CALL DELAY
	CALL PORTCBIT6HIGH; 
	LD A,100		; 1 sec delay *500ms on datasheet but allow a margin
	CALL DELAY		; 
	CALL PORT_3		; UDRIVE IS ON PORT 3
	LD E,'U'		; INITIALISE BYTE at current baud rate
	CALL WRITE_CONSOLE
	CALL CONIN		; USE CONIN CODE HERE AS CONIN ON CP/M MIGHT HAVE THE KEYBOARD 	
	CALL PORT_0	; BACK TO CONSOLE
	RET

; ************************************************
SPACECOUNT:		DB	0	; count spaces so line up
ENTRYCOUNT:		DB	0	; 4 entries per line
DIRCOUNT:		Dw	0	; two byte counter
DIRSTART:		DB	'U: $' ; string to start with
DIRERROR:		DB	'ERROR - ABORTING$'
DIRPAGECOUNT:	DB	0	; count from 1 to 20, then ask user to hit key to continue
DIR_MESSAGE:	DB	'HIT ANY KEY TO CONTINUE...$'
			
UDIR:	
	LD A,0
	LD (DIRPAGECOUNT),A	; reset the page counter
	CALL PORT_3			; TALK TO UDRIVE
	LD E,40H
	CALL WRITE_CONSOLE	; DIR INSTRUCTION IS @D* THEN 0 FOR DIR *.*
	LD E,64H
	CALL WRITE_CONSOLE
	LD E,02AH
	CALL WRITE_CONSOLE
	LD E,0
	CALL WRITE_CONSOLE	; UDRIVE WILL NOW SEND BACK LISTING
	LD HL,DIR_BUFFER	; START OF BUFFER LOCATION
UDIR1:	
	CALL CONIN		; CHARACTER IN A
	LD (HL),A		; STORE TO BUFFER 
	INC HL			; INCREMENT COUNTER
	CP 15H			; IS IT A NAK?
	JP Z,UDIR9		; ERROR so abort and print error message
	CP 6H			; 6 IS THE END CHARACTER
	JP NZ,UDIR1
	CALL PORT_0		; TALK TO CONSOLE
UDIR2:			; initialise
	LD A,0
	LD (ENTRYCOUNT),A	; start with entry as 0, goes 0 to 3
	LD HL,DIR_BUFFER
	LD (DIRCOUNT),HL	; store the byte counter
	LD DE,DIRSTART
	CALL WRITE_STRING
UDIR3:			
	LD A,9
	LD (SPACECOUNT),A	; start with 9 spaces
UDIR4:
	LD HL,(DIRCOUNT)	; get the counter
	LD A,(HL)		; get the byte
	INC HL		; add 1 for next time
	LD (DIRCOUNT),HL	; store it
	CP 6			; end of listin
	JP Z,UDIR8		; 
	CP 10			; end of filename
	JP Z,UDIR7		; 
	CP '.'		; if a . then pad out with spaces
	JP Z,UDIR6
	LD E,A		; print out the character
	CALL WRITE_CONSOLE
	LD A,(SPACECOUNT)	; subtract 1 off the space counter
	DEC A
	LD (SPACECOUNT),A
	JP UDIR4
UDIR6:			; pad with spaces
	LD A,(SPACECOUNT)
	LD B,A
UDIR61:
	PUSH BC
	LD E,' '		' print out n padding spaces instead of .
	CALL WRITE_CONSOLE
	POP BC
	DJNZ UDIR61
	JP UDIR4		; keep printing
UDIR7:
	LD A,9		; reset the spaces counter as new entry
	LD (SPACECOUNT),A
	LD A,(ENTRYCOUNT)	; entry 1,2,3,4 then new line
	INC A			; add one
	CP 4			; overrange
	JP NZ,UDIR71	; no then just store new number
				; new line
	CALL UDIR10		; wait for user input if >n lines
	LD DE,CRLF		
	CALL WRITE_STRING	; new line
	LD DE,DIRSTART	; new line
	CALL WRITE_STRING
	LD A,0		; reset the counter
	LD (ENTRYCOUNT),A ; reset the counter
	JP UDIR4 		; back to getting the next character
UDIR71:
	LD (ENTRYCOUNT),A	; store new value
	LD E,' '
	CALL WRITE_CONSOLE	; print ' : '
	LD E,':'
	CALL WRITE_CONSOLE
	LD E,' '
	CALL WRITE_CONSOLE
	JP UDIR4
UDIR8:
	RET			; finish up
UDIR9:
	LD DE,DIRERROR
	CALL WRITE_STRING_CR
	RET
UDIR10:			; new line message
	LD A,(DIRPAGECOUNT)	; ask user for input after n pages
	INC A
	LD (DIRPAGECOUNT),A
	CP 22
	RET NZ			; return if not 10
	LD A,0			; but if =10 then wait for input
	LD (DIRPAGECOUNT),A	; reset the counter
	LD DE,CRLF
	CALL WRITE_STRING		; new line
	LD DE,DIR_MESSAGE		; print message to hit a key
	CALL WRITE_STRING
	CALL READ_CONSOLE			; wait for 1 key but discard it	
	RET

; ************************************************
; UWRITE sends a file in fcb to the udrive 
	; declare local variables
RECORDCOUNT:	DW	0,0		; number of records
SIZESTRING:		DB	'NNNN$'	; 4 bytes
UERRSTRING:		DB	13,10,'ERROR - RUN USTART.COM TO RESET$'
BLOCKCOUNT:		DB	0		; 4 lots of 32 bytes in udrive per 128 byte recored
DMACOUNT:		DW	0,0		; dma counter
RECORDSTRING:	DB	'RECORDS$'
BYTESTRING:		DB	'BYTES$'


UWRITE:
	CALL CONCLEAR		; clear the uart buffer ? not needed
	CALL GET_COMMAND_STRING ; user passes the filename
	CALL SPLIT_COMMAND	; returns filename and fileext
	CALL FILENAME_TO_FCB 	; put filename and extension string to fcb
	CALL FILE_SIZE		; uses fcb, returns de records
	LD (RECORDCOUNT),DE	; store it for later

;	CALL PRINT_DE
;	LD DE,RECORDSTRING
;	CALL WRITE_STRING_CR	; print number of records

	LD DE,(RECORDCOUNT)	; number of records
	LD BC,128			; get records
	CALL MUL16			; BC*DE=DEHL number of bytes
	LD IX,SIZESTRING
	LD (IX+0),D			; store 4 size bytes
	LD (IX+1),E
	LD (IX+2),H
	LD (IX+3),L
;	CALL PRINT_HL
;	LD DE,BYTESTRING
;	CALL WRITE_STRING_CR

	LD IX,SIZESTRING
	CALL PRINT_COPY_TIME

	LD DE,STRING1
	CALL STRINGS_CLEAR 	; clear the string
	LD DE,FILENAME
	LD HL,STRING1
	CALL STRINGS_COPY		; filename to string1
	LD A,'.'
	LD DE,STRING1
	CALL STRINGS_ADD_CHAR 	; add the .
	LD BC,STRING1
	LD DE,FILEEXT
	LD HL,STRING2
	CALL STRINGS_CONCAT	; answer in string2

	CALL PORT_3			; talk to udrive
	LD E,40H
	CALL WRITE_CONSOLE	; write @t packetsize filename 0 size wait packet1 wait packet2
	LD E,74H
	CALL WRITE_CONSOLE
	LD E,32			; 32 bytes per packet
	CALL WRITE_CONSOLE
	LD DE,STRING2
	CALL WRITE_STRING		; filename myfile.ext
	LD E,0
	CALL WRITE_CONSOLE	; 0 at end
	LD DE,SIZESTRING		; 4 bytes
	CALL WRITE_STRING		; send them out
	CALL OPEN_FILE		; open the file at the fcb

; note that up until here we have been printing via the fdos commands through cp/m
; from now on use local conin and conout as bypasses lcd display and keyboard checks so is faster
	CALL CONIN_TIMEOUT
	CP 15				; error if NAK. Ok if times out or ACK
	JP Z,U_WRITE_ERR
UWRITE1:
	CALL READ_SEQ		; get 128 bytes from drive A file 0=success 1=fail eg eof
	CP 1				; is it the eof?
	JP Z,UWRITE4
	LD A,4			; count down from 4 for 32x4=128
	LD (BLOCKCOUNT),A		; store it
	LD HL,80H			; setup dma counter
	LD (DMACOUNT),HL
UWRITE2:				; send out 32 bytes
	LD B,32			; 32 bytes
UWRITE3:
	LD HL,(DMACOUNT)		; get the counter
	LD A,(HL)			; get the byte
	LD E,A			; ready to send out
	PUSH BC			; store the counter
;	CALL WRITE_CONSOLE	; send it (fast local with conout, write_console has lcd etc)
	CALL CONOUT			; CONOUT needs a delay, ? how short (1ms is working)
	LD A,1			; 1ms delay maybe it can go faster
	CALL DELAY_MILLISECOND  ; sdelay is too fast though.
;	CALL SDELAY
	POP BC
	LD HL,(DMACOUNT)		; get the counter
	INC HL			; add one
	LD (DMACOUNT),HL		; store it
	DJNZ UWRITE3		; loop until counter =0
	CALL CONIN_TIMEOUT	; get ack
	CP 15				; error if NAK. Ok if times out or ACK
	JP Z,U_WRITE_ERR
	LD A,(BLOCKCOUNT)		; 1 of 4 blocks to send
	DEC A
	LD (BLOCKCOUNT),A		; store it
	CP 0				; zero?
	JP NZ UWRITE2		; no, so do 4 x
					; is this the last record?
	LD DE,(RECORDCOUNT)
	DEC DE
	LD (RECORDCOUNT),DE
	JP UWRITE1			; get the next record

UWRITE4:				; finish up
	CALL CLOSE_FILE
	CALL PORT_0		; back to console 
	CALL CONIN_TIMEOUT	; collect the final ^F if there is one
	RET
U_WRITE_ERR:	
	CALL PORT_0
	LD DE,UERRSTRING
	CALL WRITE_STRING_CR
	CALL CLOSE_FILE
	RET


; ************************************************
; erase a file on the udrive. Erases file in FILENAME$ and FILEEXT$
U_ERASE_FILESTRING:	DB	'ERASE FILE$'
UERASEFAIL:		DB	'ERASE FAIL$'

UERASE:
	CALL CONCLEAR		; clear the uart buffer ? not needed
					; create the filename string in string2
	LD DE,STRING1		; use generic strings string1 string2 etc
	CALL STRINGS_CLEAR 	; clear the string
	LD DE,FILENAME
	LD HL,STRING1
	CALL STRINGS_COPY		; filename to string1
	LD A,'.'
	LD DE,STRING1
	CALL STRINGS_ADD_CHAR 	; add the .
	LD BC,STRING1
	LD DE,FILEEXT
	LD HL,STRING2
	CALL STRINGS_CONCAT	; answer in string2
	CALL PORT_3			; talk to udrive
	LD E,40H
	CALL WRITE_CONSOLE	; erase command
	LD E,65H
	CALL WRITE_CONSOLE
	LD DE,STRING2
	CALL WRITE_STRING		; filename eg myfile.ext
	LD E,0
	CALL WRITE_CONSOLE	; 0 at end
	CALL CONIN			; get ack or NAK
	CP 15
	JP Z,UERASE1		; fail prints a message but no need if succeeded
	CALL PORT_0			; back to console port
	RET
UERASE1:
	CALL PORT_0			; print error message
	LD DE,UERASEFAIL
	CALL WRITE_STRING_CR
	RET
; ************************************************
; read file from udrive - uses FILENAME$ AND FILEEXT$ - use dw as safer than db

READSIZE:			DB	'NNNN$'	; 4 bytes
READ_64K			DW	0		; 2 bytes 0-64k as above but easier to read
READ_RECORDS:		DW	0		; 2 bytes
READ_REMAINDER:		DW	0		; 2 bytes
READ_COUNTER:		Dw	0		; 80H to FFH
READ_REMAINDER_BLOCKS:	Dw	0		; how many blocks to read in the remainder
READ_REMAINDER_FINISH:	Dw	0		; remainder at the very end
UREAD_MESSAGE:		DB	' BYTES COPIED FROM DRIVE U: TO DRIVE A:$'



UREAD:
	CALL CONCLEAR		; clear the uart buffer ? not needed
	CALL GET_COMMAND_STRING ; user passes the filename
	CALL SPLIT_COMMAND	; returns filename and fileext


	CALL FILENAME_TO_FCB 	; put filename and extension string to fcb need this for file access
	CALL DELETE_FILE		; delete it if it exists
	CALL FILENAME_TO_FCB	; put it back again as delete deletes the fcb too

	CALL PORT_3			; talk to udrive

	LD E,40H
	CALL WRITE_CONSOLE	; read 
	LD E,61H
	CALL WRITE_CONSOLE
	LD E,32			; 32 bytes per packet	
	CALL WRITE_CONSOLE
	LD DE,FILENAME
	CALL WRITE_STRING		; filename
	LD E,'.'
	CALL WRITE_CONSOLE	
	LD DE,FILEEXT
	CALL WRITE_STRING		; extension
	LD E,0			; end with a 0
	CALL WRITE_CONSOLE	; udrive will respond with the file size 4 bytes
	LD IX,READSIZE		; store file size here
	CALL CONIN			; get first byte
	LD (IX+0),A
	CALL CONIN			; get second byte
	LD (IX+1),A
	CALL CONIN			; get third byte
	LD (IX+2),A
	CALL CONIN			; get last byte
	LD (IX+3),A
	LD H,(IX+2)			; store the 0-64k size
	LD L,(IX+3)
	LD (READ_64K),HL		; easier to read this way
					; work out number of records and remainder
	LD DE,0			; would always be <64k
	LD H,(IX+2)			; get the number of bytes in DEHL
	LD L,(IX+3)
	LD BC,128			; calculate the number of records
	CALL DIVIDE			; DE=answer, remainder = HL
	LD (READ_RECORDS),DE	; number of records to read
	LD (READ_REMAINDER),HL	; use this at the end, may need to read 1-4 32byte groups plus extra
	CALL UREAD_FINAL_BLOCKS	; maths for the last record 
	CALL CREATE_FILE		; if making a file on the A drive, need to create it first
	CALL OPEN_FILE		; open the file at the fcb

;	CALL PORT_0		; debugging, check number of records etc. Maybe print these out with time
;	LD HL,(READ_64K)			; debugging routines bytes
;	CALL PRINT_HL
;	LD HL,(READ_RECORDS) 				; debugging
;	CALL PRINT_HL
;	LD HL,(READ_REMAINDER)
;	CALL PRINT_HL
;	CALL PORT_3
UREAD1:
	LD DE,(READ_RECORDS)	; test the record counter
	CALL TEST_WORD_ZERO	; is it zero, returns Z flag=1 if zero
	JP Z,UREAD2			; if at the end, clean up the remainder
	CALL UREAD_RECORD		; read in the record
	CALL UREAD_SUBTRACT1	; subtract 1 from the record counter
	JP UREAD1			; loop until read all the records
UREAD2:				; now do all the remainder bytes
	CALL RESET_FCB_COUNTER	; back to 80H
	LD DE,(READ_REMAINDER)	; if there is a remainder then get these bytes
	CALL TEST_WORD_ZERO
	JP Z,UREAD3			; if no remainder then skip remainder bytes
	CALL UFILL_CNTRL_Z      ; may as well fill with ^Z = end of text file
	CALL U_REMAINDER		; read in any remainder bytes if not a multiple of 128
UREAD3:				; finish up 
	CALL CONIN_TIMEOUT	; there will be a final ack at the end of all files must timeout
	CALL CLOSE_FILE		; close the file at the fcb
	CALL PORT_0			; close the port
	CALL CONIN_TIMEOUT	; clean up any leftover bytes

	CALL UREAD_FINISH_MESSAGE	; print a message to say it worked

	RET

; *** uread subroutines ***

U_REMAINDER:				; read in remainder bytes anything from 1 to 127
	LD A,(READ_REMAINDER_BLOCKS)
	CP 0					; 0 last blocks, jump to sending the last few bytes
	JP Z,U_REMAINDER1			; loop through the last blocks
	CALL SEND_ACK			; send an ack
	CALL UREAD_BLOCK			; get block
	LD A,(READ_REMAINDER_BLOCKS)
	DEC A					; decrement counter
	LD (READ_REMAINDER_BLOCKS),A	; store it
	JP U_REMAINDER			; loop until finish reading all the blocks
U_REMAINDER1:
	LD A,(READ_REMAINDER_FINISH)	; 0 TO 31 bytes
	CP 0
	JP Z,U_REMAINDER2		; if no more bytes then close the file and finish up
	CALL SEND_ACK		; request the next group
	LD A,(READ_REMAINDER_FINISH)	; 0 TO 31 bytes
	LD B,A			; counter to B
	CALL UREAD_BLOCK_B	; read this number of bytes
U_REMAINDER2:				; store the bytes ?? needs ^Z at the end or fill dma with ^Z
	CALL WRITE_SEQ		; if any last blocks etc then store this record
	RET

UTESTA:	; PRINT OUT A
	PUSH AF
	CALL PORT_0
	CALL PRINT_A
	CALL PORT_3
	POP AF
	RET

UTESTDE:	; PRINT OUT DE while talking to udrive
	PUSH DE
	CALL PORT_0
	CALL PRINT_DE
	CALL PORT_3
	POP DE
	RET

UTESTHL:	; PRINT OUT HL while talking to udrive
	PUSH HL
	CALL PORT_0
	CALL PRINT_HL
	CALL PORT_3
	POP HL
	RET

UTESTBC:	; Print out BC while talking to udrive
	PUSH BC
	CALL PORT_0
	CALL PRINT_BC
	CALL PORT_3
	POP BC
	RET


UREAD_RECORD:		; get 1 record from the udrive and store it to the open file
	CALL RESET_FCB_COUNTER
	CALL SEND_ACK	
	CALL UREAD_BLOCK	; read the 32 byte block 4 times
	CALL SEND_ACK
	CALL UREAD_BLOCK
	CALL SEND_ACK
	CALL UREAD_BLOCK
	CALL SEND_ACK
	CALL UREAD_BLOCK
	CALL WRITE_SEQ	; send it to the file on drive A
	RET

RESET_FCB_COUNTER:
	LD HL,80H		; FCB counts from 80H to FFH
	LD (READ_COUNTER),HL	; store it
	RET

UREAD_BLOCK:			; read 32 bytes from the udrive
	LD B,32
	LD C,0			; not really needed but makes debugging easier to follow
UREAD_BLOCK1:
	PUSH BC			; temp store for b
	CALL CONIN			; get a byte from udrive in A use local conin not CP/M
	LD HL,(READ_COUNTER)	; get the counter
	LD (HL),A			; store it
	INC HL			; add 1
	LD (READ_COUNTER),HL	; store the counter
	POP BC			; restore B
	DJNZ UREAD_BLOCK1		; loop 32 times
	RET

UREAD_BLOCK_B:			; read B bytes from the udrive
	LD C,0			; not really needed but makes debugging easier to follow
	JP UREAD_BLOCK1		; same as code above but B is any number, not 32

SEND_ACK:
	LD E,06H			; send the ACK
	CALL CONOUT			; local conout bypasses LCD etc
	RET

UREAD_ZERO:				; tests if record count is zero, returns Z flag 
	XOR A
	LD BC,0			; subtracing 0 is just so can test if hl is 0, a two byte CP 0
	LD HL,(READ_RECORDS)	
	SBC HL,BC
	RET

UREAD_SUBTRACT1:			; subtract 1 from the record counter
	LD HL,(READ_RECORDS)	
	DEC HL
	LD (READ_RECORDS),HL	; and store it again
	RET

UREAD_FINAL_BLOCKS:		; pass a number 0 to 127, turns into n 32byte blocks and r remainder
; DEHL/BC = DE r = HL
	LD DE,0
	LD HL,(READ_REMAINDER)
	LD BC,32
	CALL DIVIDE
	LD A,E				; store answers
	LD (READ_REMAINDER_BLOCKS),A	;0 1 2 or 3
	LD A,L
	LD (READ_REMAINDER_FINISH),A	; 0 TO 31 (if 32 would be 1 more block and/or record)
	RET

UFILL_CNTRL_Z:			; put 128 bytes of ^Z in the fcb
	LD B,128
	LD A,26			; ^Z = end text file
	LD HL,080H			; fcb at 80H
UFILL1:
	LD (HL),A
	INC HL
	DJNZ UFILL1			; loop 128 times
	RET	

UREAD_FINISH_MESSAGE:
	LD HL,(READ_64K)		; this many bytes
	CALL BINTOASCII		; bin to ascii
	CALL WRITE_STRING		; print it out
	LD DE,UREAD_MESSAGE	; text message
	CALL WRITE_STRING_CR	; prnit it out
	RET


; ************************************************
; print estimated time to copy a file to the udrive
	; declare local strings
PRINTCOPY1:	DB	'COPYING FILE IN $'
PRINTCOPY2:	DB	' SECONDS AT 38400 BAUD$'

PRINT_COPY_TIME:
	; pass IX=sizestring eg 5400 bytes at 38400 baud is about 5.5 seconds, so /1000
	; declare local strings
	LD DE,PRINTCOPY1	; print copying message
	CALL WRITE_STRING
	LD D,(IX+0)		; get the number of bytes	
	LD E,(IX+1)
	LD H,(IX+2)
	LD L,(IX+3)
	LD BC,900		; divide by 900 to get seconds (38400
	CALL DIVIDE		;dehl/bc=de
	EX DE,HL
	CALL BINTOASCII
	CALL WRITE_STRING
	LD DE,PRINTCOPY2
	CALL WRITE_STRING_CR
	RET

	

; ************************************************		
CONIN:			; direct console input
	IN 	A,(UART+05H); IS THERE A BYTE, 0=NO 1=YES
	AND	1
	JP 	Z,CONIN	; LOOP UNTIL THERE IS
	IN	A,(UART)	; GET THE BYTE
	RET
; ************************************************
CONOUT:			; used to bypass the lcd display, keyboard check etc in CP/M
				; sends out byte in E (CP/M sends out C)
	IN	A,(UART + $05)	; READ LINE STATUS REGISTER
	AND	$20		; TEST IF UART IS READY TO SEND
	JP	Z,CONOUT	; IF NOT REPEAT
	LD	A,E		; GET TO ACCUMULATOR
	OUT	(UART),A	; THEN WRITE THE CHAR TO UART (UART0 = $68 + $00)
	RET
; ************************************************	

CONCLEAR:		; is there a byte, if yes then get it but if no then just return
	IN A,(UART+05H); IS THERE A BYTE, 0=NO 1=YES
	AND A,1
	RET Z	; no byte so return
	IN	A,(UART)	; GET THE BYTE
	RET

; ************************************************	
; checks for input returns byte if there is one and B<>1 if success, B=0 if time out
CONIN_TIMEOUT:
	LD B,100			;	loop 100 times timeout in 1sec
CONIN_TIMEOUT1:
	IN 	A,(UART+05H)	; IS THERE A BYTE, 0=NO 1=YES
	AND	1
	JP 	NZ,CONIN_TIMEOUT2	; got a byte
	PUSH BC			; store the counter
	LD A,1
	CALL DELAY_MILLISECOND	;0.001 second delay
	POP BC			; restore the counter
	DJNZ 	CONIN_TIMEOUT1	; try 255 times 
	LD A,0			; return A=0,B=0
	RET				; timed out.
CONIN_TIMEOUT2:
	IN	A,(UART)		; GET THE BYTE	B returns the counter value
	RET

		
;-----------------------------------------------
; delay
;-----------------------------------------------
; pass A - delay is A*0.01 seconds, BCDEHL all preserved
DELAY:	
	PUSH BC		; STORE ALL VARIABLES
	PUSH DE
	PUSH HL
	LD B,A		; PUT THE VARIABLE DELAY IN B
	LD DE,1
LOOP1:	
	LD HL,1481	; ADJUST THIS VALUE FOR YOUR CLOCK 1481=3.68MHZ, 3219=8MHZ
LOOP2:	
	SBC HL,DE	;HL-1
	JR NZ,LOOP2
	DJNZ LOOP1
	POP HL		; RESTORE VARIABLES
	POP DE
	POP BC
	RET

;-----------------------------------------------
; delay millisecond - 1 = 1 millisecond
;-----------------------------------------------
; pass A - delay is A*0.001 seconds, BCDEHL not preserved as slows things
DELAY_MILLISECOND:	
	LD B,A	; put the variable delay in B
	LD DE,1
DELAYM1:	
	LD HL,148	; adjust this value for your clock 1481=3.68Mhz, 3219=8Mhz
DELAYM2:	
	SBC HL,DE	;hl-1
	JR NZ,DELAYM2
	DJNZ DELAYM1
	RET


; ************************************************
; maths routines		

; 1) 16 by 16 bit multiply
; 2) 32 by 16 bit divide with remainder
; 3) 8 by 8 bit multiply
; 4) 16 plus 16 bit add
; 5) 32 minus 16 bit subtract
; 6) 8 bit Comparison
; 7) Ascii to Binary
; 8) Binary to Ascii
; 9) Ascii to Hex
; 10) Hex to Ascii
; 11) 16 bit binary value to 5 ascii characters 0-9
; 12) 5 ascii characters 0-9 to 16 bit binary
; 13) Delay routine
; 14) Floating Point 16 Bit by 16Bit Multiply 123.45 * 12.345 = 1523.99025
		
POWER10TABLE:	DW	10000,1000,100,10,1
	
;       LD BC,100
;	LD DE,30
;	CALL MUL16

;       LD HL,5000
;	LD DE,0
;	LD BC,500	
;	CALL DIVIDE

;       LD A,30
;	LD B,100
;	CALL MUL8

;       LD DE,1000
;	LD HL,1000	
;	CALL ADD16

;       LD DE,1
;	LD HL,86A0H
;	LD BC,0C350H
;	CALL SUB32

;       LD A,5
;	LD B,7
;	CALL COMPARE

;       ORG 1100:DB "10110010":ORG 100H:LD HL,1100:CALL ASCBINARY
;       LD C,0AAH:LD HL,1110:CALL BINASC

;       LD D,"5"
;	LD E,"F"
;	CALL ASCHEX

;       LD C,5FH
;	CALL HEXASC

;       LD IX,1000
;	LD HL,12345
;	CALL DECIMALASC
;
;       ORG 1250:DB "65535":ORG 100H:LD IX,1250:CALL ASCDEC

;       LD A,100
;	CALL DELAY

;       LD BC,12345
;	LD DE,12345
;	LD H,2
;	LD L,3
;	CALL FLOPMUL
;        RET	
; 16 by 16 bit multiply BC * DE = DEHL		
MUL16:  
	PUSH BC
	PUSH DE
	LD B,16
	EXX
	POP DE
	POP BC
	LD HL,0
        EX DE,HL
	ADD HL,HL
	EX DE,HL
	PUSH AF
MUL161: 
	POP AF
	JP NC,MUL162
	ADD HL,BC
	JP NC,MUL162
	INC DE
MUL162: 
	EXX
	DEC B
	EXX
	RET Z		; RETURN
        EX DE,HL
	ADD HL,HL
	EX DE,HL
	PUSH AF
	ADD HL,HL
      JP NC,MUL161
	INC DE	
	JP MUL161

; 32 bit by 16 bit unsigned divide DEHL/BC = DE r = HL
DIVIDE: LD A,16
	EX DE,HL
DIVIDE1:
	ADD HL,HL
	EX DE,HL
	ADD HL,HL
	EX DE,HL
	JP NC,DIVIDE2
	INC HL
DIVIDE2:
	OR A
	SBC HL,BC
	INC DE
	JP P,DIVIDE3
	ADD HL,BC
	RES 0,E
DIVIDE3:
	DEC A
	JP NZ,DIVIDE1
	RET

; 8 bit by 8 bit unsigned multiply  A*B = HL		
MUL8:   
	LD L,0
	LD H,A
	LD C,B
	LD B,0
	LD A,8
MUL81:  
	ADD HL,HL
	JP NC,MUL82
	ADD HL,BC
MUL82:  
	DEC A
	JP NZ,MUL81
	RET

; 16 plus 16 bit add DE+HL=DEHL			
ADD16: 	LD BC,0
	OR A
	ADC HL,DE
	EX DE,HL
	LD HL,0
	ADC HL,BC
	EX DE,HL
	RET

; 32 minus 16 bit subtract DEHL-BC=DEHL	
SUB32: 	OR A
	SBC HL,BC
	PUSH HL
	EX DE,HL
	LD BC,0
	SBC HL,BC
	EX DE,HL
	POP HL
	RET
; Ascii to binary. 8 ascii 0 or 1 in memory location HL. Answer in A.		
ASCBINARY:
	LD B,8
	LD C,0
ASCBIN1:SLA C
	LD A,(HL)
	INC HL
	SUB 30H
	OR C
	LD C,A
	DJNZ ASCBIN1
      RET
; Binary to Ascii. Value in C to 8 ascii characters in mem HL
BINASC:LD B,8
BINASC1:LD A,30H
	BIT 7,C 		
	JP Z,BINASC2
	INC A
BINASC2:LD (HL),A
	SLA C
	INC HL
	DJNZ BINASC1
	RET
; Ascii to Hex. Ascii in DE eg ld d,"3":ld e,"B" answer 3bh or 59 in A 
ASCHEX: LD A,D
 	CALL ASCHEXCVERT
	LD C,A
	LD A,E
	CALL ASCHEXCVERT
      SLA C
	SLA C
	SLA C
	SLA C
	ADD A,C
	RET
ASCHEXCVERT:
 	SUB 30H
	CP 10
 	RET M
	SUB 7
	RET

; Hex to Ascii. Hex value in C. Answer in DE.			
HEXASC:LD A,0F0H
	AND C
	RRCA
	RRCA
	RRCA
	RRCA
	CALL HEXASC1
	LD D,A
      LD A,0FH
	AND C
	CALL HEXASC1
	LD E,A
	RET
HEXASC1:ADD A,30H
	CP 3AH
	RET M
	ADD A,7
	RET
		

BINTOASCII:	; pass HL, returns answer in 5 characters at DE
	LD IY,POWER10TABLE
	LD IX,BINASCII	; ALWAYS PUT ANSWER HERE
DECASC1:
	XOR A
	LD E,(IY)
	LD D,(IY+1)
DECASC2:
	OR A
	SBC HL,DE
	JP C,DECASC3
	INC A
	JP DECASC2
DECASC3:ADD HL,DE
	ADD A,30H		; SO ASCII VALUES
	LD (IX+0),A	
	INC IX		; STORE IN IX LOCATION
	INC IY		; POWER10 COUNTER
	INC IY
	LD A,E
	CP 1
	JP NZ,DECASC1
	LD (IX),'$'
	LD DE,BINASCII	; answer in DE ready to print if needed
        RET
 

ASCIITOBIN:		;location in de of 5 bytes, answer in hl 0-65535
	LD B,5
	LD HL,0
	PUSH DE
	POP IX
ASCDECLOOP:
	ADD HL,HL	
	PUSH HL
	ADD HL,HL
	ADD HL,HL
	POP DE
	ADD HL,DE
      LD A,(IX)	
	SUB 30H
	LD E,A
	LD D,0
	ADD HL,DE
	INC IX
      DJNZ ASCDECLOOP
      RET

; 16 bit by 16 bit floating point multiply
; BC * DE = DEHL Decimal point position in H and L, answer in C		
FLOPMUL:
	PUSH HL
	CALL MUL16
	POP BC
      LD A,C
	ADD A,B
	LD C,A
	LD B,00
      RET

; ************************************************
; test zero for words. Pass DE, returns Z flag =1 if zero. Same as CP 0 for a byte
TEST_WORD_ZERO:
	xOR A
	LD BC,0			; subtracing 0 is just so can test if hl is 0, a two byte CP 0
	EX DE,HL
	SBC HL,BC
	RET
		
; ************************************************
; strings	len,left,mid,instr,concat,strings_add_char,clear,copy
		
STRINGS_LEN:		; de=string, a=answer
	LD B,0	; COUNTER
STRINGS_LEN1:
	LD A,(DE)
	CP '$'	; IS IT THE END?
	JP Z,STRINGS_LEN2
	INC B		; +1
	INC DE	; +1
	JP STRINGS_LEN1
STRINGS_LEN2:
	LD A,B	; PUT THE ANSWER A
	RET

		
STRINGS_LEFT:	; check string de, returns string in hl, number of bytes in B
	PUSH HL
STRINGS_LEFT_1:
	LD A,(DE)			; GET CHARACTER
	LD (HL),A			; MOVE IT
	INC HL			; HL+1
	INC DE			; DE+1
	DJNZ STRINGS_LEFT_1	; LOOP UNTIL B=0
	LD A,'$'			; PUT A $ AT THE END OF THIS SHORTER STRING
	LD (HL),A
	POP HL			; RESTORE START
	RET


STRINGS_INSTR:	; CHECK STRING DE, FIND BYTE C, NUMBER RETURNED IN A
	LD B,1	
STRINGS_INSTR_1:
	LD A,(DE)
	CP '$'	; CHECK FOR END
	JP Z,STRINGS_INSTR_2
	CP C		; CHECK FOR BYTE
	JP Z,STRINGS_INSTR_2
	INC B
	INC DE
	JP STRINGS_INSTR_1
STRINGS_INSTR_2:
	LD A,B
	RET	
	
STRINGS_MID:	; CHECK STRING DE, RETURNS IN HL, B BYTES STARTING AT C
	PUSH HL
	LD H,0
	LD L,C
	ADD HL,DE
	DEC HL	; 1 LESS
	EX DE,HL	; NEW START LOCATION IN DE
	POP HL
STRINGS_MID1:
	LD A,(DE)	; MOVE THE BYTES
	LD (HL),A
	INC HL
	INC DE
	DJNZ STRINGS_MID1
	LD A,'$'	; END OF STRING MARKER
	LD (HL),A
	RET

; EXAMPLE
;	LD DE,STRING1
;	LD HL,STRING2
;	LD B,6
;	LD C,4
;	CALL STRINGS_MID
;	LD DE,STRING2
;	CALL WRITE_STRING_CR

STRINGS_CONCAT:	; STRING HL=STRING BC+DE
	; MOVE STRING BC TO HL FIRST
	LD A,(BC)
	CP '$'
	JP Z,STRINGS_CONCAT_1	
	LD (HL),A
	INC HL
	INC BC
	JP STRINGS_CONCAT
STRINGS_CONCAT_1:
	LD A,(DE)
	CP '$'
	JP Z,STRINGS_CONCAT_2
	LD (HL),A
	INC HL
	INC DE
	JP STRINGS_CONCAT_1
STRINGS_CONCAT_2:	
	LD A,'$'	; PUT MARKER AT END
	LD (HL),A
	RET

STRINGS_ADD_CHAR:	;DE=STRING, A IS CHARACTER TO ADD AT END
	PUSH AF
	PUSH DE
	CALL STRINGS_LEN	; GET LENGTH IN A
	POP DE
	LD H,0
	LD L,A
	ADD HL,DE	; GET LOCATION OF END OF STRING
	POP AF      ; EG 8 CHARACTERS SO NEXT ONE LOCATION 8
	LD (HL),A
	INC HL
	LD A,'$'	; PUT $ AT THE END
	LD (HL),A
	RET
	
STRINGS_CLEAR:	;DE=STRING, CLEARS TO ""
	LD A,'$'
	LD (DE),A
	RET

STRINGS_COPY:	; COPY STRING DE TO HL
	PUSH DE
	PUSH HL
	CALL STRINGS_LEN
	LD C,A
	INC C		;COPY THE $ AS WELL
	LD B,0
	POP HL
	POP DE
	EX DE,HL	; ROUND THE RIGHT WAY FOR LDIR
	LDIR
	RET
	



; ************************************************
; filename manipulation
;FILENAME:		DB	'MYFILE$'
;FILEPAD:		DB	'        $'
;FILEEXT:		DB	'COM$'

FILEPAD:		DB	'        $'


FILENAME_TO_FCB:	; pass filename and fileext, puts into fcb
	LD HL,FILEPAD
	LD DE,FCB
	INC DE	; filename starts at byte 1
	LD BC,8	; move 8 bytes so filename is blank
	LDIR
	LD DE,FILENAME
	CALL STRINGS_LEN	; length of this file
	LD BC,0
	LD C,A	; move this number of bytes to the fcb
	LD HL,FILENAME
	LD DE,FCB
	INC DE	; point to name =1
	LDIR		; move it
	LD DE,FCB
	LD HL,9
	ADD HL,DE	; point to location of ext
	EX DE,HL	
	LD HL,FILEEXT
	LD BC,3
	LDIR		; move the 3 bytes over
	RET



			
; ************************************************			
DIR_BUFFER:	DEFS	1000		; THE DIR BUFFER COULD BE HUGE ON A 2 GIG DRIVE 
					; sits up at the top of the program so no real need to define size

	END
