/*
USQ.C - Unsqueeze module of CP/M File eXpress
Copyright 20 Jan 1992 by 
Carson Wilson
1359 W. Greenleaf, #1D
Chicago, IL 60626

UUCP:	carson@sputnik.uucp
	..!uunet!ddsw1!carson

BBS:	Antelope Freeway, 1-708-455-0120
*/

#include "cfx.h"

/* Stuff for Huffman unsqueezing */

#define SPEOF 256			/* special endfile token */
#define NUMVALS 257			/* 256 data values plus SPEOF */

#ifdef DUMBLINKER

struct nd				/* decoding tree */
{
	int child[2];			/* left, right */
} *node;

#else

struct nd				/* decoding tree */
{
	int child[2];			/* left, right */
} node[NUMVALS];			/* use large buffer */

#endif

static int bpos;			/* last bit position read */
static int curin;			/* last byte value read */
static int numnodes;			/* number of nodes in decode tree */

char *usqnptr;				/* global squeezed file name */

/* ------------------------------------------------------------------ */

static int get_int(f)			/* get an integer */
FILE *f;				/* file to get it from */
{
	int i;

	i = cgetc(f);
	return (short) (i | (cgetc(f) << 8));
}
/* ------------------------------------------------------------------ */

int init_usq(f)				/* initialize Huffman unsqueezing */
FILE *f;				/* file containing squeezed data */
{
	int i;				/* node index */

	bpos = 99;			/* force initial read */

	numnodes = get_int(f);

	if (numnodes < 0 || numnodes >= NUMVALS)
	{	cerror("invalid decode tree.");
		return (0);
	}

	/* initialize for possible empty tree (SPEOF only) */

	node[0].child[0] = -(SPEOF + 1);
	node[0].child[1] = -(SPEOF + 1);

	for (i = 0; i < numnodes; ++i)	/* get decoding tree from file */
	{	node[i].child[0] = get_int(f);
		node[i].child[1] = get_int(f);
	}
	return (1);
}
/* ------------------------------------------------------------------ */

int getc_usq(f)				/* get byte from squeezed file */
FILE *f;				/* file containing squeezed data */
{
	int i;				/* tree index */

	/* follow bit stream in tree to a leaf */

	for (i = 0; i >= 0; )		/* work down(up?) from root */
	{	if (++bpos > 7)
		{	if ((curin = cgetc(f)) == EOF)
				return(EOF);
			bpos = 0;

			/* move a level deeper in tree */
			i = node[i].child[1&curin];
		}
		else
			i = node[i].child[1 & (curin >>= 1)];
	}

	/* decode fake node index to original data value */

	i = -(i + 1);

	/* decode special endfile token to normal EOF */

	i = (i == SPEOF) ? EOF : i;
	return i;
}
/* ==================================================================== */

void unsqueeze(usqfd, usqfn, usqflen)
FILE *usqfd;
char *usqfn;
long usqflen;
{
	unsigned usqfcrc;
	int tchar;
	char *p;
	char outfn[80];			/* space to build output file name   */

	get_int(usqfd);			/* skip ID bytes */
	usqfcrc = get_int(usqfd);
	usqnptr = usqfn;

	/* Extract and build output file name*/

	for ( p = outfn; (*p = cgetc(usqfd)) != '\0' ; p++);
#ifdef UNIX
	unixfn(outfn);
#endif
	outcrlf(1);
	printf("  --> %s", outfn);

	*(cisubstr(outfn, ".") + 4) = '\0'; /*truncate non-name portion*/

	if (diskout)
	{	/* Open output file */
		if ( 0 == (outfd = fopen( outfn, "wb")) )
		{	cerror("can't create %s", outfn);
			return;
		}
	}
	else
		outcrlf(2);
#ifdef DUMBLINKER
	/* Allocate storage now for the table (keeps load short) */
	node = (struct nd *) malloc(NUMVALS * sizeof(struct nd));
#endif
	if (init_usq(usqfd) == 0)
		return;

	outreccount = 0;

	while ((tchar = getc_usq(usqfd)) != EOF && (contin))
		send(tchar);
	cksum &= 0xFFFF;
	if (usqfcrc != cksum)
		cerror("checksum error: expected: %04xh actual: %04xh", usqfcrc, cksum);
	free(node);
}
/* End of USQ.C */
